/**
 * *************************************************************************************************************
 * @file BoardCfg.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2024-12-11
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for BoardCfg firmware library
 * MCU / CFG Ver. :BH66F2455/1.1
 * Version = 1.0.0W

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#ifndef _BOARD_CFG_H_
#define _BOARD_CFG_H_

#include "..\driver\stdbool.h"
#include "..\driver\Gpio.h"

#define USE_UART 1
#define USE_SPI  0
#define USE_I2C  0
#if (USE_UART + USE_SPI + USE_I2C) != 1
    #error "Only one communication protocol should be enabled"
#endif

#define MEASURE_CURRENT 1
#define MEASURE_VOL     0
#if (MEASURE_VOL + MEASURE_CURRENT) != 1
    #error "Please select only one option: either MEASURE_VOL or MEASURE_CURRENT!"
#endif

#define AUTO_SLEEP     0    // Automatic hibernation is not supported
#define DRDY_LOW_PULSE 0    // DRDY:1 use low pulse, 0 use low electric plane

// clang-format off
// DRDY output default:PA4
#define AFE_DRDY_OUTPUT() 	{ _pac4 = 0; }
#define AFE_DRDY_LOW() 		{ _pa4 = 0; }
#define AFE_DRDY_HIGH() 	{ _pa4 = 1; }

#if USE_SPI
#define SPI_CS_ENABLED 0 // default:0 Disable CS functionality when using SPI communication
#else
#define SPI_CS_ENABLED 0 // default:0 Disable CS functionality when not using SPI communication
#endif
#if ((USE_SPI == 0)&&(SPI_CS_ENABLED == 1))
#error "CS functionality should not be enabled when SPI communication is not used!"
#endif

#if SPI_CS_ENABLED
#define AFE_IO_WAKEUP_SLEEP_INIT() { _pac1 = 1; _papu1 = 1; _pawu1 = 1; }//default:PA1 !!!Note: Do not use CS PA5
#define AFE_IO_WAKEUP_GET()		   ((_pa1) == (0))
#define AFE_IO_WAKEUP_DISABLE()    { _pac1 = 1; _papu1 = 1; _pawu1 = 0; }
#else
#define AFE_IO_WAKEUP_SLEEP_INIT() { _pac5 = 1; _papu5 = 1; _pawu5 = 1; }//default:PA5
#define AFE_IO_WAKEUP_GET()		   ((_pa5) == (0))
#define AFE_IO_WAKEUP_DISABLE()    { _pac5 = 1; _papu5 = 1; _pawu5 = 0; }
#endif


// clang-format off
// #define SUPPORT_ISP

//-------------UART config-----------------
#define UART_BAUD_RATE 38400    //!< 300,600,1200,2400,4800,9600,14400,19200,38400,57600,115200,230400,250000
#define PIN_TX_PA6              // PA6,PA0
#define PIN_RX_PA7              // PA7,PA2
//-------------SPI config-----------------
#define PIN_SCS_PA5    // PA5
#define PIN_SCK_PB0    // PB0,PA4
#define PIN_SDI_PA7    // PA7,PA2
#define PIN_SDO_PA6    // PA6,PA0

//-------------CTM0 config-----------------
#define PIN_CTCK0_PA4    // PA4
#define PIN_CTP0_PA4     // PA4

//-------------INT PIN config-----------------
#define PIN_INT0_PA4    // PA4
#define PIN_INT1_PA5    // PA5
#define PIN_INT2_PA7    // PA7
#define PIN_INT3_PB0    // PB0

#endif
