/**
 * *************************************************************************************************************
 * @file Gpio.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Gpio firmware library
 * MCU / CFG Ver. :BH66F2475/1.7
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _GPIO_H_
#define _GPIO_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include "BH66F2455.h"

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
#define PIN_ModeOutput(p, n)        { _##p##c##n = 0;}
#define PIN_ModeInput(p, n)         { _##p##c##n = 1;}
#define PIN_OutputHigh(p, n)        { _##p####n = 1;}
#define PIN_OutputLow(p, n)         { _##p####n = 0;}
#define PIN_OutputInvert(p, n)      { _##p####n = ~_##p####n;}
#define PIN_PullHigh_Enable(p, n)   { _##p##pu##n = 1;}
#define PIN_PullHigh_Disable(p, n)  { _##p##pu##n = 0;}
#define PIN_WakeUp_Enable(p, n)     { _##p##wu##n = 1;}  //!< only pa port
#define PIN_WakeUp_Disable(p, n)    { _##p##wu##n = 0;}  //!< only pa port
#define PIN_IsHigh(p, n)              _##p####n == 1
#define PIN_IsLow(p, n)               _##p####n == 0
#define PIN_Data(p, n)                _##p####n

// clang-format on
// clang-format off
#define PIN_PA0_GPIO()      { _pas01 = 0; _pas00 = 0;}
#define PIN_PA0_SDO()       { _pas01 = 0; _pas00 = 1;}
#define PIN_PA0_TX()        { _pas01 = 1; _pas00 = 0;}

#define PIN_PA1_GPIO()      { _pas03 = 0; _pas02 = 0;}
#define PIN_PA1_AIN1()      { _pas03 = 1; _pas02 = 1;}

#define PIN_PA2_GPIO()      { _pas05 = 0; _pas04 = 0;}
#define PIN_PA2_SDI()       { _pas05 = 0; _pas04 = 1; _spisdips = 1;}
#define PIN_PA2_RX()        { _pas05 = 1; _pas04 = 0; _rxtxps = 1;}

#define PIN_PA3_GPIO()      { _pas07 = 0; _pas06 = 0;}
#define PIN_PA3_AIN0()      { _pas07 = 1; _pas06 = 1;}

#define PIN_PA4_GPIO()      { _pas11 = 0; _pas10 = 0;}
#define PIN_PA4_INT0()      { _pas11 = 0; _pas10 = 0;}
#define PIN_PA4_CTCK()      { _pas11 = 0; _pas10 = 0;}
#define PIN_PA4_CTP()       { _pas11 = 0; _pas10 = 1;}
#define PIN_PA4_SCK()       { _pas11 = 1; _pas10 = 0; _spisckps = 1;}

#define PIN_PA5_GPIO()      { _pas13 = 0; _pas12 = 0;}
#define PIN_PA5_INT1()      { _pas13 = 0; _pas12 = 0;}
#define PIN_PA5_PTCK()      { _pas13 = 0; _pas12 = 0;}
#define PIN_PA5_SCS()       { _pas13 = 1; _pas12 = 1;}

#define PIN_PA6_GPIO()      { _pas15 = 0; _pas14 = 0;}
#define PIN_PA6_SDO()       { _pas15 = 1; _pas14 = 0;}
#define PIN_PA6_TX()        { _pas15 = 1; _pas14 = 1;}

#define PIN_PA7_GPIO()      { _pas17 = 0; _pas16 = 0;}
#define PIN_PA7_INT2()      { _pas17 = 0; _pas16 = 0;}
#define PIN_PA7_PTPI()      { _pas17 = 0; _pas16 = 0;}
#define PIN_PA7_SDI()       { _pas17 = 0; _pas16 = 1; _spisdips = 0;}
#define PIN_PA7_RX()        { _pas17 = 1; _pas16 = 0; _rxtxps = 0;}

#define PIN_PB0_GPIO()      { _pbs01 = 0; _pbs00 = 0;}
#define PIN_PB0_INT3()      { _pbs01 = 0; _pbs00 = 0;}
#define PIN_PB0_SCK()       { _pbs01 = 0; _pbs00 = 1; _spisckps = 0;}
#define PIN_PB0_PTP()       { _pbs01 = 1; _pbs00 = 0;}

// clang-format on

#endif