/**
 * *************************************************************************************************************
 * @file Spi.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2024-12-26
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Spi firmware library
 * MCU / CFG Ver. :BH66F2455/1.3
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "Spi.h"
#include "..\board\BoardCfg.h"

/**
 * @brief spi config
 *
 * @param Cfg @ref Spi_Cfg_t
 */
void Spi_Cfg(const Spi_Cfg_t *cfg)
{
#if defined(PIN_SCS_PA5)
    if (cfg->csen)
    {
        PIN_PA5_SCS();
    }
#endif
#if defined(PIN_SCK_PB0)
    PIN_PB0_SCK();
#endif
#if defined(PIN_SCK_PA4)
    PIN_PA4_SCK();
#endif
#if defined(PIN_SDI_PA7)
    PIN_PA7_SDI();
#endif
#if defined(PIN_SDI_PA2)
    PIN_PA2_SDI();
#endif
#if defined(PIN_SDO_PA6)
    PIN_PA6_SDO();
#endif
#if defined(PIN_SDO_PA0)
    PIN_PA0_SDO();
#endif
    _spic0 = cfg->mode;
    _spic1 = cfg->csen + cfg->dataShift + cfg->sck_edge;
}

/**
 * @brief Spi 發送接收數據
 *
 * @param txData 發送的數據
 * @return uint8_t 接收的數據
 */
uint8_t Spi_TxRxByte(uint8_t txData)
{
    do
    {
        _spiwcol = 0x00;
        _spid = txData;
    } while (_spiwcol);
    while (!_spitrf)
    {
        ;
    }
    _spitrf = 0;
    return _spid;
}

DEFINE_ISR(SPI_ISR, 0x1C)
{
    GCC_NOP();
    GCC_NOP();
    GCC_NOP();
}
