/*************************************************************************************************************
 * @file    ht32f675x5_reg.h
 * @version V1.0
 * @date    2021-02-06
 * @brief   
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/*!
************************************************************
* \file
*    ht32f675x5_reg.h
*    ht32f675x5 configuration registers address definition      
* generated by rbus_gen_soft automatically,dont modify it
 
*    start_address   end_address  size(KB)  module_name  
*    0x00000000       0x0001FFFF    128       ROM_CODE     
*    0x00020000       0x007FFFFF    8064        Rsv          
*    0x00800000       0x0093FFFF    1280      SRAM_CODE    
*    0x00940000       0x0FFFFFFF    252672    Rsv          
*    0x10000000       0x11FFFFFF    32768       QSPI0_CODE   
*    0x12000000       0x1FFFFFFF    229376    Rsv          
*    0x20000000       0x2013FFFF    1280      SRAM_DATA    
*    0x20140000       0x2FFFFFFF    260864    Rsv          
*    0x30000000       0x31FFFFFF    32768       QSPI0_DATA   
*    0x32000000       0x33FFFFFF    32768       QSPI1_DATA   
*    0x34000000       0x35FFFFFF    32768       QSPI2_DATA   
*    0x36000000       0x37FFFFFF    32768       QSPI3_DATA   
*    0x38000000       0x39FFFFFF    32748     Rsv          
*    0x3A000000       0x3A01FFFF    128       ROM_DATA     
*    0x3A020000       0x3FFFFFFF    98176     Rsv          
*    0x40000000       0x400003FF    1           LLC_CFG      
*    0x40000400       0x400007FF    1           LLC_STA      
*    0x40000800       0x40000FFF    2           Rsv          
*    0x40001000       0x40001FFF    4           TRNG         
*    0x40002000       0x40007FFF    24        Rsv          
*    0x40008000       0x400087FF    2           RF_MDM_SECA  
*    0x40008800       0x40008FFF    2           RF_MDM_SECB  
*    0x40009000       0x400097FF    2           RF_MDM_SECF  
*    0x40009800       0x40009FFF    2           RF_MDM_SECG  
*    0x4000A000       0x4000A7FF    2           RF_MDM_SECR  
*    0x4000A800       0x4000ABFF    1           RF_MDM_PMU   
*    0x4000AC00       0x4000AFFF    1           RF_MDM_TABLE 
*    0x4000B000       0x4000B3FF    1         CPTO_CFG     
*    0x4000B400       0x4000B7FF    1           CPTO_STA     
*    0x4000B800       0x4FFFFFFF    262098    Rsv          
*    0x50000000       0x50000FFF    4           QSPI0_CFG    
*    0x50001000       0x50001FFF    4           QSPI1_CFG    
*    0x50002000       0x50002FFF    4           QSPI2_CFG    
*    0x50003000       0x50003FFF    4           QSPI3_CFG    
*    0x50004000       0x50007FFF    16        SRAM_CACHE   
*    0x50008000       0x50008FFF    4           DMA_CFG      
*    0x50009000       0x50009FFF    4           CACHE_CFG    
*    0x5000A000       0x5000AFFF    4           PLCD         
*    0x5000B000       0x5000BFFF    4           USB          
*    0x5000C000       0x5FFFFFFF    262096    Rsv          
*    0x60000000       0x600003FF    1           UART0        
*    0x60000400       0x600007FF    1           UART1        
*    0x60000800       0x60000BFF    1           UART2/SCD    
*    0x60000C00       0x60000FFF    1           Rsv          
*    0x60001000       0x60001FFF    4           SPI0         
*    0x60002000       0x60002FFF    4           SPI1         
*    0x60003000       0x600033FF    1           I2C0         
*    0x60003400       0x600037FF    1           I2C1         
*    0x60003800       0x60003BFF    1           I2C2         
*    0x60003C00       0x60003FFF    1           Rsv          
*    0x60004000       0x60004FFF    4           IOMUX        
*    0x60005000       0x6001FFFF    108       Rsv          
*    0x60020000       0x600203FF    1           GPADC        
*    0x60020400       0x6002CFFF    51        Rsv          
*    0x6002D000       0x6002D3FF    1           I2S          
*    0x6002D400       0x6002DFFF    3           Rsv          
*    0x6002E000       0x6002EFFF    4           CIC          
*    0x6002F000       0x6002F3FF    1           EFUSE_ARRY   
*    0x6002F400       0x6002FFFF    3           EFUSE_REG    
*    0x60030000       0x60030FFF    4           QDEC         
*    0x60031000       0x60031FFF    4           Rsv          
*    0x60032000       0x60032FFF    4           GTIM0        
*    0x60033000       0x60033FFF    4           GTIM1        
*    0x60034000       0x6003AFFF    28        Rsv          
*    0x6003B000       0x6003BFFF    4           GTIM2        
*    0x6003C000       0x6003CFFF    4           GTIM3        
*    0x6003D000       0x6004AFFF    56        Rsv          
*    0x6004B000       0x6004BFFF    4           GPIO         
*    0x6004C000       0x6004CFFF    4           Rsv          
*    0x6004D000       0x6004DFFF    4           RTC          
*    0x6004E000       0x6004E7FF    2           WDT0         
*    0x6004E800       0x6004EFFF    2           WDT1         
*    0x6004F000       0x6004FFFF    4           CRG          
*    0x60050000       0x60050FFF    4           PMU          
*    0x60051000       0x60051FFF    4           SYS_CTRL     
*    0x60052000       0x60052FFF    4           STIM0        
*    0x60053000       0x60053FFF    4           STIM1        
*    0x60054000       0xFFFFFFFF    2621104   Rsv          
************************************************************
*/
#ifndef __HT32F675X5_REG_H__
#define __HT32F675X5_REG_H__


//---------------------------------------------------
// llc in  domain address definition
//---------------------------------------------------

#define reg_llc_int_state_reg                                         (*(volatile uint32_t *)0x40000000)
#define adr_llc_int_state_reg                                                               (0x40000000)
#define mask_llc_int_state_reg_int_state                                (0xffffff)                      

#define reg_llc_ret_pd_int_en_ctrl                                    (*(volatile uint32_t *)0x40000004)
#define adr_llc_ret_pd_int_en_ctrl                                                          (0x40000004)
#define mask_llc_ret_pd_int_en_ctrl_int_wake_up_en                      (0x800000)                      
#define mask_llc_ret_pd_int_en_ctrl_int_mdm_sync                        (0x400000)                      
#define mask_llc_ret_pd_int_en_ctrl_int_p24g_en                         (0x3f0000)                      
#define mask_llc_ret_pd_int_en_ctrl_int_en                              (0xffff)                        

#define reg_llc_int_clr_ctrl_reg                                      (*(volatile uint32_t *)0x40000008)
#define adr_llc_int_clr_ctrl_reg                                                            (0x40000008)
#define mask_llc_int_clr_ctrl_reg_int_clr_trig                          (0xffffff)                      

#define reg_llc_ret_pd_llc_ltrx_ctrl                                  (*(volatile uint32_t *)0x4000000c)
#define adr_llc_ret_pd_llc_ltrx_ctrl                                                        (0x4000000c)
#define mask_llc_ret_pd_llc_ltrx_ctrl_tx_data_rate                      (0xc)                           
#define mask_llc_ret_pd_llc_ltrx_ctrl_rx_data_rate                      (0x3)                           

#define reg_llc_ret_pd_llc_control                                    (*(volatile uint32_t *)0x40000010)
#define adr_llc_ret_pd_llc_control                                                          (0x40000010)
#define mask_llc_ret_pd_llc_control_int_hw_mask                         (0x80)                          
#define mask_llc_ret_pd_llc_control_trxs_host_tx_en                     (0x40)                          
#define mask_llc_ret_pd_llc_control_trxs_host_rx_en                     (0x20)                          
#define mask_llc_ret_pd_llc_control_trxs_host_mode                      (0x10)                          
#define mask_llc_ret_pd_llc_control_close_whiten                        (0x8)                           
#define mask_llc_ret_pd_llc_control_byp_en                              (0x4)                           
#define mask_llc_ret_pd_llc_control_dtm_en                              (0x2)                           
#define mask_llc_ret_pd_llc_control_ltc_en                              (0x1)                           

#define reg_llc_ltrx_stop_trig                                        (*(volatile uint32_t *)0x40000014)
#define adr_llc_ltrx_stop_trig                                                              (0x40000014)
#define mask_llc_ltrx_stop_trig_trx_force_stop_trig                     (0x2)                           
#define mask_llc_ltrx_stop_trig_rx_restart_trig                         (0x1)                           

#define reg_ltc_trig_cfg                                              (*(volatile uint32_t *)0x40000018)
#define adr_ltc_trig_cfg                                                                    (0x40000018)
#define mask_ltc_trig_cfg_sch_reload_trig                               (0x20)                          
#define mask_ltc_trig_cfg_sync_regs_to_slp_clk_trig                     (0x10)                          
#define mask_ltc_trig_cfg_itv_reload_trig                               (0x8)                           
#define mask_ltc_trig_cfg_read_trig                                     (0x4)                           
#define mask_ltc_trig_cfg_wakeup_begin                                  (0x2)                           
#define mask_ltc_trig_cfg_slp_begin                                     (0x1)                           

#define reg_ltc_ltc_cfg                                               (*(volatile uint32_t *)0x4000001c)
#define adr_ltc_ltc_cfg                                                                     (0x4000001c)
#define mask_ltc_ltc_cfg_clk_ratio_sel                                  (0x10000)                       
#define mask_ltc_ltc_cfg_clk_ratio                                      (0xffff)                        

#define reg_llc_ret_pd_tx_header_cfg                                  (*(volatile uint32_t *)0x40000020)
#define adr_llc_ret_pd_tx_header_cfg                                                        (0x40000020)
#define mask_llc_ret_pd_tx_header_cfg_tx_header                         (0xffffff)                      

#define reg_llc_ret_pd_rx_header_cfg                                  (*(volatile uint32_t *)0x40000024)
#define adr_llc_ret_pd_rx_header_cfg                                                        (0x40000024)
#define mask_llc_ret_pd_rx_header_cfg_rx_header                         (0xffff00)                      
#define mask_llc_ret_pd_rx_header_cfg_dch_max_len                       (0xff)                          

#define reg_ltrx_ret_pd_ltrx_chidx_sel                                (*(volatile uint32_t *)0x40000028)
#define adr_ltrx_ret_pd_ltrx_chidx_sel                                                      (0x40000028)
#define mask_ltrx_ret_pd_ltrx_chidx_sel_snd_adv_chn                     (0x40)                          
#define mask_ltrx_ret_pd_ltrx_chidx_sel_chidx                           (0x3f)                          

#define reg_ltrx_ret_pd_tx_access_code                                (*(volatile uint32_t *)0x4000002c)
#define adr_ltrx_ret_pd_tx_access_code                                                      (0x4000002c)

#define reg_p24g_ret_pd_tx_def_data                                   (*(volatile uint32_t *)0x40000030)
#define adr_p24g_ret_pd_tx_def_data                                                         (0x40000030)

#define reg_llc_ret_pd_ble_cfg                                        (*(volatile uint32_t *)0x40000034)
#define adr_llc_ret_pd_ble_cfg                                                              (0x40000034)
#define mask_llc_ret_pd_ble_cfg_rx_end_sel                              (0x8)                           
#define mask_llc_ret_pd_ble_cfg_mode                                    (0x7)                           

#define reg_llc_ret_pd_ble_ctrl                                       (*(volatile uint32_t *)0x40000038)
#define adr_llc_ret_pd_ble_ctrl                                                             (0x40000038)
#define mask_llc_ret_pd_ble_ctrl_lsm_type_ck_en                         (0x4)                           
#define mask_llc_ret_pd_ble_ctrl_lsm_rsv_rx_en                          (0x2)                           
#define mask_llc_ret_pd_ble_ctrl_lsm_scan_act_en                        (0x1)                           

#define reg_p24g_ret_pd_work_mode_cfg                                 (*(volatile uint32_t *)0x40000040)
#define adr_p24g_ret_pd_work_mode_cfg                                                       (0x40000040)
#define mask_p24g_ret_pd_work_mode_cfg_work_mode                        (0x7)                           

#define reg_p24g_ret_pd_p24g_ctrl                                     (*(volatile uint32_t *)0x40000044)
#define adr_p24g_ret_pd_p24g_ctrl                                                           (0x40000044)
#define mask_p24g_ret_pd_p24g_ctrl_trx_need_ready_trig_en               (0x8)                           
#define mask_p24g_ret_pd_p24g_ctrl_continue_en                          (0x4)                           
#define mask_p24g_ret_pd_p24g_ctrl_wl_fail_stp_auto                     (0x2)                           
#define mask_p24g_ret_pd_p24g_ctrl_csma_en                              (0x1)                           

#define reg_p24g_ret_pd_csma_control                                  (*(volatile uint32_t *)0x40000048)
#define adr_p24g_ret_pd_csma_control                                                        (0x40000048)
#define mask_p24g_ret_pd_csma_control_csma_stop_time                    (0xffff0000)                    
#define mask_p24g_ret_pd_csma_control_csma_len                          (0xffff)                        

#define reg_p24g_tx_rx_trig                                           (*(volatile uint32_t *)0x4000004c)
#define adr_p24g_tx_rx_trig                                                                 (0x4000004c)
#define mask_p24g_tx_rx_trig_start_trx_trig                             (0x2)                           
#define mask_p24g_tx_rx_trig_ready_to_trx_trig                          (0x1)                           

#define reg_ltrx_ret_pd_crc_init                                      (*(volatile uint32_t *)0x40000050)
#define adr_ltrx_ret_pd_crc_init                                                            (0x40000050)

#define reg_llc_ret_pd_rx_crc_ctrl                                    (*(volatile uint32_t *)0x40000054)
#define adr_llc_ret_pd_rx_crc_ctrl                                                          (0x40000054)
#define mask_llc_ret_pd_rx_crc_ctrl_rx_nbit_tail                        (0x3)                           

#define reg_ltrx_ret_pd_crc_code_rd_sel                               (*(volatile uint32_t *)0x40000058)
#define adr_ltrx_ret_pd_crc_code_rd_sel                                                     (0x40000058)

#define reg_ltc_ret_pd_slp_len                                        (*(volatile uint32_t *)0x40000080)
#define adr_ltc_ret_pd_slp_len                                                              (0x40000080)

#define reg_ltc_slp_cycle_to_act                                      (*(volatile uint32_t *)0x40000084)
#define adr_ltc_slp_cycle_to_act                                                            (0x40000084)

#define reg_ltc_ret_pd_itv_len_hi                                     (*(volatile uint32_t *)0x40000088)
#define adr_ltc_ret_pd_itv_len_hi                                                           (0x40000088)

#define reg_ltc_ret_pd_itv_len_lo                                     (*(volatile uint32_t *)0x4000008c)
#define adr_ltc_ret_pd_itv_len_lo                                                           (0x4000008c)

#define reg_ltc_itv_reload_value_hi                                   (*(volatile uint32_t *)0x40000090)
#define adr_ltc_itv_reload_value_hi                                                         (0x40000090)
#define mask_ltc_itv_reload_value_hi_itv_reload_plus                    (0x40)                          
#define mask_ltc_itv_reload_value_hi_itv_reload_delta_hi                (0x3f)                          

#define reg_ltc_itv_reload_value_lo                                   (*(volatile uint32_t *)0x40000094)
#define adr_ltc_itv_reload_value_lo                                                         (0x40000094)
#define mask_ltc_itv_reload_value_lo_itv_reload_delta_lo                (0xffffffff)                    

#define reg_ltc_ret_pd_itv_reload_max_hi                              (*(volatile uint32_t *)0x40000098)
#define adr_ltc_ret_pd_itv_reload_max_hi                                                    (0x40000098)

#define reg_ltc_ret_pd_itv_reload_max_lo                              (*(volatile uint32_t *)0x4000009c)
#define adr_ltc_ret_pd_itv_reload_max_lo                                                    (0x4000009c)

#define reg_ltc_ret_pd_itv_reload_min_hi                              (*(volatile uint32_t *)0x400000a0)
#define adr_ltc_ret_pd_itv_reload_min_hi                                                    (0x400000a0)

#define reg_ltc_ret_pd_itv_reload_min_lo                              (*(volatile uint32_t *)0x400000a4)
#define adr_ltc_ret_pd_itv_reload_min_lo                                                    (0x400000a4)

#define reg_ltc_ret_pd_itv_auto_reload_en                             (*(volatile uint32_t *)0x400000a8)
#define adr_ltc_ret_pd_itv_auto_reload_en                                                   (0x400000a8)

#define reg_ltc_ret_pd_tx_ifs_len_ctrl                                (*(volatile uint32_t *)0x400000c0)
#define adr_ltc_ret_pd_tx_ifs_len_ctrl                                                      (0x400000c0)
#define mask_ltc_ret_pd_tx_ifs_len_ctrl_ifs_tx_len_500k                 (0xffff0000)                    
#define mask_ltc_ret_pd_tx_ifs_len_ctrl_ifs_tx_len                      (0xffff)                        

#define reg_ltc_ret_pd_rx_ifs_len_ctrl                                (*(volatile uint32_t *)0x400000c4)
#define adr_ltc_ret_pd_rx_ifs_len_ctrl                                                      (0x400000c4)
#define mask_ltc_ret_pd_rx_ifs_len_ctrl_ifs_rx_len                      (0xffff)                        

#define reg_ltc_ret_pd_ifs_wnd_ctrl                                   (*(volatile uint32_t *)0x400000c8)
#define adr_ltc_ret_pd_ifs_wnd_ctrl                                                         (0x400000c8)
#define mask_ltc_ret_pd_ifs_wnd_ctrl_ifs_wnd                            (0xffff)                        

#define reg_ltc_ret_pd_itv_lsn_bgn_hi                                 (*(volatile uint32_t *)0x40000100)
#define adr_ltc_ret_pd_itv_lsn_bgn_hi                                                       (0x40000100)

#define reg_ltc_ret_pd_itv_lsn_bgn_lo                                 (*(volatile uint32_t *)0x40000104)
#define adr_ltc_ret_pd_itv_lsn_bgn_lo                                                       (0x40000104)

#define reg_ltc_ret_pd_itv_lsn_end_hi                                 (*(volatile uint32_t *)0x40000108)
#define adr_ltc_ret_pd_itv_lsn_end_hi                                                       (0x40000108)

#define reg_ltc_ret_pd_itv_lsn_end_lo                                 (*(volatile uint32_t *)0x4000010c)
#define adr_ltc_ret_pd_itv_lsn_end_lo                                                       (0x4000010c)

#define reg_ltc_ret_pd_rx_stop_before_lsn_end_hi                      (*(volatile uint32_t *)0x40000110)
#define adr_ltc_ret_pd_rx_stop_before_lsn_end_hi                                            (0x40000110)

#define reg_ltc_ret_pd_rx_stop_before_lsn_end_lo                      (*(volatile uint32_t *)0x40000114)
#define adr_ltc_ret_pd_rx_stop_before_lsn_end_lo                                            (0x40000114)

#define reg_ltc_ret_pd_itv_pre_time                                   (*(volatile uint32_t *)0x40000118)
#define adr_ltc_ret_pd_itv_pre_time                                                         (0x40000118)
#define mask_ltc_ret_pd_itv_pre_time_itv_tx_pre_time                    (0x3ffe000)                     
#define mask_ltc_ret_pd_itv_pre_time_itv_rx_pre_time                    (0x1fff)                        

#define reg_llc_ret_pd_tx_rx_stop_before_intvl_hi                     (*(volatile uint32_t *)0x4000011c)
#define adr_llc_ret_pd_tx_rx_stop_before_intvl_hi                                           (0x4000011c)

#define reg_llc_ret_pd_tx_rx_stop_before_intvl_lo                     (*(volatile uint32_t *)0x40000120)
#define adr_llc_ret_pd_tx_rx_stop_before_intvl_lo                                           (0x40000120)

#define reg_ltc_ret_pd_ifs_pre_time                                   (*(volatile uint32_t *)0x40000124)
#define adr_ltc_ret_pd_ifs_pre_time                                                         (0x40000124)
#define mask_ltc_ret_pd_ifs_pre_time_ifs_tx_pre_time                    (0x3ffe000)                     
#define mask_ltc_ret_pd_ifs_pre_time_ifs_rx_pre_time                    (0x1fff)                        

#define reg_ltc_ccm_prepare_time                                      (*(volatile uint32_t *)0x40000128)
#define adr_ltc_ccm_prepare_time                                                            (0x40000128)
#define mask_ltc_ccm_prepare_time_ccm_tx_pre_time                       (0xffff0000)                    
#define mask_ltc_ccm_prepare_time_ccm_rx_pre_time                       (0xffff)                        

#define reg_ltc_ret_pd_burst_on_time_btxen_brxen                      (*(volatile uint32_t *)0x4000012c)
#define adr_ltc_ret_pd_burst_on_time_btxen_brxen                                            (0x4000012c)
#define mask_ltc_ret_pd_burst_on_time_btxen_brxen_btxen_on_time         (0x1fff0000)                    
#define mask_ltc_ret_pd_burst_on_time_btxen_brxen_brxen_on_time         (0x1fff)                        

#define reg_ltrx_ret_pd_burst_off_time_btxen_brxen                    (*(volatile uint32_t *)0x40000130)
#define adr_ltrx_ret_pd_burst_off_time_btxen_brxen                                          (0x40000130)
#define mask_ltrx_ret_pd_burst_off_time_btxen_brxen_brf_btxen_off_time  (0xfff000)                      
#define mask_ltrx_ret_pd_burst_off_time_btxen_brxen_brf_brxen_off_time  (0xfff)                         

#define reg_llc_ret_pd_interrupt_delay                                (*(volatile uint32_t *)0x40000140)
#define adr_llc_ret_pd_interrupt_delay                                                      (0x40000140)
#define mask_llc_ret_pd_interrupt_delay_int_rx_end_dly                  (0xff0000)                      
#define mask_llc_ret_pd_interrupt_delay_int_rx_pdu_end_dly              (0xff00)                        
#define mask_llc_ret_pd_interrupt_delay_int_tx_end_dly                  (0xff)                          

#define reg_lsm_ret_pd_init_addr_h                                    (*(volatile uint32_t *)0x40000144)
#define adr_lsm_ret_pd_init_addr_h                                                          (0x40000144)

#define reg_lsm_ret_pd_init_addr_l                                    (*(volatile uint32_t *)0x40000148)
#define adr_lsm_ret_pd_init_addr_l                                                          (0x40000148)

#define reg_lsm_ret_pd_adv_addr_h                                     (*(volatile uint32_t *)0x4000014c)
#define adr_lsm_ret_pd_adv_addr_h                                                           (0x4000014c)

#define reg_lsm_ret_pd_adv_addr_l                                     (*(volatile uint32_t *)0x40000150)
#define adr_lsm_ret_pd_adv_addr_l                                                           (0x40000150)

#define reg_lsm_ret_pd_device_addr_match_en                           (*(volatile uint32_t *)0x40000154)
#define adr_lsm_ret_pd_device_addr_match_en                                                 (0x40000154)

#define reg_llc_debug_brk_point                                       (*(volatile uint32_t *)0x40000158)
#define adr_llc_debug_brk_point                                                             (0x40000158)

#define reg_llc_debug_sel_adv                                         (*(volatile uint32_t *)0x4000015c)
#define adr_llc_debug_sel_adv                                                               (0x4000015c)

#define reg_ltc_slp_ind                                               (*(volatile uint32_t *)0x40000180)
#define adr_ltc_slp_ind                                                                     (0x40000180)

#define reg_p24g_trx_vld                                              (*(volatile uint32_t *)0x40000184)
#define adr_p24g_trx_vld                                                                    (0x40000184)

#define reg_ltrx_ble_tx_status                                        (*(volatile uint32_t *)0x40000188)
#define adr_ltrx_ble_tx_status                                                              (0x40000188)
#define mask_ltrx_ble_tx_status_ble_tx_ext_advmode                      (0xc0)                          
#define mask_ltrx_ble_tx_status_ble_tx_ext_hlen                         (0x3f)                          

#define reg_llc_ble_tx_update_status                                  (*(volatile uint32_t *)0x4000018c)
#define adr_llc_ble_tx_update_status                                                        (0x4000018c)
#define mask_llc_ble_tx_update_status_tx_cteinfo                        (0xff00)                        
#define mask_llc_ble_tx_update_status_tx_extheader_flg                  (0xff)                          

#define reg_ltrx_ble_rx_status                                        (*(volatile uint32_t *)0x40000190)
#define adr_ltrx_ble_rx_status                                                              (0x40000190)
#define mask_ltrx_ble_rx_status_ci                                      (0x300)                         
#define mask_ltrx_ble_rx_status_ble_rx_ext_advmode                      (0xc0)                          
#define mask_ltrx_ble_rx_status_ble_rx_ext_hlen                         (0x3f)                          

#define reg_llc_ble_rx_update_status                                  (*(volatile uint32_t *)0x40000194)
#define adr_llc_ble_rx_update_status                                                        (0x40000194)
#define mask_llc_ble_rx_update_status_rx_cteinfo                        (0xff00)                        
#define mask_llc_ble_rx_update_status_rx_extheader_flg                  (0xff)                          

#define reg_ltrx_rx_header                                            (*(volatile uint32_t *)0x40000198)
#define adr_ltrx_rx_header                                                                  (0x40000198)

#define reg_ltrx_crc_code_flg                                         (*(volatile uint32_t *)0x4000019c)
#define adr_ltrx_crc_code_flg                                                               (0x4000019c)
#define mask_ltrx_crc_code_flg_crc_err                                  (0x1000000)                     
#define mask_ltrx_crc_code_flg_crc_code                                 (0xffffff)                      

#define reg_lsm_llc_state                                             (*(volatile uint32_t *)0x400001a0)
#define adr_lsm_llc_state                                                                   (0x400001a0)

#define reg_ltrx_rx_nesn                                              (*(volatile uint32_t *)0x400001a4)
#define adr_ltrx_rx_nesn                                                                    (0x400001a4)

#define reg_ltrx_rx_sn                                                (*(volatile uint32_t *)0x400001a8)
#define adr_ltrx_rx_sn                                                                      (0x400001a8)

#define reg_p24g_lsm_state                                            (*(volatile uint32_t *)0x400001ac)
#define adr_p24g_lsm_state                                                                  (0x400001ac)

#define reg_ltc_itv_act_cnt_hi                                        (*(volatile uint32_t *)0x400001c0)
#define adr_ltc_itv_act_cnt_hi                                                              (0x400001c0)

#define reg_ltc_itv_act_cnt_lo                                        (*(volatile uint32_t *)0x400001c4)
#define adr_ltc_itv_act_cnt_lo                                                              (0x400001c4)

#define reg_ltc_itv_trig_act_cnt_hi                                   (*(volatile uint32_t *)0x400001c8)
#define adr_ltc_itv_trig_act_cnt_hi                                                         (0x400001c8)

#define reg_ltc_itv_trig_act_cnt_lo                                   (*(volatile uint32_t *)0x400001cc)
#define adr_ltc_itv_trig_act_cnt_lo                                                         (0x400001cc)

#define reg_ltc_ifs_cnt                                               (*(volatile uint32_t *)0x400001d0)
#define adr_ltc_ifs_cnt                                                                     (0x400001d0)

#define reg_ltc_trig_ifs_cnt                                          (*(volatile uint32_t *)0x400001d4)
#define adr_ltc_trig_ifs_cnt                                                                (0x400001d4)

#define reg_ltc_sch_act_cnt_hi                                        (*(volatile uint32_t *)0x400001d8)
#define adr_ltc_sch_act_cnt_hi                                                              (0x400001d8)

#define reg_ltc_sch_act_cnt_lo                                        (*(volatile uint32_t *)0x400001dc)
#define adr_ltc_sch_act_cnt_lo                                                              (0x400001dc)

#define reg_ltc_sch_trig_act_cnt_hi                                   (*(volatile uint32_t *)0x400001e0)
#define adr_ltc_sch_trig_act_cnt_hi                                                         (0x400001e0)

#define reg_ltc_sch_trig_act_cnt_lo                                   (*(volatile uint32_t *)0x400001e4)
#define adr_ltc_sch_trig_act_cnt_lo                                                         (0x400001e4)

#define reg_ltc_slp_cnt                                               (*(volatile uint32_t *)0x400001e8)
#define adr_ltc_slp_cnt                                                                     (0x400001e8)

#define reg_ltc_slp_to_act_rlt_hi                                     (*(volatile uint32_t *)0x400001ec)
#define adr_ltc_slp_to_act_rlt_hi                                                           (0x400001ec)

#define reg_ltc_slp_to_act_rlt_lo                                     (*(volatile uint32_t *)0x400001f0)
#define adr_ltc_slp_to_act_rlt_lo                                                           (0x400001f0)

#define reg_ltc_anc_pos_hi                                            (*(volatile uint32_t *)0x40000200)
#define adr_ltc_anc_pos_hi                                                                  (0x40000200)

#define reg_ltc_anc_pos_lo                                            (*(volatile uint32_t *)0x40000204)
#define adr_ltc_anc_pos_lo                                                                  (0x40000204)

#define reg_ltc_sch_auxptr_cnt_hi                                     (*(volatile uint32_t *)0x40000208)
#define adr_ltc_sch_auxptr_cnt_hi                                                           (0x40000208)

#define reg_ltc_sch_auxptr_cnt_lo                                     (*(volatile uint32_t *)0x4000020c)
#define adr_ltc_sch_auxptr_cnt_lo                                                           (0x4000020c)

#define reg_llc_wakeup_flg                                            (*(volatile uint32_t *)0x40000210)
#define adr_llc_wakeup_flg                                                                  (0x40000210)

#define reg_cte_ret_pd_time_limit                                     (*(volatile uint32_t *)0x40000240)
#define adr_cte_ret_pd_time_limit                                                           (0x40000240)

#define reg_ltc_sch_reload_value_hi                                   (*(volatile uint32_t *)0x40000244)
#define adr_ltc_sch_reload_value_hi                                                         (0x40000244)

#define reg_ltc_sch_reload_value_lo                                   (*(volatile uint32_t *)0x40000248)
#define adr_ltc_sch_reload_value_lo                                                         (0x40000248)

#define reg_ltc_ret_pd_lsn_bgn_sel_en                                 (*(volatile uint32_t *)0x4000024c)
#define adr_ltc_ret_pd_lsn_bgn_sel_en                                                       (0x4000024c)

#define reg_ltc_ret_pd_snd_wnd_en                                     (*(volatile uint32_t *)0x40000250)
#define adr_ltc_ret_pd_snd_wnd_en                                                           (0x40000250)

#define reg_ltc_ret_pd_itv_snd_wnd_hi                                 (*(volatile uint32_t *)0x40000254)
#define adr_ltc_ret_pd_itv_snd_wnd_hi                                                       (0x40000254)

#define reg_ltc_ret_pd_itv_snd_wnd_lo                                 (*(volatile uint32_t *)0x40000258)
#define adr_ltc_ret_pd_itv_snd_wnd_lo                                                       (0x40000258)

#define reg_llc_ret_pd_ext_cg_en                                      (*(volatile uint32_t *)0x4000025c)
#define adr_llc_ret_pd_ext_cg_en                                                            (0x4000025c)

#define reg_llc_ret_pd_back_door_cfg                                  (*(volatile uint32_t *)0x40000280)
#define adr_llc_ret_pd_back_door_cfg                                                        (0x40000280)
#define mask_llc_ret_pd_back_door_cfg_wakeup_int_source_sel             (0x8)                           
#define mask_llc_ret_pd_back_door_cfg_ifs_len_sel                       (0x4)                           
#define mask_llc_ret_pd_back_door_cfg_close_init_no_lsn_end_function    (0x2)                           
#define mask_llc_ret_pd_back_door_cfg_modify_condition_tx_stop          (0x1)                           

#define reg_llc_test_start                                            (*(volatile uint32_t *)0x40000284)
#define adr_llc_test_start                                                                  (0x40000284)

#define reg_test_time                                                 (*(volatile uint32_t *)0x40000288)
#define adr_test_time                                                                       (0x40000288)

#define reg_test_pkt_cnt                                              (*(volatile uint32_t *)0x4000028c)
#define adr_test_pkt_cnt                                                                    (0x4000028c)
#define mask_test_pkt_cnt_pkt_ok_cnt                                    (0xffff0000)                    
#define mask_test_pkt_cnt_pkt_err_cnt                                   (0xffff)                        

#define reg_test_down                                                 (*(volatile uint32_t *)0x40000290)
#define adr_test_down                                                                       (0x40000290)


//---------------------------------------------------
// trng in  domain address definition
//---------------------------------------------------

#define reg_trng_fifo_data                                         (*(volatile uint32_t *)0x40001000)
#define adr_trng_fifo_data                                                               (0x40001000)
#define mask_trng_fifo_data_ehr_data0                                (0xffffffff)                    

#define reg_trng_imr_reg                                           (*(volatile uint32_t *)0x40001100)
#define adr_trng_imr_reg                                                                 (0x40001100)
#define mask_trng_imr_reg_read_underflow_int_mask                    (0x20)                          
#define mask_trng_imr_reg_write_overflow_int_mask                    (0x10)                          
#define mask_trng_imr_reg_vn_err_int_mask                            (0x8)                           
#define mask_trng_imr_reg_crngt_err_int_mask                         (0x4)                           
#define mask_trng_imr_reg_autocorr_err_int_mask                      (0x2)                           
#define mask_trng_imr_reg_ehr_valid_int_mask                         (0x1)                           

#define reg_trng_isr_reg                                           (*(volatile uint32_t *)0x40001104)
#define adr_trng_isr_reg                                                                 (0x40001104)
#define mask_trng_isr_reg_read_underflow_err                         (0x20)                          
#define mask_trng_isr_reg_write_overflow_err                         (0x10)                          
#define mask_trng_isr_reg_vn_err                                     (0x8)                           
#define mask_trng_isr_reg_crngt_err                                  (0x4)                           
#define mask_trng_isr_reg_autocorr_err                               (0x2)                           
#define mask_trng_isr_reg_ehr_valid                                  (0x1)                           

#define reg_trng_rng_icr_reg                                       (*(volatile uint32_t *)0x40001108)
#define adr_trng_rng_icr_reg                                                             (0x40001108)
#define mask_trng_rng_icr_reg_read_underflow_err                     (0x20)                          
#define mask_trng_rng_icr_reg_write_overflow_err                     (0x10)                          
#define mask_trng_rng_icr_reg_vn_err                                 (0x8)                           
#define mask_trng_rng_icr_reg_crngt_err                              (0x4)                           
#define mask_trng_rng_icr_reg_autocorr_err                           (0x2)                           
#define mask_trng_rng_icr_reg_ehr_valid                              (0x1)                           

#define reg_trng_trng_config                                       (*(volatile uint32_t *)0x4000110c)
#define adr_trng_trng_config                                                             (0x4000110c)
#define mask_trng_trng_config_sop_sel                                (0x100)                         
#define mask_trng_trng_config_rnd_src3_sel                           (0xc0)                          
#define mask_trng_trng_config_rnd_src2_sel                           (0x30)                          
#define mask_trng_trng_config_rnd_src1_sel                           (0xc)                           
#define mask_trng_trng_config_rnd_src0_sel                           (0x3)                           

#define reg_trng_trng_valid                                        (*(volatile uint32_t *)0x40001110)
#define adr_trng_trng_valid                                                              (0x40001110)
#define mask_trng_trng_valid_ehr_valid                               (0x1)                           

#define reg_trng_ehr_data0                                         (*(volatile uint32_t *)0x40001114)
#define adr_trng_ehr_data0                                                               (0x40001114)
#define mask_trng_ehr_data0_ehr_data0                                (0xffffffff)                    

#define reg_trng_ehr_data1                                         (*(volatile uint32_t *)0x40001118)
#define adr_trng_ehr_data1                                                               (0x40001118)
#define mask_trng_ehr_data1_ehr_data1                                (0xffffffff)                    

#define reg_trng_ehr_data2                                         (*(volatile uint32_t *)0x4000111c)
#define adr_trng_ehr_data2                                                               (0x4000111c)
#define mask_trng_ehr_data2_ehr_data2                                (0xffffffff)                    

#define reg_trng_ehr_data3                                         (*(volatile uint32_t *)0x40001120)
#define adr_trng_ehr_data3                                                               (0x40001120)
#define mask_trng_ehr_data3_ehr_data3                                (0xffffffff)                    

#define reg_trng_ehr_data4                                         (*(volatile uint32_t *)0x40001124)
#define adr_trng_ehr_data4                                                               (0x40001124)
#define mask_trng_ehr_data4_ehr_data4                                (0xffffffff)                    

#define reg_trng_ehr_data5                                         (*(volatile uint32_t *)0x40001128)
#define adr_trng_ehr_data5                                                               (0x40001128)
#define mask_trng_ehr_data5_ehr_data5                                (0xffffffff)                    

#define reg_trng_rnd_source_enable                                 (*(volatile uint32_t *)0x4000112c)
#define adr_trng_rnd_source_enable                                                       (0x4000112c)
#define mask_trng_rnd_source_enable_dma_en                           (0x20)                          
#define mask_trng_rnd_source_enable_ana_rnd_src_en                   (0x10)                          
#define mask_trng_rnd_source_enable_rnd_src3_en                      (0x8)                           
#define mask_trng_rnd_source_enable_rnd_src2_en                      (0x4)                           
#define mask_trng_rnd_source_enable_rnd_src1_en                      (0x2)                           
#define mask_trng_rnd_source_enable_rnd_src0_en                      (0x1)                           

#define reg_trng_sample_cnt1                                       (*(volatile uint32_t *)0x40001130)
#define adr_trng_sample_cnt1                                                             (0x40001130)
#define mask_trng_sample_cnt1_sample_cntr1                           (0xffffffff)                    

#define reg_trng_autocorr_statistic                                (*(volatile uint32_t *)0x40001134)
#define adr_trng_autocorr_statistic                                                      (0x40001134)
#define mask_trng_autocorr_statistic_autocorr_fails                  (0x3fc000)                      
#define mask_trng_autocorr_statistic_autocorr_trys                   (0x3fff)                        

#define reg_trng_trng_debug_control                                (*(volatile uint32_t *)0x40001138)
#define adr_trng_trng_debug_control                                                      (0x40001138)
#define mask_trng_trng_debug_control_rng_parallel_data_sel           (0x40)                          
#define mask_trng_trng_debug_control_rng_debug_enable                (0x20)                          
#define mask_trng_trng_debug_control_lfsr_bypass                     (0x10)                          
#define mask_trng_trng_debug_control_auto_correlate_bypass           (0x8)                           
#define mask_trng_trng_debug_control_trng_crngt_bypass               (0x4)                           
#define mask_trng_trng_debug_control_vnc_bypass                      (0x2)                           
#define mask_trng_trng_debug_control_reserved                        (0x1)                           

#define reg_trng_trng_bit_number                                   (*(volatile uint32_t *)0x4000113c)
#define adr_trng_trng_bit_number                                                         (0x4000113c)
#define mask_trng_trng_bit_number_trng_bit_number                    (0xffffffff)                    

#define reg_trng_trng_sw_reset                                     (*(volatile uint32_t *)0x40001140)
#define adr_trng_trng_sw_reset                                                           (0x40001140)
#define mask_trng_trng_sw_reset_trng_sw_reset                        (0x1)                           

#define reg_trng_trng_busy                                         (*(volatile uint32_t *)0x400011b8)
#define adr_trng_trng_busy                                                               (0x400011b8)
#define mask_trng_trng_busy_trng_busy                                (0x1)                           

#define reg_trng_rst_bits_counter                                  (*(volatile uint32_t *)0x400011bc)
#define adr_trng_rst_bits_counter                                                        (0x400011bc)
#define mask_trng_rst_bits_counter_rst_bits_counter                  (0x1)                           

#define reg_trng_trng_version                                      (*(volatile uint32_t *)0x400011c0)
#define adr_trng_trng_version                                                            (0x400011c0)
#define mask_trng_trng_version_trng_version                          (0xff)                          

#define reg_trng_rng_bist_cntr0                                    (*(volatile uint32_t *)0x400011e0)
#define adr_trng_rng_bist_cntr0                                                          (0x400011e0)
#define mask_trng_rng_bist_cntr0_rosc_cntr_val0                      (0x3fffff)                      

#define reg_trng_rng_bist_cntr1                                    (*(volatile uint32_t *)0x400011e4)
#define adr_trng_rng_bist_cntr1                                                          (0x400011e4)
#define mask_trng_rng_bist_cntr1_rosc_cntr_val1                      (0x3fffff)                      

#define reg_trng_rng_bist_cntr2                                    (*(volatile uint32_t *)0x400011e8)
#define adr_trng_rng_bist_cntr2                                                          (0x400011e8)
#define mask_trng_rng_bist_cntr2_rosc_cntr_val2                      (0x3fffff)                      

#define reg_trnga_ana_cnt1                                         (*(volatile uint32_t *)0x400011ec)
#define adr_trnga_ana_cnt1                                                               (0x400011ec)
#define mask_trnga_ana_cnt1_reserved2                                (0xffe00000)                    
#define mask_trnga_ana_cnt1_trnga_ext_cg_en                          (0x100000)                      
#define mask_trnga_ana_cnt1_trnga_clk_div                            (0xf0000)                       
#define mask_trnga_ana_cnt1_reserved1                                (0xffc0)                        
#define mask_trnga_ana_cnt1_clk_manual                               (0x20)                          
#define mask_trnga_ana_cnt1_clk_manual_sel                           (0x10)                          
#define mask_trnga_ana_cnt1_reserved0                                (0x8)                           
#define mask_trnga_ana_cnt1_mode                                     (0x4)                           
#define mask_trnga_ana_cnt1_dly_sel                                  (0x3)                           

#define reg_trnga_trnga_dat                                        (*(volatile uint32_t *)0x400011f0)
#define adr_trnga_trnga_dat                                                              (0x400011f0)
#define mask_trnga_trnga_dat_trnga_dat                               (0xffff)                        


//---------------------------------------------------
// trxs_ret_pd in  domain address definition
//---------------------------------------------------

#define reg_trxs_ret_pd_t1t2_sel                                        (*(volatile uint32_t *)0x40008000)
#define adr_trxs_ret_pd_t1t2_sel                                                              (0x40008000)
#define mask_trxs_ret_pd_t1t2_sel_t2_time                                 (0xff00)                        
#define mask_trxs_ret_pd_t1t2_sel_t1_time                                 (0xff)                          

#define reg_trxs_ret_pd_t3t4t5_sel                                      (*(volatile uint32_t *)0x40008004)
#define adr_trxs_ret_pd_t3t4t5_sel                                                            (0x40008004)
#define mask_trxs_ret_pd_t3t4t5_sel_bp_2g4_lock                           (0x8000)                        
#define mask_trxs_ret_pd_t3t4t5_sel_t1_ov_set                             (0x7000)                        
#define mask_trxs_ret_pd_t3t4t5_sel_t5_time                               (0xf00)                         
#define mask_trxs_ret_pd_t3t4t5_sel_t3_time                               (0xc0)                          
#define mask_trxs_ret_pd_t3t4t5_sel_t4_time                               (0x3f)                          

#define reg_trxs_ret_pd_t6t7_sel                                        (*(volatile uint32_t *)0x40008008)
#define adr_trxs_ret_pd_t6t7_sel                                                              (0x40008008)
#define mask_trxs_ret_pd_t6t7_sel_t7_cycle                                (0xff00)                        
#define mask_trxs_ret_pd_t6t7_sel_t6_cycle                                (0xff)                          

#define reg_trxs_ret_pd_t8_time                                         (*(volatile uint32_t *)0x4000800c)
#define adr_trxs_ret_pd_t8_time                                                               (0x4000800c)

#define reg_trxs_ret_pd_lo_adrs                                         (*(volatile uint32_t *)0x40008010)
#define adr_trxs_ret_pd_lo_adrs                                                               (0x40008010)

#define reg_trxs_ret_pd_auto_write_en                                   (*(volatile uint32_t *)0x40008014)
#define adr_trxs_ret_pd_auto_write_en                                                         (0x40008014)

#define reg_trxs_ret_pd_base_offset                                     (*(volatile uint32_t *)0x40008018)
#define adr_trxs_ret_pd_base_offset                                                           (0x40008018)

#define reg_trxs_ret_pd_tx_bgn_dat_reg                                  (*(volatile uint32_t *)0x40008020)
#define adr_trxs_ret_pd_tx_bgn_dat_reg                                                        (0x40008020)
#define mask_trxs_ret_pd_tx_bgn_dat_reg_tx_bgn_dat                        (0xffff)                        

#define reg_trxs_ret_pd_tx_end_dat_reg                                  (*(volatile uint32_t *)0x40008024)
#define adr_trxs_ret_pd_tx_end_dat_reg                                                        (0x40008024)
#define mask_trxs_ret_pd_tx_end_dat_reg_tx_end_dat                        (0xffff)                        

#define reg_trxs_ret_pd_rx_bgn_dat_reg                                  (*(volatile uint32_t *)0x40008028)
#define adr_trxs_ret_pd_rx_bgn_dat_reg                                                        (0x40008028)
#define mask_trxs_ret_pd_rx_bgn_dat_reg_rx_bgn_dat                        (0xffff)                        

#define reg_trxs_ret_pd_rx_end_dat_reg                                  (*(volatile uint32_t *)0x4000802c)
#define adr_trxs_ret_pd_rx_end_dat_reg                                                        (0x4000802c)
#define mask_trxs_ret_pd_rx_end_dat_reg_rx_end_dat                        (0xffff)                        

#define reg_trxs_ret_pd_tx_bgn_adr_set                                  (*(volatile uint32_t *)0x40008030)
#define adr_trxs_ret_pd_tx_bgn_adr_set                                                        (0x40008030)
#define mask_trxs_ret_pd_tx_bgn_adr_set_tx_bgn_burst_en                   (0x8000)                        
#define mask_trxs_ret_pd_tx_bgn_adr_set_tx_bgn_adr                        (0x7fff)                        

#define reg_trxs_ret_pd_tx_end_adr_set                                  (*(volatile uint32_t *)0x40008034)
#define adr_trxs_ret_pd_tx_end_adr_set                                                        (0x40008034)
#define mask_trxs_ret_pd_tx_end_adr_set_tx_end_burst_en                   (0x8000)                        
#define mask_trxs_ret_pd_tx_end_adr_set_tx_end_adr                        (0x7fff)                        

#define reg_trxs_ret_pd_rx_bgn_adr_set                                  (*(volatile uint32_t *)0x40008038)
#define adr_trxs_ret_pd_rx_bgn_adr_set                                                        (0x40008038)
#define mask_trxs_ret_pd_rx_bgn_adr_set_rx_bgn_burst_en                   (0x8000)                        
#define mask_trxs_ret_pd_rx_bgn_adr_set_rx_bgn_adr                        (0x7fff)                        

#define reg_trxs_ret_pd_rx_end_adr_set                                  (*(volatile uint32_t *)0x4000803c)
#define adr_trxs_ret_pd_rx_end_adr_set                                                        (0x4000803c)
#define mask_trxs_ret_pd_rx_end_adr_set_rx_end_burst_en                   (0x8000)                        
#define mask_trxs_ret_pd_rx_end_adr_set_rx_end_adr                        (0x7fff)                        

#define reg_trxs_ret_pd_slot_set                                        (*(volatile uint32_t *)0x40008040)
#define adr_trxs_ret_pd_slot_set                                                              (0x40008040)
#define mask_trxs_ret_pd_slot_set_slot_time_host_en                       (0x10)                          
#define mask_trxs_ret_pd_slot_set_host_slot_time                          (0xc)                           
#define mask_trxs_ret_pd_slot_set_aoa_slot_time                           (0x3)                           

#define reg_trxs_ret_pd_ant_set1                                        (*(volatile uint32_t *)0x40008044)
#define adr_trxs_ret_pd_ant_set1                                                              (0x40008044)
#define mask_trxs_ret_pd_ant_set1_ant_cfg3                                (0x7000)                        
#define mask_trxs_ret_pd_ant_set1_ant_cfg2                                (0xe00)                         
#define mask_trxs_ret_pd_ant_set1_ant_cfg1                                (0x1c0)                         
#define mask_trxs_ret_pd_ant_set1_txant_cfg0                              (0x38)                          
#define mask_trxs_ret_pd_ant_set1_ant_num                                 (0x7)                           

#define reg_trxs_ret_pd_ant_set2                                        (*(volatile uint32_t *)0x40008048)
#define adr_trxs_ret_pd_ant_set2                                                              (0x40008048)
#define mask_trxs_ret_pd_ant_set2_rxant_cfg0                              (0x7000)                        
#define mask_trxs_ret_pd_ant_set2_ant_cfg7                                (0xe00)                         
#define mask_trxs_ret_pd_ant_set2_ant_cfg6                                (0x1c0)                         
#define mask_trxs_ret_pd_ant_set2_ant_cfg5                                (0x38)                          
#define mask_trxs_ret_pd_ant_set2_ant_cfg4                                (0x7)                           

#define reg_trxs_ret_pd_sw_offset_cfg                                   (*(volatile uint32_t *)0x4000804c)
#define adr_trxs_ret_pd_sw_offset_cfg                                                         (0x4000804c)
#define mask_trxs_ret_pd_sw_offset_cfg_tone_bgn_ofset                     (0xff0)                         
#define mask_trxs_ret_pd_sw_offset_cfg_tone_switch_offset                 (0xf)                           

#define reg_trxs_ret_pd_lo_on_off_cfg                                   (*(volatile uint32_t *)0x40008050)
#define adr_trxs_ret_pd_lo_on_off_cfg                                                         (0x40008050)
#define mask_trxs_ret_pd_lo_on_off_cfg_lo_off                             (0x7c00)                        
#define mask_trxs_ret_pd_lo_on_off_cfg_rx_lo_on                           (0x3e0)                         
#define mask_trxs_ret_pd_lo_on_off_cfg_tx_lo_on                           (0x1f)                          

#define reg_rdmode_ret_pd_mode_host_reg                                 (*(volatile uint32_t *)0x40008054)
#define adr_rdmode_ret_pd_mode_host_reg                                                       (0x40008054)
#define mask_rdmode_ret_pd_mode_host_reg_tx_en                            (0x8000)                        
#define mask_rdmode_ret_pd_mode_host_reg_rx_en                            (0x4000)                        
#define mask_rdmode_ret_pd_mode_host_reg_nbt_ble                          (0x2000)                        
#define mask_rdmode_ret_pd_mode_host_reg_clk_ana_dig_en                   (0x1000)                        
#define mask_rdmode_ret_pd_mode_host_reg_rst_act_n                        (0x800)                         
#define mask_rdmode_ret_pd_mode_host_reg_reserved                         (0x600)                         
#define mask_rdmode_ret_pd_mode_host_reg_data_rate                        (0x180)                         
#define mask_rdmode_ret_pd_mode_host_reg_chn_num                          (0x7f)                          

#define reg_mode_ret_pd_ctrl_reg                                        (*(volatile uint32_t *)0x40008058)
#define adr_mode_ret_pd_ctrl_reg                                                              (0x40008058)
#define mask_mode_ret_pd_ctrl_reg_act_digen_sel                           (0x1000)                        
#define mask_mode_ret_pd_ctrl_reg_act_rst_sel                             (0x800)                         
#define mask_mode_ret_pd_ctrl_reg_radio_reg_spi_read                      (0x400)                         
#define mask_mode_ret_pd_ctrl_reg_agc_sel                                 (0x200)                         
#define mask_mode_ret_pd_ctrl_reg_chn_num_sel                             (0x100)                         
#define mask_mode_ret_pd_ctrl_reg_txdata                                  (0xc0)                          
#define mask_mode_ret_pd_ctrl_reg_trxen                                   (0x30)                          
#define mask_mode_ret_pd_ctrl_reg_rate                                    (0xc)                           
#define mask_mode_ret_pd_ctrl_reg_nbt_ble                                 (0x3)                           

#define reg_ctrl_ret_pd_rd_mode                                         (*(volatile uint32_t *)0x4000805c)
#define adr_ctrl_ret_pd_rd_mode                                                               (0x4000805c)
#define mask_ctrl_ret_pd_rd_mode_rd_dbg_rstclk_force1_en                  (0x8)                           
#define mask_ctrl_ret_pd_rd_mode_rd_clk_free_en                           (0x4)                           
#define mask_ctrl_ret_pd_rd_mode_rd_rst_free_en                           (0x2)                           
#define mask_ctrl_ret_pd_rd_mode_adc_fpga_en                              (0x1)                           

#define reg_clk_ret_pd_clk_ext_cg_en_reg                                (*(volatile uint32_t *)0x400080cc)
#define adr_clk_ret_pd_clk_ext_cg_en_reg                                                      (0x400080cc)
#define mask_clk_ret_pd_clk_ext_cg_en_reg_sdm_cg_en                       (0x800)                         
#define mask_clk_ret_pd_clk_ext_cg_en_reg_vcocali_cg_en                   (0x400)                         
#define mask_clk_ret_pd_clk_ext_cg_en_reg_apb_ext_cg_en                   (0x200)                         
#define mask_clk_ret_pd_clk_ext_cg_en_reg_trxs_ext_cg_en                  (0x100)                         
#define mask_clk_ret_pd_clk_ext_cg_en_reg_lo_ext_cg_en                    (0x80)                          
#define mask_clk_ret_pd_clk_ext_cg_en_reg_adc_ana_ext_cg_en               (0x40)                          
#define mask_clk_ret_pd_clk_ext_cg_en_reg_dyn_dcoc_ext_cg_en              (0x20)                          
#define mask_clk_ret_pd_clk_ext_cg_en_reg_rfmux_ext_cg_en                 (0x10)                          
#define mask_clk_ret_pd_clk_ext_cg_en_reg_dtm_ext_cg_en                   (0x4)                           
#define mask_clk_ret_pd_clk_ext_cg_en_reg_modem_rx_ext_cg_en              (0x2)                           
#define mask_clk_ret_pd_clk_ext_cg_en_reg_modem_tx_ext_cg_en              (0x1)                           

#define reg_clk_ret_pd_clk_en_reg                                       (*(volatile uint32_t *)0x400080d0)
#define adr_clk_ret_pd_clk_en_reg                                                             (0x400080d0)
#define mask_clk_ret_pd_clk_en_reg_sdm_lo_gate_by_syn_ldo                 (0x40)                          
#define mask_clk_ret_pd_clk_en_reg_out_sel                                (0x30)                          
#define mask_clk_ret_pd_clk_en_reg_out_en                                 (0x8)                           
#define mask_clk_ret_pd_clk_en_reg_rfdig_fd_en                            (0x4)                           
#define mask_clk_ret_pd_clk_en_reg_rfdig_iomux_en                         (0x2)                           
#define mask_clk_ret_pd_clk_en_reg_rfdig_dcoc_en                          (0x1)                           

#define reg_rfdig_ret_pd_soft_reset_reg                                 (*(volatile uint32_t *)0x400080d4)
#define adr_rfdig_ret_pd_soft_reset_reg                                                       (0x400080d4)
#define mask_rfdig_ret_pd_soft_reset_reg_rst_sdm_n                        (0x100)                         
#define mask_rfdig_ret_pd_soft_reset_reg_rst_trxs_n                       (0x80)                          
#define mask_rfdig_ret_pd_soft_reset_reg_rst_lo16_n                       (0x40)                          
#define mask_rfdig_ret_pd_soft_reset_reg_rst_dtm_n                        (0x20)                          
#define mask_rfdig_ret_pd_soft_reset_reg_rst_mdm_n                        (0x10)                          
#define mask_rfdig_ret_pd_soft_reset_reg_rst_txp_n                        (0x8)                           
#define mask_rfdig_ret_pd_soft_reset_reg_rfmux_reset_n                    (0x4)                           
#define mask_rfdig_ret_pd_soft_reset_reg_fd_reset_n                       (0x2)                           
#define mask_rfdig_ret_pd_soft_reset_reg_dcoc_reset_n                     (0x1)                           

#define reg_brxp_ret_pd_brxp_ctrl_reg                                   (*(volatile uint32_t *)0x400080d8)
#define adr_brxp_ret_pd_brxp_ctrl_reg                                                         (0x400080d8)
#define mask_brxp_ret_pd_brxp_ctrl_reg_agc_dc_remove_step                 (0xc0)                          
#define mask_brxp_ret_pd_brxp_ctrl_reg_gpadc_edge_sel                     (0x20)                          
#define mask_brxp_ret_pd_brxp_ctrl_reg_lsb_zero                           (0x10)                          
#define mask_brxp_ret_pd_brxp_ctrl_reg_clk_edge_sel                       (0x8)                           
#define mask_brxp_ret_pd_brxp_ctrl_reg_iq_swap                            (0x4)                           
#define mask_brxp_ret_pd_brxp_ctrl_reg_i_en                               (0x2)                           
#define mask_brxp_ret_pd_brxp_ctrl_reg_q_en                               (0x1)                           

#define reg_rfmux_ret_pd_btrx_rx_2m_rate_fd_offset                      (*(volatile uint32_t *)0x400080dc)
#define adr_rfmux_ret_pd_btrx_rx_2m_rate_fd_offset                                            (0x400080dc)
#define mask_rfmux_ret_pd_btrx_rx_2m_rate_fd_offset_btrx_rx_fd_offset_2m  (0x7f)                          

#define reg_rfmux_ret_pd_host_btrx_fd_offset_reg                        (*(volatile uint32_t *)0x400080e0)
#define adr_rfmux_ret_pd_host_btrx_fd_offset_reg                                              (0x400080e0)
#define mask_rfmux_ret_pd_host_btrx_fd_offset_reg_RX_FD_OFFSET            (0x7f)                          

#define reg_rfmux_ret_pd_holtek_mode_table_idx_reg                      (*(volatile uint32_t *)0x400080e8)
#define adr_rfmux_ret_pd_holtek_mode_table_idx_reg                                            (0x400080e8)
#define mask_rfmux_ret_pd_holtek_mode_table_idx_reg_mode_idx              (0x3)                           

#define reg_rfmux_ret_pd_control_mode_cfg                               (*(volatile uint32_t *)0x400080ec)
#define adr_rfmux_ret_pd_control_mode_cfg                                                     (0x400080ec)
#define mask_rfmux_ret_pd_control_mode_cfg_exlna_polarity                 (0x800)                         
#define mask_rfmux_ret_pd_control_mode_cfg_exlna_host                     (0x400)                         
#define mask_rfmux_ret_pd_control_mode_cfg_exlna_host_en                  (0x200)                         
#define mask_rfmux_ret_pd_control_mode_cfg_expa_polarity                  (0x100)                         
#define mask_rfmux_ret_pd_control_mode_cfg_expa_host                      (0x80)                          
#define mask_rfmux_ret_pd_control_mode_cfg_expa_sel                       (0x60)                          
#define mask_rfmux_ret_pd_control_mode_cfg_txpower_host_en                (0x10)                          
#define mask_rfmux_ret_pd_control_mode_cfg_btrx_host_en                   (0x8)                           
#define mask_rfmux_ret_pd_control_mode_cfg_sw_host_en                     (0x4)                           
#define mask_rfmux_ret_pd_control_mode_cfg_mode_ht32_en                   (0x2)                           
#define mask_rfmux_ret_pd_control_mode_cfg_mode_host_en                   (0x1)                           

#define reg_fd_ret_pd_tune_sel                                          (*(volatile uint32_t *)0x400080f0)
#define adr_fd_ret_pd_tune_sel                                                                (0x400080f0)

#define reg_fd_ret_pd_btrx_tune_ctrl                                    (*(volatile uint32_t *)0x400080f4)
#define adr_fd_ret_pd_btrx_tune_ctrl                                                          (0x400080f4)

#define reg_ioproc_ret_pd_io_proc_sel_reg                               (*(volatile uint32_t *)0x400080f8)
#define adr_ioproc_ret_pd_io_proc_sel_reg                                                     (0x400080f8)
#define mask_ioproc_ret_pd_io_proc_sel_reg_trx_glitch_en                  (0x20)                          
#define mask_ioproc_ret_pd_io_proc_sel_reg_agc_pos_sel                    (0x10)                          
#define mask_ioproc_ret_pd_io_proc_sel_reg_rate_pos_sel                   (0x8)                           
#define mask_ioproc_ret_pd_io_proc_sel_reg_gfsk_pos_sel                   (0x4)                           
#define mask_ioproc_ret_pd_io_proc_sel_reg_brxp_input_data_sel            (0x3)                           

#define reg_rfmux_ret_pd_pa_gain_sel                                    (*(volatile uint32_t *)0x400080fc)
#define adr_rfmux_ret_pd_pa_gain_sel                                                          (0x400080fc)
#define mask_rfmux_ret_pd_pa_gain_sel_pa_gain                             (0x7)                           

#define reg_rfmux_ret_pd_mode_en_tbl_idle_wd0_reg                       (*(volatile uint32_t *)0x40008100)
#define adr_rfmux_ret_pd_mode_en_tbl_idle_wd0_reg                                             (0x40008100)
#define mask_rfmux_ret_pd_mode_en_tbl_idle_wd0_reg_mode_en_tbl_idle_wd0   (0xffff)                        

#define reg_rfmux_ret_pd_mode_en_tbl_tx_wd0_reg                         (*(volatile uint32_t *)0x40008104)
#define adr_rfmux_ret_pd_mode_en_tbl_tx_wd0_reg                                               (0x40008104)
#define mask_rfmux_ret_pd_mode_en_tbl_tx_wd0_reg_mode_en_tbl_tx_wd0       (0xffff)                        

#define reg_rfmux_ret_pd_mode_en_tbl_rx_wd0_reg                         (*(volatile uint32_t *)0x40008108)
#define adr_rfmux_ret_pd_mode_en_tbl_rx_wd0_reg                                               (0x40008108)
#define mask_rfmux_ret_pd_mode_en_tbl_rx_wd0_reg_mode_en_tbl_rx_wd0       (0xffff)                        

#define reg_rfmux_ret_pd_btrx_rx_fd_offset_reg                          (*(volatile uint32_t *)0x4000810c)
#define adr_rfmux_ret_pd_btrx_rx_fd_offset_reg                                                (0x4000810c)
#define mask_rfmux_ret_pd_btrx_rx_fd_offset_reg_btrx_rx_fd_offset_entry1  (0x3f80)                        
#define mask_rfmux_ret_pd_btrx_rx_fd_offset_reg_btrx_rx_fd_offset_entry0  (0x7f)                          

#define reg_soi_ret_pd_tbl_cfg0                                         (*(volatile uint32_t *)0x40008110)
#define adr_soi_ret_pd_tbl_cfg0                                                               (0x40008110)
#define mask_soi_ret_pd_tbl_cfg0_rfon_time_sel                            (0x200)                         
#define mask_soi_ret_pd_tbl_cfg0_ctrl3                                    (0x1c0)                         
#define mask_soi_ret_pd_tbl_cfg0_ctrl2                                    (0x38)                          
#define mask_soi_ret_pd_tbl_cfg0_ctrl1                                    (0x7)                           

#define reg_soi_ret_pd_tbl_cfg1                                         (*(volatile uint32_t *)0x40008114)
#define adr_soi_ret_pd_tbl_cfg1                                                               (0x40008114)
#define mask_soi_ret_pd_tbl_cfg1_ctrl7                                    (0xe00)                         
#define mask_soi_ret_pd_tbl_cfg1_ctrl6                                    (0x1c0)                         
#define mask_soi_ret_pd_tbl_cfg1_ctrl5                                    (0x38)                          
#define mask_soi_ret_pd_tbl_cfg1_ctrl4                                    (0x7)                           

#define reg_rfmux_ret_pd_bw_cfg                                         (*(volatile uint32_t *)0x40008118)
#define adr_rfmux_ret_pd_bw_cfg                                                               (0x40008118)
#define mask_rfmux_ret_pd_bw_cfg_bw1m_r                                   (0xff00)                        
#define mask_rfmux_ret_pd_bw_cfg_bw2m_r                                   (0xff)                          

#define reg_rfmux_ret_pd_dcoc_host_cfg                                  (*(volatile uint32_t *)0x4000811c)
#define adr_rfmux_ret_pd_dcoc_host_cfg                                                        (0x4000811c)
#define mask_rfmux_ret_pd_dcoc_host_cfg_pga_2m_bw_host_en                 (0x8)                           
#define mask_rfmux_ret_pd_dcoc_host_cfg_pga_2m_if_host_en                 (0x4)                           
#define mask_rfmux_ret_pd_dcoc_host_cfg_btrx_dcoc_tia_host_en             (0x2)                           
#define mask_rfmux_ret_pd_dcoc_host_cfg_btrx_dcoc_pga_host_en             (0x1)                           

#define reg_dcoc_ret_pd_dyn_set                                         (*(volatile uint32_t *)0x40008120)
#define adr_dcoc_ret_pd_dyn_set                                                               (0x40008120)
#define mask_dcoc_ret_pd_dyn_set_dyn_rng                                  (0x7e0)                         
#define mask_dcoc_ret_pd_dyn_set_dyn_dis                                  (0x10)                          
#define mask_dcoc_ret_pd_dyn_set_dyn_dly_us                               (0xf)                           

#define reg_txp_ret_pd_txp_cfg1                                         (*(volatile uint32_t *)0x40008124)
#define adr_txp_ret_pd_txp_cfg1                                                               (0x40008124)
#define mask_txp_ret_pd_txp_cfg1_ramp_bp                                  (0x4000)                        
#define mask_txp_ret_pd_txp_cfg1_acw_exg_en                               (0x2000)                        
#define mask_txp_ret_pd_txp_cfg1_rs_cnt16_sel                             (0x1000)                        
#define mask_txp_ret_pd_txp_cfg1_acw_bp                                   (0x800)                         
#define mask_txp_ret_pd_txp_cfg1_acw_dly                                  (0x700)                         
#define mask_txp_ret_pd_txp_cfg1_ramp_step                                (0xf0)                          
#define mask_txp_ret_pd_txp_cfg1_gfskscl                                  (0xf)                           

#define reg_txp_ret_pd_txp_cfg2                                         (*(volatile uint32_t *)0x40008128)
#define adr_txp_ret_pd_txp_cfg2                                                               (0x40008128)
#define mask_txp_ret_pd_txp_cfg2_a2pscl                                   (0xff)                          

#define reg_txp_ret_pd_acw_vlu_reg                                      (*(volatile uint32_t *)0x4000812c)
#define adr_txp_ret_pd_acw_vlu_reg                                                            (0x4000812c)
#define mask_txp_ret_pd_acw_vlu_reg_ramp_time                             (0xff00)                        
#define mask_txp_ret_pd_acw_vlu_reg_acw_vlu                               (0xff)                          

#define reg_txp_ret_pd_gfcw_vlu_reg                                     (*(volatile uint32_t *)0x40008130)
#define adr_txp_ret_pd_gfcw_vlu_reg                                                           (0x40008130)
#define mask_txp_ret_pd_gfcw_vlu_reg_gfcw_scl_host_en                     (0x100)                         
#define mask_txp_ret_pd_gfcw_vlu_reg_gfcw_scl_host                        (0xff)                          

#define reg_txp_ret_pd_txpower_host_reg                                 (*(volatile uint32_t *)0x40008134)
#define adr_txp_ret_pd_txpower_host_reg                                                       (0x40008134)
#define mask_txp_ret_pd_txpower_host_reg_txpower_host_vlue                (0xff)                          

#define reg_modgain_ret_pd_base_freq_cfg                                (*(volatile uint32_t *)0x40008140)
#define adr_modgain_ret_pd_base_freq_cfg                                                      (0x40008140)
#define mask_modgain_ret_pd_base_freq_cfg_base_feq                        (0x3ff)                         

#define reg_modgain_ret_pd_adj_k_cfg                                    (*(volatile uint32_t *)0x40008144)
#define adr_modgain_ret_pd_adj_k_cfg                                                          (0x40008144)
#define mask_modgain_ret_pd_adj_k_cfg_k                                   (0xff)                          

#define reg_plldig_ret_pd_acw_cfg                                       (*(volatile uint32_t *)0x40008148)
#define adr_plldig_ret_pd_acw_cfg                                                             (0x40008148)
#define mask_plldig_ret_pd_acw_cfg_acw_mod_byp                            (0x4000)                        
#define mask_plldig_ret_pd_acw_cfg_acw_dly_sel                            (0x3f00)                        
#define mask_plldig_ret_pd_acw_cfg_acw_mod                                (0xff)                          

#define reg_plldig_ret_pd_fcw_cfg                                       (*(volatile uint32_t *)0x4000814c)
#define adr_plldig_ret_pd_fcw_cfg                                                             (0x4000814c)
#define mask_plldig_ret_pd_fcw_cfg_fcw_mod_byp                            (0x1000)                        
#define mask_plldig_ret_pd_fcw_cfg_fcw_mod                                (0xfff)                         

#define reg_plldig_ret_pd_fcw_dly_sel_reg                               (*(volatile uint32_t *)0x40008150)
#define adr_plldig_ret_pd_fcw_dly_sel_reg                                                     (0x40008150)
#define mask_plldig_ret_pd_fcw_dly_sel_reg_fcw_dly_sel                    (0x3f)                          

#define reg_plldig_ret_pd_fcw_ch1_reg                                   (*(volatile uint32_t *)0x40008154)
#define adr_plldig_ret_pd_fcw_ch1_reg                                                         (0x40008154)
#define mask_plldig_ret_pd_fcw_ch1_reg_fcw_byp                            (0x400)                         
#define mask_plldig_ret_pd_fcw_ch1_reg_fcw_ch1                            (0x3ff)                         

#define reg_plldig_ret_pd_fcw_ch0_reg                                   (*(volatile uint32_t *)0x40008158)
#define adr_plldig_ret_pd_fcw_ch0_reg                                                         (0x40008158)
#define mask_plldig_ret_pd_fcw_ch0_reg_fcw_ch0                            (0xffff)                        

#define reg_plldig_ret_pd_flo_ofset_reg                                 (*(volatile uint32_t *)0x4000815c)
#define adr_plldig_ret_pd_flo_ofset_reg                                                       (0x4000815c)
#define mask_plldig_ret_pd_flo_ofset_reg_flo_offset                       (0xfff)                         

#define reg_plldig_ret_pd_sdm_cfg                                       (*(volatile uint32_t *)0x40008160)
#define adr_plldig_ret_pd_sdm_cfg                                                             (0x40008160)
#define mask_plldig_ret_pd_sdm_cfg_rfdata_clkedge                         (0x2000)                        
#define mask_plldig_ret_pd_sdm_cfg_divn_dither                            (0x1000)                        
#define mask_plldig_ret_pd_sdm_cfg_divn_mash3                             (0x800)                         
#define mask_plldig_ret_pd_sdm_cfg_otw_order                              (0x600)                         
#define mask_plldig_ret_pd_sdm_cfg_otw_byp                                (0x100)                         
#define mask_plldig_ret_pd_sdm_cfg_otw_rbus                               (0xff)                          

#define reg_vcocali_ret_pd_modgain_scl_cfg                              (*(volatile uint32_t *)0x40008164)
#define adr_vcocali_ret_pd_modgain_scl_cfg                                                    (0x40008164)
#define mask_vcocali_ret_pd_modgain_scl_cfg_otw_sel                       (0x20)                          
#define mask_vcocali_ret_pd_modgain_scl_cfg_modgain_scale                 (0x1f)                          

#define reg_vcocali_ret_pd_modgain_cfg                                  (*(volatile uint32_t *)0x40008168)
#define adr_vcocali_ret_pd_modgain_cfg                                                        (0x40008168)
#define mask_vcocali_ret_pd_modgain_cfg_byp_modgain                       (0x1000)                        
#define mask_vcocali_ret_pd_modgain_cfg_modgain_rbus                      (0xfff)                         

#define reg_vcocali_ret_pd_vcotune_amp_cfg                              (*(volatile uint32_t *)0x4000816c)
#define adr_vcocali_ret_pd_vcotune_amp_cfg                                                    (0x4000816c)
#define mask_vcocali_ret_pd_vcotune_amp_cfg_vcobist                       (0x2000)                        
#define mask_vcocali_ret_pd_vcotune_amp_cfg_byp_amp                       (0x1000)                        
#define mask_vcocali_ret_pd_vcotune_amp_cfg_vcoib_rbus                    (0xf00)                         
#define mask_vcocali_ret_pd_vcotune_amp_cfg_byp_pvt                       (0x80)                          
#define mask_vcocali_ret_pd_vcotune_amp_cfg_vcotune_rbus                  (0x7f)                          

#define reg_vcocali_ret_pd_wait_cfg                                     (*(volatile uint32_t *)0x40008170)
#define adr_vcocali_ret_pd_wait_cfg                                                           (0x40008170)
#define mask_vcocali_ret_pd_wait_cfg_wait_startup                         (0x700)                         
#define mask_vcocali_ret_pd_wait_cfg_wait_gain                            (0xe0)                          
#define mask_vcocali_ret_pd_wait_cfg_wait_lock                            (0x1c)                          
#define mask_vcocali_ret_pd_wait_cfg_status_sel                           (0x3)                           

#define reg_xo_ret_pd_xo_cfg                                            (*(volatile uint32_t *)0x40008174)
#define adr_xo_ret_pd_xo_cfg                                                                  (0x40008174)
#define mask_xo_ret_pd_xo_cfg_doubler_en                                  (0x4)                           
#define mask_xo_ret_pd_xo_cfg_sel                                         (0x3)                           

#define reg_radio_int_status                                            (*(volatile uint32_t *)0x40008198)
#define adr_radio_int_status                                                                  (0x40008198)

#define reg_radio_ret_pd_int_mask                                       (*(volatile uint32_t *)0x4000819c)
#define adr_radio_ret_pd_int_mask                                                             (0x4000819c)

#define reg_radio_int_clear                                             (*(volatile uint32_t *)0x400081a0)
#define adr_radio_int_clear                                                                   (0x400081a0)


//---------------------------------------------------
// RF_ret_pd in  domain address definition
//---------------------------------------------------

#define reg_RF_ret_pd_RBUS_CALI_PATH1_reg                          (*(volatile uint32_t *)0x40008800)
#define adr_RF_ret_pd_RBUS_CALI_PATH1_reg                                                (0x40008800)
#define mask_RF_ret_pd_RBUS_CALI_PATH1_reg_DCOC_COMP_RST             (0x100)                         
#define mask_RF_ret_pd_RBUS_CALI_PATH1_reg_FD_EN                     (0x80)                          
#define mask_RF_ret_pd_RBUS_CALI_PATH1_reg_PGA_OP_ICTRL              (0x60)                          
#define mask_RF_ret_pd_RBUS_CALI_PATH1_reg_PGA_DCOC_RANGE            (0x10)                          
#define mask_RF_ret_pd_RBUS_CALI_PATH1_reg_RXIF_VCM_CTRL             (0xc)                           
#define mask_RF_ret_pd_RBUS_CALI_PATH1_reg_RFBG_RES_SEL              (0x3)                           

#define reg_RF_ret_pd_RBUS_RXRF_CFG_reg                            (*(volatile uint32_t *)0x40008804)
#define adr_RF_ret_pd_RBUS_RXRF_CFG_reg                                                  (0x40008804)
#define mask_RF_ret_pd_RBUS_RXRF_CFG_reg_MIXER_DCOC_RANGE            (0x200)                         
#define mask_RF_ret_pd_RBUS_RXRF_CFG_reg_MIXER_TIA_ICTRL             (0x180)                         
#define mask_RF_ret_pd_RBUS_RXRF_CFG_reg_MIXER_LO_CTRL               (0x70)                          
#define mask_RF_ret_pd_RBUS_RXRF_CFG_reg_RXRF_LNA_TANK_CTRL          (0xf)                           

#define reg_RF_ret_pd_DCDCTEST_reg                                 (*(volatile uint32_t *)0x4000880c)
#define adr_RF_ret_pd_DCDCTEST_reg                                                       (0x4000880c)
#define mask_RF_ret_pd_DCDCTEST_reg_RXIF_TEST_EN                     (0x40)                          
#define mask_RF_ret_pd_DCDCTEST_reg_RXIF_TEST_CTRL                   (0x38)                          
#define mask_RF_ret_pd_DCDCTEST_reg_RF_DCTEST_CTRL                   (0x7)                           

#define reg_RF_ret_pd_LDOs_reg                                     (*(volatile uint32_t *)0x40008810)
#define adr_RF_ret_pd_LDOs_reg                                                           (0x40008810)
#define mask_RF_ret_pd_LDOs_reg_SYN_LOOP_FILTER_RES_RX               (0xe000)                        
#define mask_RF_ret_pd_LDOs_reg_SYN_LOOP_CP_CTRL_RX                  (0x1f00)                        
#define mask_RF_ret_pd_LDOs_reg_SYN_LOOP_FILTER_RES_TX               (0xe0)                          
#define mask_RF_ret_pd_LDOs_reg_SYN_LOOP_CP_CTRL_TX                  (0x1f)                          

#define reg_RF_ret_pd_SYN_CFG1_reg                                 (*(volatile uint32_t *)0x40008814)
#define adr_RF_ret_pd_SYN_CFG1_reg                                                       (0x40008814)
#define mask_RF_ret_pd_SYN_CFG1_reg_LDO_RF_EN_BY_SYN                 (0x200)                         
#define mask_RF_ret_pd_SYN_CFG1_reg_SYN_GATE_LO16                    (0x100)                         
#define mask_RF_ret_pd_SYN_CFG1_reg_SYN_VCO_PDET_CTRL                (0xe0)                          
#define mask_RF_ret_pd_SYN_CFG1_reg_SYN_VCOIB_RES                    (0x1c)                          
#define mask_RF_ret_pd_SYN_CFG1_reg_SYN_OTW_SMP_EDGE                 (0x2)                           
#define mask_RF_ret_pd_SYN_CFG1_reg_SYN_MMD_EDGE_SEL                 (0x1)                           

#define reg_RF_ret_pd_SYN_CFG2_reg                                 (*(volatile uint32_t *)0x40008818)
#define adr_RF_ret_pd_SYN_CFG2_reg                                                       (0x40008818)
#define mask_RF_ret_pd_SYN_CFG2_reg_SYN_CP_LEAK_CTRL                 (0x780)                         
#define mask_RF_ret_pd_SYN_CFG2_reg_SYN_CP_LEAK_DIR                  (0x40)                          
#define mask_RF_ret_pd_SYN_CFG2_reg_SYN_CP_LEAK_EN                   (0x20)                          
#define mask_RF_ret_pd_SYN_CFG2_reg_SYN_CPOUT_INIT                   (0x18)                          
#define mask_RF_ret_pd_SYN_CFG2_reg_SYN_PFD_DLY                      (0x6)                           
#define mask_RF_ret_pd_SYN_CFG2_reg_SYN_LOOP_RST                     (0x1)                           

#define reg_RF_ret_pd_PA_CTRL_reg                                  (*(volatile uint32_t *)0x4000881c)
#define adr_RF_ret_pd_PA_CTRL_reg                                                        (0x4000881c)
#define mask_RF_ret_pd_PA_CTRL_reg_PA_MODE                           (0x300)                         
#define mask_RF_ret_pd_PA_CTRL_reg_PA_ACW_SMP_BYP                    (0x80)                          
#define mask_RF_ret_pd_PA_CTRL_reg_PA_ACW_SMP_EDGE                   (0x40)                          
#define mask_RF_ret_pd_PA_CTRL_reg_PA_SYNC                           (0x20)                          
#define mask_RF_ret_pd_PA_CTRL_reg_PA_H2                             (0x1e)                          
#define mask_RF_ret_pd_PA_CTRL_reg_PA_DCC_EN                         (0x1)                           

#define reg_RF_ret_pd_RBUS_RFLDO_reg                               (*(volatile uint32_t *)0x40008820)
#define adr_RF_ret_pd_RBUS_RFLDO_reg                                                     (0x40008820)
#define mask_RF_ret_pd_RBUS_RFLDO_reg_LDO_RF_EXTCAP                  (0x8000)                        
#define mask_RF_ret_pd_RBUS_RFLDO_reg_LDO_RF_CFG                     (0x7000)                        
#define mask_RF_ret_pd_RBUS_RFLDO_reg_LDO_IF_BYP                     (0x800)                         
#define mask_RF_ret_pd_RBUS_RFLDO_reg_LDO_IF_CFG                     (0x700)                         
#define mask_RF_ret_pd_RBUS_RFLDO_reg_LDO_VCO_BYP                    (0x80)                          
#define mask_RF_ret_pd_RBUS_RFLDO_reg_LDO_VCO_CFG                    (0x70)                          
#define mask_RF_ret_pd_RBUS_RFLDO_reg_LDO_CP_BYP                     (0x8)                           
#define mask_RF_ret_pd_RBUS_RFLDO_reg_LDO_CP_CFG                     (0x7)                           

#define reg_RF_ret_pd_SYN_BACKUP                                   (*(volatile uint32_t *)0x40008824)
#define adr_RF_ret_pd_SYN_BACKUP                                                         (0x40008824)

#define reg_PGA_ret_pd_IF_R                                        (*(volatile uint32_t *)0x40008828)
#define adr_PGA_ret_pd_IF_R                                                              (0x40008828)

#define reg_RF_ret_pd_RFIO_TX_reg                                  (*(volatile uint32_t *)0x4000882c)
#define adr_RF_ret_pd_RFIO_TX_reg                                                        (0x4000882c)
#define mask_RF_ret_pd_RFIO_TX_reg_RFIO_CAP1_TX_10dBm                (0x1f00)                        
#define mask_RF_ret_pd_RFIO_TX_reg_RFIO_CAP1_TX_0dBm                 (0xf8)                          
#define mask_RF_ret_pd_RFIO_TX_reg_RFIO_CAP2_TX                      (0x7)                           

#define reg_RF_ret_pd_RFIO_RX_reg                                  (*(volatile uint32_t *)0x40008830)
#define adr_RF_ret_pd_RFIO_RX_reg                                                        (0x40008830)
#define mask_RF_ret_pd_RFIO_RX_reg_RFIO_CAP1_RX                      (0x7c0)                         
#define mask_RF_ret_pd_RFIO_RX_reg_RFIO_CAP2_RX_LGAIN                (0x38)                          
#define mask_RF_ret_pd_RFIO_RX_reg_RFIO_CAP2_RX_HGAIN                (0x7)                           

#define reg_AUDIO0_RBUS_reg1                                       (*(volatile uint32_t *)0x40008884)
#define adr_AUDIO0_RBUS_reg1                                                             (0x40008884)
#define mask_AUDIO0_RBUS_reg1_MIC_BIAS_CTRL                          (0x38)                          
#define mask_AUDIO0_RBUS_reg1_ADC_EN                                 (0x4)                           
#define mask_AUDIO0_RBUS_reg1_ADC_BIAS_CFG                           (0x3)                           

#define reg_AUDIO0_RBUS_reg2                                       (*(volatile uint32_t *)0x40008888)
#define adr_AUDIO0_RBUS_reg2                                                             (0x40008888)
#define mask_AUDIO0_RBUS_reg2_MICBIAS_EXTREFA                        (0x80)                          
#define mask_AUDIO0_RBUS_reg2_MICBIAS_EXTREFB                        (0x40)                          
#define mask_AUDIO0_RBUS_reg2_MICBIAS_INTREF                         (0x20)                          
#define mask_AUDIO0_RBUS_reg2_P00_EN                                 (0x10)                          
#define mask_AUDIO0_RBUS_reg2_PGA_SHORT_INPUT                        (0x8)                           
#define mask_AUDIO0_RBUS_reg2_PGA_SINGLE_EN                          (0x4)                           
#define mask_AUDIO0_RBUS_reg2_VCM_CFG                                (0x3)                           

#define reg_AUD0_GP_ADC_AUD_reg                                    (*(volatile uint32_t *)0x4000888c)
#define adr_AUD0_GP_ADC_AUD_reg                                                          (0x4000888c)
#define mask_AUD0_GP_ADC_AUD_reg_ch_host_en                          (0x400)                         
#define mask_AUD0_GP_ADC_AUD_reg_ADC_AUD_BUF_GAIN                    (0x300)                         
#define mask_AUD0_GP_ADC_AUD_reg_ADC_AUD_BUF_EN                      (0x80)                          
#define mask_AUD0_GP_ADC_AUD_reg_ADC_AUD_BKUP                        (0x7c)                          
#define mask_AUD0_GP_ADC_AUD_reg_ADC_AUD_BIAS_CTRL                   (0x3)                           

#define reg_AUD0_ch_pga_ctrl0_cfg                                  (*(volatile uint32_t *)0x40008890)
#define adr_AUD0_ch_pga_ctrl0_cfg                                                        (0x40008890)
#define mask_AUD0_ch_pga_ctrl0_cfg_ch3_pga_g                         (0xf000)                        
#define mask_AUD0_ch_pga_ctrl0_cfg_ch2_pga_g                         (0xf00)                         
#define mask_AUD0_ch_pga_ctrl0_cfg_ch1_pga_g                         (0xf0)                          
#define mask_AUD0_ch_pga_ctrl0_cfg_ch0_pga_g                         (0xf)                           

#define reg_AUD0_ch_pga_ctrl1_cfg                                  (*(volatile uint32_t *)0x40008894)
#define adr_AUD0_ch_pga_ctrl1_cfg                                                        (0x40008894)
#define mask_AUD0_ch_pga_ctrl1_cfg_ch7_pga_g                         (0xf000)                        
#define mask_AUD0_ch_pga_ctrl1_cfg_ch6_pga_g                         (0xf00)                         
#define mask_AUD0_ch_pga_ctrl1_cfg_ch5_pga_g                         (0xf0)                          
#define mask_AUD0_ch_pga_ctrl1_cfg_ch4_pga_g                         (0xf)                           

#define reg_AUD0_ch_pga_ctrl2_cfg                                  (*(volatile uint32_t *)0x40008898)
#define adr_AUD0_ch_pga_ctrl2_cfg                                                        (0x40008898)
#define mask_AUD0_ch_pga_ctrl2_cfg_pga_host_en                       (0x100)                         
#define mask_AUD0_ch_pga_ctrl2_cfg_ch9_pga_g                         (0xf0)                          
#define mask_AUD0_ch_pga_ctrl2_cfg_ch8_pga_g                         (0xf)                           

#define reg_AUDIO1_RBUS_reg1                                       (*(volatile uint32_t *)0x400088c8)
#define adr_AUDIO1_RBUS_reg1                                                             (0x400088c8)
#define mask_AUDIO1_RBUS_reg1_MIC_BIAS_CTRL                          (0x38)                          
#define mask_AUDIO1_RBUS_reg1_ADC_EN                                 (0x4)                           
#define mask_AUDIO1_RBUS_reg1_ADC_BIAS_CFG                           (0x3)                           

#define reg_AUDIO1_RBUS_reg2                                       (*(volatile uint32_t *)0x400088cc)
#define adr_AUDIO1_RBUS_reg2                                                             (0x400088cc)
#define mask_AUDIO1_RBUS_reg2_MICBIAS_EXTREFA                        (0x80)                          
#define mask_AUDIO1_RBUS_reg2_MICBIAS_EXTREFB                        (0x40)                          
#define mask_AUDIO1_RBUS_reg2_MICBIAS_INTREF                         (0x20)                          
#define mask_AUDIO1_RBUS_reg2_P00_EN                                 (0x10)                          
#define mask_AUDIO1_RBUS_reg2_PGA_SHORT_INPUT                        (0x8)                           
#define mask_AUDIO1_RBUS_reg2_PGA_SINGLE_EN                          (0x4)                           
#define mask_AUDIO1_RBUS_reg2_VCM_CFG                                (0x3)                           

#define reg_AUD1_GP_ADC_AUD_reg                                    (*(volatile uint32_t *)0x400088d0)
#define adr_AUD1_GP_ADC_AUD_reg                                                          (0x400088d0)
#define mask_AUD1_GP_ADC_AUD_reg_ch_host_en                          (0x400)                         
#define mask_AUD1_GP_ADC_AUD_reg_ADC_AUD_BUF_GAIN                    (0x300)                         
#define mask_AUD1_GP_ADC_AUD_reg_ADC_AUD_BUF_EN                      (0x80)                          
#define mask_AUD1_GP_ADC_AUD_reg_ADC_AUD_BKUP                        (0x7c)                          
#define mask_AUD1_GP_ADC_AUD_reg_ADC_AUD_BIAS_CTRL                   (0x3)                           

#define reg_AUD1_ch_pga_ctrl0_cfg                                  (*(volatile uint32_t *)0x400088d4)
#define adr_AUD1_ch_pga_ctrl0_cfg                                                        (0x400088d4)
#define mask_AUD1_ch_pga_ctrl0_cfg_ch3_pga_g                         (0xf000)                        
#define mask_AUD1_ch_pga_ctrl0_cfg_ch2_pga_g                         (0xf00)                         
#define mask_AUD1_ch_pga_ctrl0_cfg_ch1_pga_g                         (0xf0)                          
#define mask_AUD1_ch_pga_ctrl0_cfg_ch0_pga_g                         (0xf)                           

#define reg_AUD1_ch_pga_ctrl1_cfg                                  (*(volatile uint32_t *)0x400088d8)
#define adr_AUD1_ch_pga_ctrl1_cfg                                                        (0x400088d8)
#define mask_AUD1_ch_pga_ctrl1_cfg_ch7_pga_g                         (0xf000)                        
#define mask_AUD1_ch_pga_ctrl1_cfg_ch6_pga_g                         (0xf00)                         
#define mask_AUD1_ch_pga_ctrl1_cfg_ch5_pga_g                         (0xf0)                          
#define mask_AUD1_ch_pga_ctrl1_cfg_ch4_pga_g                         (0xf)                           

#define reg_AUD1_ch_pga_ctrl2_cfg                                  (*(volatile uint32_t *)0x400088dc)
#define adr_AUD1_ch_pga_ctrl2_cfg                                                        (0x400088dc)
#define mask_AUD1_ch_pga_ctrl2_cfg_pga_host_en                       (0x100)                         
#define mask_AUD1_ch_pga_ctrl2_cfg_ch9_pga_g                         (0xf0)                          
#define mask_AUD1_ch_pga_ctrl2_cfg_ch8_pga_g                         (0xf)                           


//---------------------------------------------------
// morx_ret_pd in  domain address definition
//---------------------------------------------------

#define reg_morx_ret_pd_agc_config_reg                             (*(volatile uint32_t *)0x40009000)
#define adr_morx_ret_pd_agc_config_reg                                                   (0x40009000)
#define mask_morx_ret_pd_agc_config_reg_aci_wait_num                 (0xf000)                        
#define mask_morx_ret_pd_agc_config_reg_agc_ripple_sel               (0x800)                         
#define mask_morx_ret_pd_agc_config_reg_avgf_bypass                  (0x400)                         
#define mask_morx_ret_pd_agc_config_reg_default_state                (0x200)                         
#define mask_morx_ret_pd_agc_config_reg_agc_step1_dcr_en             (0x100)                         
#define mask_morx_ret_pd_agc_config_reg_wb_dcr_n                     (0xe0)                          
#define mask_morx_ret_pd_agc_config_reg_agc_dcr_en                   (0x10)                          
#define mask_morx_ret_pd_agc_config_reg_agc_wait_num                 (0xf)                           

#define reg_morx_ret_pd_agc_rssi_max                               (*(volatile uint32_t *)0x40009004)
#define adr_morx_ret_pd_agc_rssi_max                                                     (0x40009004)
#define mask_morx_ret_pd_agc_rssi_max_agc_rssi_2_max                 (0xff00)                        
#define mask_morx_ret_pd_agc_rssi_max_agc_rssi_1_max                 (0xff)                          

#define reg_morx_ret_pd_agc_rssi_min                               (*(volatile uint32_t *)0x40009008)
#define adr_morx_ret_pd_agc_rssi_min                                                     (0x40009008)

#define reg_morx_ret_pd_agc_rssi_scl                               (*(volatile uint32_t *)0x4000900c)
#define adr_morx_ret_pd_agc_rssi_scl                                                     (0x4000900c)
#define mask_morx_ret_pd_agc_rssi_scl_agc_rssi_g1_th                 (0xfe00)                        
#define mask_morx_ret_pd_agc_rssi_scl_agc_rssi_dnscl                 (0x1c0)                         
#define mask_morx_ret_pd_agc_rssi_scl_agc_rssi_2_upscl               (0x38)                          
#define mask_morx_ret_pd_agc_rssi_scl_agc_rssi_1_upscl               (0x7)                           

#define reg_morx_ret_pd_agc_bb_ctrl                                (*(volatile uint32_t *)0x40009010)
#define adr_morx_ret_pd_agc_bb_ctrl                                                      (0x40009010)
#define mask_morx_ret_pd_agc_bb_ctrl_agc_aci_new_old                 (0x400)                         
#define mask_morx_ret_pd_agc_bb_ctrl_agc_step_sel                    (0x200)                         
#define mask_morx_ret_pd_agc_bb_ctrl_agc_gn_scl                      (0x1c0)                         
#define mask_morx_ret_pd_agc_bb_ctrl_reserved                        (0x30)                          
#define mask_morx_ret_pd_agc_bb_ctrl_bb_agc                          (0x6)                           
#define mask_morx_ret_pd_agc_bb_ctrl_bypass_mdm_agc                  (0x1)                           

#define reg_morx_ret_pd_agc_th                                     (*(volatile uint32_t *)0x40009014)
#define adr_morx_ret_pd_agc_th                                                           (0x40009014)
#define mask_morx_ret_pd_agc_th_agc_aci_step_1to0_th                 (0x7f8)                         
#define mask_morx_ret_pd_agc_th_agc_sat_th                           (0x7)                           

#define reg_morx_ret_pd_acr_process                                (*(volatile uint32_t *)0x40009018)
#define adr_morx_ret_pd_acr_process                                                      (0x40009018)
#define mask_morx_ret_pd_acr_process_aci_try_en                      (0x100)                         
#define mask_morx_ret_pd_acr_process_aci_try_sel                     (0xff)                          

#define reg_morx_ret_pd_agc_time_out_th                            (*(volatile uint32_t *)0x4000901c)
#define adr_morx_ret_pd_agc_time_out_th                                                  (0x4000901c)

#define reg_morx_ret_pd_cte                                        (*(volatile uint32_t *)0x40009028)
#define adr_morx_ret_pd_cte                                                              (0x40009028)
#define mask_morx_ret_pd_cte_samp_sel                                (0x30)                          
#define mask_morx_ret_pd_cte_samp_offset                             (0xf)                           

#define reg_morx_ret_pd_rssi_2_byte                                (*(volatile uint32_t *)0x4000902c)
#define adr_morx_ret_pd_rssi_2_byte                                                      (0x4000902c)

#define reg_morx_ret_pd_rssi_th                                    (*(volatile uint32_t *)0x40009030)
#define adr_morx_ret_pd_rssi_th                                                          (0x40009030)

#define reg_morx_ret_pd_rssi_trig                                  (*(volatile uint32_t *)0x40009034)
#define adr_morx_ret_pd_rssi_trig                                                        (0x40009034)

#define reg_morx_ret_pd_fo_ctrl                                    (*(volatile uint32_t *)0x40009038)
#define adr_morx_ret_pd_fo_ctrl                                                          (0x40009038)
#define mask_morx_ret_pd_fo_ctrl_hard_peak_th                        (0x6)                           
#define mask_morx_ret_pd_fo_ctrl_fbp_en                              (0x1)                           

#define reg_morx_ret_pd_radio_mode                                 (*(volatile uint32_t *)0x4000903c)
#define adr_morx_ret_pd_radio_mode                                                       (0x4000903c)
#define mask_morx_ret_pd_radio_mode_rd_mode                          (0x3)                           

#define reg_morx_ret_pd_access_code_hi                             (*(volatile uint32_t *)0x40009040)
#define adr_morx_ret_pd_access_code_hi                                                   (0x40009040)

#define reg_morx_ret_pd_access_code_lo                             (*(volatile uint32_t *)0x40009044)
#define adr_morx_ret_pd_access_code_lo                                                   (0x40009044)

#define reg_morx_ret_pd_db_rssi_agc0                               (*(volatile uint32_t *)0x40009048)
#define adr_morx_ret_pd_db_rssi_agc0                                                     (0x40009048)

#define reg_morx_ret_pd_db_rssi_agc1                               (*(volatile uint32_t *)0x4000904c)
#define adr_morx_ret_pd_db_rssi_agc1                                                     (0x4000904c)

#define reg_morx_ret_pd_db_rssi_agc2                               (*(volatile uint32_t *)0x40009050)
#define adr_morx_ret_pd_db_rssi_agc2                                                     (0x40009050)

#define reg_morx_ret_pd_power_ant_sub_value                        (*(volatile uint32_t *)0x40009054)
#define adr_morx_ret_pd_power_ant_sub_value                                              (0x40009054)

#define reg_morx_ret_pd_agc_dco_th                                 (*(volatile uint32_t *)0x40009058)
#define adr_morx_ret_pd_agc_dco_th                                                       (0x40009058)

#define reg_morx_ret_pd_agc_pwr_th                                 (*(volatile uint32_t *)0x4000905c)
#define adr_morx_ret_pd_agc_pwr_th                                                       (0x4000905c)

#define reg_morx_ret_pd_agc_g1_th                                  (*(volatile uint32_t *)0x40009060)
#define adr_morx_ret_pd_agc_g1_th                                                        (0x40009060)

#define reg_morx_ret_pd_agc_ib_sel                                 (*(volatile uint32_t *)0x40009064)
#define adr_morx_ret_pd_agc_ib_sel                                                       (0x40009064)

#define reg_motx_ret_pd_gfsk_dly                                   (*(volatile uint32_t *)0x40009070)
#define adr_motx_ret_pd_gfsk_dly                                                         (0x40009070)

#define reg_motx_ret_pd_dat_swap_en                                (*(volatile uint32_t *)0x40009074)
#define adr_motx_ret_pd_dat_swap_en                                                      (0x40009074)

#define reg_motx_ret_pd_config                                     (*(volatile uint32_t *)0x40009078)
#define adr_motx_ret_pd_config                                                           (0x40009078)
#define mask_motx_ret_pd_config_trailing_time                        (0x70)                          
#define mask_motx_ret_pd_config_cte_dat                              (0xc)                           
#define mask_motx_ret_pd_config_sft_sel                              (0x3)                           


//---------------------------------------------------
// dbg in  domain address definition
//---------------------------------------------------

#define reg_dbg_cfg1                                               (*(volatile uint32_t *)0x40009820)
#define adr_dbg_cfg1                                                                     (0x40009820)
#define mask_dbg_cfg1_morx_sel                                       (0xf00)                         
#define mask_dbg_cfg1_adc_sel                                        (0xc0)                          
#define mask_dbg_cfg1_mdm_sel                                        (0x30)                          
#define mask_dbg_cfg1_txp_sel                                        (0xc)                           
#define mask_dbg_cfg1_out_sel                                        (0x3)                           

#define reg_rdon_sel                                               (*(volatile uint32_t *)0x40009824)
#define adr_rdon_sel                                                                     (0x40009824)
#define mask_rdon_sel_dp_sel                                         (0xf)                           

#define reg_fd_bgn                                                 (*(volatile uint32_t *)0x40009854)
#define adr_fd_bgn                                                                       (0x40009854)

#define reg_rfmux_RBUS_DCOC_CFG1_reg                               (*(volatile uint32_t *)0x40009860)
#define adr_rfmux_RBUS_DCOC_CFG1_reg                                                     (0x40009860)
#define mask_rfmux_RBUS_DCOC_CFG1_reg_MIXER_DCOCQ                    (0xff00)                        
#define mask_rfmux_RBUS_DCOC_CFG1_reg_MIXER_DCOCI                    (0xff)                          

#define reg_rfmux_RBUS_DCOC_CFG2_reg                               (*(volatile uint32_t *)0x40009864)
#define adr_rfmux_RBUS_DCOC_CFG2_reg                                                     (0x40009864)
#define mask_rfmux_RBUS_DCOC_CFG2_reg_PGA_DCOCQ                      (0xff00)                        
#define mask_rfmux_RBUS_DCOC_CFG2_reg_PGA_DCOCI                      (0xff)                          

#define reg_rfmux_RBUS_TRX_GAIN1_reg                               (*(volatile uint32_t *)0x40009868)
#define adr_rfmux_RBUS_TRX_GAIN1_reg                                                     (0x40009868)
#define mask_rfmux_RBUS_TRX_GAIN1_reg_PGA_GAIN                       (0x3c0)                         
#define mask_rfmux_RBUS_TRX_GAIN1_reg_MIXER_IF_G                     (0x38)                          
#define mask_rfmux_RBUS_TRX_GAIN1_reg_LNA_GAIN                       (0x7)                           

#define reg_rfmux_TRX_EN1_reg                                      (*(volatile uint32_t *)0x4000986c)
#define adr_rfmux_TRX_EN1_reg                                                            (0x4000986c)
#define mask_rfmux_TRX_EN1_reg_mode_en_tbl_host                      (0xffff)                        

#define reg_rfmux_2M_CFG_reg                                       (*(volatile uint32_t *)0x40009870)
#define adr_rfmux_2M_CFG_reg                                                             (0x40009870)
#define mask_rfmux_2M_CFG_reg_LNA_C                                  (0xc0)                          
#define mask_rfmux_2M_CFG_reg_RXRF_GM2_C                             (0x30)                          
#define mask_rfmux_2M_CFG_reg_RXRF_GM1_C                             (0xc)                           
#define mask_rfmux_2M_CFG_reg_PGA_2M_BW                              (0x2)                           
#define mask_rfmux_2M_CFG_reg_PGA_2M_IF                              (0x1)                           

#define reg_test_tx_en_bf_dat_time                                 (*(volatile uint32_t *)0x400098b4)
#define adr_test_tx_en_bf_dat_time                                                       (0x400098b4)

#define reg_modem_bluerf_test_set                                  (*(volatile uint32_t *)0x400098b8)
#define adr_modem_bluerf_test_set                                                        (0x400098b8)
#define mask_modem_bluerf_test_set_testber_dat_fr_adc                (0x20)                          
#define mask_modem_bluerf_test_set_tx_polsel_vld                     (0x10)                          
#define mask_modem_bluerf_test_set_test_continu_vld                  (0x8)                           
#define mask_modem_bluerf_test_set_srcsel                            (0x7)                           

#define reg_modem_process_ctrl                                     (*(volatile uint32_t *)0x400098bc)
#define adr_modem_process_ctrl                                                           (0x400098bc)
#define mask_modem_process_ctrl_test_end                             (0x4)                           
#define mask_modem_process_ctrl_ber_clr                              (0x2)                           
#define mask_modem_process_ctrl_test_start                           (0x1)                           

#define reg_test_rx_en_dur_time                                    (*(volatile uint32_t *)0x400098c0)
#define adr_test_rx_en_dur_time                                                          (0x400098c0)

#define reg_test_pkg_num                                           (*(volatile uint32_t *)0x400098c4)
#define adr_test_pkg_num                                                                 (0x400098c4)

#define reg_test_pdu_length                                        (*(volatile uint32_t *)0x400098c8)
#define adr_test_pdu_length                                                              (0x400098c8)

#define reg_test_test_intv_set                                     (*(volatile uint32_t *)0x400098cc)
#define adr_test_test_intv_set                                                           (0x400098cc)
#define mask_test_test_intv_set_syn_dat_inv                          (0x800)                         
#define mask_test_test_intv_set_ble_bypass_white                     (0x400)                         
#define mask_test_test_intv_set_pkg_intv                             (0x3ff)                         

#define reg_test_ble_head                                          (*(volatile uint32_t *)0x400098d0)
#define adr_test_ble_head                                                                (0x400098d0)

#define reg_test_reg_set                                           (*(volatile uint32_t *)0x400098d4)
#define adr_test_reg_set                                                                 (0x400098d4)

#define reg_test_acc3                                              (*(volatile uint32_t *)0x400098d8)
#define adr_test_acc3                                                                    (0x400098d8)

#define reg_test_acc2                                              (*(volatile uint32_t *)0x400098dc)
#define adr_test_acc2                                                                    (0x400098dc)

#define reg_test_acc1                                              (*(volatile uint32_t *)0x400098e0)
#define adr_test_acc1                                                                    (0x400098e0)

#define reg_test_acc0                                              (*(volatile uint32_t *)0x400098e4)
#define adr_test_acc0                                                                    (0x400098e4)

#define reg_test_test_data_sel                                     (*(volatile uint32_t *)0x400098e8)
#define adr_test_test_data_sel                                                           (0x400098e8)
#define mask_test_test_data_sel_rssi_req                             (0x80)                          
#define mask_test_test_data_sel_ble_mode                             (0x40)                          
#define mask_test_test_data_sel_edr_mode                             (0x20)                          
#define mask_test_test_data_sel_rx_en                                (0x10)                          
#define mask_test_test_data_sel_code_rate                            (0xc)                           
#define mask_test_test_data_sel_data_rate                            (0x3)                           

#define reg_RF_SYN_TRX_reg                                         (*(volatile uint32_t *)0x40009938)
#define adr_RF_SYN_TRX_reg                                                               (0x40009938)
#define mask_RF_SYN_TRX_reg_idx_flo                                  (0xffc0)                        
#define mask_RF_SYN_TRX_reg_tx_sel                                   (0x20)                          
#define mask_RF_SYN_TRX_reg_SYN_OTW_SMP_BYP                          (0x10)                          
#define mask_RF_SYN_TRX_reg_adpll_start                              (0x8)                           
#define mask_RF_SYN_TRX_reg_SYN_TX_LOBUFF_EN                         (0x4)                           
#define mask_RF_SYN_TRX_reg_SYN_RX_LOBUFF_EN                         (0x2)                           
#define mask_RF_SYN_TRX_reg_SYN_LDO_SYN_EN                           (0x1)                           

#define reg_dcoc_dcoc_wait_tim_set                                 (*(volatile uint32_t *)0x40009948)
#define adr_dcoc_dcoc_wait_tim_set                                                       (0x40009948)
#define mask_dcoc_dcoc_wait_tim_set_mode_set_tw                      (0xc0)                          
#define mask_dcoc_dcoc_wait_tim_set_init_settle_tw                   (0x30)                          
#define mask_dcoc_dcoc_wait_tim_set_idac_settle_tw                   (0xc)                           
#define mask_dcoc_dcoc_wait_tim_set_gain_settle_tw                   (0x3)                           

#define reg_dcoc_dcoc_path_switch_reg                              (*(volatile uint32_t *)0x4000994c)
#define adr_dcoc_dcoc_path_switch_reg                                                    (0x4000994c)
#define mask_dcoc_dcoc_path_switch_reg_mode_adrs_sel                 (0xc00)                         
#define mask_dcoc_dcoc_path_switch_reg_k_std_up_sel                  (0x200)                         
#define mask_dcoc_dcoc_path_switch_reg_rd_dcoc_sel                   (0x180)                         
#define mask_dcoc_dcoc_path_switch_reg_dac_polarity_pga_ipath        (0x40)                          
#define mask_dcoc_dcoc_path_switch_reg_dac_polarity_pga_qpath        (0x20)                          
#define mask_dcoc_dcoc_path_switch_reg_dac_polarity_tia_ipath        (0x10)                          
#define mask_dcoc_dcoc_path_switch_reg_dac_polarity_tia_qpath        (0x8)                           
#define mask_dcoc_dcoc_path_switch_reg_sw_vcm_bt                     (0x4)                           
#define mask_dcoc_dcoc_path_switch_reg_complex_en                    (0x2)                           
#define mask_dcoc_dcoc_path_switch_reg_iqdac_exchange                (0x1)                           

#define reg_dcoc_dcoc_path_dc_target                               (*(volatile uint32_t *)0x40009950)
#define adr_dcoc_dcoc_path_dc_target                                                     (0x40009950)
#define mask_dcoc_dcoc_path_dc_target_dc_target                      (0x1ff)                         

#define reg_dcoc_bgn                                               (*(volatile uint32_t *)0x40009954)
#define adr_dcoc_bgn                                                                     (0x40009954)

#define reg_dcoc_dcoc_ctrl_reg                                     (*(volatile uint32_t *)0x40009958)
#define adr_dcoc_dcoc_ctrl_reg                                                           (0x40009958)
#define mask_dcoc_dcoc_ctrl_reg_tia_bgn_channel                      (0x3f80)                        
#define mask_dcoc_dcoc_ctrl_reg_manu_gain_set                        (0x60)                          
#define mask_dcoc_dcoc_ctrl_reg_manu_mode_set                        (0x1e)                          
#define mask_dcoc_dcoc_ctrl_reg_manual_mode_en                       (0x1)                           

#define reg_dcoc_dcoc_work_en                                      (*(volatile uint32_t *)0x4000995c)
#define adr_dcoc_dcoc_work_en                                                            (0x4000995c)
#define mask_dcoc_dcoc_work_en_spur_bp_en                            (0x8)                           
#define mask_dcoc_dcoc_work_en_k_en                                  (0x4)                           
#define mask_dcoc_dcoc_work_en_pga_en                                (0x2)                           
#define mask_dcoc_dcoc_work_en_tia_en                                (0x1)                           

#define reg_dcoc_mode_adr                                          (*(volatile uint32_t *)0x40009960)
#define adr_dcoc_mode_adr                                                                (0x40009960)

#define reg_dcoc_dcoc_rng_set_reg                                  (*(volatile uint32_t *)0x40009964)
#define adr_dcoc_dcoc_rng_set_reg                                                        (0x40009964)
#define mask_dcoc_dcoc_rng_set_reg_chn_step                          (0x1f0)                         
#define mask_dcoc_dcoc_rng_set_reg_dac_offset                        (0xf)                           

#define reg_dcoc_pga_wdat1                                         (*(volatile uint32_t *)0x40009968)
#define adr_dcoc_pga_wdat1                                                               (0x40009968)

#define reg_dcoc_pga_wadr2                                         (*(volatile uint32_t *)0x4000996c)
#define adr_dcoc_pga_wadr2                                                               (0x4000996c)

#define reg_dcoc_pga_wdat2                                         (*(volatile uint32_t *)0x40009970)
#define adr_dcoc_pga_wdat2                                                               (0x40009970)

#define reg_dcoc_tia_wdat1                                         (*(volatile uint32_t *)0x40009984)
#define adr_dcoc_tia_wdat1                                                               (0x40009984)

#define reg_dcoc_k_wdat1                                           (*(volatile uint32_t *)0x4000999c)
#define adr_dcoc_k_wdat1                                                                 (0x4000999c)

#define reg_dcoc_k_wadr2                                           (*(volatile uint32_t *)0x400099a0)
#define adr_dcoc_k_wadr2                                                                 (0x400099a0)

#define reg_dcoc_k_wdat2                                           (*(volatile uint32_t *)0x400099a4)
#define adr_dcoc_k_wdat2                                                                 (0x400099a4)

#define reg_dcoc_back_wadr2                                        (*(volatile uint32_t *)0x400099b4)
#define adr_dcoc_back_wadr2                                                              (0x400099b4)

#define reg_dcoc_back_wdat2                                        (*(volatile uint32_t *)0x400099b8)
#define adr_dcoc_back_wdat2                                                              (0x400099b8)

#define reg_rxp_dc_offset                                          (*(volatile uint32_t *)0x400099c4)
#define adr_rxp_dc_offset                                                                (0x400099c4)
#define mask_rxp_dc_offset_dci_offset                                (0xff00)                        
#define mask_rxp_dc_offset_dcq_offset                                (0xff)                          

#define reg_dc_cal_trig                                            (*(volatile uint32_t *)0x400099c8)
#define adr_dc_cal_trig                                                                  (0x400099c8)
#define mask_dc_cal_trig_cal_bgn                                     (0x2)                           
#define mask_dc_cal_trig_cal_clr                                     (0x1)                           

#define reg_ctrl_sreg0_data                                        (*(volatile uint32_t *)0x400099cc)
#define adr_ctrl_sreg0_data                                                              (0x400099cc)

#define reg_ctrl_sreg1_data                                        (*(volatile uint32_t *)0x400099d0)
#define adr_ctrl_sreg1_data                                                              (0x400099d0)

#define reg_test_multi_cell_sel                                    (*(volatile uint32_t *)0x400099f8)
#define adr_test_multi_cell_sel                                                          (0x400099f8)

#define reg_rcb_clk_div                                            (*(volatile uint32_t *)0x400099fc)
#define adr_rcb_clk_div                                                                  (0x400099fc)


//---------------------------------------------------
// dp in  domain address definition
//---------------------------------------------------

#define reg_dp_rdon_mux                                            (*(volatile uint32_t *)0x4000a000)
#define adr_dp_rdon_mux                                                                  (0x4000a000)

#define reg_morx_peak_found                                        (*(volatile uint32_t *)0x4000a00c)
#define adr_morx_peak_found                                                              (0x4000a00c)

#define reg_morx_agc_rssi_rd                                       (*(volatile uint32_t *)0x4000a010)
#define adr_morx_agc_rssi_rd                                                             (0x4000a010)
#define mask_morx_agc_rssi_rd_agc_step                               (0xc000)                        
#define mask_morx_agc_rssi_rd_rssi_sum                               (0x3fff)                        

#define reg_morx_agc_wb_rssi_rd                                    (*(volatile uint32_t *)0x4000a014)
#define adr_morx_agc_wb_rssi_rd                                                          (0x4000a014)
#define mask_morx_agc_wb_rssi_rd_wb_agc                              (0x6000)                        
#define mask_morx_agc_wb_rssi_rd_wb_rssi                             (0x1fff)                        

#define reg_morx_agc_dbg                                           (*(volatile uint32_t *)0x4000a018)
#define adr_morx_agc_dbg                                                                 (0x4000a018)

#define reg_morx_fbp_fo                                            (*(volatile uint32_t *)0x4000a020)
#define adr_morx_fbp_fo                                                                  (0x4000a020)

#define reg_morx_db_rssi_rd                                        (*(volatile uint32_t *)0x4000a024)
#define adr_morx_db_rssi_rd                                                              (0x4000a024)

#define reg_morx_agc_state                                         (*(volatile uint32_t *)0x4000a028)
#define adr_morx_agc_state                                                               (0x4000a028)
#define mask_morx_agc_state_agc_hold_rd                              (0x40)                          
#define mask_morx_agc_state_aci_state                                (0x3f)                          

#define reg_morx_rd                                                (*(volatile uint32_t *)0x4000a02c)
#define adr_morx_rd                                                                      (0x4000a02c)

#define reg_morx_ld                                                (*(volatile uint32_t *)0x4000a030)
#define adr_morx_ld                                                                      (0x4000a030)

#define reg_rfmux_bb_mode_read_reg                                 (*(volatile uint32_t *)0x4000a03c)
#define adr_rfmux_bb_mode_read_reg                                                       (0x4000a03c)
#define mask_rfmux_bb_mode_read_reg_bb_mode_sel_read                 (0x3)                           

#define reg_fd_btrx_status_reg                                     (*(volatile uint32_t *)0x4000a044)
#define adr_fd_btrx_status_reg                                                           (0x4000a044)
#define mask_fd_btrx_status_reg_btrx_tune_lpf_sync                   (0x7f)                          

#define reg_rf_RF_status                                           (*(volatile uint32_t *)0x4000a058)
#define adr_rf_RF_status                                                                 (0x4000a058)
#define mask_rf_RF_status_DCXOLF_READY                               (0x400)                         
#define mask_rf_RF_status_RC32K_READY                                (0x200)                         
#define mask_rf_RF_status_RC16M_READY                                (0x100)                         
#define mask_rf_RF_status_DCXO_CLK_READY                             (0x80)                          
#define mask_rf_RF_status_DCOC_COMP_I                                (0x40)                          
#define mask_rf_RF_status_DCOC_COMP_Q                                (0x20)                          
#define mask_rf_RF_status_PLL_LOCK                                   (0x10)                          
#define mask_rf_RF_status_PLL_SLOW                                   (0x8)                           
#define mask_rf_RF_status_SYN_VCO_AMP                                (0x4)                           
#define mask_rf_RF_status_SYN_VCO_LOCK                               (0x2)                           
#define mask_rf_RF_status_SYN_VCO_SLOW                               (0x1)                           

#define reg_cali_status                                            (*(volatile uint32_t *)0x4000a05c)
#define adr_cali_status                                                                  (0x4000a05c)

#define reg_rfmux_btrx_to_rf_read_wd4_reg                          (*(volatile uint32_t *)0x4000a070)
#define adr_rfmux_btrx_to_rf_read_wd4_reg                                                (0x4000a070)
#define mask_rfmux_btrx_to_rf_read_wd4_reg_TIA_DCOCQ_read            (0xff00)                        
#define mask_rfmux_btrx_to_rf_read_wd4_reg_TIA_DCOCI_read            (0xff)                          

#define reg_rfmux_btrx_to_if_read_wd4_reg                          (*(volatile uint32_t *)0x4000a074)
#define adr_rfmux_btrx_to_if_read_wd4_reg                                                (0x4000a074)
#define mask_rfmux_btrx_to_if_read_wd4_reg_PGA_DCOCQ_read            (0xff00)                        
#define mask_rfmux_btrx_to_if_read_wd4_reg_PGA_DCOCI_read            (0xff)                          

#define reg_rfmux_btrx_to_rf_read_wd3_reg                          (*(volatile uint32_t *)0x4000a078)
#define adr_rfmux_btrx_to_rf_read_wd3_reg                                                (0x4000a078)
#define mask_rfmux_btrx_to_rf_read_wd3_reg_PGA_GAIN_read             (0x3c00)                        
#define mask_rfmux_btrx_to_rf_read_wd3_reg_RXRF_LNA_C_read           (0x300)                         
#define mask_rfmux_btrx_to_rf_read_wd3_reg_MIXER_IF_G_read           (0xe0)                          
#define mask_rfmux_btrx_to_rf_read_wd3_reg_RXRF_LNA_GAIN_read        (0x1c)                          
#define mask_rfmux_btrx_to_rf_read_wd3_reg_DCOC_SW_VCM_read          (0x2)                           
#define mask_rfmux_btrx_to_rf_read_wd3_reg_PGA_COMPLEX_EN_read       (0x1)                           

#define reg_rfmux_btrx_idx_read_reg                                (*(volatile uint32_t *)0x4000a07c)
#define adr_rfmux_btrx_idx_read_reg                                                      (0x4000a07c)
#define mask_rfmux_btrx_idx_read_reg_RXRF_GM1_C_read                 (0x600)                         
#define mask_rfmux_btrx_idx_read_reg_RXRF_GM2_C_read                 (0x180)                         
#define mask_rfmux_btrx_idx_read_reg_btrx_tia_dcoc_idx_read          (0x70)                          
#define mask_rfmux_btrx_idx_read_reg_btrx_tia_gidx_read              (0xc)                           
#define mask_rfmux_btrx_idx_read_reg_btrx_pga_gdc_idx_read           (0x3)                           

#define reg_modem_intf_reg                                         (*(volatile uint32_t *)0x4000a080)
#define adr_modem_intf_reg                                                               (0x4000a080)
#define mask_modem_intf_reg_btxen                                    (0x2)                           
#define mask_modem_intf_reg_brxen                                    (0x1)                           

#define reg_test_dtm_txpkg_cnt                                     (*(volatile uint32_t *)0x4000a09c)
#define adr_test_dtm_txpkg_cnt                                                           (0x4000a09c)

#define reg_test_test_rssi                                         (*(volatile uint32_t *)0x4000a0a0)
#define adr_test_test_rssi                                                               (0x4000a0a0)

#define reg_test_rxblock_err                                       (*(volatile uint32_t *)0x4000a0a4)
#define adr_test_rxblock_err                                                             (0x4000a0a4)

#define reg_test_rxblock_num                                       (*(volatile uint32_t *)0x4000a0a8)
#define adr_test_rxblock_num                                                             (0x4000a0a8)

#define reg_test_all_ber                                           (*(volatile uint32_t *)0x4000a0ac)
#define adr_test_all_ber                                                                 (0x4000a0ac)

#define reg_test_test_sber                                         (*(volatile uint32_t *)0x4000a0b0)
#define adr_test_test_sber                                                               (0x4000a0b0)
#define mask_test_test_sber_data_gen_fsm                             (0xf000)                        
#define mask_test_test_sber_test_fsm                                 (0xe00)                         
#define mask_test_test_sber_test_fsm_end                             (0x100)                         
#define mask_test_test_sber_single_ber                               (0xff)                          

#define reg_dcoc_iqdat_reg                                         (*(volatile uint32_t *)0x4000a0b4)
#define adr_dcoc_iqdat_reg                                                               (0x4000a0b4)
#define mask_dcoc_iqdat_reg_rfcali_qdat                              (0xff00)                        
#define mask_dcoc_iqdat_reg_rfcali_idat                              (0xff)                          

#define reg_dcoc_rfcali_dcoc_state_reg                             (*(volatile uint32_t *)0x4000a0b8)
#define adr_dcoc_rfcali_dcoc_state_reg                                                   (0x4000a0b8)
#define mask_dcoc_rfcali_dcoc_state_reg_chn_vld_num                  (0x1c00)                        
#define mask_dcoc_rfcali_dcoc_state_reg_dyn_status                   (0x200)                         
#define mask_dcoc_rfcali_dcoc_state_reg_tia_base_vld                 (0x100)                         
#define mask_dcoc_rfcali_dcoc_state_reg_main_fsm                     (0xf0)                          
#define mask_dcoc_rfcali_dcoc_state_reg_search_done                  (0x8)                           
#define mask_dcoc_rfcali_dcoc_state_reg_dyn_done                     (0x4)                           
#define mask_dcoc_rfcali_dcoc_state_reg_k_cal_done                   (0x2)                           
#define mask_dcoc_rfcali_dcoc_state_reg_static_done                  (0x1)                           

#define reg_dcoc_dcoc_chn_state_reg                                (*(volatile uint32_t *)0x4000a0bc)
#define adr_dcoc_dcoc_chn_state_reg                                                      (0x4000a0bc)
#define mask_dcoc_dcoc_chn_state_reg_chn_sel                         (0x7f)                          

#define reg_dcoc_k_stdi                                            (*(volatile uint32_t *)0x4000a0c0)
#define adr_dcoc_k_stdi                                                                  (0x4000a0c0)

#define reg_dcoc_k_stdq                                            (*(volatile uint32_t *)0x4000a0c4)
#define adr_dcoc_k_stdq                                                                  (0x4000a0c4)

#define reg_dcoc_dcoc_dac_reg                                      (*(volatile uint32_t *)0x4000a0c8)
#define adr_dcoc_dcoc_dac_reg                                                            (0x4000a0c8)
#define mask_dcoc_dcoc_dac_reg_dcoc_q_rd                             (0xff00)                        
#define mask_dcoc_dcoc_dac_reg_dcoc_i_rd                             (0xff)                          

#define reg_dig_status                                             (*(volatile uint32_t *)0x4000a0cc)
#define adr_dig_status                                                                   (0x4000a0cc)

#define reg_trxs_vco_lock_ov_flagh                                 (*(volatile uint32_t *)0x4000a0d0)
#define adr_trxs_vco_lock_ov_flagh                                                       (0x4000a0d0)

#define reg_trxs_vco_lock_ov_flagl                                 (*(volatile uint32_t *)0x4000a0d4)
#define adr_trxs_vco_lock_ov_flagl                                                       (0x4000a0d4)

#define reg_vcocali_rdh                                            (*(volatile uint32_t *)0x4000a0d8)
#define adr_vcocali_rdh                                                                  (0x4000a0d8)
#define mask_vcocali_rdh_stah                                        (0xffff)                        

#define reg_vcocali_rdl                                            (*(volatile uint32_t *)0x4000a0dc)
#define adr_vcocali_rdl                                                                  (0x4000a0dc)
#define mask_vcocali_rdl_stal                                        (0x7f)                          

#define reg_ioproc_dcoc_dac_reg                                    (*(volatile uint32_t *)0x4000a0e0)
#define adr_ioproc_dcoc_dac_reg                                                          (0x4000a0e0)
#define mask_ioproc_dcoc_dac_reg_rx_en_from_pad                      (0x20)                          
#define mask_ioproc_dcoc_dac_reg_tx_en_from_pad                      (0x10)                          
#define mask_ioproc_dcoc_dac_reg_rate_from_pad                       (0xc)                           
#define mask_ioproc_dcoc_dac_reg_agc_from_pad                        (0x3)                           

#define reg_dc_dc_state                                            (*(volatile uint32_t *)0x4000a10c)
#define adr_dc_dc_state                                                                  (0x4000a10c)
#define mask_dc_dc_state_cal_done                                    (0x2)                           
#define mask_dc_dc_state_cal_fine                                    (0x1)                           

#define reg_dc_dc_sumi                                             (*(volatile uint32_t *)0x4000a110)
#define adr_dc_dc_sumi                                                                   (0x4000a110)
#define mask_dc_dc_sumi_sumi                                         (0xffff)                        

#define reg_dc_dc_sumq                                             (*(volatile uint32_t *)0x4000a114)
#define adr_dc_dc_sumq                                                                   (0x4000a114)
#define mask_dc_dc_sumq_sumq                                         (0xffff)                        


//---------------------------------------------------
// rftbl in  domain address definition
//---------------------------------------------------

#define reg_rftbl_BTRX_IF_GAIN0                                    (*(volatile uint32_t *)0x4000ac00)
#define adr_rftbl_BTRX_IF_GAIN0                                                          (0x4000ac00)
#define mask_rftbl_BTRX_IF_GAIN0_RX_PGA_GAIN                         (0x1e)                          
#define mask_rftbl_BTRX_IF_GAIN0_RX_FD_OFFSET_ID                     (0x1)                           

#define reg_rftbl_BTRX_IF_GAIN1                                    (*(volatile uint32_t *)0x4000ac04)
#define adr_rftbl_BTRX_IF_GAIN1                                                          (0x4000ac04)
#define mask_rftbl_BTRX_IF_GAIN1_RX_PGA_GAIN                         (0x1e)                          
#define mask_rftbl_BTRX_IF_GAIN1_RX_FD_OFFSET_ID                     (0x1)                           

#define reg_rftbl_BTRX_IF_GAIN2                                    (*(volatile uint32_t *)0x4000ac08)
#define adr_rftbl_BTRX_IF_GAIN2                                                          (0x4000ac08)
#define mask_rftbl_BTRX_IF_GAIN2_RX_PGA_GAIN                         (0x1e)                          
#define mask_rftbl_BTRX_IF_GAIN2_RX_FD_OFFSET_ID                     (0x1)                           

#define reg_rftbl_BTRX_RF_GAIN0                                    (*(volatile uint32_t *)0x4000ac40)
#define adr_rftbl_BTRX_RF_GAIN0                                                          (0x4000ac40)
#define mask_rftbl_BTRX_RF_GAIN0_GM2_C                               (0xc00)                         
#define mask_rftbl_BTRX_RF_GAIN0_GM1_C                               (0x300)                         
#define mask_rftbl_BTRX_RF_GAIN0_LNA_C                               (0xc0)                          
#define mask_rftbl_BTRX_RF_GAIN0_MIXER_IF_G                          (0x38)                          
#define mask_rftbl_BTRX_RF_GAIN0_LNA_GFAIN                           (0x7)                           

#define reg_rftbl_BTRX_RF_GAIN1                                    (*(volatile uint32_t *)0x4000ac44)
#define adr_rftbl_BTRX_RF_GAIN1                                                          (0x4000ac44)
#define mask_rftbl_BTRX_RF_GAIN1_GM2_C                               (0xc00)                         
#define mask_rftbl_BTRX_RF_GAIN1_GM1_C                               (0x300)                         
#define mask_rftbl_BTRX_RF_GAIN1_LNA_C                               (0xc0)                          
#define mask_rftbl_BTRX_RF_GAIN1_MIXER_IF_G                          (0x38)                          
#define mask_rftbl_BTRX_RF_GAIN1_LNA_GFAIN                           (0x7)                           

#define reg_rftbl_BTRX_RF_GAIN2                                    (*(volatile uint32_t *)0x4000ac48)
#define adr_rftbl_BTRX_RF_GAIN2                                                          (0x4000ac48)
#define mask_rftbl_BTRX_RF_GAIN2_GM2_C                               (0xc00)                         
#define mask_rftbl_BTRX_RF_GAIN2_GM1_C                               (0x300)                         
#define mask_rftbl_BTRX_RF_GAIN2_LNA_C                               (0xc0)                          
#define mask_rftbl_BTRX_RF_GAIN2_MIXER_IF_G                          (0x38)                          
#define mask_rftbl_BTRX_RF_GAIN2_LNA_GFAIN                           (0x7)                           

#define reg_rftbl_PGA_DCOC0                                        (*(volatile uint32_t *)0x4000ac80)
#define adr_rftbl_PGA_DCOC0                                                              (0x4000ac80)
#define mask_rftbl_PGA_DCOC0_PGA_DCOC_Q                              (0xff00)                        
#define mask_rftbl_PGA_DCOC0_PGA_DCOC_I                              (0xff)                          

#define reg_rftbl_PGA_DCOC1                                        (*(volatile uint32_t *)0x4000ac84)
#define adr_rftbl_PGA_DCOC1                                                              (0x4000ac84)
#define mask_rftbl_PGA_DCOC1_PGA_DCOC_Q                              (0xff00)                        
#define mask_rftbl_PGA_DCOC1_PGA_DCOC_I                              (0xff)                          

#define reg_rftbl_PGA_DCOC2                                        (*(volatile uint32_t *)0x4000ac88)
#define adr_rftbl_PGA_DCOC2                                                              (0x4000ac88)
#define mask_rftbl_PGA_DCOC2_PGA_DCOC_Q                              (0xff00)                        
#define mask_rftbl_PGA_DCOC2_PGA_DCOC_I                              (0xff)                          

#define reg_rftbl_TIA_DCOC0                                        (*(volatile uint32_t *)0x4000acc0)
#define adr_rftbl_TIA_DCOC0                                                              (0x4000acc0)
#define mask_rftbl_TIA_DCOC0_TIA_DCOC_Q                              (0xff00)                        
#define mask_rftbl_TIA_DCOC0_TIA_DCOC_I                              (0xff)                          

#define reg_rftbl_TIA_DCOC1                                        (*(volatile uint32_t *)0x4000acc4)
#define adr_rftbl_TIA_DCOC1                                                              (0x4000acc4)
#define mask_rftbl_TIA_DCOC1_TIA_DCOC_Q                              (0xff00)                        
#define mask_rftbl_TIA_DCOC1_TIA_DCOC_I                              (0xff)                          

#define reg_rftbl_TIA_DCOC20                                       (*(volatile uint32_t *)0x4000acc8)
#define adr_rftbl_TIA_DCOC20                                                             (0x4000acc8)
#define mask_rftbl_TIA_DCOC20_TIA_DCOC_Q                             (0xff00)                        
#define mask_rftbl_TIA_DCOC20_TIA_DCOC_I                             (0xff)                          

#define reg_rftbl_TIA_DCOC21                                       (*(volatile uint32_t *)0x4000accc)
#define adr_rftbl_TIA_DCOC21                                                             (0x4000accc)
#define mask_rftbl_TIA_DCOC21_TIA_DCOC_Q                             (0xff00)                        
#define mask_rftbl_TIA_DCOC21_TIA_DCOC_I                             (0xff)                          

#define reg_rftbl_TIA_DCOC22                                       (*(volatile uint32_t *)0x4000acd0)
#define adr_rftbl_TIA_DCOC22                                                             (0x4000acd0)
#define mask_rftbl_TIA_DCOC22_TIA_DCOC_Q                             (0xff00)                        
#define mask_rftbl_TIA_DCOC22_TIA_DCOC_I                             (0xff)                          

#define reg_rftbl_TIA_DCOC23                                       (*(volatile uint32_t *)0x4000acd4)
#define adr_rftbl_TIA_DCOC23                                                             (0x4000acd4)
#define mask_rftbl_TIA_DCOC23_TIA_DCOC_Q                             (0xff00)                        
#define mask_rftbl_TIA_DCOC23_TIA_DCOC_I                             (0xff)                          

#define reg_rftbl_TIA_DCOC24                                       (*(volatile uint32_t *)0x4000acd8)
#define adr_rftbl_TIA_DCOC24                                                             (0x4000acd8)
#define mask_rftbl_TIA_DCOC24_TIA_DCOC_Q                             (0xff00)                        
#define mask_rftbl_TIA_DCOC24_TIA_DCOC_I                             (0xff)                          

#define reg_rftbl_TIA_DCOC25                                       (*(volatile uint32_t *)0x4000acdc)
#define adr_rftbl_TIA_DCOC25                                                             (0x4000acdc)
#define mask_rftbl_TIA_DCOC25_TIA_DCOC_Q                             (0xff00)                        
#define mask_rftbl_TIA_DCOC25_TIA_DCOC_I                             (0xff)                          

#define reg_rftbl_TIA_DCOC2_CH0                                    (*(volatile uint32_t *)0x4000ad00)
#define adr_rftbl_TIA_DCOC2_CH0                                                          (0x4000ad00)
#define mask_rftbl_TIA_DCOC2_CH0_CH0_VLD                             (0x80)                          
#define mask_rftbl_TIA_DCOC2_CH0_CH0_NUM                             (0x7f)                          

#define reg_rftbl_TIA_DCOC2_CH1                                    (*(volatile uint32_t *)0x4000ad04)
#define adr_rftbl_TIA_DCOC2_CH1                                                          (0x4000ad04)
#define mask_rftbl_TIA_DCOC2_CH1_CH0_VLD                             (0x80)                          
#define mask_rftbl_TIA_DCOC2_CH1_CH0_NUM                             (0x7f)                          

#define reg_rftbl_TIA_DCOC2_CH2                                    (*(volatile uint32_t *)0x4000ad08)
#define adr_rftbl_TIA_DCOC2_CH2                                                          (0x4000ad08)
#define mask_rftbl_TIA_DCOC2_CH2_CH0_VLD                             (0x80)                          
#define mask_rftbl_TIA_DCOC2_CH2_CH0_NUM                             (0x7f)                          

#define reg_rftbl_TIA_DCOC2_CH3                                    (*(volatile uint32_t *)0x4000ad0c)
#define adr_rftbl_TIA_DCOC2_CH3                                                          (0x4000ad0c)
#define mask_rftbl_TIA_DCOC2_CH3_CH0_VLD                             (0x80)                          
#define mask_rftbl_TIA_DCOC2_CH3_CH0_NUM                             (0x7f)                          

#define reg_rftbl_TIA_DCOC2_CH4                                    (*(volatile uint32_t *)0x4000ad10)
#define adr_rftbl_TIA_DCOC2_CH4                                                          (0x4000ad10)
#define mask_rftbl_TIA_DCOC2_CH4_CH0_VLD                             (0x80)                          
#define mask_rftbl_TIA_DCOC2_CH4_CH0_NUM                             (0x7f)                          

#define reg_rftbl_TIA_DCOC2_CH5                                    (*(volatile uint32_t *)0x4000ad14)
#define adr_rftbl_TIA_DCOC2_CH5                                                          (0x4000ad14)
#define mask_rftbl_TIA_DCOC2_CH5_CH0_VLD                             (0x80)                          
#define mask_rftbl_TIA_DCOC2_CH5_CH0_NUM                             (0x7f)                          

#define reg_rftbl_ADC_BIT_SCALE                                    (*(volatile uint32_t *)0x4000ad40)
#define adr_rftbl_ADC_BIT_SCALE                                                          (0x4000ad40)
#define mask_rftbl_ADC_BIT_SCALE_Q_K_INT                             (0xff00)                        
#define mask_rftbl_ADC_BIT_SCALE_I_K_INT                             (0xff)                          

#define reg_rftbl_TX_GAIN0                                         (*(volatile uint32_t *)0x4000ad80)
#define adr_rftbl_TX_GAIN0                                                               (0x4000ad80)

#define reg_rftbl_TX_GAIN1                                         (*(volatile uint32_t *)0x4000ad84)
#define adr_rftbl_TX_GAIN1                                                               (0x4000ad84)

#define reg_rftbl_TX_GAIN2                                         (*(volatile uint32_t *)0x4000ad88)
#define adr_rftbl_TX_GAIN2                                                               (0x4000ad88)

#define reg_rftbl_TX_GAIN3                                         (*(volatile uint32_t *)0x4000ad8c)
#define adr_rftbl_TX_GAIN3                                                               (0x4000ad8c)

#define reg_rftbl_TX_GAIN4                                         (*(volatile uint32_t *)0x4000ad90)
#define adr_rftbl_TX_GAIN4                                                               (0x4000ad90)

#define reg_rftbl_TX_GAIN5                                         (*(volatile uint32_t *)0x4000ad94)
#define adr_rftbl_TX_GAIN5                                                               (0x4000ad94)


//---------------------------------------------------
// cpto0_secb in  domain address definition
//---------------------------------------------------

#define reg_cpto0_secb_llc_mode                                    (*(volatile uint32_t *)0x4000b000)
#define adr_cpto0_secb_llc_mode                                                          (0x4000b000)

#define reg_cpto0_secb_llc_key_sram_raddr                          (*(volatile uint32_t *)0x4000b004)
#define adr_cpto0_secb_llc_key_sram_raddr                                                (0x4000b004)

#define reg_cpto0_secb_llc_dat_sram_waddr                          (*(volatile uint32_t *)0x4000b008)
#define adr_cpto0_secb_llc_dat_sram_waddr                                                (0x4000b008)

#define reg_cpto0_secb_llc_dat_sram_raddr                          (*(volatile uint32_t *)0x4000b00c)
#define adr_cpto0_secb_llc_dat_sram_raddr                                                (0x4000b00c)

#define reg_cpto0_secb_llc_ctr_sram_waddr                          (*(volatile uint32_t *)0x4000b010)
#define adr_cpto0_secb_llc_ctr_sram_waddr                                                (0x4000b010)

#define reg_cpto0_secb_llc_adv_sram_waddr                          (*(volatile uint32_t *)0x4000b014)
#define adr_cpto0_secb_llc_adv_sram_waddr                                                (0x4000b014)

#define reg_cpto0_secb_llc_iv0                                     (*(volatile uint32_t *)0x4000b018)
#define adr_cpto0_secb_llc_iv0                                                           (0x4000b018)

#define reg_cpto0_secb_llc_iv1                                     (*(volatile uint32_t *)0x4000b01c)
#define adr_cpto0_secb_llc_iv1                                                           (0x4000b01c)

#define reg_cpto0_secb_llc_maxlen                                  (*(volatile uint32_t *)0x4000b020)
#define adr_cpto0_secb_llc_maxlen                                                        (0x4000b020)
#define mask_cpto0_secb_llc_maxlen_llc_byp_rx_len                    (0xff0000)                      
#define mask_cpto0_secb_llc_maxlen_llc_ctr_len                       (0xff00)                        
#define mask_cpto0_secb_llc_maxlen_llc_dat_len                       (0xff)                          

#define reg_cpto0_secb_llc_enc_pkt_cnt_hi                          (*(volatile uint32_t *)0x4000b024)
#define adr_cpto0_secb_llc_enc_pkt_cnt_hi                                                (0x4000b024)

#define reg_cpto0_secb_llc_enc_pkt_cnt_lo                          (*(volatile uint32_t *)0x4000b028)
#define adr_cpto0_secb_llc_enc_pkt_cnt_lo                                                (0x4000b028)

#define reg_cpto0_secb_llc_dec_pkt_cnt_hi                          (*(volatile uint32_t *)0x4000b02c)
#define adr_cpto0_secb_llc_dec_pkt_cnt_hi                                                (0x4000b02c)

#define reg_cpto0_secb_llc_dec_pkt_cnt_lo                          (*(volatile uint32_t *)0x4000b030)
#define adr_cpto0_secb_llc_dec_pkt_cnt_lo                                                (0x4000b030)

#define reg_cpto0_secb_llc_byp_rxhead_num                          (*(volatile uint32_t *)0x4000b034)
#define adr_cpto0_secb_llc_byp_rxhead_num                                                (0x4000b034)

#define reg_cpto0_secb_llc_mic_cal                                 (*(volatile uint32_t *)0x4000b038)
#define adr_cpto0_secb_llc_mic_cal                                                       (0x4000b038)

#define reg_cpto0_secb_llc_mic_cal_1                               (*(volatile uint32_t *)0x4000b03c)
#define adr_cpto0_secb_llc_mic_cal_1                                                     (0x4000b03c)

#define reg_cpto0_secb_sram_wen                                    (*(volatile uint32_t *)0x4000b040)
#define adr_cpto0_secb_sram_wen                                                          (0x4000b040)
#define mask_cpto0_secb_sram_wen_ctrl_pkt_wen                        (0x4)                           
#define mask_cpto0_secb_sram_wen_data_pkt_wen                        (0x2)                           
#define mask_cpto0_secb_sram_wen_adv_pkt_wen                         (0x1)                           

#define reg_cpto0_secb_sw_mode                                     (*(volatile uint32_t *)0x4000b080)
#define adr_cpto0_secb_sw_mode                                                           (0x4000b080)
#define mask_cpto0_secb_sw_mode_sw_data_word_pol                     (0x200)                         
#define mask_cpto0_secb_sw_mode_sw_data_byte_pol                     (0x100)                         
#define mask_cpto0_secb_sw_mode_sw_key_size                          (0xc0)                          
#define mask_cpto0_secb_sw_mode_sw_aes_mode                          (0x30)                          
#define mask_cpto0_secb_sw_mode_sw_ende_mode                         (0x8)                           
#define mask_cpto0_secb_sw_mode_sw_sel_mode                          (0x7)                           

#define reg_cpto0_secb_sw_len                                      (*(volatile uint32_t *)0x4000b084)
#define adr_cpto0_secb_sw_len                                                            (0x4000b084)

#define reg_cpto0_secb_sw_key_sram_raddr                           (*(volatile uint32_t *)0x4000b088)
#define adr_cpto0_secb_sw_key_sram_raddr                                                 (0x4000b088)

#define reg_cpto0_secb_sw_dat_sram_waddr                           (*(volatile uint32_t *)0x4000b08c)
#define adr_cpto0_secb_sw_dat_sram_waddr                                                 (0x4000b08c)

#define reg_cpto0_secb_sw_dat_sram_raddr                           (*(volatile uint32_t *)0x4000b090)
#define adr_cpto0_secb_sw_dat_sram_raddr                                                 (0x4000b090)

#define reg_cpto0_secb_sw_keyexp_sram_waddr                        (*(volatile uint32_t *)0x4000b094)
#define adr_cpto0_secb_sw_keyexp_sram_waddr                                              (0x4000b094)

#define reg_cpto0_secb_sw_ccm_cfg                                  (*(volatile uint32_t *)0x4000b098)
#define adr_cpto0_secb_sw_ccm_cfg                                                        (0x4000b098)
#define mask_cpto0_secb_sw_ccm_cfg_sw_directionbit                   (0x10)                          
#define mask_cpto0_secb_sw_ccm_cfg_sw_ccm_llid                       (0xc)                           
#define mask_cpto0_secb_sw_ccm_cfg_sw_ccm_pkt_type                   (0x3)                           

#define reg_cpto0_secb_sw_iv0                                      (*(volatile uint32_t *)0x4000b09c)
#define adr_cpto0_secb_sw_iv0                                                            (0x4000b09c)

#define reg_cpto0_secb_sw_iv1                                      (*(volatile uint32_t *)0x4000b0a0)
#define adr_cpto0_secb_sw_iv1                                                            (0x4000b0a0)

#define reg_cpto0_secb_sw_iv2                                      (*(volatile uint32_t *)0x4000b0a4)
#define adr_cpto0_secb_sw_iv2                                                            (0x4000b0a4)

#define reg_cpto0_secb_sw_iv3                                      (*(volatile uint32_t *)0x4000b0a8)
#define adr_cpto0_secb_sw_iv3                                                            (0x4000b0a8)

#define reg_cpto0_secb_sw_enc_pkt_cnt_hi                           (*(volatile uint32_t *)0x4000b0ac)
#define adr_cpto0_secb_sw_enc_pkt_cnt_hi                                                 (0x4000b0ac)

#define reg_cpto0_secb_sw_enc_pkt_cnt_lo                           (*(volatile uint32_t *)0x4000b0b0)
#define adr_cpto0_secb_sw_enc_pkt_cnt_lo                                                 (0x4000b0b0)

#define reg_cpto0_secb_sw_dec_pkt_cnt_hi                           (*(volatile uint32_t *)0x4000b0b4)
#define adr_cpto0_secb_sw_dec_pkt_cnt_hi                                                 (0x4000b0b4)

#define reg_cpto0_secb_sw_dec_pkt_cnt_lo                           (*(volatile uint32_t *)0x4000b0b8)
#define adr_cpto0_secb_sw_dec_pkt_cnt_lo                                                 (0x4000b0b8)

#define reg_cpto0_secb_sw_bgn_trig                                 (*(volatile uint32_t *)0x4000b0bc)
#define adr_cpto0_secb_sw_bgn_trig                                                       (0x4000b0bc)

#define reg_cpto0_secb_cpto_status                                 (*(volatile uint32_t *)0x4000b0c0)
#define adr_cpto0_secb_cpto_status                                                       (0x4000b0c0)
#define mask_cpto0_secb_cpto_status_tx_flag                          (0x4000)                        
#define mask_cpto0_secb_cpto_status_rx_flag                          (0x2000)                        
#define mask_cpto0_secb_cpto_status_aes_core_state                   (0x1f00)                        
#define mask_cpto0_secb_cpto_status_cpto_sub_state                   (0xf0)                          
#define mask_cpto0_secb_cpto_status_cpto_main_state                  (0xf)                           

#define reg_cpto0_secb_cpto_int_en                                 (*(volatile uint32_t *)0x4000b100)
#define adr_cpto0_secb_cpto_int_en                                                       (0x4000b100)
#define mask_cpto0_secb_cpto_int_en_sw_collide_en                    (0x100)                         
#define mask_cpto0_secb_cpto_int_en_sw_done_en                       (0x80)                          
#define mask_cpto0_secb_cpto_int_en_sw_aes_done_en                   (0x40)                          
#define mask_cpto0_secb_cpto_int_en_llc_byp_rxend_en                 (0x20)                          
#define mask_cpto0_secb_cpto_int_en_llc_byp_rxhead_en                (0x10)                          
#define mask_cpto0_secb_cpto_int_en_llc_len_lim_en                   (0x8)                           
#define mask_cpto0_secb_cpto_int_en_llc_emp_pac_en                   (0x4)                           
#define mask_cpto0_secb_cpto_int_en_llc_mic_fail_en                  (0x2)                           
#define mask_cpto0_secb_cpto_int_en_llc_work_done_en                 (0x1)                           

#define reg_cpto0_secb_cpto_int_clr                                (*(volatile uint32_t *)0x4000b104)
#define adr_cpto0_secb_cpto_int_clr                                                      (0x4000b104)
#define mask_cpto0_secb_cpto_int_clr_sw_collide_clr                  (0x100)                         
#define mask_cpto0_secb_cpto_int_clr_sw_done_clr                     (0x80)                          
#define mask_cpto0_secb_cpto_int_clr_sw_aes_done_clr                 (0x40)                          
#define mask_cpto0_secb_cpto_int_clr_llc_byp_rxend_clr               (0x20)                          
#define mask_cpto0_secb_cpto_int_clr_llc_byp_rxhead_clr              (0x10)                          
#define mask_cpto0_secb_cpto_int_clr_llc_len_lim_clr                 (0x8)                           
#define mask_cpto0_secb_cpto_int_clr_llc_emp_pac_clr                 (0x4)                           
#define mask_cpto0_secb_cpto_int_clr_llc_mic_fail_clr                (0x2)                           
#define mask_cpto0_secb_cpto_int_clr_llc_work_done_clr               (0x1)                           

#define reg_cpto0_secb_cpto_int_st                                 (*(volatile uint32_t *)0x4000b108)
#define adr_cpto0_secb_cpto_int_st                                                       (0x4000b108)
#define mask_cpto0_secb_cpto_int_st_sw_collide_st                    (0x100)                         
#define mask_cpto0_secb_cpto_int_st_sw_done_st                       (0x80)                          
#define mask_cpto0_secb_cpto_int_st_sw_aes_done_st                   (0x40)                          
#define mask_cpto0_secb_cpto_int_st_llc_byp_rxend_st                 (0x20)                          
#define mask_cpto0_secb_cpto_int_st_llc_byp_rxhead_st                (0x10)                          
#define mask_cpto0_secb_cpto_int_st_llc_len_lim_st                   (0x8)                           
#define mask_cpto0_secb_cpto_int_st_llc_emp_pac_st                   (0x4)                           
#define mask_cpto0_secb_cpto_int_st_llc_mic_fail_st                  (0x2)                           
#define mask_cpto0_secb_cpto_int_st_llc_work_done_st                 (0x1)                           

#define reg_cpto0_secb_ext_cg_en                                   (*(volatile uint32_t *)0x4000b10c)
#define adr_cpto0_secb_ext_cg_en                                                         (0x4000b10c)


//---------------------------------------------------
// cpto1_secb in  domain address definition
//---------------------------------------------------

#define reg_cpto1_secb_llc_mode                                    (*(volatile uint32_t *)0x4000c000)
#define adr_cpto1_secb_llc_mode                                                          (0x4000c000)

#define reg_cpto1_secb_llc_key_sram_raddr                          (*(volatile uint32_t *)0x4000c004)
#define adr_cpto1_secb_llc_key_sram_raddr                                                (0x4000c004)

#define reg_cpto1_secb_llc_dat_sram_waddr                          (*(volatile uint32_t *)0x4000c008)
#define adr_cpto1_secb_llc_dat_sram_waddr                                                (0x4000c008)

#define reg_cpto1_secb_llc_dat_sram_raddr                          (*(volatile uint32_t *)0x4000c00c)
#define adr_cpto1_secb_llc_dat_sram_raddr                                                (0x4000c00c)

#define reg_cpto1_secb_llc_ctr_sram_waddr                          (*(volatile uint32_t *)0x4000c010)
#define adr_cpto1_secb_llc_ctr_sram_waddr                                                (0x4000c010)

#define reg_cpto1_secb_llc_adv_sram_waddr                          (*(volatile uint32_t *)0x4000c014)
#define adr_cpto1_secb_llc_adv_sram_waddr                                                (0x4000c014)

#define reg_cpto1_secb_llc_iv0                                     (*(volatile uint32_t *)0x4000c018)
#define adr_cpto1_secb_llc_iv0                                                           (0x4000c018)

#define reg_cpto1_secb_llc_iv1                                     (*(volatile uint32_t *)0x4000c01c)
#define adr_cpto1_secb_llc_iv1                                                           (0x4000c01c)

#define reg_cpto1_secb_llc_maxlen                                  (*(volatile uint32_t *)0x4000c020)
#define adr_cpto1_secb_llc_maxlen                                                        (0x4000c020)
#define mask_cpto1_secb_llc_maxlen_llc_byp_rx_len                    (0xff0000)                      
#define mask_cpto1_secb_llc_maxlen_llc_ctr_len                       (0xff00)                        
#define mask_cpto1_secb_llc_maxlen_llc_dat_len                       (0xff)                          

#define reg_cpto1_secb_llc_enc_pkt_cnt_hi                          (*(volatile uint32_t *)0x4000c024)
#define adr_cpto1_secb_llc_enc_pkt_cnt_hi                                                (0x4000c024)

#define reg_cpto1_secb_llc_enc_pkt_cnt_lo                          (*(volatile uint32_t *)0x4000c028)
#define adr_cpto1_secb_llc_enc_pkt_cnt_lo                                                (0x4000c028)

#define reg_cpto1_secb_llc_dec_pkt_cnt_hi                          (*(volatile uint32_t *)0x4000c02c)
#define adr_cpto1_secb_llc_dec_pkt_cnt_hi                                                (0x4000c02c)

#define reg_cpto1_secb_llc_dec_pkt_cnt_lo                          (*(volatile uint32_t *)0x4000c030)
#define adr_cpto1_secb_llc_dec_pkt_cnt_lo                                                (0x4000c030)

#define reg_cpto1_secb_llc_byp_rxhead_num                          (*(volatile uint32_t *)0x4000c034)
#define adr_cpto1_secb_llc_byp_rxhead_num                                                (0x4000c034)

#define reg_cpto1_secb_llc_mic_cal                                 (*(volatile uint32_t *)0x4000c038)
#define adr_cpto1_secb_llc_mic_cal                                                       (0x4000c038)

#define reg_cpto1_secb_llc_mic_cal_1                               (*(volatile uint32_t *)0x4000c03c)
#define adr_cpto1_secb_llc_mic_cal_1                                                     (0x4000c03c)

#define reg_cpto1_secb_sram_wen                                    (*(volatile uint32_t *)0x4000c040)
#define adr_cpto1_secb_sram_wen                                                          (0x4000c040)
#define mask_cpto1_secb_sram_wen_ctrl_pkt_wen                        (0x4)                           
#define mask_cpto1_secb_sram_wen_data_pkt_wen                        (0x2)                           
#define mask_cpto1_secb_sram_wen_adv_pkt_wen                         (0x1)                           

#define reg_cpto1_secb_sw_mode                                     (*(volatile uint32_t *)0x4000c080)
#define adr_cpto1_secb_sw_mode                                                           (0x4000c080)
#define mask_cpto1_secb_sw_mode_sw_data_word_pol                     (0x200)                         
#define mask_cpto1_secb_sw_mode_sw_data_byte_pol                     (0x100)                         
#define mask_cpto1_secb_sw_mode_sw_key_size                          (0xc0)                          
#define mask_cpto1_secb_sw_mode_sw_aes_mode                          (0x30)                          
#define mask_cpto1_secb_sw_mode_sw_ende_mode                         (0x8)                           
#define mask_cpto1_secb_sw_mode_sw_sel_mode                          (0x7)                           

#define reg_cpto1_secb_sw_len                                      (*(volatile uint32_t *)0x4000c084)
#define adr_cpto1_secb_sw_len                                                            (0x4000c084)

#define reg_cpto1_secb_sw_key_sram_raddr                           (*(volatile uint32_t *)0x4000c088)
#define adr_cpto1_secb_sw_key_sram_raddr                                                 (0x4000c088)

#define reg_cpto1_secb_sw_dat_sram_waddr                           (*(volatile uint32_t *)0x4000c08c)
#define adr_cpto1_secb_sw_dat_sram_waddr                                                 (0x4000c08c)

#define reg_cpto1_secb_sw_dat_sram_raddr                           (*(volatile uint32_t *)0x4000c090)
#define adr_cpto1_secb_sw_dat_sram_raddr                                                 (0x4000c090)

#define reg_cpto1_secb_sw_keyexp_sram_waddr                        (*(volatile uint32_t *)0x4000c094)
#define adr_cpto1_secb_sw_keyexp_sram_waddr                                              (0x4000c094)

#define reg_cpto1_secb_sw_ccm_cfg                                  (*(volatile uint32_t *)0x4000c098)
#define adr_cpto1_secb_sw_ccm_cfg                                                        (0x4000c098)
#define mask_cpto1_secb_sw_ccm_cfg_sw_directionbit                   (0x10)                          
#define mask_cpto1_secb_sw_ccm_cfg_sw_ccm_llid                       (0xc)                           
#define mask_cpto1_secb_sw_ccm_cfg_sw_ccm_pkt_type                   (0x3)                           

#define reg_cpto1_secb_sw_iv0                                      (*(volatile uint32_t *)0x4000c09c)
#define adr_cpto1_secb_sw_iv0                                                            (0x4000c09c)

#define reg_cpto1_secb_sw_iv1                                      (*(volatile uint32_t *)0x4000c0a0)
#define adr_cpto1_secb_sw_iv1                                                            (0x4000c0a0)

#define reg_cpto1_secb_sw_iv2                                      (*(volatile uint32_t *)0x4000c0a4)
#define adr_cpto1_secb_sw_iv2                                                            (0x4000c0a4)

#define reg_cpto1_secb_sw_iv3                                      (*(volatile uint32_t *)0x4000c0a8)
#define adr_cpto1_secb_sw_iv3                                                            (0x4000c0a8)

#define reg_cpto1_secb_sw_enc_pkt_cnt_hi                           (*(volatile uint32_t *)0x4000c0ac)
#define adr_cpto1_secb_sw_enc_pkt_cnt_hi                                                 (0x4000c0ac)

#define reg_cpto1_secb_sw_enc_pkt_cnt_lo                           (*(volatile uint32_t *)0x4000c0b0)
#define adr_cpto1_secb_sw_enc_pkt_cnt_lo                                                 (0x4000c0b0)

#define reg_cpto1_secb_sw_dec_pkt_cnt_hi                           (*(volatile uint32_t *)0x4000c0b4)
#define adr_cpto1_secb_sw_dec_pkt_cnt_hi                                                 (0x4000c0b4)

#define reg_cpto1_secb_sw_dec_pkt_cnt_lo                           (*(volatile uint32_t *)0x4000c0b8)
#define adr_cpto1_secb_sw_dec_pkt_cnt_lo                                                 (0x4000c0b8)

#define reg_cpto1_secb_sw_bgn_trig                                 (*(volatile uint32_t *)0x4000c0bc)
#define adr_cpto1_secb_sw_bgn_trig                                                       (0x4000c0bc)

#define reg_cpto1_secb_cpto_status                                 (*(volatile uint32_t *)0x4000c0c0)
#define adr_cpto1_secb_cpto_status                                                       (0x4000c0c0)
#define mask_cpto1_secb_cpto_status_tx_flag                          (0x4000)                        
#define mask_cpto1_secb_cpto_status_rx_flag                          (0x2000)                        
#define mask_cpto1_secb_cpto_status_aes_core_state                   (0x1f00)                        
#define mask_cpto1_secb_cpto_status_cpto_sub_state                   (0xf0)                          
#define mask_cpto1_secb_cpto_status_cpto_main_state                  (0xf)                           

#define reg_cpto1_secb_cpto_int_en                                 (*(volatile uint32_t *)0x4000c100)
#define adr_cpto1_secb_cpto_int_en                                                       (0x4000c100)
#define mask_cpto1_secb_cpto_int_en_sw_collide_en                    (0x100)                         
#define mask_cpto1_secb_cpto_int_en_sw_done_en                       (0x80)                          
#define mask_cpto1_secb_cpto_int_en_sw_aes_done_en                   (0x40)                          
#define mask_cpto1_secb_cpto_int_en_llc_byp_rxend_en                 (0x20)                          
#define mask_cpto1_secb_cpto_int_en_llc_byp_rxhead_en                (0x10)                          
#define mask_cpto1_secb_cpto_int_en_llc_len_lim_en                   (0x8)                           
#define mask_cpto1_secb_cpto_int_en_llc_emp_pac_en                   (0x4)                           
#define mask_cpto1_secb_cpto_int_en_llc_mic_fail_en                  (0x2)                           
#define mask_cpto1_secb_cpto_int_en_llc_work_done_en                 (0x1)                           

#define reg_cpto1_secb_cpto_int_clr                                (*(volatile uint32_t *)0x4000c104)
#define adr_cpto1_secb_cpto_int_clr                                                      (0x4000c104)
#define mask_cpto1_secb_cpto_int_clr_sw_collide_clr                  (0x100)                         
#define mask_cpto1_secb_cpto_int_clr_sw_done_clr                     (0x80)                          
#define mask_cpto1_secb_cpto_int_clr_sw_aes_done_clr                 (0x40)                          
#define mask_cpto1_secb_cpto_int_clr_llc_byp_rxend_clr               (0x20)                          
#define mask_cpto1_secb_cpto_int_clr_llc_byp_rxhead_clr              (0x10)                          
#define mask_cpto1_secb_cpto_int_clr_llc_len_lim_clr                 (0x8)                           
#define mask_cpto1_secb_cpto_int_clr_llc_emp_pac_clr                 (0x4)                           
#define mask_cpto1_secb_cpto_int_clr_llc_mic_fail_clr                (0x2)                           
#define mask_cpto1_secb_cpto_int_clr_llc_work_done_clr               (0x1)                           

#define reg_cpto1_secb_cpto_int_st                                 (*(volatile uint32_t *)0x4000c108)
#define adr_cpto1_secb_cpto_int_st                                                       (0x4000c108)
#define mask_cpto1_secb_cpto_int_st_sw_collide_st                    (0x100)                         
#define mask_cpto1_secb_cpto_int_st_sw_done_st                       (0x80)                          
#define mask_cpto1_secb_cpto_int_st_sw_aes_done_st                   (0x40)                          
#define mask_cpto1_secb_cpto_int_st_llc_byp_rxend_st                 (0x20)                          
#define mask_cpto1_secb_cpto_int_st_llc_byp_rxhead_st                (0x10)                          
#define mask_cpto1_secb_cpto_int_st_llc_len_lim_st                   (0x8)                           
#define mask_cpto1_secb_cpto_int_st_llc_emp_pac_st                   (0x4)                           
#define mask_cpto1_secb_cpto_int_st_llc_mic_fail_st                  (0x2)                           
#define mask_cpto1_secb_cpto_int_st_llc_work_done_st                 (0x1)                           

#define reg_cpto1_secb_ext_cg_en                                   (*(volatile uint32_t *)0x4000c10c)
#define adr_cpto1_secb_ext_cg_en                                                         (0x4000c10c)


//---------------------------------------------------
// qspi0_seca in  domain address definition
//---------------------------------------------------

#define reg_qspi0_seca_sreg_qspi_spdr_rd                           (*(volatile uint32_t *)0x50000000)
#define adr_qspi0_seca_sreg_qspi_spdr_rd                                                 (0x50000000)

#define reg_qspi0_seca_sreg_qspi_spdr_wr                           (*(volatile uint32_t *)0x50000004)
#define adr_qspi0_seca_sreg_qspi_spdr_wr                                                 (0x50000004)

#define reg_qspi0_seca_int_status                                  (*(volatile uint32_t *)0x50000008)
#define adr_qspi0_seca_int_status                                                        (0x50000008)

#define reg_qspi0_seca_int_mask                                    (*(volatile uint32_t *)0x5000000c)
#define adr_qspi0_seca_int_mask                                                          (0x5000000c)

#define reg_qspi0_seca_int_clear                                   (*(volatile uint32_t *)0x50000010)
#define adr_qspi0_seca_int_clear                                                         (0x50000010)

#define reg_qspi0_seca_txfifo_threshold                            (*(volatile uint32_t *)0x50000014)
#define adr_qspi0_seca_txfifo_threshold                                                  (0x50000014)

#define reg_qspi0_seca_rxfifo_threshold                            (*(volatile uint32_t *)0x50000018)
#define adr_qspi0_seca_rxfifo_threshold                                                  (0x50000018)

#define reg_qspi0_seca_core_clock_en                               (*(volatile uint32_t *)0x5000001c)
#define adr_qspi0_seca_core_clock_en                                                     (0x5000001c)

#define reg_qspi0_seca_ext_cg_en                                   (*(volatile uint32_t *)0x50000020)
#define adr_qspi0_seca_ext_cg_en                                                         (0x50000020)

#define reg_qspi0_seca_scramble_ctrl                               (*(volatile uint32_t *)0x50000024)
#define adr_qspi0_seca_scramble_ctrl                                                     (0x50000024)
#define mask_qspi0_seca_scramble_ctrl_directif_scramble_en           (0x2)                           
#define mask_qspi0_seca_scramble_ctrl_indirectif_scramble_en         (0x1)                           

#define reg_qspi0_seca_scramble_key                                (*(volatile uint32_t *)0x50000028)
#define adr_qspi0_seca_scramble_key                                                      (0x50000028)

#define reg_qspi0_seca_spcr                                        (*(volatile uint32_t *)0x5000002c)
#define adr_qspi0_seca_spcr                                                              (0x5000002c)
#define mask_qspi0_seca_spcr_sample_edge                             (0x20)                          
#define mask_qspi0_seca_spcr_data_comb_mode                          (0x18)                          
#define mask_qspi0_seca_spcr_sda_mode                                (0x4)                           
#define mask_qspi0_seca_spcr_cpha                                    (0x2)                           
#define mask_qspi0_seca_spcr_cpol                                    (0x1)                           

#define reg_qspi0_seca_dly_cfg                                     (*(volatile uint32_t *)0x50000030)
#define adr_qspi0_seca_dly_cfg                                                           (0x50000030)
#define mask_qspi0_seca_dly_cfg_input_clk_dly                        (0x38)                          
#define mask_qspi0_seca_dly_cfg_output_clk_dly                       (0x7)                           

#define reg_qspi0_seca_opi_ctrl                                    (*(volatile uint32_t *)0x50000034)
#define adr_qspi0_seca_opi_ctrl                                                          (0x50000034)
#define mask_qspi0_seca_opi_ctrl_opi_en                              (0x100)                         
#define mask_qspi0_seca_opi_ctrl_dtr_read_cpha                       (0x80)                          
#define mask_qspi0_seca_opi_ctrl_write_dtr_en                        (0x40)                          
#define mask_qspi0_seca_opi_ctrl_read_dtr_en                         (0x20)                          
#define mask_qspi0_seca_opi_ctrl_datamask_en                         (0x10)                          
#define mask_qspi0_seca_opi_ctrl_byte_mask_config                    (0xf)                           

#define reg_qspi0_seca_send_ctrl                                   (*(volatile uint32_t *)0x50000040)
#define adr_qspi0_seca_send_ctrl                                                         (0x50000040)
#define mask_qspi0_seca_send_ctrl_adr_byte_mode                      (0x800)                         
#define mask_qspi0_seca_send_ctrl_cmd_with_arg                       (0x700)                         
#define mask_qspi0_seca_send_ctrl_adr_with_arg                       (0xc0)                          
#define mask_qspi0_seca_send_ctrl_cmd_bit_num                        (0x30)                          
#define mask_qspi0_seca_send_ctrl_addr_bit_num                       (0xc)                           
#define mask_qspi0_seca_send_ctrl_data_bit_num                       (0x3)                           

#define reg_qspi0_seca_reg_qspi_rxtx_dat_len                       (*(volatile uint32_t *)0x50000044)
#define adr_qspi0_seca_reg_qspi_rxtx_dat_len                                             (0x50000044)

#define reg_qspi0_seca_reg_qspi_cmd_reg                            (*(volatile uint32_t *)0x50000048)
#define adr_qspi0_seca_reg_qspi_cmd_reg                                                  (0x50000048)

#define reg_qspi0_seca_reg_qspi_addr_reg                           (*(volatile uint32_t *)0x5000004c)
#define adr_qspi0_seca_reg_qspi_addr_reg                                                 (0x5000004c)

#define reg_qspi0_seca_mcu_adrcnd_bit_len                          (*(volatile uint32_t *)0x50000050)
#define adr_qspi0_seca_mcu_adrcnd_bit_len                                                (0x50000050)
#define mask_qspi0_seca_mcu_adrcnd_bit_len_mcu_rd_dummy              (0xf000)                        
#define mask_qspi0_seca_mcu_adrcnd_bit_len_mcu_cmd_max_len           (0xfc0)                         
#define mask_qspi0_seca_mcu_adrcnd_bit_len_mcu_adr_max_len           (0x3f)                          

#define reg_qspi0_seca_flash_busy                                  (*(volatile uint32_t *)0x50000054)
#define adr_qspi0_seca_flash_busy                                                        (0x50000054)

#define reg_qspi0_seca_auto_busy_enable                            (*(volatile uint32_t *)0x50000058)
#define adr_qspi0_seca_auto_busy_enable                                                  (0x50000058)

#define reg_qspi0_seca_auto_busy_configa                           (*(volatile uint32_t *)0x5000005c)
#define adr_qspi0_seca_auto_busy_configa                                                 (0x5000005c)
#define mask_qspi0_seca_auto_busy_configa_ini_cnt_value              (0xfffff000)                    
#define mask_qspi0_seca_auto_busy_configa_inval_cnt_value            (0xfff)                         

#define reg_qspi0_seca_auto_busy_configb                           (*(volatile uint32_t *)0x50000060)
#define adr_qspi0_seca_auto_busy_configb                                                 (0x50000060)
#define mask_qspi0_seca_auto_busy_configb_rdsr_cmd_num               (0x300)                         
#define mask_qspi0_seca_auto_busy_configb_rdsr_cmd                   (0xff)                          

#define reg_qspi0_seca_suspend_timing_ctrl                         (*(volatile uint32_t *)0x50000064)
#define adr_qspi0_seca_suspend_timing_ctrl                                               (0x50000064)
#define mask_qspi0_seca_suspend_timing_ctrl_sus_delay_max            (0xff000000)                    
#define mask_qspi0_seca_suspend_timing_ctrl_tps_tes_cfg              (0xff0000)                      
#define mask_qspi0_seca_suspend_timing_ctrl_ters_tprs_cfg            (0xff00)                        
#define mask_qspi0_seca_suspend_timing_ctrl_timeunit_us              (0xff)                          

#define reg_qspi0_seca_suspend_trig                                (*(volatile uint32_t *)0x50000068)
#define adr_qspi0_seca_suspend_trig                                                      (0x50000068)

#define reg_qspi0_seca_send_en                                     (*(volatile uint32_t *)0x5000006c)
#define adr_qspi0_seca_send_en                                                           (0x5000006c)

#define reg_qspi0_seca_flash_busy_auto                             (*(volatile uint32_t *)0x50000070)
#define adr_qspi0_seca_flash_busy_auto                                                   (0x50000070)

#define reg_qspi0_seca_cache_cmd1                                  (*(volatile uint32_t *)0x50000080)
#define adr_qspi0_seca_cache_cmd1                                                        (0x50000080)
#define mask_qspi0_seca_cache_cmd1_hpm_cmd                           (0xff000000)                    
#define mask_qspi0_seca_cache_cmd1_resume_cmd                        (0xff0000)                      
#define mask_qspi0_seca_cache_cmd1_sus_cmd                           (0xff00)                        
#define mask_qspi0_seca_cache_cmd1_read_cmd                          (0xff)                          

#define reg_qspi0_seca_cache_cmd2                                  (*(volatile uint32_t *)0x50000084)
#define adr_qspi0_seca_cache_cmd2                                                        (0x50000084)
#define mask_qspi0_seca_cache_cmd2_write_cmd                         (0xff0000)                      
#define mask_qspi0_seca_cache_cmd2_continu_rd_mod                    (0xff00)                        
#define mask_qspi0_seca_cache_cmd2_exithpm_mod                       (0xff)                          

#define reg_qspi0_seca_cache_delay_set                             (*(volatile uint32_t *)0x50000088)
#define adr_qspi0_seca_cache_delay_set                                                   (0x50000088)
#define mask_qspi0_seca_cache_delay_set_hpm_delay_max                (0x3f)                          

#define reg_qspi0_seca_delay_set                                   (*(volatile uint32_t *)0x5000008c)
#define adr_qspi0_seca_delay_set                                                         (0x5000008c)
#define mask_qspi0_seca_delay_set_cache_rd_dummy                     (0xf0000000)                    
#define mask_qspi0_seca_delay_set_dir_wr_en                          (0x8000000)                     
#define mask_qspi0_seca_delay_set_cache_addr_byte_mode               (0x4000000)                     
#define mask_qspi0_seca_delay_set_cache_cmd_bit_num                  (0x3000000)                     
#define mask_qspi0_seca_delay_set_cache_addr_bit_num                 (0xc00000)                      
#define mask_qspi0_seca_delay_set_cache_data_bit_num                 (0x300000)                      
#define mask_qspi0_seca_delay_set_cache_no_dummy_cmd_len             (0xf0000)                       
#define mask_qspi0_seca_delay_set_cache_cmd_len                      (0xf000)                        
#define mask_qspi0_seca_delay_set_adr_bit_max                        (0xfc0)                         
#define mask_qspi0_seca_delay_set_hpm_len                            (0x3f)                          

#define reg_qspi0_seca_continue_rd_mod_index                       (*(volatile uint32_t *)0x50000090)
#define adr_qspi0_seca_continue_rd_mod_index                                             (0x50000090)

#define reg_qspi0_seca_continue_status                             (*(volatile uint32_t *)0x50000094)
#define adr_qspi0_seca_continue_status                                                   (0x50000094)

#define reg_qspi0_seca_rst_trig                                    (*(volatile uint32_t *)0x50000098)
#define adr_qspi0_seca_rst_trig                                                          (0x50000098)

#define reg_qspi0_seca_rst_status                                  (*(volatile uint32_t *)0x5000009c)
#define adr_qspi0_seca_rst_status                                                        (0x5000009c)

#define reg_qspi0_seca_cache_access_status                         (*(volatile uint32_t *)0x500000a0)
#define adr_qspi0_seca_cache_access_status                                               (0x500000a0)

#define reg_qspi0_seca_cmd_send_status                             (*(volatile uint32_t *)0x500000a4)
#define adr_qspi0_seca_cmd_send_status                                                   (0x500000a4)

#define reg_qspi0_seca_manual_mode_cfg                             (*(volatile uint32_t *)0x500000c0)
#define adr_qspi0_seca_manual_mode_cfg                                                   (0x500000c0)
#define mask_qspi0_seca_manual_mode_cfg_maul_tx_data_seq_num         (0x600)                         
#define mask_qspi0_seca_manual_mode_cfg_maul_dcx_value               (0x100)                         
#define mask_qspi0_seca_manual_mode_cfg_maul_data_bit_num            (0xc0)                          
#define mask_qspi0_seca_manual_mode_cfg_cs_hold_ctrl                 (0x20)                          
#define mask_qspi0_seca_manual_mode_cfg_maul_rxtx_data_size          (0x1f)                          

#define reg_qspi0_seca_manual_mode_ctrl                            (*(volatile uint32_t *)0x500000c4)
#define adr_qspi0_seca_manual_mode_ctrl                                                  (0x500000c4)
#define mask_qspi0_seca_manual_mode_ctrl_maul_rd_dum                 (0x40)                          
#define mask_qspi0_seca_manual_mode_ctrl_maul_dcx_opt_mode           (0x20)                          
#define mask_qspi0_seca_manual_mode_ctrl_maul_dcx_mode               (0x18)                          
#define mask_qspi0_seca_manual_mode_ctrl_manual_trx_mode             (0x4)                           
#define mask_qspi0_seca_manual_mode_ctrl_cs_hold_mode                (0x2)                           
#define mask_qspi0_seca_manual_mode_ctrl_manual_mode                 (0x1)                           

#define reg_qspi0_seca_maul_rx_trig                                (*(volatile uint32_t *)0x500000c8)
#define adr_qspi0_seca_maul_rx_trig                                                      (0x500000c8)

#define reg_qspi0_seca_maul_mode_tx_st                             (*(volatile uint32_t *)0x500000cc)
#define adr_qspi0_seca_maul_mode_tx_st                                                   (0x500000cc)

#define reg_qspi0_seca_maul_mode_rx_st                             (*(volatile uint32_t *)0x500000d0)
#define adr_qspi0_seca_maul_mode_rx_st                                                   (0x500000d0)

#define reg_qspi0_seca_bypass_hpm                                  (*(volatile uint32_t *)0x500000d4)
#define adr_qspi0_seca_bypass_hpm                                                        (0x500000d4)

#define reg_qspi0_seca_atom_op_en                                  (*(volatile uint32_t *)0x500000d8)
#define adr_qspi0_seca_atom_op_en                                                        (0x500000d8)

#define reg_qspi0_seca_clr_hpm                                     (*(volatile uint32_t *)0x500000dc)
#define adr_qspi0_seca_clr_hpm                                                           (0x500000dc)


//---------------------------------------------------
// qspi1_seca in  domain address definition
//---------------------------------------------------

#define reg_qspi1_seca_sreg_qspi_spdr_rd                           (*(volatile uint32_t *)0x50001000)
#define adr_qspi1_seca_sreg_qspi_spdr_rd                                                 (0x50001000)

#define reg_qspi1_seca_sreg_qspi_spdr_wr                           (*(volatile uint32_t *)0x50001004)
#define adr_qspi1_seca_sreg_qspi_spdr_wr                                                 (0x50001004)

#define reg_qspi1_seca_int_status                                  (*(volatile uint32_t *)0x50001008)
#define adr_qspi1_seca_int_status                                                        (0x50001008)

#define reg_qspi1_seca_int_mask                                    (*(volatile uint32_t *)0x5000100c)
#define adr_qspi1_seca_int_mask                                                          (0x5000100c)

#define reg_qspi1_seca_int_clear                                   (*(volatile uint32_t *)0x50001010)
#define adr_qspi1_seca_int_clear                                                         (0x50001010)

#define reg_qspi1_seca_txfifo_threshold                            (*(volatile uint32_t *)0x50001014)
#define adr_qspi1_seca_txfifo_threshold                                                  (0x50001014)

#define reg_qspi1_seca_rxfifo_threshold                            (*(volatile uint32_t *)0x50001018)
#define adr_qspi1_seca_rxfifo_threshold                                                  (0x50001018)

#define reg_qspi1_seca_core_clock_en                               (*(volatile uint32_t *)0x5000101c)
#define adr_qspi1_seca_core_clock_en                                                     (0x5000101c)

#define reg_qspi1_seca_ext_cg_en                                   (*(volatile uint32_t *)0x50001020)
#define adr_qspi1_seca_ext_cg_en                                                         (0x50001020)

#define reg_qspi1_seca_scramble_ctrl                               (*(volatile uint32_t *)0x50001024)
#define adr_qspi1_seca_scramble_ctrl                                                     (0x50001024)
#define mask_qspi1_seca_scramble_ctrl_directif_scramble_en           (0x2)                           
#define mask_qspi1_seca_scramble_ctrl_indirectif_scramble_en         (0x1)                           

#define reg_qspi1_seca_scramble_key                                (*(volatile uint32_t *)0x50001028)
#define adr_qspi1_seca_scramble_key                                                      (0x50001028)

#define reg_qspi1_seca_spcr                                        (*(volatile uint32_t *)0x5000102c)
#define adr_qspi1_seca_spcr                                                              (0x5000102c)
#define mask_qspi1_seca_spcr_sample_edge                             (0x20)                          
#define mask_qspi1_seca_spcr_data_comb_mode                          (0x18)                          
#define mask_qspi1_seca_spcr_sda_mode                                (0x4)                           
#define mask_qspi1_seca_spcr_cpha                                    (0x2)                           
#define mask_qspi1_seca_spcr_cpol                                    (0x1)                           

#define reg_qspi1_seca_dly_cfg                                     (*(volatile uint32_t *)0x50001030)
#define adr_qspi1_seca_dly_cfg                                                           (0x50001030)
#define mask_qspi1_seca_dly_cfg_input_clk_dly                        (0x38)                          
#define mask_qspi1_seca_dly_cfg_output_clk_dly                       (0x7)                           

#define reg_qspi1_seca_opi_ctrl                                    (*(volatile uint32_t *)0x50001034)
#define adr_qspi1_seca_opi_ctrl                                                          (0x50001034)
#define mask_qspi1_seca_opi_ctrl_opi_en                              (0x100)                         
#define mask_qspi1_seca_opi_ctrl_dtr_read_cpha                       (0x80)                          
#define mask_qspi1_seca_opi_ctrl_write_dtr_en                        (0x40)                          
#define mask_qspi1_seca_opi_ctrl_read_dtr_en                         (0x20)                          
#define mask_qspi1_seca_opi_ctrl_datamask_en                         (0x10)                          
#define mask_qspi1_seca_opi_ctrl_byte_mask_config                    (0xf)                           

#define reg_qspi1_seca_send_ctrl                                   (*(volatile uint32_t *)0x50001040)
#define adr_qspi1_seca_send_ctrl                                                         (0x50001040)
#define mask_qspi1_seca_send_ctrl_adr_byte_mode                      (0x800)                         
#define mask_qspi1_seca_send_ctrl_cmd_with_arg                       (0x700)                         
#define mask_qspi1_seca_send_ctrl_adr_with_arg                       (0xc0)                          
#define mask_qspi1_seca_send_ctrl_cmd_bit_num                        (0x30)                          
#define mask_qspi1_seca_send_ctrl_addr_bit_num                       (0xc)                           
#define mask_qspi1_seca_send_ctrl_data_bit_num                       (0x3)                           

#define reg_qspi1_seca_reg_qspi_rxtx_dat_len                       (*(volatile uint32_t *)0x50001044)
#define adr_qspi1_seca_reg_qspi_rxtx_dat_len                                             (0x50001044)

#define reg_qspi1_seca_reg_qspi_cmd_reg                            (*(volatile uint32_t *)0x50001048)
#define adr_qspi1_seca_reg_qspi_cmd_reg                                                  (0x50001048)

#define reg_qspi1_seca_reg_qspi_addr_reg                           (*(volatile uint32_t *)0x5000104c)
#define adr_qspi1_seca_reg_qspi_addr_reg                                                 (0x5000104c)

#define reg_qspi1_seca_mcu_adrcnd_bit_len                          (*(volatile uint32_t *)0x50001050)
#define adr_qspi1_seca_mcu_adrcnd_bit_len                                                (0x50001050)
#define mask_qspi1_seca_mcu_adrcnd_bit_len_mcu_rd_dummy              (0xf000)                        
#define mask_qspi1_seca_mcu_adrcnd_bit_len_mcu_cmd_max_len           (0xfc0)                         
#define mask_qspi1_seca_mcu_adrcnd_bit_len_mcu_adr_max_len           (0x3f)                          

#define reg_qspi1_seca_flash_busy                                  (*(volatile uint32_t *)0x50001054)
#define adr_qspi1_seca_flash_busy                                                        (0x50001054)

#define reg_qspi1_seca_auto_busy_enable                            (*(volatile uint32_t *)0x50001058)
#define adr_qspi1_seca_auto_busy_enable                                                  (0x50001058)

#define reg_qspi1_seca_auto_busy_configa                           (*(volatile uint32_t *)0x5000105c)
#define adr_qspi1_seca_auto_busy_configa                                                 (0x5000105c)
#define mask_qspi1_seca_auto_busy_configa_ini_cnt_value              (0xfffff000)                    
#define mask_qspi1_seca_auto_busy_configa_inval_cnt_value            (0xfff)                         

#define reg_qspi1_seca_auto_busy_configb                           (*(volatile uint32_t *)0x50001060)
#define adr_qspi1_seca_auto_busy_configb                                                 (0x50001060)
#define mask_qspi1_seca_auto_busy_configb_rdsr_cmd_num               (0x300)                         
#define mask_qspi1_seca_auto_busy_configb_rdsr_cmd                   (0xff)                          

#define reg_qspi1_seca_suspend_timing_ctrl                         (*(volatile uint32_t *)0x50001064)
#define adr_qspi1_seca_suspend_timing_ctrl                                               (0x50001064)
#define mask_qspi1_seca_suspend_timing_ctrl_sus_delay_max            (0xff000000)                    
#define mask_qspi1_seca_suspend_timing_ctrl_tps_tes_cfg              (0xff0000)                      
#define mask_qspi1_seca_suspend_timing_ctrl_ters_tprs_cfg            (0xff00)                        
#define mask_qspi1_seca_suspend_timing_ctrl_timeunit_us              (0xff)                          

#define reg_qspi1_seca_suspend_trig                                (*(volatile uint32_t *)0x50001068)
#define adr_qspi1_seca_suspend_trig                                                      (0x50001068)

#define reg_qspi1_seca_send_en                                     (*(volatile uint32_t *)0x5000106c)
#define adr_qspi1_seca_send_en                                                           (0x5000106c)

#define reg_qspi1_seca_flash_busy_auto                             (*(volatile uint32_t *)0x50001070)
#define adr_qspi1_seca_flash_busy_auto                                                   (0x50001070)

#define reg_qspi1_seca_cache_cmd1                                  (*(volatile uint32_t *)0x50001080)
#define adr_qspi1_seca_cache_cmd1                                                        (0x50001080)
#define mask_qspi1_seca_cache_cmd1_hpm_cmd                           (0xff000000)                    
#define mask_qspi1_seca_cache_cmd1_resume_cmd                        (0xff0000)                      
#define mask_qspi1_seca_cache_cmd1_sus_cmd                           (0xff00)                        
#define mask_qspi1_seca_cache_cmd1_read_cmd                          (0xff)                          

#define reg_qspi1_seca_cache_cmd2                                  (*(volatile uint32_t *)0x50001084)
#define adr_qspi1_seca_cache_cmd2                                                        (0x50001084)
#define mask_qspi1_seca_cache_cmd2_write_cmd                         (0xff0000)                      
#define mask_qspi1_seca_cache_cmd2_continu_rd_mod                    (0xff00)                        
#define mask_qspi1_seca_cache_cmd2_exithpm_mod                       (0xff)                          

#define reg_qspi1_seca_cache_delay_set                             (*(volatile uint32_t *)0x50001088)
#define adr_qspi1_seca_cache_delay_set                                                   (0x50001088)
#define mask_qspi1_seca_cache_delay_set_hpm_delay_max                (0x3f)                          

#define reg_qspi1_seca_delay_set                                   (*(volatile uint32_t *)0x5000108c)
#define adr_qspi1_seca_delay_set                                                         (0x5000108c)
#define mask_qspi1_seca_delay_set_cache_rd_dummy                     (0xf0000000)                    
#define mask_qspi1_seca_delay_set_dir_wr_en                          (0x8000000)                     
#define mask_qspi1_seca_delay_set_cache_addr_byte_mode               (0x4000000)                     
#define mask_qspi1_seca_delay_set_cache_cmd_bit_num                  (0x3000000)                     
#define mask_qspi1_seca_delay_set_cache_addr_bit_num                 (0xc00000)                      
#define mask_qspi1_seca_delay_set_cache_data_bit_num                 (0x300000)                      
#define mask_qspi1_seca_delay_set_cache_no_dummy_cmd_len             (0xf0000)                       
#define mask_qspi1_seca_delay_set_cache_cmd_len                      (0xf000)                        
#define mask_qspi1_seca_delay_set_adr_bit_max                        (0xfc0)                         
#define mask_qspi1_seca_delay_set_hpm_len                            (0x3f)                          

#define reg_qspi1_seca_continue_rd_mod_index                       (*(volatile uint32_t *)0x50001090)
#define adr_qspi1_seca_continue_rd_mod_index                                             (0x50001090)

#define reg_qspi1_seca_continue_status                             (*(volatile uint32_t *)0x50001094)
#define adr_qspi1_seca_continue_status                                                   (0x50001094)

#define reg_qspi1_seca_rst_trig                                    (*(volatile uint32_t *)0x50001098)
#define adr_qspi1_seca_rst_trig                                                          (0x50001098)

#define reg_qspi1_seca_rst_status                                  (*(volatile uint32_t *)0x5000109c)
#define adr_qspi1_seca_rst_status                                                        (0x5000109c)

#define reg_qspi1_seca_cache_access_status                         (*(volatile uint32_t *)0x500010a0)
#define adr_qspi1_seca_cache_access_status                                               (0x500010a0)

#define reg_qspi1_seca_cmd_send_status                             (*(volatile uint32_t *)0x500010a4)
#define adr_qspi1_seca_cmd_send_status                                                   (0x500010a4)

#define reg_qspi1_seca_manual_mode_cfg                             (*(volatile uint32_t *)0x500010c0)
#define adr_qspi1_seca_manual_mode_cfg                                                   (0x500010c0)
#define mask_qspi1_seca_manual_mode_cfg_maul_tx_data_seq_num         (0x600)                         
#define mask_qspi1_seca_manual_mode_cfg_maul_dcx_value               (0x100)                         
#define mask_qspi1_seca_manual_mode_cfg_maul_data_bit_num            (0xc0)                          
#define mask_qspi1_seca_manual_mode_cfg_cs_hold_ctrl                 (0x20)                          
#define mask_qspi1_seca_manual_mode_cfg_maul_rxtx_data_size          (0x1f)                          

#define reg_qspi1_seca_manual_mode_ctrl                            (*(volatile uint32_t *)0x500010c4)
#define adr_qspi1_seca_manual_mode_ctrl                                                  (0x500010c4)
#define mask_qspi1_seca_manual_mode_ctrl_maul_rd_dum                 (0x40)                          
#define mask_qspi1_seca_manual_mode_ctrl_maul_dcx_opt_mode           (0x20)                          
#define mask_qspi1_seca_manual_mode_ctrl_maul_dcx_mode               (0x18)                          
#define mask_qspi1_seca_manual_mode_ctrl_manual_trx_mode             (0x4)                           
#define mask_qspi1_seca_manual_mode_ctrl_cs_hold_mode                (0x2)                           
#define mask_qspi1_seca_manual_mode_ctrl_manual_mode                 (0x1)                           

#define reg_qspi1_seca_maul_rx_trig                                (*(volatile uint32_t *)0x500010c8)
#define adr_qspi1_seca_maul_rx_trig                                                      (0x500010c8)

#define reg_qspi1_seca_maul_mode_tx_st                             (*(volatile uint32_t *)0x500010cc)
#define adr_qspi1_seca_maul_mode_tx_st                                                   (0x500010cc)

#define reg_qspi1_seca_maul_mode_rx_st                             (*(volatile uint32_t *)0x500010d0)
#define adr_qspi1_seca_maul_mode_rx_st                                                   (0x500010d0)

#define reg_qspi1_seca_bypass_hpm                                  (*(volatile uint32_t *)0x500010d4)
#define adr_qspi1_seca_bypass_hpm                                                        (0x500010d4)

#define reg_qspi1_seca_atom_op_en                                  (*(volatile uint32_t *)0x500010d8)
#define adr_qspi1_seca_atom_op_en                                                        (0x500010d8)

#define reg_qspi1_seca_clr_hpm                                     (*(volatile uint32_t *)0x500010dc)
#define adr_qspi1_seca_clr_hpm                                                           (0x500010dc)


//---------------------------------------------------
// qspi2_seca in  domain address definition
//---------------------------------------------------

#define reg_qspi2_seca_sreg_qspi_spdr_rd                           (*(volatile uint32_t *)0x50002000)
#define adr_qspi2_seca_sreg_qspi_spdr_rd                                                 (0x50002000)

#define reg_qspi2_seca_sreg_qspi_spdr_wr                           (*(volatile uint32_t *)0x50002004)
#define adr_qspi2_seca_sreg_qspi_spdr_wr                                                 (0x50002004)

#define reg_qspi2_seca_int_status                                  (*(volatile uint32_t *)0x50002008)
#define adr_qspi2_seca_int_status                                                        (0x50002008)

#define reg_qspi2_seca_int_mask                                    (*(volatile uint32_t *)0x5000200c)
#define adr_qspi2_seca_int_mask                                                          (0x5000200c)

#define reg_qspi2_seca_int_clear                                   (*(volatile uint32_t *)0x50002010)
#define adr_qspi2_seca_int_clear                                                         (0x50002010)

#define reg_qspi2_seca_txfifo_threshold                            (*(volatile uint32_t *)0x50002014)
#define adr_qspi2_seca_txfifo_threshold                                                  (0x50002014)

#define reg_qspi2_seca_rxfifo_threshold                            (*(volatile uint32_t *)0x50002018)
#define adr_qspi2_seca_rxfifo_threshold                                                  (0x50002018)

#define reg_qspi2_seca_core_clock_en                               (*(volatile uint32_t *)0x5000201c)
#define adr_qspi2_seca_core_clock_en                                                     (0x5000201c)

#define reg_qspi2_seca_ext_cg_en                                   (*(volatile uint32_t *)0x50002020)
#define adr_qspi2_seca_ext_cg_en                                                         (0x50002020)

#define reg_qspi2_seca_scramble_ctrl                               (*(volatile uint32_t *)0x50002024)
#define adr_qspi2_seca_scramble_ctrl                                                     (0x50002024)
#define mask_qspi2_seca_scramble_ctrl_directif_scramble_en           (0x2)                           
#define mask_qspi2_seca_scramble_ctrl_indirectif_scramble_en         (0x1)                           

#define reg_qspi2_seca_scramble_key                                (*(volatile uint32_t *)0x50002028)
#define adr_qspi2_seca_scramble_key                                                      (0x50002028)

#define reg_qspi2_seca_spcr                                        (*(volatile uint32_t *)0x5000202c)
#define adr_qspi2_seca_spcr                                                              (0x5000202c)
#define mask_qspi2_seca_spcr_sample_edge                             (0x20)                          
#define mask_qspi2_seca_spcr_data_comb_mode                          (0x18)                          
#define mask_qspi2_seca_spcr_sda_mode                                (0x4)                           
#define mask_qspi2_seca_spcr_cpha                                    (0x2)                           
#define mask_qspi2_seca_spcr_cpol                                    (0x1)                           

#define reg_qspi2_seca_dly_cfg                                     (*(volatile uint32_t *)0x50002030)
#define adr_qspi2_seca_dly_cfg                                                           (0x50002030)
#define mask_qspi2_seca_dly_cfg_input_clk_dly                        (0x38)                          
#define mask_qspi2_seca_dly_cfg_output_clk_dly                       (0x7)                           

#define reg_qspi2_seca_opi_ctrl                                    (*(volatile uint32_t *)0x50002034)
#define adr_qspi2_seca_opi_ctrl                                                          (0x50002034)
#define mask_qspi2_seca_opi_ctrl_opi_en                              (0x100)                         
#define mask_qspi2_seca_opi_ctrl_dtr_read_cpha                       (0x80)                          
#define mask_qspi2_seca_opi_ctrl_write_dtr_en                        (0x40)                          
#define mask_qspi2_seca_opi_ctrl_read_dtr_en                         (0x20)                          
#define mask_qspi2_seca_opi_ctrl_datamask_en                         (0x10)                          
#define mask_qspi2_seca_opi_ctrl_byte_mask_config                    (0xf)                           

#define reg_qspi2_seca_send_ctrl                                   (*(volatile uint32_t *)0x50002040)
#define adr_qspi2_seca_send_ctrl                                                         (0x50002040)
#define mask_qspi2_seca_send_ctrl_adr_byte_mode                      (0x800)                         
#define mask_qspi2_seca_send_ctrl_cmd_with_arg                       (0x700)                         
#define mask_qspi2_seca_send_ctrl_adr_with_arg                       (0xc0)                          
#define mask_qspi2_seca_send_ctrl_cmd_bit_num                        (0x30)                          
#define mask_qspi2_seca_send_ctrl_addr_bit_num                       (0xc)                           
#define mask_qspi2_seca_send_ctrl_data_bit_num                       (0x3)                           

#define reg_qspi2_seca_reg_qspi_rxtx_dat_len                       (*(volatile uint32_t *)0x50002044)
#define adr_qspi2_seca_reg_qspi_rxtx_dat_len                                             (0x50002044)

#define reg_qspi2_seca_reg_qspi_cmd_reg                            (*(volatile uint32_t *)0x50002048)
#define adr_qspi2_seca_reg_qspi_cmd_reg                                                  (0x50002048)

#define reg_qspi2_seca_reg_qspi_addr_reg                           (*(volatile uint32_t *)0x5000204c)
#define adr_qspi2_seca_reg_qspi_addr_reg                                                 (0x5000204c)

#define reg_qspi2_seca_mcu_adrcnd_bit_len                          (*(volatile uint32_t *)0x50002050)
#define adr_qspi2_seca_mcu_adrcnd_bit_len                                                (0x50002050)
#define mask_qspi2_seca_mcu_adrcnd_bit_len_mcu_rd_dummy              (0xf000)                        
#define mask_qspi2_seca_mcu_adrcnd_bit_len_mcu_cmd_max_len           (0xfc0)                         
#define mask_qspi2_seca_mcu_adrcnd_bit_len_mcu_adr_max_len           (0x3f)                          

#define reg_qspi2_seca_flash_busy                                  (*(volatile uint32_t *)0x50002054)
#define adr_qspi2_seca_flash_busy                                                        (0x50002054)

#define reg_qspi2_seca_auto_busy_enable                            (*(volatile uint32_t *)0x50002058)
#define adr_qspi2_seca_auto_busy_enable                                                  (0x50002058)

#define reg_qspi2_seca_auto_busy_configa                           (*(volatile uint32_t *)0x5000205c)
#define adr_qspi2_seca_auto_busy_configa                                                 (0x5000205c)
#define mask_qspi2_seca_auto_busy_configa_ini_cnt_value              (0xfffff000)                    
#define mask_qspi2_seca_auto_busy_configa_inval_cnt_value            (0xfff)                         

#define reg_qspi2_seca_auto_busy_configb                           (*(volatile uint32_t *)0x50002060)
#define adr_qspi2_seca_auto_busy_configb                                                 (0x50002060)
#define mask_qspi2_seca_auto_busy_configb_rdsr_cmd_num               (0x300)                         
#define mask_qspi2_seca_auto_busy_configb_rdsr_cmd                   (0xff)                          

#define reg_qspi2_seca_suspend_timing_ctrl                         (*(volatile uint32_t *)0x50002064)
#define adr_qspi2_seca_suspend_timing_ctrl                                               (0x50002064)
#define mask_qspi2_seca_suspend_timing_ctrl_sus_delay_max            (0xff000000)                    
#define mask_qspi2_seca_suspend_timing_ctrl_tps_tes_cfg              (0xff0000)                      
#define mask_qspi2_seca_suspend_timing_ctrl_ters_tprs_cfg            (0xff00)                        
#define mask_qspi2_seca_suspend_timing_ctrl_timeunit_us              (0xff)                          

#define reg_qspi2_seca_suspend_trig                                (*(volatile uint32_t *)0x50002068)
#define adr_qspi2_seca_suspend_trig                                                      (0x50002068)

#define reg_qspi2_seca_send_en                                     (*(volatile uint32_t *)0x5000206c)
#define adr_qspi2_seca_send_en                                                           (0x5000206c)

#define reg_qspi2_seca_flash_busy_auto                             (*(volatile uint32_t *)0x50002070)
#define adr_qspi2_seca_flash_busy_auto                                                   (0x50002070)

#define reg_qspi2_seca_cache_cmd1                                  (*(volatile uint32_t *)0x50002080)
#define adr_qspi2_seca_cache_cmd1                                                        (0x50002080)
#define mask_qspi2_seca_cache_cmd1_hpm_cmd                           (0xff000000)                    
#define mask_qspi2_seca_cache_cmd1_resume_cmd                        (0xff0000)                      
#define mask_qspi2_seca_cache_cmd1_sus_cmd                           (0xff00)                        
#define mask_qspi2_seca_cache_cmd1_read_cmd                          (0xff)                          

#define reg_qspi2_seca_cache_cmd2                                  (*(volatile uint32_t *)0x50002084)
#define adr_qspi2_seca_cache_cmd2                                                        (0x50002084)
#define mask_qspi2_seca_cache_cmd2_write_cmd                         (0xff0000)                      
#define mask_qspi2_seca_cache_cmd2_continu_rd_mod                    (0xff00)                        
#define mask_qspi2_seca_cache_cmd2_exithpm_mod                       (0xff)                          

#define reg_qspi2_seca_cache_delay_set                             (*(volatile uint32_t *)0x50002088)
#define adr_qspi2_seca_cache_delay_set                                                   (0x50002088)
#define mask_qspi2_seca_cache_delay_set_hpm_delay_max                (0x3f)                          

#define reg_qspi2_seca_delay_set                                   (*(volatile uint32_t *)0x5000208c)
#define adr_qspi2_seca_delay_set                                                         (0x5000208c)
#define mask_qspi2_seca_delay_set_cache_rd_dummy                     (0xf0000000)                    
#define mask_qspi2_seca_delay_set_dir_wr_en                          (0x8000000)                     
#define mask_qspi2_seca_delay_set_cache_addr_byte_mode               (0x4000000)                     
#define mask_qspi2_seca_delay_set_cache_cmd_bit_num                  (0x3000000)                     
#define mask_qspi2_seca_delay_set_cache_addr_bit_num                 (0xc00000)                      
#define mask_qspi2_seca_delay_set_cache_data_bit_num                 (0x300000)                      
#define mask_qspi2_seca_delay_set_cache_no_dummy_cmd_len             (0xf0000)                       
#define mask_qspi2_seca_delay_set_cache_cmd_len                      (0xf000)                        
#define mask_qspi2_seca_delay_set_adr_bit_max                        (0xfc0)                         
#define mask_qspi2_seca_delay_set_hpm_len                            (0x3f)                          

#define reg_qspi2_seca_continue_rd_mod_index                       (*(volatile uint32_t *)0x50002090)
#define adr_qspi2_seca_continue_rd_mod_index                                             (0x50002090)

#define reg_qspi2_seca_continue_status                             (*(volatile uint32_t *)0x50002094)
#define adr_qspi2_seca_continue_status                                                   (0x50002094)

#define reg_qspi2_seca_rst_trig                                    (*(volatile uint32_t *)0x50002098)
#define adr_qspi2_seca_rst_trig                                                          (0x50002098)

#define reg_qspi2_seca_rst_status                                  (*(volatile uint32_t *)0x5000209c)
#define adr_qspi2_seca_rst_status                                                        (0x5000209c)

#define reg_qspi2_seca_cache_access_status                         (*(volatile uint32_t *)0x500020a0)
#define adr_qspi2_seca_cache_access_status                                               (0x500020a0)

#define reg_qspi2_seca_cmd_send_status                             (*(volatile uint32_t *)0x500020a4)
#define adr_qspi2_seca_cmd_send_status                                                   (0x500020a4)

#define reg_qspi2_seca_manual_mode_cfg                             (*(volatile uint32_t *)0x500020c0)
#define adr_qspi2_seca_manual_mode_cfg                                                   (0x500020c0)
#define mask_qspi2_seca_manual_mode_cfg_maul_tx_data_seq_num         (0x600)                         
#define mask_qspi2_seca_manual_mode_cfg_maul_dcx_value               (0x100)                         
#define mask_qspi2_seca_manual_mode_cfg_maul_data_bit_num            (0xc0)                          
#define mask_qspi2_seca_manual_mode_cfg_cs_hold_ctrl                 (0x20)                          
#define mask_qspi2_seca_manual_mode_cfg_maul_rxtx_data_size          (0x1f)                          

#define reg_qspi2_seca_manual_mode_ctrl                            (*(volatile uint32_t *)0x500020c4)
#define adr_qspi2_seca_manual_mode_ctrl                                                  (0x500020c4)
#define mask_qspi2_seca_manual_mode_ctrl_maul_rd_dum                 (0x40)                          
#define mask_qspi2_seca_manual_mode_ctrl_maul_dcx_opt_mode           (0x20)                          
#define mask_qspi2_seca_manual_mode_ctrl_maul_dcx_mode               (0x18)                          
#define mask_qspi2_seca_manual_mode_ctrl_manual_trx_mode             (0x4)                           
#define mask_qspi2_seca_manual_mode_ctrl_cs_hold_mode                (0x2)                           
#define mask_qspi2_seca_manual_mode_ctrl_manual_mode                 (0x1)                           

#define reg_qspi2_seca_maul_rx_trig                                (*(volatile uint32_t *)0x500020c8)
#define adr_qspi2_seca_maul_rx_trig                                                      (0x500020c8)

#define reg_qspi2_seca_maul_mode_tx_st                             (*(volatile uint32_t *)0x500020cc)
#define adr_qspi2_seca_maul_mode_tx_st                                                   (0x500020cc)

#define reg_qspi2_seca_maul_mode_rx_st                             (*(volatile uint32_t *)0x500020d0)
#define adr_qspi2_seca_maul_mode_rx_st                                                   (0x500020d0)

#define reg_qspi2_seca_bypass_hpm                                  (*(volatile uint32_t *)0x500020d4)
#define adr_qspi2_seca_bypass_hpm                                                        (0x500020d4)

#define reg_qspi2_seca_atom_op_en                                  (*(volatile uint32_t *)0x500020d8)
#define adr_qspi2_seca_atom_op_en                                                        (0x500020d8)

#define reg_qspi2_seca_clr_hpm                                     (*(volatile uint32_t *)0x500020dc)
#define adr_qspi2_seca_clr_hpm                                                           (0x500020dc)


//---------------------------------------------------
// qspi3_seca in  domain address definition
//---------------------------------------------------

#define reg_qspi3_seca_sreg_qspi_spdr_rd                           (*(volatile uint32_t *)0x50003000)
#define adr_qspi3_seca_sreg_qspi_spdr_rd                                                 (0x50003000)

#define reg_qspi3_seca_sreg_qspi_spdr_wr                           (*(volatile uint32_t *)0x50003004)
#define adr_qspi3_seca_sreg_qspi_spdr_wr                                                 (0x50003004)

#define reg_qspi3_seca_int_status                                  (*(volatile uint32_t *)0x50003008)
#define adr_qspi3_seca_int_status                                                        (0x50003008)

#define reg_qspi3_seca_int_mask                                    (*(volatile uint32_t *)0x5000300c)
#define adr_qspi3_seca_int_mask                                                          (0x5000300c)

#define reg_qspi3_seca_int_clear                                   (*(volatile uint32_t *)0x50003010)
#define adr_qspi3_seca_int_clear                                                         (0x50003010)

#define reg_qspi3_seca_txfifo_threshold                            (*(volatile uint32_t *)0x50003014)
#define adr_qspi3_seca_txfifo_threshold                                                  (0x50003014)

#define reg_qspi3_seca_rxfifo_threshold                            (*(volatile uint32_t *)0x50003018)
#define adr_qspi3_seca_rxfifo_threshold                                                  (0x50003018)

#define reg_qspi3_seca_core_clock_en                               (*(volatile uint32_t *)0x5000301c)
#define adr_qspi3_seca_core_clock_en                                                     (0x5000301c)

#define reg_qspi3_seca_ext_cg_en                                   (*(volatile uint32_t *)0x50003020)
#define adr_qspi3_seca_ext_cg_en                                                         (0x50003020)

#define reg_qspi3_seca_scramble_ctrl                               (*(volatile uint32_t *)0x50003024)
#define adr_qspi3_seca_scramble_ctrl                                                     (0x50003024)
#define mask_qspi3_seca_scramble_ctrl_directif_scramble_en           (0x2)                           
#define mask_qspi3_seca_scramble_ctrl_indirectif_scramble_en         (0x1)                           

#define reg_qspi3_seca_scramble_key                                (*(volatile uint32_t *)0x50003028)
#define adr_qspi3_seca_scramble_key                                                      (0x50003028)

#define reg_qspi3_seca_spcr                                        (*(volatile uint32_t *)0x5000302c)
#define adr_qspi3_seca_spcr                                                              (0x5000302c)
#define mask_qspi3_seca_spcr_sample_edge                             (0x20)                          
#define mask_qspi3_seca_spcr_data_comb_mode                          (0x18)                          
#define mask_qspi3_seca_spcr_sda_mode                                (0x4)                           
#define mask_qspi3_seca_spcr_cpha                                    (0x2)                           
#define mask_qspi3_seca_spcr_cpol                                    (0x1)                           

#define reg_qspi3_seca_dly_cfg                                     (*(volatile uint32_t *)0x50003030)
#define adr_qspi3_seca_dly_cfg                                                           (0x50003030)
#define mask_qspi3_seca_dly_cfg_input_clk_dly                        (0x38)                          
#define mask_qspi3_seca_dly_cfg_output_clk_dly                       (0x7)                           

#define reg_qspi3_seca_opi_ctrl                                    (*(volatile uint32_t *)0x50003034)
#define adr_qspi3_seca_opi_ctrl                                                          (0x50003034)
#define mask_qspi3_seca_opi_ctrl_opi_en                              (0x100)                         
#define mask_qspi3_seca_opi_ctrl_dtr_read_cpha                       (0x80)                          
#define mask_qspi3_seca_opi_ctrl_write_dtr_en                        (0x40)                          
#define mask_qspi3_seca_opi_ctrl_read_dtr_en                         (0x20)                          
#define mask_qspi3_seca_opi_ctrl_datamask_en                         (0x10)                          
#define mask_qspi3_seca_opi_ctrl_byte_mask_config                    (0xf)                           

#define reg_qspi3_seca_send_ctrl                                   (*(volatile uint32_t *)0x50003040)
#define adr_qspi3_seca_send_ctrl                                                         (0x50003040)
#define mask_qspi3_seca_send_ctrl_adr_byte_mode                      (0x800)                         
#define mask_qspi3_seca_send_ctrl_cmd_with_arg                       (0x700)                         
#define mask_qspi3_seca_send_ctrl_adr_with_arg                       (0xc0)                          
#define mask_qspi3_seca_send_ctrl_cmd_bit_num                        (0x30)                          
#define mask_qspi3_seca_send_ctrl_addr_bit_num                       (0xc)                           
#define mask_qspi3_seca_send_ctrl_data_bit_num                       (0x3)                           

#define reg_qspi3_seca_reg_qspi_rxtx_dat_len                       (*(volatile uint32_t *)0x50003044)
#define adr_qspi3_seca_reg_qspi_rxtx_dat_len                                             (0x50003044)

#define reg_qspi3_seca_reg_qspi_cmd_reg                            (*(volatile uint32_t *)0x50003048)
#define adr_qspi3_seca_reg_qspi_cmd_reg                                                  (0x50003048)

#define reg_qspi3_seca_reg_qspi_addr_reg                           (*(volatile uint32_t *)0x5000304c)
#define adr_qspi3_seca_reg_qspi_addr_reg                                                 (0x5000304c)

#define reg_qspi3_seca_mcu_adrcnd_bit_len                          (*(volatile uint32_t *)0x50003050)
#define adr_qspi3_seca_mcu_adrcnd_bit_len                                                (0x50003050)
#define mask_qspi3_seca_mcu_adrcnd_bit_len_mcu_rd_dummy              (0xf000)                        
#define mask_qspi3_seca_mcu_adrcnd_bit_len_mcu_cmd_max_len           (0xfc0)                         
#define mask_qspi3_seca_mcu_adrcnd_bit_len_mcu_adr_max_len           (0x3f)                          

#define reg_qspi3_seca_flash_busy                                  (*(volatile uint32_t *)0x50003054)
#define adr_qspi3_seca_flash_busy                                                        (0x50003054)

#define reg_qspi3_seca_auto_busy_enable                            (*(volatile uint32_t *)0x50003058)
#define adr_qspi3_seca_auto_busy_enable                                                  (0x50003058)

#define reg_qspi3_seca_auto_busy_configa                           (*(volatile uint32_t *)0x5000305c)
#define adr_qspi3_seca_auto_busy_configa                                                 (0x5000305c)
#define mask_qspi3_seca_auto_busy_configa_ini_cnt_value              (0xfffff000)                    
#define mask_qspi3_seca_auto_busy_configa_inval_cnt_value            (0xfff)                         

#define reg_qspi3_seca_auto_busy_configb                           (*(volatile uint32_t *)0x50003060)
#define adr_qspi3_seca_auto_busy_configb                                                 (0x50003060)
#define mask_qspi3_seca_auto_busy_configb_rdsr_cmd_num               (0x300)                         
#define mask_qspi3_seca_auto_busy_configb_rdsr_cmd                   (0xff)                          

#define reg_qspi3_seca_suspend_timing_ctrl                         (*(volatile uint32_t *)0x50003064)
#define adr_qspi3_seca_suspend_timing_ctrl                                               (0x50003064)
#define mask_qspi3_seca_suspend_timing_ctrl_sus_delay_max            (0xff000000)                    
#define mask_qspi3_seca_suspend_timing_ctrl_tps_tes_cfg              (0xff0000)                      
#define mask_qspi3_seca_suspend_timing_ctrl_ters_tprs_cfg            (0xff00)                        
#define mask_qspi3_seca_suspend_timing_ctrl_timeunit_us              (0xff)                          

#define reg_qspi3_seca_suspend_trig                                (*(volatile uint32_t *)0x50003068)
#define adr_qspi3_seca_suspend_trig                                                      (0x50003068)

#define reg_qspi3_seca_send_en                                     (*(volatile uint32_t *)0x5000306c)
#define adr_qspi3_seca_send_en                                                           (0x5000306c)

#define reg_qspi3_seca_flash_busy_auto                             (*(volatile uint32_t *)0x50003070)
#define adr_qspi3_seca_flash_busy_auto                                                   (0x50003070)

#define reg_qspi3_seca_cache_cmd1                                  (*(volatile uint32_t *)0x50003080)
#define adr_qspi3_seca_cache_cmd1                                                        (0x50003080)
#define mask_qspi3_seca_cache_cmd1_hpm_cmd                           (0xff000000)                    
#define mask_qspi3_seca_cache_cmd1_resume_cmd                        (0xff0000)                      
#define mask_qspi3_seca_cache_cmd1_sus_cmd                           (0xff00)                        
#define mask_qspi3_seca_cache_cmd1_read_cmd                          (0xff)                          

#define reg_qspi3_seca_cache_cmd2                                  (*(volatile uint32_t *)0x50003084)
#define adr_qspi3_seca_cache_cmd2                                                        (0x50003084)
#define mask_qspi3_seca_cache_cmd2_write_cmd                         (0xff0000)                      
#define mask_qspi3_seca_cache_cmd2_continu_rd_mod                    (0xff00)                        
#define mask_qspi3_seca_cache_cmd2_exithpm_mod                       (0xff)                          

#define reg_qspi3_seca_cache_delay_set                             (*(volatile uint32_t *)0x50003088)
#define adr_qspi3_seca_cache_delay_set                                                   (0x50003088)
#define mask_qspi3_seca_cache_delay_set_hpm_delay_max                (0x3f)                          

#define reg_qspi3_seca_delay_set                                   (*(volatile uint32_t *)0x5000308c)
#define adr_qspi3_seca_delay_set                                                         (0x5000308c)
#define mask_qspi3_seca_delay_set_cache_rd_dummy                     (0xf0000000)                    
#define mask_qspi3_seca_delay_set_dir_wr_en                          (0x8000000)                     
#define mask_qspi3_seca_delay_set_cache_addr_byte_mode               (0x4000000)                     
#define mask_qspi3_seca_delay_set_cache_cmd_bit_num                  (0x3000000)                     
#define mask_qspi3_seca_delay_set_cache_addr_bit_num                 (0xc00000)                      
#define mask_qspi3_seca_delay_set_cache_data_bit_num                 (0x300000)                      
#define mask_qspi3_seca_delay_set_cache_no_dummy_cmd_len             (0xf0000)                       
#define mask_qspi3_seca_delay_set_cache_cmd_len                      (0xf000)                        
#define mask_qspi3_seca_delay_set_adr_bit_max                        (0xfc0)                         
#define mask_qspi3_seca_delay_set_hpm_len                            (0x3f)                          

#define reg_qspi3_seca_continue_rd_mod_index                       (*(volatile uint32_t *)0x50003090)
#define adr_qspi3_seca_continue_rd_mod_index                                             (0x50003090)

#define reg_qspi3_seca_continue_status                             (*(volatile uint32_t *)0x50003094)
#define adr_qspi3_seca_continue_status                                                   (0x50003094)

#define reg_qspi3_seca_rst_trig                                    (*(volatile uint32_t *)0x50003098)
#define adr_qspi3_seca_rst_trig                                                          (0x50003098)

#define reg_qspi3_seca_rst_status                                  (*(volatile uint32_t *)0x5000309c)
#define adr_qspi3_seca_rst_status                                                        (0x5000309c)

#define reg_qspi3_seca_cache_access_status                         (*(volatile uint32_t *)0x500030a0)
#define adr_qspi3_seca_cache_access_status                                               (0x500030a0)

#define reg_qspi3_seca_cmd_send_status                             (*(volatile uint32_t *)0x500030a4)
#define adr_qspi3_seca_cmd_send_status                                                   (0x500030a4)

#define reg_qspi3_seca_manual_mode_cfg                             (*(volatile uint32_t *)0x500030c0)
#define adr_qspi3_seca_manual_mode_cfg                                                   (0x500030c0)
#define mask_qspi3_seca_manual_mode_cfg_maul_tx_data_seq_num         (0x600)                         
#define mask_qspi3_seca_manual_mode_cfg_maul_dcx_value               (0x100)                         
#define mask_qspi3_seca_manual_mode_cfg_maul_data_bit_num            (0xc0)                          
#define mask_qspi3_seca_manual_mode_cfg_cs_hold_ctrl                 (0x20)                          
#define mask_qspi3_seca_manual_mode_cfg_maul_rxtx_data_size          (0x1f)                          

#define reg_qspi3_seca_manual_mode_ctrl                            (*(volatile uint32_t *)0x500030c4)
#define adr_qspi3_seca_manual_mode_ctrl                                                  (0x500030c4)
#define mask_qspi3_seca_manual_mode_ctrl_maul_rd_dum                 (0x40)                          
#define mask_qspi3_seca_manual_mode_ctrl_maul_dcx_opt_mode           (0x20)                          
#define mask_qspi3_seca_manual_mode_ctrl_maul_dcx_mode               (0x18)                          
#define mask_qspi3_seca_manual_mode_ctrl_manual_trx_mode             (0x4)                           
#define mask_qspi3_seca_manual_mode_ctrl_cs_hold_mode                (0x2)                           
#define mask_qspi3_seca_manual_mode_ctrl_manual_mode                 (0x1)                           

#define reg_qspi3_seca_maul_rx_trig                                (*(volatile uint32_t *)0x500030c8)
#define adr_qspi3_seca_maul_rx_trig                                                      (0x500030c8)

#define reg_qspi3_seca_maul_mode_tx_st                             (*(volatile uint32_t *)0x500030cc)
#define adr_qspi3_seca_maul_mode_tx_st                                                   (0x500030cc)

#define reg_qspi3_seca_maul_mode_rx_st                             (*(volatile uint32_t *)0x500030d0)
#define adr_qspi3_seca_maul_mode_rx_st                                                   (0x500030d0)

#define reg_qspi3_seca_bypass_hpm                                  (*(volatile uint32_t *)0x500030d4)
#define adr_qspi3_seca_bypass_hpm                                                        (0x500030d4)

#define reg_qspi3_seca_atom_op_en                                  (*(volatile uint32_t *)0x500030d8)
#define adr_qspi3_seca_atom_op_en                                                        (0x500030d8)

#define reg_qspi3_seca_clr_hpm                                     (*(volatile uint32_t *)0x500030dc)
#define adr_qspi3_seca_clr_hpm                                                           (0x500030dc)


//---------------------------------------------------
// dma in  domain address definition
//---------------------------------------------------

#define reg_dma_0_int_status                                       (*(volatile uint32_t *)0x50008000)
#define adr_dma_0_int_status                                                             (0x50008000)

#define reg_dma_0_int_mask                                         (*(volatile uint32_t *)0x50008004)
#define adr_dma_0_int_mask                                                               (0x50008004)

#define reg_dma_0_int_clear                                        (*(volatile uint32_t *)0x50008008)
#define adr_dma_0_int_clear                                                              (0x50008008)

#define reg_dma_0_config                                           (*(volatile uint32_t *)0x5000800c)
#define adr_dma_0_config                                                                 (0x5000800c)
#define mask_dma_0_config_0_en                                       (0x10000000)                    
#define mask_dma_0_config_0_pause                                    (0x8000000)                     
#define mask_dma_0_config_0_stop                                     (0x4000000)                     
#define mask_dma_0_config_0_src_inc                                  (0x2000000)                     
#define mask_dma_0_config_0_src_size                                 (0x1800000)                     
#define mask_dma_0_config_0_dst_inc                                  (0x400000)                      
#define mask_dma_0_config_0_dst_size                                 (0x300000)                      
#define mask_dma_0_config_0_mode                                     (0xc0000)                       
#define mask_dma_0_config_0_pri                                      (0x20000)                       
#define mask_dma_0_config_0_circ                                     (0x10000)                       
#define mask_dma_0_config_0_cfg_cnt                                  (0xffff)                        

#define reg_dma_0_total_length                                     (*(volatile uint32_t *)0x50008010)
#define adr_dma_0_total_length                                                           (0x50008010)

#define reg_dma_0_src_addr                                         (*(volatile uint32_t *)0x50008014)
#define adr_dma_0_src_addr                                                               (0x50008014)

#define reg_dma_0_dst_addr                                         (*(volatile uint32_t *)0x50008018)
#define adr_dma_0_dst_addr                                                               (0x50008018)

#define reg_dma_0_tcnt                                             (*(volatile uint32_t *)0x5000801c)
#define adr_dma_0_tcnt                                                                   (0x5000801c)

#define reg_dma_0_total_tcnt                                       (*(volatile uint32_t *)0x50008020)
#define adr_dma_0_total_tcnt                                                             (0x50008020)

#define reg_dma_0_to_cfg                                           (*(volatile uint32_t *)0x50008024)
#define adr_dma_0_to_cfg                                                                 (0x50008024)
#define mask_dma_0_to_cfg_0_tu                                       (0x300)                         
#define mask_dma_0_to_cfg_0_to_thld                                  (0xff)                          

#define reg_dma_0_peri_sel                                         (*(volatile uint32_t *)0x50008028)
#define adr_dma_0_peri_sel                                                               (0x50008028)

#define reg_dma_0_inter_tx_cfg                                     (*(volatile uint32_t *)0x5000802c)
#define adr_dma_0_inter_tx_cfg                                                           (0x5000802c)
#define mask_dma_0_inter_tx_cfg_0_inter_tx_mode                      (0x10000)                       
#define mask_dma_0_inter_tx_cfg_0_inter_tx_offset                    (0xffff)                        

#define reg_dma_0_data_ready                                       (*(volatile uint32_t *)0x50008030)
#define adr_dma_0_data_ready                                                             (0x50008030)

#define reg_dma_0_int_sel                                          (*(volatile uint32_t *)0x50008034)
#define adr_dma_0_int_sel                                                                (0x50008034)

#define reg_dma_0_p2p_peri_sel                                     (*(volatile uint32_t *)0x50008038)
#define adr_dma_0_p2p_peri_sel                                                           (0x50008038)
#define mask_dma_0_p2p_peri_sel_src_peri_sel_res                     (0xc000)                        
#define mask_dma_0_p2p_peri_sel_src_peri_sel                         (0x3f00)                        
#define mask_dma_0_p2p_peri_sel_dst_peri_sel_res                     (0xc0)                          
#define mask_dma_0_p2p_peri_sel_dst_peri_sel                         (0x3f)                          

#define reg_dma_0_sram_ctrl                                        (*(volatile uint32_t *)0x5000803c)
#define adr_dma_0_sram_ctrl                                                              (0x5000803c)
#define mask_dma_0_sram_ctrl_sram_test1                              (0x4000)                        
#define mask_dma_0_sram_ctrl_sram_rme                                (0x2000)                        
#define mask_dma_0_sram_ctrl_sram_rm                                 (0x1e00)                        
#define mask_dma_0_sram_ctrl_sram_ra                                 (0x180)                         
#define mask_dma_0_sram_ctrl_sram_wa                                 (0x70)                          
#define mask_dma_0_sram_ctrl_sram_ls                                 (0x1)                           

#define reg_dma_1_int_status                                       (*(volatile uint32_t *)0x50008040)
#define adr_dma_1_int_status                                                             (0x50008040)

#define reg_dma_1_int_mask                                         (*(volatile uint32_t *)0x50008044)
#define adr_dma_1_int_mask                                                               (0x50008044)

#define reg_dma_1_int_clear                                        (*(volatile uint32_t *)0x50008048)
#define adr_dma_1_int_clear                                                              (0x50008048)

#define reg_dma_1_config                                           (*(volatile uint32_t *)0x5000804c)
#define adr_dma_1_config                                                                 (0x5000804c)
#define mask_dma_1_config_1_en                                       (0x10000000)                    
#define mask_dma_1_config_1_pause                                    (0x8000000)                     
#define mask_dma_1_config_1_stop                                     (0x4000000)                     
#define mask_dma_1_config_1_src_inc                                  (0x2000000)                     
#define mask_dma_1_config_1_src_size                                 (0x1800000)                     
#define mask_dma_1_config_1_dst_inc                                  (0x400000)                      
#define mask_dma_1_config_1_dst_size                                 (0x300000)                      
#define mask_dma_1_config_1_mode                                     (0xc0000)                       
#define mask_dma_1_config_1_pri                                      (0x20000)                       
#define mask_dma_1_config_1_circ                                     (0x10000)                       
#define mask_dma_1_config_1_cfg_cnt                                  (0xffff)                        

#define reg_dma_1_total_length                                     (*(volatile uint32_t *)0x50008050)
#define adr_dma_1_total_length                                                           (0x50008050)

#define reg_dma_1_src_addr                                         (*(volatile uint32_t *)0x50008054)
#define adr_dma_1_src_addr                                                               (0x50008054)

#define reg_dma_1_dst_addr                                         (*(volatile uint32_t *)0x50008058)
#define adr_dma_1_dst_addr                                                               (0x50008058)

#define reg_dma_1_tcnt                                             (*(volatile uint32_t *)0x5000805c)
#define adr_dma_1_tcnt                                                                   (0x5000805c)

#define reg_dma_1_total_tcnt                                       (*(volatile uint32_t *)0x50008060)
#define adr_dma_1_total_tcnt                                                             (0x50008060)

#define reg_dma_1_to_cfg                                           (*(volatile uint32_t *)0x50008064)
#define adr_dma_1_to_cfg                                                                 (0x50008064)
#define mask_dma_1_to_cfg_1_tu                                       (0x300)                         
#define mask_dma_1_to_cfg_1_to_thld                                  (0xff)                          

#define reg_dma_1_peri_sel                                         (*(volatile uint32_t *)0x50008068)
#define adr_dma_1_peri_sel                                                               (0x50008068)

#define reg_dma_1_inter_tx_cfg                                     (*(volatile uint32_t *)0x5000806c)
#define adr_dma_1_inter_tx_cfg                                                           (0x5000806c)
#define mask_dma_1_inter_tx_cfg_1_inter_tx_mode                      (0x10000)                       
#define mask_dma_1_inter_tx_cfg_1_inter_tx_offset                    (0xffff)                        

#define reg_dma_1_data_ready                                       (*(volatile uint32_t *)0x50008070)
#define adr_dma_1_data_ready                                                             (0x50008070)

#define reg_dma_1_int_sel                                          (*(volatile uint32_t *)0x50008074)
#define adr_dma_1_int_sel                                                                (0x50008074)

#define reg_dma_2_int_status                                       (*(volatile uint32_t *)0x50008080)
#define adr_dma_2_int_status                                                             (0x50008080)

#define reg_dma_2_int_mask                                         (*(volatile uint32_t *)0x50008084)
#define adr_dma_2_int_mask                                                               (0x50008084)

#define reg_dma_2_int_clear                                        (*(volatile uint32_t *)0x50008088)
#define adr_dma_2_int_clear                                                              (0x50008088)

#define reg_dma_2_config                                           (*(volatile uint32_t *)0x5000808c)
#define adr_dma_2_config                                                                 (0x5000808c)
#define mask_dma_2_config_2_en                                       (0x10000000)                    
#define mask_dma_2_config_2_pause                                    (0x8000000)                     
#define mask_dma_2_config_2_stop                                     (0x4000000)                     
#define mask_dma_2_config_2_src_inc                                  (0x2000000)                     
#define mask_dma_2_config_2_src_size                                 (0x1800000)                     
#define mask_dma_2_config_2_dst_inc                                  (0x400000)                      
#define mask_dma_2_config_2_dst_size                                 (0x300000)                      
#define mask_dma_2_config_2_mode                                     (0xc0000)                       
#define mask_dma_2_config_2_pri                                      (0x20000)                       
#define mask_dma_2_config_2_circ                                     (0x10000)                       
#define mask_dma_2_config_2_cfg_cnt                                  (0xffff)                        

#define reg_dma_2_total_length                                     (*(volatile uint32_t *)0x50008090)
#define adr_dma_2_total_length                                                           (0x50008090)

#define reg_dma_2_src_addr                                         (*(volatile uint32_t *)0x50008094)
#define adr_dma_2_src_addr                                                               (0x50008094)

#define reg_dma_2_dst_addr                                         (*(volatile uint32_t *)0x50008098)
#define adr_dma_2_dst_addr                                                               (0x50008098)

#define reg_dma_2_tcnt                                             (*(volatile uint32_t *)0x5000809c)
#define adr_dma_2_tcnt                                                                   (0x5000809c)

#define reg_dma_2_total_tcnt                                       (*(volatile uint32_t *)0x500080a0)
#define adr_dma_2_total_tcnt                                                             (0x500080a0)

#define reg_dma_2_to_cfg                                           (*(volatile uint32_t *)0x500080a4)
#define adr_dma_2_to_cfg                                                                 (0x500080a4)
#define mask_dma_2_to_cfg_2_tu                                       (0x300)                         
#define mask_dma_2_to_cfg_2_to_thld                                  (0xff)                          

#define reg_dma_2_peri_sel                                         (*(volatile uint32_t *)0x500080a8)
#define adr_dma_2_peri_sel                                                               (0x500080a8)

#define reg_dma_2_inter_tx_cfg                                     (*(volatile uint32_t *)0x500080ac)
#define adr_dma_2_inter_tx_cfg                                                           (0x500080ac)
#define mask_dma_2_inter_tx_cfg_2_inter_tx_mode                      (0x10000)                       
#define mask_dma_2_inter_tx_cfg_2_inter_tx_offset                    (0xffff)                        

#define reg_dma_2_data_ready                                       (*(volatile uint32_t *)0x500080b0)
#define adr_dma_2_data_ready                                                             (0x500080b0)

#define reg_dma_2_int_sel                                          (*(volatile uint32_t *)0x500080b4)
#define adr_dma_2_int_sel                                                                (0x500080b4)

#define reg_dma_3_int_status                                       (*(volatile uint32_t *)0x500080c0)
#define adr_dma_3_int_status                                                             (0x500080c0)

#define reg_dma_3_int_mask                                         (*(volatile uint32_t *)0x500080c4)
#define adr_dma_3_int_mask                                                               (0x500080c4)

#define reg_dma_3_int_clear                                        (*(volatile uint32_t *)0x500080c8)
#define adr_dma_3_int_clear                                                              (0x500080c8)

#define reg_dma_3_config                                           (*(volatile uint32_t *)0x500080cc)
#define adr_dma_3_config                                                                 (0x500080cc)
#define mask_dma_3_config_3_en                                       (0x10000000)                    
#define mask_dma_3_config_3_pause                                    (0x8000000)                     
#define mask_dma_3_config_3_stop                                     (0x4000000)                     
#define mask_dma_3_config_3_src_inc                                  (0x2000000)                     
#define mask_dma_3_config_3_src_size                                 (0x1800000)                     
#define mask_dma_3_config_3_dst_inc                                  (0x400000)                      
#define mask_dma_3_config_3_dst_size                                 (0x300000)                      
#define mask_dma_3_config_3_mode                                     (0xc0000)                       
#define mask_dma_3_config_3_pri                                      (0x20000)                       
#define mask_dma_3_config_3_circ                                     (0x10000)                       
#define mask_dma_3_config_3_cfg_cnt                                  (0xffff)                        

#define reg_dma_3_total_length                                     (*(volatile uint32_t *)0x500080d0)
#define adr_dma_3_total_length                                                           (0x500080d0)

#define reg_dma_3_src_addr                                         (*(volatile uint32_t *)0x500080d4)
#define adr_dma_3_src_addr                                                               (0x500080d4)

#define reg_dma_3_dst_addr                                         (*(volatile uint32_t *)0x500080d8)
#define adr_dma_3_dst_addr                                                               (0x500080d8)

#define reg_dma_3_tcnt                                             (*(volatile uint32_t *)0x500080dc)
#define adr_dma_3_tcnt                                                                   (0x500080dc)

#define reg_dma_3_total_tcnt                                       (*(volatile uint32_t *)0x500080e0)
#define adr_dma_3_total_tcnt                                                             (0x500080e0)

#define reg_dma_3_to_cfg                                           (*(volatile uint32_t *)0x500080e4)
#define adr_dma_3_to_cfg                                                                 (0x500080e4)
#define mask_dma_3_to_cfg_3_tu                                       (0x300)                         
#define mask_dma_3_to_cfg_3_to_thld                                  (0xff)                          

#define reg_dma_3_peri_sel                                         (*(volatile uint32_t *)0x500080e8)
#define adr_dma_3_peri_sel                                                               (0x500080e8)

#define reg_dma_3_inter_tx_cfg                                     (*(volatile uint32_t *)0x500080ec)
#define adr_dma_3_inter_tx_cfg                                                           (0x500080ec)
#define mask_dma_3_inter_tx_cfg_3_inter_tx_mode                      (0x10000)                       
#define mask_dma_3_inter_tx_cfg_3_inter_tx_offset                    (0xffff)                        

#define reg_dma_3_data_ready                                       (*(volatile uint32_t *)0x500080f0)
#define adr_dma_3_data_ready                                                             (0x500080f0)

#define reg_dma_3_int_sel                                          (*(volatile uint32_t *)0x500080f4)
#define adr_dma_3_int_sel                                                                (0x500080f4)

#define reg_dma_4_int_status                                       (*(volatile uint32_t *)0x50008100)
#define adr_dma_4_int_status                                                             (0x50008100)

#define reg_dma_4_int_mask                                         (*(volatile uint32_t *)0x50008104)
#define adr_dma_4_int_mask                                                               (0x50008104)

#define reg_dma_4_int_clear                                        (*(volatile uint32_t *)0x50008108)
#define adr_dma_4_int_clear                                                              (0x50008108)

#define reg_dma_4_config                                           (*(volatile uint32_t *)0x5000810c)
#define adr_dma_4_config                                                                 (0x5000810c)
#define mask_dma_4_config_4_en                                       (0x10000000)                    
#define mask_dma_4_config_4_pause                                    (0x8000000)                     
#define mask_dma_4_config_4_stop                                     (0x4000000)                     
#define mask_dma_4_config_4_src_inc                                  (0x2000000)                     
#define mask_dma_4_config_4_src_size                                 (0x1800000)                     
#define mask_dma_4_config_4_dst_inc                                  (0x400000)                      
#define mask_dma_4_config_4_dst_size                                 (0x300000)                      
#define mask_dma_4_config_4_mode                                     (0xc0000)                       
#define mask_dma_4_config_4_pri                                      (0x20000)                       
#define mask_dma_4_config_4_circ                                     (0x10000)                       
#define mask_dma_4_config_4_cfg_cnt                                  (0xffff)                        

#define reg_dma_4_total_length                                     (*(volatile uint32_t *)0x50008110)
#define adr_dma_4_total_length                                                           (0x50008110)

#define reg_dma_4_src_addr                                         (*(volatile uint32_t *)0x50008114)
#define adr_dma_4_src_addr                                                               (0x50008114)

#define reg_dma_4_dst_addr                                         (*(volatile uint32_t *)0x50008118)
#define adr_dma_4_dst_addr                                                               (0x50008118)

#define reg_dma_4_tcnt                                             (*(volatile uint32_t *)0x5000811c)
#define adr_dma_4_tcnt                                                                   (0x5000811c)

#define reg_dma_4_total_tcnt                                       (*(volatile uint32_t *)0x50008120)
#define adr_dma_4_total_tcnt                                                             (0x50008120)

#define reg_dma_4_to_cfg                                           (*(volatile uint32_t *)0x50008124)
#define adr_dma_4_to_cfg                                                                 (0x50008124)
#define mask_dma_4_to_cfg_4_tu                                       (0x300)                         
#define mask_dma_4_to_cfg_4_to_thld                                  (0xff)                          

#define reg_dma_4_peri_sel                                         (*(volatile uint32_t *)0x50008128)
#define adr_dma_4_peri_sel                                                               (0x50008128)

#define reg_dma_4_inter_tx_cfg                                     (*(volatile uint32_t *)0x5000812c)
#define adr_dma_4_inter_tx_cfg                                                           (0x5000812c)
#define mask_dma_4_inter_tx_cfg_4_inter_tx_mode                      (0x10000)                       
#define mask_dma_4_inter_tx_cfg_4_inter_tx_offset                    (0xffff)                        

#define reg_dma_4_data_ready                                       (*(volatile uint32_t *)0x50008130)
#define adr_dma_4_data_ready                                                             (0x50008130)

#define reg_dma_4_int_sel                                          (*(volatile uint32_t *)0x50008134)
#define adr_dma_4_int_sel                                                                (0x50008134)

#define reg_dma_5_int_status                                       (*(volatile uint32_t *)0x50008140)
#define adr_dma_5_int_status                                                             (0x50008140)

#define reg_dma_5_int_mask                                         (*(volatile uint32_t *)0x50008144)
#define adr_dma_5_int_mask                                                               (0x50008144)

#define reg_dma_5_int_clear                                        (*(volatile uint32_t *)0x50008148)
#define adr_dma_5_int_clear                                                              (0x50008148)

#define reg_dma_5_config                                           (*(volatile uint32_t *)0x5000814c)
#define adr_dma_5_config                                                                 (0x5000814c)
#define mask_dma_5_config_5_en                                       (0x10000000)                    
#define mask_dma_5_config_5_pause                                    (0x8000000)                     
#define mask_dma_5_config_5_stop                                     (0x4000000)                     
#define mask_dma_5_config_5_src_inc                                  (0x2000000)                     
#define mask_dma_5_config_5_src_size                                 (0x1800000)                     
#define mask_dma_5_config_5_dst_inc                                  (0x400000)                      
#define mask_dma_5_config_5_dst_size                                 (0x300000)                      
#define mask_dma_5_config_5_mode                                     (0xc0000)                       
#define mask_dma_5_config_5_pri                                      (0x20000)                       
#define mask_dma_5_config_5_circ                                     (0x10000)                       
#define mask_dma_5_config_5_cfg_cnt                                  (0xffff)                        

#define reg_dma_5_total_length                                     (*(volatile uint32_t *)0x50008150)
#define adr_dma_5_total_length                                                           (0x50008150)

#define reg_dma_5_src_addr                                         (*(volatile uint32_t *)0x50008154)
#define adr_dma_5_src_addr                                                               (0x50008154)

#define reg_dma_5_dst_addr                                         (*(volatile uint32_t *)0x50008158)
#define adr_dma_5_dst_addr                                                               (0x50008158)

#define reg_dma_5_tcnt                                             (*(volatile uint32_t *)0x5000815c)
#define adr_dma_5_tcnt                                                                   (0x5000815c)

#define reg_dma_5_total_tcnt                                       (*(volatile uint32_t *)0x50008160)
#define adr_dma_5_total_tcnt                                                             (0x50008160)

#define reg_dma_5_to_cfg                                           (*(volatile uint32_t *)0x50008164)
#define adr_dma_5_to_cfg                                                                 (0x50008164)
#define mask_dma_5_to_cfg_5_tu                                       (0x300)                         
#define mask_dma_5_to_cfg_5_to_thld                                  (0xff)                          

#define reg_dma_5_peri_sel                                         (*(volatile uint32_t *)0x50008168)
#define adr_dma_5_peri_sel                                                               (0x50008168)

#define reg_dma_5_inter_tx_cfg                                     (*(volatile uint32_t *)0x5000816c)
#define adr_dma_5_inter_tx_cfg                                                           (0x5000816c)
#define mask_dma_5_inter_tx_cfg_5_inter_tx_mode                      (0x10000)                       
#define mask_dma_5_inter_tx_cfg_5_inter_tx_offset                    (0xffff)                        

#define reg_dma_5_data_ready                                       (*(volatile uint32_t *)0x50008170)
#define adr_dma_5_data_ready                                                             (0x50008170)

#define reg_dma_5_int_sel                                          (*(volatile uint32_t *)0x50008174)
#define adr_dma_5_int_sel                                                                (0x50008174)

#define reg_dma_6_int_status                                       (*(volatile uint32_t *)0x50008180)
#define adr_dma_6_int_status                                                             (0x50008180)

#define reg_dma_6_int_mask                                         (*(volatile uint32_t *)0x50008184)
#define adr_dma_6_int_mask                                                               (0x50008184)

#define reg_dma_6_int_clear                                        (*(volatile uint32_t *)0x50008188)
#define adr_dma_6_int_clear                                                              (0x50008188)

#define reg_dma_6_config                                           (*(volatile uint32_t *)0x5000818c)
#define adr_dma_6_config                                                                 (0x5000818c)
#define mask_dma_6_config_6_en                                       (0x10000000)                    
#define mask_dma_6_config_6_pause                                    (0x8000000)                     
#define mask_dma_6_config_6_stop                                     (0x4000000)                     
#define mask_dma_6_config_6_src_inc                                  (0x2000000)                     
#define mask_dma_6_config_6_src_size                                 (0x1800000)                     
#define mask_dma_6_config_6_dst_inc                                  (0x400000)                      
#define mask_dma_6_config_6_dst_size                                 (0x300000)                      
#define mask_dma_6_config_6_mode                                     (0xc0000)                       
#define mask_dma_6_config_6_pri                                      (0x20000)                       
#define mask_dma_6_config_6_circ                                     (0x10000)                       
#define mask_dma_6_config_6_cfg_cnt                                  (0xffff)                        

#define reg_dma_6_total_length                                     (*(volatile uint32_t *)0x50008190)
#define adr_dma_6_total_length                                                           (0x50008190)

#define reg_dma_6_src_addr                                         (*(volatile uint32_t *)0x50008194)
#define adr_dma_6_src_addr                                                               (0x50008194)

#define reg_dma_6_dst_addr                                         (*(volatile uint32_t *)0x50008198)
#define adr_dma_6_dst_addr                                                               (0x50008198)

#define reg_dma_6_tcnt                                             (*(volatile uint32_t *)0x5000819c)
#define adr_dma_6_tcnt                                                                   (0x5000819c)

#define reg_dma_6_total_tcnt                                       (*(volatile uint32_t *)0x500081a0)
#define adr_dma_6_total_tcnt                                                             (0x500081a0)

#define reg_dma_6_to_cfg                                           (*(volatile uint32_t *)0x500081a4)
#define adr_dma_6_to_cfg                                                                 (0x500081a4)
#define mask_dma_6_to_cfg_6_tu                                       (0x300)                         
#define mask_dma_6_to_cfg_6_to_thld                                  (0xff)                          

#define reg_dma_6_peri_sel                                         (*(volatile uint32_t *)0x500081a8)
#define adr_dma_6_peri_sel                                                               (0x500081a8)

#define reg_dma_6_inter_tx_cfg                                     (*(volatile uint32_t *)0x500081ac)
#define adr_dma_6_inter_tx_cfg                                                           (0x500081ac)
#define mask_dma_6_inter_tx_cfg_6_inter_tx_mode                      (0x10000)                       
#define mask_dma_6_inter_tx_cfg_6_inter_tx_offset                    (0xffff)                        

#define reg_dma_6_data_ready                                       (*(volatile uint32_t *)0x500081b0)
#define adr_dma_6_data_ready                                                             (0x500081b0)

#define reg_dma_6_int_sel                                          (*(volatile uint32_t *)0x500081b4)
#define adr_dma_6_int_sel                                                                (0x500081b4)

#define reg_dma_7_int_status                                       (*(volatile uint32_t *)0x500081c0)
#define adr_dma_7_int_status                                                             (0x500081c0)

#define reg_dma_7_int_mask                                         (*(volatile uint32_t *)0x500081c4)
#define adr_dma_7_int_mask                                                               (0x500081c4)

#define reg_dma_7_int_clear                                        (*(volatile uint32_t *)0x500081c8)
#define adr_dma_7_int_clear                                                              (0x500081c8)

#define reg_dma_7_config                                           (*(volatile uint32_t *)0x500081cc)
#define adr_dma_7_config                                                                 (0x500081cc)
#define mask_dma_7_config_7_en                                       (0x10000000)                    
#define mask_dma_7_config_7_pause                                    (0x8000000)                     
#define mask_dma_7_config_7_stop                                     (0x4000000)                     
#define mask_dma_7_config_7_src_inc                                  (0x2000000)                     
#define mask_dma_7_config_7_src_size                                 (0x1800000)                     
#define mask_dma_7_config_7_dst_inc                                  (0x400000)                      
#define mask_dma_7_config_7_dst_size                                 (0x300000)                      
#define mask_dma_7_config_7_mode                                     (0xc0000)                       
#define mask_dma_7_config_7_pri                                      (0x20000)                       
#define mask_dma_7_config_7_circ                                     (0x10000)                       
#define mask_dma_7_config_7_cfg_cnt                                  (0xffff)                        

#define reg_dma_7_total_length                                     (*(volatile uint32_t *)0x500081d0)
#define adr_dma_7_total_length                                                           (0x500081d0)

#define reg_dma_7_src_addr                                         (*(volatile uint32_t *)0x500081d4)
#define adr_dma_7_src_addr                                                               (0x500081d4)

#define reg_dma_7_dst_addr                                         (*(volatile uint32_t *)0x500081d8)
#define adr_dma_7_dst_addr                                                               (0x500081d8)

#define reg_dma_7_tcnt                                             (*(volatile uint32_t *)0x500081dc)
#define adr_dma_7_tcnt                                                                   (0x500081dc)

#define reg_dma_7_total_tcnt                                       (*(volatile uint32_t *)0x500081e0)
#define adr_dma_7_total_tcnt                                                             (0x500081e0)

#define reg_dma_7_to_cfg                                           (*(volatile uint32_t *)0x500081e4)
#define adr_dma_7_to_cfg                                                                 (0x500081e4)
#define mask_dma_7_to_cfg_7_tu                                       (0x300)                         
#define mask_dma_7_to_cfg_7_to_thld                                  (0xff)                          

#define reg_dma_7_peri_sel                                         (*(volatile uint32_t *)0x500081e8)
#define adr_dma_7_peri_sel                                                               (0x500081e8)

#define reg_dma_7_inter_tx_cfg                                     (*(volatile uint32_t *)0x500081ec)
#define adr_dma_7_inter_tx_cfg                                                           (0x500081ec)
#define mask_dma_7_inter_tx_cfg_7_inter_tx_mode                      (0x10000)                       
#define mask_dma_7_inter_tx_cfg_7_inter_tx_offset                    (0xffff)                        

#define reg_dma_7_data_ready                                       (*(volatile uint32_t *)0x500081f0)
#define adr_dma_7_data_ready                                                             (0x500081f0)

#define reg_dma_7_int_sel                                          (*(volatile uint32_t *)0x500081f4)
#define adr_dma_7_int_sel                                                                (0x500081f4)

#define reg_dma_ext_cg_en                                          (*(volatile uint32_t *)0x500081f8)
#define adr_dma_ext_cg_en                                                                (0x500081f8)


//---------------------------------------------------
// cach_ret_pd in  domain address definition
//---------------------------------------------------

#define reg_cach_ret_pd_cach_ctrl                                  (*(volatile uint32_t *)0x50009000)
#define adr_cach_ret_pd_cach_ctrl                                                        (0x50009000)
#define mask_cach_ret_pd_cach_ctrl_wrap_n_incr                       (0x40)                          
#define mask_cach_ret_pd_cach_ctrl_cmd                               (0x3e)                          
#define mask_cach_ret_pd_cach_ctrl_en                                (0x1)                           

#define reg_cach_cmd_en                                            (*(volatile uint32_t *)0x50009004)
#define adr_cach_cmd_en                                                                  (0x50009004)

#define reg_cach_cmd_busy                                          (*(volatile uint32_t *)0x50009008)
#define adr_cach_cmd_busy                                                                (0x50009008)

#define reg_cach_access_cnt_cm3                                    (*(volatile uint32_t *)0x5000900c)
#define adr_cach_access_cnt_cm3                                                          (0x5000900c)

#define reg_cach_access_cnt_slv                                    (*(volatile uint32_t *)0x50009010)
#define adr_cach_access_cnt_slv                                                          (0x50009010)

#define reg_cach_miss_cnt_basic                                    (*(volatile uint32_t *)0x50009014)
#define adr_cach_miss_cnt_basic                                                          (0x50009014)

#define reg_cach_miss_cnt_adv                                      (*(volatile uint32_t *)0x50009018)
#define adr_cach_miss_cnt_adv                                                            (0x50009018)

#define reg_cach_penalty_cycle_cnt_cm3                             (*(volatile uint32_t *)0x5000901c)
#define adr_cach_penalty_cycle_cnt_cm3                                                   (0x5000901c)

#define reg_cach_penalty_cycle_cnt_slv                             (*(volatile uint32_t *)0x50009020)
#define adr_cach_penalty_cycle_cnt_slv                                                   (0x50009020)

#define reg_cach_last_miss_addr                                    (*(volatile uint32_t *)0x50009024)
#define adr_cach_last_miss_addr                                                          (0x50009024)

#define reg_cach_bist_err_cnt                                      (*(volatile uint32_t *)0x50009028)
#define adr_cach_bist_err_cnt                                                            (0x50009028)

#define reg_cach_reset_statistic_info                              (*(volatile uint32_t *)0x5000902c)
#define adr_cach_reset_statistic_info                                                    (0x5000902c)
#define mask_cach_reset_statistic_info_reset_last_miss_addr          (0x40)                          
#define mask_cach_reset_statistic_info_reset_penalty_cycle_cnt_slv   (0x20)                          
#define mask_cach_reset_statistic_info_reset_penalty_cycle_cnt_cm3   (0x10)                          
#define mask_cach_reset_statistic_info_reset_miss_cnt_adv            (0x8)                           
#define mask_cach_reset_statistic_info_reset_miss_cnt_basic          (0x4)                           
#define mask_cach_reset_statistic_info_reset_access_cnt_slv          (0x2)                           
#define mask_cach_reset_statistic_info_reset_access_cnt_cm3          (0x1)                           

#define reg_cach_ext_cg_en                                         (*(volatile uint32_t *)0x50009030)
#define adr_cach_ext_cg_en                                                               (0x50009030)
#define mask_cach_ext_cg_en_func_ext_cg_en                           (0x4)                           
#define mask_cach_ext_cg_en_reg_ext_cg_en                            (0x2)                           
#define mask_cach_ext_cg_en_sram_ext_cg_en                           (0x1)                           


//---------------------------------------------------
// uart0 in  domain address definition
//---------------------------------------------------

#define reg_uart0_tfifo_wr_data                                    (*(volatile uint32_t *)0x60000000)
#define adr_uart0_tfifo_wr_data                                                          (0x60000000)

#define reg_uart0_rfifo_rd_data                                    (*(volatile uint32_t *)0x60000004)
#define adr_uart0_rfifo_rd_data                                                          (0x60000004)


//---------------------------------------------------
// uart0 in  domain address definition
//---------------------------------------------------

#define reg_uart0_uart_int_status                                  (*(volatile uint32_t *)0x60000008)
#define adr_uart0_uart_int_status                                                        (0x60000008)

#define reg_uart0_uart_int_mask                                    (*(volatile uint32_t *)0x6000000c)
#define adr_uart0_uart_int_mask                                                          (0x6000000c)

#define reg_uart0_uart_int_clear                                   (*(volatile uint32_t *)0x60000010)
#define adr_uart0_uart_int_clear                                                         (0x60000010)

#define reg_uart0_config                                           (*(volatile uint32_t *)0x60000014)
#define adr_uart0_config                                                                 (0x60000014)
#define mask_uart0_config_err_discard                                (0x2000000)                     
#define mask_uart0_config_rts_thld                                   (0x1f00000)                     
#define mask_uart0_config_flow_ctrl_en                               (0x80000)                       
#define mask_uart0_config_lb_snd                                     (0x40000)                       
#define mask_uart0_config_msb                                        (0x20000)                       
#define mask_uart0_config_parity_mode                                (0x1c000)                       
#define mask_uart0_config_byte_size                                  (0x3000)                        
#define mask_uart0_config_stop_bit                                   (0xc00)                         
#define mask_uart0_config_rfifo_thld                                 (0x3e0)                         
#define mask_uart0_config_tfifo_thld                                 (0x1f)                          

#define reg_uart0_config1                                          (*(volatile uint32_t *)0x60000018)
#define adr_uart0_config1                                                                (0x60000018)
#define mask_uart0_config1_to_thld                                   (0xff)                          

#define reg_uart0_divisor                                          (*(volatile uint32_t *)0x6000001c)
#define adr_uart0_divisor                                                                (0x6000001c)
#define mask_uart0_divisor_trig_intv                                 (0x3ff0000)                     
#define mask_uart0_divisor_cap_intv                                  (0xffff)                        

#define reg_uart0_rfifo_cnt                                        (*(volatile uint32_t *)0x60000020)
#define adr_uart0_rfifo_cnt                                                              (0x60000020)

#define reg_uart0_tfifo_cnt                                        (*(volatile uint32_t *)0x60000024)
#define adr_uart0_tfifo_cnt                                                              (0x60000024)

#define reg_uart0_rfifo_clr                                        (*(volatile uint32_t *)0x60000028)
#define adr_uart0_rfifo_clr                                                              (0x60000028)

#define reg_uart0_tfifo_clr                                        (*(volatile uint32_t *)0x6000002c)
#define adr_uart0_tfifo_clr                                                              (0x6000002c)

#define reg_uart0_ext_cg_en                                        (*(volatile uint32_t *)0x60000030)
#define adr_uart0_ext_cg_en                                                              (0x60000030)


//---------------------------------------------------
// uart1 in  domain address definition
//---------------------------------------------------

#define reg_uart1_tfifo_wr_data                                    (*(volatile uint32_t *)0x60000400)
#define adr_uart1_tfifo_wr_data                                                          (0x60000400)

#define reg_uart1_rfifo_rd_data                                    (*(volatile uint32_t *)0x60000404)
#define adr_uart1_rfifo_rd_data                                                          (0x60000404)


//---------------------------------------------------
// uart1 in  domain address definition
//---------------------------------------------------

#define reg_uart1_uart_int_status                                  (*(volatile uint32_t *)0x60000408)
#define adr_uart1_uart_int_status                                                        (0x60000408)

#define reg_uart1_uart_int_mask                                    (*(volatile uint32_t *)0x6000040c)
#define adr_uart1_uart_int_mask                                                          (0x6000040c)

#define reg_uart1_uart_int_clear                                   (*(volatile uint32_t *)0x60000410)
#define adr_uart1_uart_int_clear                                                         (0x60000410)

#define reg_uart1_config                                           (*(volatile uint32_t *)0x60000414)
#define adr_uart1_config                                                                 (0x60000414)
#define mask_uart1_config_err_discard                                (0x2000000)                     
#define mask_uart1_config_rts_thld                                   (0x1f00000)                     
#define mask_uart1_config_flow_ctrl_en                               (0x80000)                       
#define mask_uart1_config_lb_snd                                     (0x40000)                       
#define mask_uart1_config_msb                                        (0x20000)                       
#define mask_uart1_config_parity_mode                                (0x1c000)                       
#define mask_uart1_config_byte_size                                  (0x3000)                        
#define mask_uart1_config_stop_bit                                   (0xc00)                         
#define mask_uart1_config_rfifo_thld                                 (0x3e0)                         
#define mask_uart1_config_tfifo_thld                                 (0x1f)                          

#define reg_uart1_config1                                          (*(volatile uint32_t *)0x60000418)
#define adr_uart1_config1                                                                (0x60000418)
#define mask_uart1_config1_to_thld                                   (0xff)                          

#define reg_uart1_divisor                                          (*(volatile uint32_t *)0x6000041c)
#define adr_uart1_divisor                                                                (0x6000041c)
#define mask_uart1_divisor_trig_intv                                 (0x3ff0000)                     
#define mask_uart1_divisor_cap_intv                                  (0xffff)                        

#define reg_uart1_rfifo_cnt                                        (*(volatile uint32_t *)0x60000420)
#define adr_uart1_rfifo_cnt                                                              (0x60000420)

#define reg_uart1_tfifo_cnt                                        (*(volatile uint32_t *)0x60000424)
#define adr_uart1_tfifo_cnt                                                              (0x60000424)

#define reg_uart1_rfifo_clr                                        (*(volatile uint32_t *)0x60000428)
#define adr_uart1_rfifo_clr                                                              (0x60000428)

#define reg_uart1_tfifo_clr                                        (*(volatile uint32_t *)0x6000042c)
#define adr_uart1_tfifo_clr                                                              (0x6000042c)

#define reg_uart1_ext_cg_en                                        (*(volatile uint32_t *)0x60000430)
#define adr_uart1_ext_cg_en                                                              (0x60000430)


//---------------------------------------------------
// uart2 in  domain address definition
//---------------------------------------------------

#define reg_uart2_tfifo_wr_data                                    (*(volatile uint32_t *)0x60000800)
#define adr_uart2_tfifo_wr_data                                                          (0x60000800)

#define reg_uart2_rfifo_rd_data                                    (*(volatile uint32_t *)0x60000804)
#define adr_uart2_rfifo_rd_data                                                          (0x60000804)


//---------------------------------------------------
// uart2 in  domain address definition
//---------------------------------------------------

#define reg_uart2_uart_int_status                                  (*(volatile uint32_t *)0x60000808)
#define adr_uart2_uart_int_status                                                        (0x60000808)

#define reg_uart2_uart_int_mask                                    (*(volatile uint32_t *)0x6000080c)
#define adr_uart2_uart_int_mask                                                          (0x6000080c)

#define reg_uart2_uart_int_clear                                   (*(volatile uint32_t *)0x60000810)
#define adr_uart2_uart_int_clear                                                         (0x60000810)

#define reg_uart2_config                                           (*(volatile uint32_t *)0x60000814)
#define adr_uart2_config                                                                 (0x60000814)
#define mask_uart2_config_scc_en                                     (0x4000000)                     
#define mask_uart2_config_err_discard                                (0x2000000)                     
#define mask_uart2_config_rts_thld                                   (0x1f00000)                     
#define mask_uart2_config_flow_ctrl_en                               (0x80000)                       
#define mask_uart2_config_lb_snd                                     (0x40000)                       
#define mask_uart2_config_msb                                        (0x20000)                       
#define mask_uart2_config_parity_mode                                (0x1c000)                       
#define mask_uart2_config_byte_size                                  (0x3000)                        
#define mask_uart2_config_stop_bit                                   (0xc00)                         
#define mask_uart2_config_rfifo_thld                                 (0x3e0)                         
#define mask_uart2_config_tfifo_thld                                 (0x1f)                          

#define reg_uart2_config1                                          (*(volatile uint32_t *)0x60000818)
#define adr_uart2_config1                                                                (0x60000818)
#define mask_uart2_config1_to_thld                                   (0xff)                          

#define reg_uart2_divisor                                          (*(volatile uint32_t *)0x6000081c)
#define adr_uart2_divisor                                                                (0x6000081c)
#define mask_uart2_divisor_trig_intv                                 (0x3ff0000)                     
#define mask_uart2_divisor_cap_intv                                  (0xffff)                        

#define reg_uart2_rfifo_cnt                                        (*(volatile uint32_t *)0x60000820)
#define adr_uart2_rfifo_cnt                                                              (0x60000820)

#define reg_uart2_tfifo_cnt                                        (*(volatile uint32_t *)0x60000824)
#define adr_uart2_tfifo_cnt                                                              (0x60000824)

#define reg_uart2_rfifo_clr                                        (*(volatile uint32_t *)0x60000828)
#define adr_uart2_rfifo_clr                                                              (0x60000828)

#define reg_uart2_tfifo_clr                                        (*(volatile uint32_t *)0x6000082c)
#define adr_uart2_tfifo_clr                                                              (0x6000082c)

#define reg_uart2_ext_cg_en                                        (*(volatile uint32_t *)0x60000830)
#define adr_uart2_ext_cg_en                                                              (0x60000830)

#define reg_uart2_phy_config                                       (*(volatile uint32_t *)0x60000834)
#define adr_uart2_phy_config                                                             (0x60000834)
#define mask_uart2_phy_config_start_frame                            (0xff0)                         
#define mask_uart2_phy_config_txd_byte_wait_time                     (0xf)                           

#define reg_uart2_scc_basic_config                                 (*(volatile uint32_t *)0x60000838)
#define adr_uart2_scc_basic_config                                                       (0x60000838)
#define mask_uart2_scc_basic_config_rst_vld_time                     (0xfff00000)                    
#define mask_uart2_scc_basic_config_tx_byte_intvl                    (0xfffc0)                       
#define mask_uart2_scc_basic_config_clk_rate                         (0x38)                          
#define mask_uart2_scc_basic_config_mode                             (0x7)                           

#define reg_uart2_mode_trig                                        (*(volatile uint32_t *)0x6000083c)
#define adr_uart2_mode_trig                                                              (0x6000083c)


//---------------------------------------------------
// spi0 in  domain address definition
//---------------------------------------------------

#define reg_spi0_tfifo_wr_data                                     (*(volatile uint32_t *)0x60001000)
#define adr_spi0_tfifo_wr_data                                                           (0x60001000)

#define reg_spi0_rfifo_rd_data                                     (*(volatile uint32_t *)0x60001004)
#define adr_spi0_rfifo_rd_data                                                           (0x60001004)


//---------------------------------------------------
// spi0 in  domain address definition
//---------------------------------------------------

#define reg_spi0_spi_int_status                                    (*(volatile uint32_t *)0x60001008)
#define adr_spi0_spi_int_status                                                          (0x60001008)

#define reg_spi0_spi_int_mask                                      (*(volatile uint32_t *)0x6000100c)
#define adr_spi0_spi_int_mask                                                            (0x6000100c)

#define reg_spi0_spi_int_clear                                     (*(volatile uint32_t *)0x60001010)
#define adr_spi0_spi_int_clear                                                           (0x60001010)

#define reg_spi0_config1                                           (*(volatile uint32_t *)0x60001014)
#define adr_spi0_config1                                                                 (0x60001014)
#define mask_spi0_config1_cs_host_mode                               (0x40000)                       
#define mask_spi0_config1_cs_host_ctrl                               (0x20000)                       
#define mask_spi0_config1_byte_wait_en                               (0x10000)                       
#define mask_spi0_config1_size                                       (0xc000)                        
#define mask_spi0_config1_trx_mode                                   (0x3000)                        
#define mask_spi0_config1_to_thld                                    (0xff0)                         
#define mask_spi0_config1_master                                     (0x8)                           
#define mask_spi0_config1_cpol                                       (0x4)                           
#define mask_spi0_config1_cpha                                       (0x2)                           
#define mask_spi0_config1_en                                         (0x1)                           

#define reg_spi0_config2                                           (*(volatile uint32_t *)0x60001018)
#define adr_spi0_config2                                                                 (0x60001018)
#define mask_spi0_config2_len                                        (0xff)                          

#define reg_spi0_divisor                                           (*(volatile uint32_t *)0x6000101c)
#define adr_spi0_divisor                                                                 (0x6000101c)
#define mask_spi0_divisor_psdvsr                                     (0xff)                          

#define reg_spi0_rfifo_thld                                        (*(volatile uint32_t *)0x60001020)
#define adr_spi0_rfifo_thld                                                              (0x60001020)

#define reg_spi0_tfifo_thld                                        (*(volatile uint32_t *)0x60001024)
#define adr_spi0_tfifo_thld                                                              (0x60001024)

#define reg_spi0_rfifo_cnt                                         (*(volatile uint32_t *)0x60001028)
#define adr_spi0_rfifo_cnt                                                               (0x60001028)

#define reg_spi0_tfifo_cnt                                         (*(volatile uint32_t *)0x6000102c)
#define adr_spi0_tfifo_cnt                                                               (0x6000102c)

#define reg_spi0_tfifo_idle_config                                 (*(volatile uint32_t *)0x60001030)
#define adr_spi0_tfifo_idle_config                                                       (0x60001030)
#define mask_spi0_tfifo_idle_config_tfifo_idle_mode                  (0x100)                         
#define mask_spi0_tfifo_idle_config_tfifo_idle_data                  (0xff)                          

#define reg_spi0_master_read_length                                (*(volatile uint32_t *)0x60001034)
#define adr_spi0_master_read_length                                                      (0x60001034)
#define mask_spi0_master_read_length_mread_length_en                 (0x100)                         
#define mask_spi0_master_read_length_mread_length_cmd                (0xff)                          

#define reg_spi0_rfifo_clr                                         (*(volatile uint32_t *)0x60001038)
#define adr_spi0_rfifo_clr                                                               (0x60001038)

#define reg_spi0_tfifo_clr                                         (*(volatile uint32_t *)0x6000103c)
#define adr_spi0_tfifo_clr                                                               (0x6000103c)

#define reg_spi0_ext_cg_en                                         (*(volatile uint32_t *)0x60001040)
#define adr_spi0_ext_cg_en                                                               (0x60001040)


//---------------------------------------------------
// spi1 in  domain address definition
//---------------------------------------------------

#define reg_spi1_tfifo_wr_data                                     (*(volatile uint32_t *)0x60002000)
#define adr_spi1_tfifo_wr_data                                                           (0x60002000)

#define reg_spi1_rfifo_rd_data                                     (*(volatile uint32_t *)0x60002004)
#define adr_spi1_rfifo_rd_data                                                           (0x60002004)


//---------------------------------------------------
// spi1 in  domain address definition
//---------------------------------------------------

#define reg_spi1_spi_int_status                                    (*(volatile uint32_t *)0x60002008)
#define adr_spi1_spi_int_status                                                          (0x60002008)

#define reg_spi1_spi_int_mask                                      (*(volatile uint32_t *)0x6000200c)
#define adr_spi1_spi_int_mask                                                            (0x6000200c)

#define reg_spi1_spi_int_clear                                     (*(volatile uint32_t *)0x60002010)
#define adr_spi1_spi_int_clear                                                           (0x60002010)

#define reg_spi1_config1                                           (*(volatile uint32_t *)0x60002014)
#define adr_spi1_config1                                                                 (0x60002014)
#define mask_spi1_config1_cs_host_mode                               (0x40000)                       
#define mask_spi1_config1_cs_host_ctrl                               (0x20000)                       
#define mask_spi1_config1_byte_wait_en                               (0x10000)                       
#define mask_spi1_config1_size                                       (0xc000)                        
#define mask_spi1_config1_trx_mode                                   (0x3000)                        
#define mask_spi1_config1_to_thld                                    (0xff0)                         
#define mask_spi1_config1_master                                     (0x8)                           
#define mask_spi1_config1_cpol                                       (0x4)                           
#define mask_spi1_config1_cpha                                       (0x2)                           
#define mask_spi1_config1_en                                         (0x1)                           

#define reg_spi1_config2                                           (*(volatile uint32_t *)0x60002018)
#define adr_spi1_config2                                                                 (0x60002018)
#define mask_spi1_config2_len                                        (0xff)                          

#define reg_spi1_divisor                                           (*(volatile uint32_t *)0x6000201c)
#define adr_spi1_divisor                                                                 (0x6000201c)
#define mask_spi1_divisor_psdvsr                                     (0xff)                          

#define reg_spi1_rfifo_thld                                        (*(volatile uint32_t *)0x60002020)
#define adr_spi1_rfifo_thld                                                              (0x60002020)

#define reg_spi1_tfifo_thld                                        (*(volatile uint32_t *)0x60002024)
#define adr_spi1_tfifo_thld                                                              (0x60002024)

#define reg_spi1_rfifo_cnt                                         (*(volatile uint32_t *)0x60002028)
#define adr_spi1_rfifo_cnt                                                               (0x60002028)

#define reg_spi1_tfifo_cnt                                         (*(volatile uint32_t *)0x6000202c)
#define adr_spi1_tfifo_cnt                                                               (0x6000202c)

#define reg_spi1_tfifo_idle_config                                 (*(volatile uint32_t *)0x60002030)
#define adr_spi1_tfifo_idle_config                                                       (0x60002030)
#define mask_spi1_tfifo_idle_config_tfifo_idle_mode                  (0x100)                         
#define mask_spi1_tfifo_idle_config_tfifo_idle_data                  (0xff)                          

#define reg_spi1_master_read_length                                (*(volatile uint32_t *)0x60002034)
#define adr_spi1_master_read_length                                                      (0x60002034)
#define mask_spi1_master_read_length_mread_length_en                 (0x100)                         
#define mask_spi1_master_read_length_mread_length_cmd                (0xff)                          

#define reg_spi1_rfifo_clr                                         (*(volatile uint32_t *)0x60002038)
#define adr_spi1_rfifo_clr                                                               (0x60002038)

#define reg_spi1_tfifo_clr                                         (*(volatile uint32_t *)0x6000203c)
#define adr_spi1_tfifo_clr                                                               (0x6000203c)

#define reg_spi1_ext_cg_en                                         (*(volatile uint32_t *)0x60002040)
#define adr_spi1_ext_cg_en                                                               (0x60002040)


//---------------------------------------------------
// i2c0 in  domain address definition
//---------------------------------------------------

#define reg_i2c0_tfifo_wr_data                                     (*(volatile uint32_t *)0x60003000)
#define adr_i2c0_tfifo_wr_data                                                           (0x60003000)

#define reg_i2c0_rfifo_rd_data                                     (*(volatile uint32_t *)0x60003004)
#define adr_i2c0_rfifo_rd_data                                                           (0x60003004)


//---------------------------------------------------
// i2c0 in  domain address definition
//---------------------------------------------------

#define reg_i2c0_int_status                                        (*(volatile uint32_t *)0x60003008)
#define adr_i2c0_int_status                                                              (0x60003008)

#define reg_i2c0_int_mask                                          (*(volatile uint32_t *)0x6000300c)
#define adr_i2c0_int_mask                                                                (0x6000300c)

#define reg_i2c0_int_clr                                           (*(volatile uint32_t *)0x60003010)
#define adr_i2c0_int_clr                                                                 (0x60003010)

#define reg_i2c0_rfifo_thld                                        (*(volatile uint32_t *)0x60003014)
#define adr_i2c0_rfifo_thld                                                              (0x60003014)

#define reg_i2c0_tfifo_thld                                        (*(volatile uint32_t *)0x60003018)
#define adr_i2c0_tfifo_thld                                                              (0x60003018)

#define reg_i2c0_to_thld                                           (*(volatile uint32_t *)0x6000301c)
#define adr_i2c0_to_thld                                                                 (0x6000301c)

#define reg_i2c0_tfifo_idle_data                                   (*(volatile uint32_t *)0x60003020)
#define adr_i2c0_tfifo_idle_data                                                         (0x60003020)

#define reg_i2c0_i2cm_cfg                                          (*(volatile uint32_t *)0x60003024)
#define adr_i2c0_i2cm_cfg                                                                (0x60003024)
#define mask_i2c0_i2cm_cfg_i2cm_ctr                                  (0x1f0000)                      
#define mask_i2c0_i2cm_cfg_i2cm_prer                                 (0xffff)                        

#define reg_i2c0_i2cms_add                                         (*(volatile uint32_t *)0x60003028)
#define adr_i2c0_i2cms_add                                                               (0x60003028)

#define reg_i2c0_i2cs_cfg                                          (*(volatile uint32_t *)0x6000302c)
#define adr_i2c0_i2cs_cfg                                                                (0x6000302c)
#define mask_i2c0_i2cs_cfg_master                                    (0x8)                           
#define mask_i2c0_i2cs_cfg_slv_stretch_en                            (0x4)                           
#define mask_i2c0_i2cs_cfg_i2cs_10bitaddr                            (0x2)                           
#define mask_i2c0_i2cs_cfg_slv_en                                    (0x1)                           

#define reg_i2c0_slave_status                                      (*(volatile uint32_t *)0x60003030)
#define adr_i2c0_slave_status                                                            (0x60003030)
#define mask_i2c0_slave_status_i2cs_rd_op                            (0x400)                         
#define mask_i2c0_slave_status_i2cs_wr_op                            (0x200)                         
#define mask_i2c0_slave_status_i2cs_busy                             (0x100)                         
#define mask_i2c0_slave_status_i2cs_state                            (0xff)                          

#define reg_i2c0_rfifo_cnt                                         (*(volatile uint32_t *)0x60003034)
#define adr_i2c0_rfifo_cnt                                                               (0x60003034)

#define reg_i2c0_tfifo_cnt                                         (*(volatile uint32_t *)0x60003038)
#define adr_i2c0_tfifo_cnt                                                               (0x60003038)

#define reg_i2c0_status                                            (*(volatile uint32_t *)0x6000303c)
#define adr_i2c0_status                                                                  (0x6000303c)
#define mask_i2c0_status_i2cm_sr                                     (0xffff)                        

#define reg_i2c0_rfifo_clr                                         (*(volatile uint32_t *)0x60003040)
#define adr_i2c0_rfifo_clr                                                               (0x60003040)

#define reg_i2c0_tfifo_clr                                         (*(volatile uint32_t *)0x60003044)
#define adr_i2c0_tfifo_clr                                                               (0x60003044)

#define reg_i2c0_i2cm_trig_cmd                                     (*(volatile uint32_t *)0x60003048)
#define adr_i2c0_i2cm_trig_cmd                                                           (0x60003048)
#define mask_i2c0_i2cm_trig_cmd_clr                                  (0x20)                          
#define mask_i2c0_i2cm_trig_cmd_restart                              (0x10)                          
#define mask_i2c0_i2cm_trig_cmd_nack                                 (0x8)                           
#define mask_i2c0_i2cm_trig_cmd_ack                                  (0x4)                           
#define mask_i2c0_i2cm_trig_cmd_stop                                 (0x2)                           
#define mask_i2c0_i2cm_trig_cmd_start                                (0x1)                           

#define reg_i2c0_i2cs_trig_cmd                                     (*(volatile uint32_t *)0x6000304c)
#define adr_i2c0_i2cs_trig_cmd                                                           (0x6000304c)
#define mask_i2c0_i2cs_trig_cmd_slv_clr                              (0x8)                           
#define mask_i2c0_i2cs_trig_cmd_slv_idle                             (0x4)                           
#define mask_i2c0_i2cs_trig_cmd_slv_ack                              (0x2)                           
#define mask_i2c0_i2cs_trig_cmd_slv_nack                             (0x1)                           

#define reg_i2c0_rfifo_full_val                                    (*(volatile uint32_t *)0x60003050)
#define adr_i2c0_rfifo_full_val                                                          (0x60003050)

#define reg_i2c0_ext_cg_en                                         (*(volatile uint32_t *)0x60003054)
#define adr_i2c0_ext_cg_en                                                               (0x60003054)


//---------------------------------------------------
// i2c1 in  domain address definition
//---------------------------------------------------

#define reg_i2c1_tfifo_wr_data                                     (*(volatile uint32_t *)0x60003400)
#define adr_i2c1_tfifo_wr_data                                                           (0x60003400)

#define reg_i2c1_rfifo_rd_data                                     (*(volatile uint32_t *)0x60003404)
#define adr_i2c1_rfifo_rd_data                                                           (0x60003404)


//---------------------------------------------------
// i2c1 in  domain address definition
//---------------------------------------------------

#define reg_i2c1_int_status                                        (*(volatile uint32_t *)0x60003408)
#define adr_i2c1_int_status                                                              (0x60003408)

#define reg_i2c1_int_mask                                          (*(volatile uint32_t *)0x6000340c)
#define adr_i2c1_int_mask                                                                (0x6000340c)

#define reg_i2c1_int_clr                                           (*(volatile uint32_t *)0x60003410)
#define adr_i2c1_int_clr                                                                 (0x60003410)

#define reg_i2c1_rfifo_thld                                        (*(volatile uint32_t *)0x60003414)
#define adr_i2c1_rfifo_thld                                                              (0x60003414)

#define reg_i2c1_tfifo_thld                                        (*(volatile uint32_t *)0x60003418)
#define adr_i2c1_tfifo_thld                                                              (0x60003418)

#define reg_i2c1_to_thld                                           (*(volatile uint32_t *)0x6000341c)
#define adr_i2c1_to_thld                                                                 (0x6000341c)

#define reg_i2c1_tfifo_idle_data                                   (*(volatile uint32_t *)0x60003420)
#define adr_i2c1_tfifo_idle_data                                                         (0x60003420)

#define reg_i2c1_i2cm_cfg                                          (*(volatile uint32_t *)0x60003424)
#define adr_i2c1_i2cm_cfg                                                                (0x60003424)
#define mask_i2c1_i2cm_cfg_i2cm_ctr                                  (0x1f0000)                      
#define mask_i2c1_i2cm_cfg_i2cm_prer                                 (0xffff)                        

#define reg_i2c1_i2cms_add                                         (*(volatile uint32_t *)0x60003428)
#define adr_i2c1_i2cms_add                                                               (0x60003428)

#define reg_i2c1_i2cs_cfg                                          (*(volatile uint32_t *)0x6000342c)
#define adr_i2c1_i2cs_cfg                                                                (0x6000342c)
#define mask_i2c1_i2cs_cfg_master                                    (0x8)                           
#define mask_i2c1_i2cs_cfg_slv_stretch_en                            (0x4)                           
#define mask_i2c1_i2cs_cfg_i2cs_10bitaddr                            (0x2)                           
#define mask_i2c1_i2cs_cfg_slv_en                                    (0x1)                           

#define reg_i2c1_slave_status                                      (*(volatile uint32_t *)0x60003430)
#define adr_i2c1_slave_status                                                            (0x60003430)
#define mask_i2c1_slave_status_i2cs_rd_op                            (0x400)                         
#define mask_i2c1_slave_status_i2cs_wr_op                            (0x200)                         
#define mask_i2c1_slave_status_i2cs_busy                             (0x100)                         
#define mask_i2c1_slave_status_i2cs_state                            (0xff)                          

#define reg_i2c1_rfifo_cnt                                         (*(volatile uint32_t *)0x60003434)
#define adr_i2c1_rfifo_cnt                                                               (0x60003434)

#define reg_i2c1_tfifo_cnt                                         (*(volatile uint32_t *)0x60003438)
#define adr_i2c1_tfifo_cnt                                                               (0x60003438)

#define reg_i2c1_status                                            (*(volatile uint32_t *)0x6000343c)
#define adr_i2c1_status                                                                  (0x6000343c)
#define mask_i2c1_status_i2cm_sr                                     (0xffff)                        

#define reg_i2c1_rfifo_clr                                         (*(volatile uint32_t *)0x60003440)
#define adr_i2c1_rfifo_clr                                                               (0x60003440)

#define reg_i2c1_tfifo_clr                                         (*(volatile uint32_t *)0x60003444)
#define adr_i2c1_tfifo_clr                                                               (0x60003444)

#define reg_i2c1_i2cm_trig_cmd                                     (*(volatile uint32_t *)0x60003448)
#define adr_i2c1_i2cm_trig_cmd                                                           (0x60003448)
#define mask_i2c1_i2cm_trig_cmd_clr                                  (0x20)                          
#define mask_i2c1_i2cm_trig_cmd_restart                              (0x10)                          
#define mask_i2c1_i2cm_trig_cmd_nack                                 (0x8)                           
#define mask_i2c1_i2cm_trig_cmd_ack                                  (0x4)                           
#define mask_i2c1_i2cm_trig_cmd_stop                                 (0x2)                           
#define mask_i2c1_i2cm_trig_cmd_start                                (0x1)                           

#define reg_i2c1_i2cs_trig_cmd                                     (*(volatile uint32_t *)0x6000344c)
#define adr_i2c1_i2cs_trig_cmd                                                           (0x6000344c)
#define mask_i2c1_i2cs_trig_cmd_slv_clr                              (0x8)                           
#define mask_i2c1_i2cs_trig_cmd_slv_idle                             (0x4)                           
#define mask_i2c1_i2cs_trig_cmd_slv_ack                              (0x2)                           
#define mask_i2c1_i2cs_trig_cmd_slv_nack                             (0x1)                           

#define reg_i2c1_rfifo_full_val                                    (*(volatile uint32_t *)0x60003450)
#define adr_i2c1_rfifo_full_val                                                          (0x60003450)

#define reg_i2c1_ext_cg_en                                         (*(volatile uint32_t *)0x60003454)
#define adr_i2c1_ext_cg_en                                                               (0x60003454)


//---------------------------------------------------
// i2c2 in  domain address definition
//---------------------------------------------------

#define reg_i2c2_tfifo_wr_data                                     (*(volatile uint32_t *)0x60003800)
#define adr_i2c2_tfifo_wr_data                                                           (0x60003800)

#define reg_i2c2_rfifo_rd_data                                     (*(volatile uint32_t *)0x60003804)
#define adr_i2c2_rfifo_rd_data                                                           (0x60003804)


//---------------------------------------------------
// i2c2 in  domain address definition
//---------------------------------------------------

#define reg_i2c2_int_status                                        (*(volatile uint32_t *)0x60003808)
#define adr_i2c2_int_status                                                              (0x60003808)

#define reg_i2c2_int_mask                                          (*(volatile uint32_t *)0x6000380c)
#define adr_i2c2_int_mask                                                                (0x6000380c)

#define reg_i2c2_int_clr                                           (*(volatile uint32_t *)0x60003810)
#define adr_i2c2_int_clr                                                                 (0x60003810)

#define reg_i2c2_rfifo_thld                                        (*(volatile uint32_t *)0x60003814)
#define adr_i2c2_rfifo_thld                                                              (0x60003814)

#define reg_i2c2_tfifo_thld                                        (*(volatile uint32_t *)0x60003818)
#define adr_i2c2_tfifo_thld                                                              (0x60003818)

#define reg_i2c2_to_thld                                           (*(volatile uint32_t *)0x6000381c)
#define adr_i2c2_to_thld                                                                 (0x6000381c)

#define reg_i2c2_tfifo_idle_data                                   (*(volatile uint32_t *)0x60003820)
#define adr_i2c2_tfifo_idle_data                                                         (0x60003820)

#define reg_i2c2_i2cm_cfg                                          (*(volatile uint32_t *)0x60003824)
#define adr_i2c2_i2cm_cfg                                                                (0x60003824)
#define mask_i2c2_i2cm_cfg_i2cm_ctr                                  (0x1f0000)                      
#define mask_i2c2_i2cm_cfg_i2cm_prer                                 (0xffff)                        

#define reg_i2c2_i2cms_add                                         (*(volatile uint32_t *)0x60003828)
#define adr_i2c2_i2cms_add                                                               (0x60003828)

#define reg_i2c2_i2cs_cfg                                          (*(volatile uint32_t *)0x6000382c)
#define adr_i2c2_i2cs_cfg                                                                (0x6000382c)
#define mask_i2c2_i2cs_cfg_master                                    (0x8)                           
#define mask_i2c2_i2cs_cfg_slv_stretch_en                            (0x4)                           
#define mask_i2c2_i2cs_cfg_i2cs_10bitaddr                            (0x2)                           
#define mask_i2c2_i2cs_cfg_slv_en                                    (0x1)                           

#define reg_i2c2_slave_status                                      (*(volatile uint32_t *)0x60003830)
#define adr_i2c2_slave_status                                                            (0x60003830)
#define mask_i2c2_slave_status_i2cs_rd_op                            (0x400)                         
#define mask_i2c2_slave_status_i2cs_wr_op                            (0x200)                         
#define mask_i2c2_slave_status_i2cs_busy                             (0x100)                         
#define mask_i2c2_slave_status_i2cs_state                            (0xff)                          

#define reg_i2c2_rfifo_cnt                                         (*(volatile uint32_t *)0x60003834)
#define adr_i2c2_rfifo_cnt                                                               (0x60003834)

#define reg_i2c2_tfifo_cnt                                         (*(volatile uint32_t *)0x60003838)
#define adr_i2c2_tfifo_cnt                                                               (0x60003838)

#define reg_i2c2_status                                            (*(volatile uint32_t *)0x6000383c)
#define adr_i2c2_status                                                                  (0x6000383c)
#define mask_i2c2_status_i2cm_sr                                     (0xffff)                        

#define reg_i2c2_rfifo_clr                                         (*(volatile uint32_t *)0x60003840)
#define adr_i2c2_rfifo_clr                                                               (0x60003840)

#define reg_i2c2_tfifo_clr                                         (*(volatile uint32_t *)0x60003844)
#define adr_i2c2_tfifo_clr                                                               (0x60003844)

#define reg_i2c2_i2cm_trig_cmd                                     (*(volatile uint32_t *)0x60003848)
#define adr_i2c2_i2cm_trig_cmd                                                           (0x60003848)
#define mask_i2c2_i2cm_trig_cmd_clr                                  (0x20)                          
#define mask_i2c2_i2cm_trig_cmd_restart                              (0x10)                          
#define mask_i2c2_i2cm_trig_cmd_nack                                 (0x8)                           
#define mask_i2c2_i2cm_trig_cmd_ack                                  (0x4)                           
#define mask_i2c2_i2cm_trig_cmd_stop                                 (0x2)                           
#define mask_i2c2_i2cm_trig_cmd_start                                (0x1)                           

#define reg_i2c2_i2cs_trig_cmd                                     (*(volatile uint32_t *)0x6000384c)
#define adr_i2c2_i2cs_trig_cmd                                                           (0x6000384c)
#define mask_i2c2_i2cs_trig_cmd_slv_clr                              (0x8)                           
#define mask_i2c2_i2cs_trig_cmd_slv_idle                             (0x4)                           
#define mask_i2c2_i2cs_trig_cmd_slv_ack                              (0x2)                           
#define mask_i2c2_i2cs_trig_cmd_slv_nack                             (0x1)                           

#define reg_i2c2_rfifo_full_val                                    (*(volatile uint32_t *)0x60003850)
#define adr_i2c2_rfifo_full_val                                                          (0x60003850)

#define reg_i2c2_ext_cg_en                                         (*(volatile uint32_t *)0x60003854)
#define adr_i2c2_ext_cg_en                                                               (0x60003854)


//---------------------------------------------------
// i2c3 in  domain address definition
//---------------------------------------------------

#define reg_i2c3_tfifo_wr_data                                     (*(volatile uint32_t *)0x60003c00)
#define adr_i2c3_tfifo_wr_data                                                           (0x60003c00)

#define reg_i2c3_rfifo_rd_data                                     (*(volatile uint32_t *)0x60003c04)
#define adr_i2c3_rfifo_rd_data                                                           (0x60003c04)


//---------------------------------------------------
// i2c3 in  domain address definition
//---------------------------------------------------

#define reg_i2c3_int_status                                        (*(volatile uint32_t *)0x60003c08)
#define adr_i2c3_int_status                                                              (0x60003c08)

#define reg_i2c3_int_mask                                          (*(volatile uint32_t *)0x60003c0c)
#define adr_i2c3_int_mask                                                                (0x60003c0c)

#define reg_i2c3_int_clr                                           (*(volatile uint32_t *)0x60003c10)
#define adr_i2c3_int_clr                                                                 (0x60003c10)

#define reg_i2c3_rfifo_thld                                        (*(volatile uint32_t *)0x60003c14)
#define adr_i2c3_rfifo_thld                                                              (0x60003c14)

#define reg_i2c3_tfifo_thld                                        (*(volatile uint32_t *)0x60003c18)
#define adr_i2c3_tfifo_thld                                                              (0x60003c18)

#define reg_i2c3_to_thld                                           (*(volatile uint32_t *)0x60003c1c)
#define adr_i2c3_to_thld                                                                 (0x60003c1c)

#define reg_i2c3_tfifo_idle_data                                   (*(volatile uint32_t *)0x60003c20)
#define adr_i2c3_tfifo_idle_data                                                         (0x60003c20)

#define reg_i2c3_i2cm_cfg                                          (*(volatile uint32_t *)0x60003c24)
#define adr_i2c3_i2cm_cfg                                                                (0x60003c24)
#define mask_i2c3_i2cm_cfg_i2cm_ctr                                  (0x1f0000)                      
#define mask_i2c3_i2cm_cfg_i2cm_prer                                 (0xffff)                        

#define reg_i2c3_i2cms_add                                         (*(volatile uint32_t *)0x60003c28)
#define adr_i2c3_i2cms_add                                                               (0x60003c28)

#define reg_i2c3_i2cs_cfg                                          (*(volatile uint32_t *)0x60003c2c)
#define adr_i2c3_i2cs_cfg                                                                (0x60003c2c)
#define mask_i2c3_i2cs_cfg_master                                    (0x8)                           
#define mask_i2c3_i2cs_cfg_slv_stretch_en                            (0x4)                           
#define mask_i2c3_i2cs_cfg_i2cs_10bitaddr                            (0x2)                           
#define mask_i2c3_i2cs_cfg_slv_en                                    (0x1)                           

#define reg_i2c3_slave_status                                      (*(volatile uint32_t *)0x60003c30)
#define adr_i2c3_slave_status                                                            (0x60003c30)
#define mask_i2c3_slave_status_i2cs_rd_op                            (0x400)                         
#define mask_i2c3_slave_status_i2cs_wr_op                            (0x200)                         
#define mask_i2c3_slave_status_i2cs_busy                             (0x100)                         
#define mask_i2c3_slave_status_i2cs_state                            (0xff)                          

#define reg_i2c3_rfifo_cnt                                         (*(volatile uint32_t *)0x60003c34)
#define adr_i2c3_rfifo_cnt                                                               (0x60003c34)

#define reg_i2c3_tfifo_cnt                                         (*(volatile uint32_t *)0x60003c38)
#define adr_i2c3_tfifo_cnt                                                               (0x60003c38)

#define reg_i2c3_status                                            (*(volatile uint32_t *)0x60003c3c)
#define adr_i2c3_status                                                                  (0x60003c3c)
#define mask_i2c3_status_i2cm_sr                                     (0xffff)                        

#define reg_i2c3_rfifo_clr                                         (*(volatile uint32_t *)0x60003c40)
#define adr_i2c3_rfifo_clr                                                               (0x60003c40)

#define reg_i2c3_tfifo_clr                                         (*(volatile uint32_t *)0x60003c44)
#define adr_i2c3_tfifo_clr                                                               (0x60003c44)

#define reg_i2c3_i2cm_trig_cmd                                     (*(volatile uint32_t *)0x60003c48)
#define adr_i2c3_i2cm_trig_cmd                                                           (0x60003c48)
#define mask_i2c3_i2cm_trig_cmd_clr                                  (0x20)                          
#define mask_i2c3_i2cm_trig_cmd_restart                              (0x10)                          
#define mask_i2c3_i2cm_trig_cmd_nack                                 (0x8)                           
#define mask_i2c3_i2cm_trig_cmd_ack                                  (0x4)                           
#define mask_i2c3_i2cm_trig_cmd_stop                                 (0x2)                           
#define mask_i2c3_i2cm_trig_cmd_start                                (0x1)                           

#define reg_i2c3_i2cs_trig_cmd                                     (*(volatile uint32_t *)0x60003c4c)
#define adr_i2c3_i2cs_trig_cmd                                                           (0x60003c4c)
#define mask_i2c3_i2cs_trig_cmd_slv_clr                              (0x8)                           
#define mask_i2c3_i2cs_trig_cmd_slv_idle                             (0x4)                           
#define mask_i2c3_i2cs_trig_cmd_slv_ack                              (0x2)                           
#define mask_i2c3_i2cs_trig_cmd_slv_nack                             (0x1)                           

#define reg_i2c3_rfifo_full_val                                    (*(volatile uint32_t *)0x60003c50)
#define adr_i2c3_rfifo_full_val                                                          (0x60003c50)

#define reg_i2c3_ext_cg_en                                         (*(volatile uint32_t *)0x60003c54)
#define adr_i2c3_ext_cg_en                                                               (0x60003c54)


//---------------------------------------------------
// gpio_ret_pd in  domain address definition
//---------------------------------------------------

#define reg_gpio_ret_pd_p00_config                                 (*(volatile uint32_t *)0x60004000)
#define adr_gpio_ret_pd_p00_config                                                       (0x60004000)
#define mask_gpio_ret_pd_p00_config_p00_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p00_config_p00_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p00_config_p00_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p00_config_p00_pu                           (0x800)                         
#define mask_gpio_ret_pd_p00_config_p00_pd                           (0x400)                         
#define mask_gpio_ret_pd_p00_config_p00_ie                           (0x200)                         
#define mask_gpio_ret_pd_p00_config_p00_oe                           (0x100)                         
#define mask_gpio_ret_pd_p00_config_p00_pid                          (0xff)                          

#define reg_gpio_ret_pd_p01_config                                 (*(volatile uint32_t *)0x60004004)
#define adr_gpio_ret_pd_p01_config                                                       (0x60004004)
#define mask_gpio_ret_pd_p01_config_p01_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p01_config_p01_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p01_config_p01_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p01_config_p01_pu                           (0x800)                         
#define mask_gpio_ret_pd_p01_config_p01_pd                           (0x400)                         
#define mask_gpio_ret_pd_p01_config_p01_ie                           (0x200)                         
#define mask_gpio_ret_pd_p01_config_p01_oe                           (0x100)                         
#define mask_gpio_ret_pd_p01_config_p01_pid                          (0xff)                          

#define reg_gpio_ret_pd_p02_config                                 (*(volatile uint32_t *)0x60004008)
#define adr_gpio_ret_pd_p02_config                                                       (0x60004008)
#define mask_gpio_ret_pd_p02_config_p02_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p02_config_p02_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p02_config_p02_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p02_config_p02_pu                           (0x800)                         
#define mask_gpio_ret_pd_p02_config_p02_pd                           (0x400)                         
#define mask_gpio_ret_pd_p02_config_p02_ie                           (0x200)                         
#define mask_gpio_ret_pd_p02_config_p02_oe                           (0x100)                         
#define mask_gpio_ret_pd_p02_config_p02_pid                          (0xff)                          

#define reg_gpio_ret_pd_p03_config                                 (*(volatile uint32_t *)0x6000400c)
#define adr_gpio_ret_pd_p03_config                                                       (0x6000400c)
#define mask_gpio_ret_pd_p03_config_p03_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p03_config_p03_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p03_config_p03_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p03_config_p03_pu                           (0x800)                         
#define mask_gpio_ret_pd_p03_config_p03_pd                           (0x400)                         
#define mask_gpio_ret_pd_p03_config_p03_ie                           (0x200)                         
#define mask_gpio_ret_pd_p03_config_p03_oe                           (0x100)                         
#define mask_gpio_ret_pd_p03_config_p03_pid                          (0xff)                          

#define reg_gpio_ret_pd_p04_config                                 (*(volatile uint32_t *)0x60004010)
#define adr_gpio_ret_pd_p04_config                                                       (0x60004010)
#define mask_gpio_ret_pd_p04_config_p04_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p04_config_p04_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p04_config_p04_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p04_config_p04_pu                           (0x800)                         
#define mask_gpio_ret_pd_p04_config_p04_pd                           (0x400)                         
#define mask_gpio_ret_pd_p04_config_p04_ie                           (0x200)                         
#define mask_gpio_ret_pd_p04_config_p04_oe                           (0x100)                         
#define mask_gpio_ret_pd_p04_config_p04_pid                          (0xff)                          

#define reg_gpio_ret_pd_p05_config                                 (*(volatile uint32_t *)0x60004014)
#define adr_gpio_ret_pd_p05_config                                                       (0x60004014)
#define mask_gpio_ret_pd_p05_config_p05_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p05_config_p05_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p05_config_p05_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p05_config_p05_pu                           (0x800)                         
#define mask_gpio_ret_pd_p05_config_p05_pd                           (0x400)                         
#define mask_gpio_ret_pd_p05_config_p05_ie                           (0x200)                         
#define mask_gpio_ret_pd_p05_config_p05_oe                           (0x100)                         
#define mask_gpio_ret_pd_p05_config_p05_pid                          (0xff)                          

#define reg_gpio_ret_pd_p06_config                                 (*(volatile uint32_t *)0x60004018)
#define adr_gpio_ret_pd_p06_config                                                       (0x60004018)
#define mask_gpio_ret_pd_p06_config_p06_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p06_config_p06_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p06_config_p06_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p06_config_p06_pu                           (0x800)                         
#define mask_gpio_ret_pd_p06_config_p06_pd                           (0x400)                         
#define mask_gpio_ret_pd_p06_config_p06_ie                           (0x200)                         
#define mask_gpio_ret_pd_p06_config_p06_oe                           (0x100)                         
#define mask_gpio_ret_pd_p06_config_p06_pid                          (0xff)                          

#define reg_gpio_ret_pd_p07_config                                 (*(volatile uint32_t *)0x6000401c)
#define adr_gpio_ret_pd_p07_config                                                       (0x6000401c)
#define mask_gpio_ret_pd_p07_config_p07_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p07_config_p07_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p07_config_p07_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p07_config_p07_pu                           (0x800)                         
#define mask_gpio_ret_pd_p07_config_p07_pd                           (0x400)                         
#define mask_gpio_ret_pd_p07_config_p07_ie                           (0x200)                         
#define mask_gpio_ret_pd_p07_config_p07_oe                           (0x100)                         
#define mask_gpio_ret_pd_p07_config_p07_pid                          (0xff)                          

#define reg_gpio_ret_pd_p08_config                                 (*(volatile uint32_t *)0x60004020)
#define adr_gpio_ret_pd_p08_config                                                       (0x60004020)
#define mask_gpio_ret_pd_p08_config_p08_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p08_config_p08_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p08_config_p08_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p08_config_p08_pu                           (0x800)                         
#define mask_gpio_ret_pd_p08_config_p08_pd                           (0x400)                         
#define mask_gpio_ret_pd_p08_config_p08_ie                           (0x200)                         
#define mask_gpio_ret_pd_p08_config_p08_oe                           (0x100)                         
#define mask_gpio_ret_pd_p08_config_p08_pid                          (0xff)                          

#define reg_gpio_ret_pd_p09_config                                 (*(volatile uint32_t *)0x60004024)
#define adr_gpio_ret_pd_p09_config                                                       (0x60004024)
#define mask_gpio_ret_pd_p09_config_p09_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p09_config_p09_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p09_config_p09_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p09_config_p09_pu                           (0x800)                         
#define mask_gpio_ret_pd_p09_config_p09_pd                           (0x400)                         
#define mask_gpio_ret_pd_p09_config_p09_ie                           (0x200)                         
#define mask_gpio_ret_pd_p09_config_p09_oe                           (0x100)                         
#define mask_gpio_ret_pd_p09_config_p09_pid                          (0xff)                          

#define reg_gpio_ret_pd_p10_config                                 (*(volatile uint32_t *)0x60004028)
#define adr_gpio_ret_pd_p10_config                                                       (0x60004028)
#define mask_gpio_ret_pd_p10_config_p10_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p10_config_p10_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p10_config_p10_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p10_config_p10_pu                           (0x800)                         
#define mask_gpio_ret_pd_p10_config_p10_pd                           (0x400)                         
#define mask_gpio_ret_pd_p10_config_p10_ie                           (0x200)                         
#define mask_gpio_ret_pd_p10_config_p10_oe                           (0x100)                         
#define mask_gpio_ret_pd_p10_config_p10_pid                          (0xff)                          

#define reg_gpio_ret_pd_p11_config                                 (*(volatile uint32_t *)0x6000402c)
#define adr_gpio_ret_pd_p11_config                                                       (0x6000402c)
#define mask_gpio_ret_pd_p11_config_p11_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p11_config_p11_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p11_config_p11_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p11_config_p11_pu                           (0x800)                         
#define mask_gpio_ret_pd_p11_config_p11_pd                           (0x400)                         
#define mask_gpio_ret_pd_p11_config_p11_ie                           (0x200)                         
#define mask_gpio_ret_pd_p11_config_p11_oe                           (0x100)                         
#define mask_gpio_ret_pd_p11_config_p11_pid                          (0xff)                          

#define reg_gpio_ret_pd_p12_config                                 (*(volatile uint32_t *)0x60004030)
#define adr_gpio_ret_pd_p12_config                                                       (0x60004030)
#define mask_gpio_ret_pd_p12_config_p12_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p12_config_p12_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p12_config_p12_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p12_config_p12_pu                           (0x800)                         
#define mask_gpio_ret_pd_p12_config_p12_pd                           (0x400)                         
#define mask_gpio_ret_pd_p12_config_p12_ie                           (0x200)                         
#define mask_gpio_ret_pd_p12_config_p12_oe                           (0x100)                         
#define mask_gpio_ret_pd_p12_config_p12_pid                          (0xff)                          

#define reg_gpio_ret_pd_p13_config                                 (*(volatile uint32_t *)0x60004034)
#define adr_gpio_ret_pd_p13_config                                                       (0x60004034)
#define mask_gpio_ret_pd_p13_config_p13_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p13_config_p13_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p13_config_p13_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p13_config_p13_pu                           (0x800)                         
#define mask_gpio_ret_pd_p13_config_p13_pd                           (0x400)                         
#define mask_gpio_ret_pd_p13_config_p13_ie                           (0x200)                         
#define mask_gpio_ret_pd_p13_config_p13_oe                           (0x100)                         
#define mask_gpio_ret_pd_p13_config_p13_pid                          (0xff)                          

#define reg_gpio_ret_pd_p14_config                                 (*(volatile uint32_t *)0x60004038)
#define adr_gpio_ret_pd_p14_config                                                       (0x60004038)
#define mask_gpio_ret_pd_p14_config_p14_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p14_config_p14_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p14_config_p14_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p14_config_p14_pu                           (0x800)                         
#define mask_gpio_ret_pd_p14_config_p14_pd                           (0x400)                         
#define mask_gpio_ret_pd_p14_config_p14_ie                           (0x200)                         
#define mask_gpio_ret_pd_p14_config_p14_oe                           (0x100)                         
#define mask_gpio_ret_pd_p14_config_p14_pid                          (0xff)                          

#define reg_gpio_ret_pd_p15_config                                 (*(volatile uint32_t *)0x6000403c)
#define adr_gpio_ret_pd_p15_config                                                       (0x6000403c)
#define mask_gpio_ret_pd_p15_config_p15_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p15_config_p15_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p15_config_p15_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p15_config_p15_pu                           (0x800)                         
#define mask_gpio_ret_pd_p15_config_p15_pd                           (0x400)                         
#define mask_gpio_ret_pd_p15_config_p15_ie                           (0x200)                         
#define mask_gpio_ret_pd_p15_config_p15_oe                           (0x100)                         
#define mask_gpio_ret_pd_p15_config_p15_pid                          (0xff)                          

#define reg_gpio_ret_pd_p16_config                                 (*(volatile uint32_t *)0x60004040)
#define adr_gpio_ret_pd_p16_config                                                       (0x60004040)
#define mask_gpio_ret_pd_p16_config_p16_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p16_config_p16_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p16_config_p16_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p16_config_p16_pu                           (0x800)                         
#define mask_gpio_ret_pd_p16_config_p16_pd                           (0x400)                         
#define mask_gpio_ret_pd_p16_config_p16_ie                           (0x200)                         
#define mask_gpio_ret_pd_p16_config_p16_oe                           (0x100)                         
#define mask_gpio_ret_pd_p16_config_p16_pid                          (0xff)                          

#define reg_gpio_ret_pd_p17_config                                 (*(volatile uint32_t *)0x60004044)
#define adr_gpio_ret_pd_p17_config                                                       (0x60004044)
#define mask_gpio_ret_pd_p17_config_p17_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p17_config_p17_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p17_config_p17_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p17_config_p17_pu                           (0x800)                         
#define mask_gpio_ret_pd_p17_config_p17_pd                           (0x400)                         
#define mask_gpio_ret_pd_p17_config_p17_ie                           (0x200)                         
#define mask_gpio_ret_pd_p17_config_p17_oe                           (0x100)                         
#define mask_gpio_ret_pd_p17_config_p17_pid                          (0xff)                          

#define reg_gpio_ret_pd_p18_config                                 (*(volatile uint32_t *)0x60004048)
#define adr_gpio_ret_pd_p18_config                                                       (0x60004048)
#define mask_gpio_ret_pd_p18_config_p18_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p18_config_p18_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p18_config_p18_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p18_config_p18_pu                           (0x800)                         
#define mask_gpio_ret_pd_p18_config_p18_pd                           (0x400)                         
#define mask_gpio_ret_pd_p18_config_p18_ie                           (0x200)                         
#define mask_gpio_ret_pd_p18_config_p18_oe                           (0x100)                         
#define mask_gpio_ret_pd_p18_config_p18_pid                          (0xff)                          

#define reg_gpio_ret_pd_p19_config                                 (*(volatile uint32_t *)0x6000404c)
#define adr_gpio_ret_pd_p19_config                                                       (0x6000404c)
#define mask_gpio_ret_pd_p19_config_p19_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p19_config_p19_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p19_config_p19_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p19_config_p19_pu                           (0x800)                         
#define mask_gpio_ret_pd_p19_config_p19_pd                           (0x400)                         
#define mask_gpio_ret_pd_p19_config_p19_ie                           (0x200)                         
#define mask_gpio_ret_pd_p19_config_p19_oe                           (0x100)                         
#define mask_gpio_ret_pd_p19_config_p19_pid                          (0xff)                          

#define reg_gpio_ret_pd_p20_config                                 (*(volatile uint32_t *)0x60004050)
#define adr_gpio_ret_pd_p20_config                                                       (0x60004050)
#define mask_gpio_ret_pd_p20_config_p20_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p20_config_p20_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p20_config_p20_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p20_config_p20_pu                           (0x800)                         
#define mask_gpio_ret_pd_p20_config_p20_pd                           (0x400)                         
#define mask_gpio_ret_pd_p20_config_p20_ie                           (0x200)                         
#define mask_gpio_ret_pd_p20_config_p20_oe                           (0x100)                         
#define mask_gpio_ret_pd_p20_config_p20_pid                          (0xff)                          

#define reg_gpio_ret_pd_p21_config                                 (*(volatile uint32_t *)0x60004054)
#define adr_gpio_ret_pd_p21_config                                                       (0x60004054)
#define mask_gpio_ret_pd_p21_config_p21_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p21_config_p21_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p21_config_p21_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p21_config_p21_pu                           (0x800)                         
#define mask_gpio_ret_pd_p21_config_p21_pd                           (0x400)                         
#define mask_gpio_ret_pd_p21_config_p21_ie                           (0x200)                         
#define mask_gpio_ret_pd_p21_config_p21_oe                           (0x100)                         
#define mask_gpio_ret_pd_p21_config_p21_pid                          (0xff)                          

#define reg_gpio_ret_pd_p22_config                                 (*(volatile uint32_t *)0x60004058)
#define adr_gpio_ret_pd_p22_config                                                       (0x60004058)
#define mask_gpio_ret_pd_p22_config_p22_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p22_config_p22_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p22_config_p22_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p22_config_p22_pu                           (0x800)                         
#define mask_gpio_ret_pd_p22_config_p22_pd                           (0x400)                         
#define mask_gpio_ret_pd_p22_config_p22_ie                           (0x200)                         
#define mask_gpio_ret_pd_p22_config_p22_oe                           (0x100)                         
#define mask_gpio_ret_pd_p22_config_p22_pid                          (0xff)                          

#define reg_gpio_ret_pd_p23_config                                 (*(volatile uint32_t *)0x6000405c)
#define adr_gpio_ret_pd_p23_config                                                       (0x6000405c)
#define mask_gpio_ret_pd_p23_config_p23_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p23_config_p23_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p23_config_p23_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p23_config_p23_pu                           (0x800)                         
#define mask_gpio_ret_pd_p23_config_p23_pd                           (0x400)                         
#define mask_gpio_ret_pd_p23_config_p23_ie                           (0x200)                         
#define mask_gpio_ret_pd_p23_config_p23_oe                           (0x100)                         
#define mask_gpio_ret_pd_p23_config_p23_pid                          (0xff)                          

#define reg_gpio_ret_pd_p24_config                                 (*(volatile uint32_t *)0x60004060)
#define adr_gpio_ret_pd_p24_config                                                       (0x60004060)
#define mask_gpio_ret_pd_p24_config_p24_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p24_config_p24_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p24_config_p24_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p24_config_p24_pu                           (0x800)                         
#define mask_gpio_ret_pd_p24_config_p24_pd                           (0x400)                         
#define mask_gpio_ret_pd_p24_config_p24_ie                           (0x200)                         
#define mask_gpio_ret_pd_p24_config_p24_oe                           (0x100)                         
#define mask_gpio_ret_pd_p24_config_p24_pid                          (0xff)                          

#define reg_gpio_ret_pd_p25_config                                 (*(volatile uint32_t *)0x60004064)
#define adr_gpio_ret_pd_p25_config                                                       (0x60004064)
#define mask_gpio_ret_pd_p25_config_p25_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p25_config_p25_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p25_config_p25_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p25_config_p25_pu                           (0x800)                         
#define mask_gpio_ret_pd_p25_config_p25_pd                           (0x400)                         
#define mask_gpio_ret_pd_p25_config_p25_ie                           (0x200)                         
#define mask_gpio_ret_pd_p25_config_p25_oe                           (0x100)                         
#define mask_gpio_ret_pd_p25_config_p25_pid                          (0xff)                          

#define reg_gpio_ret_pd_p26_config                                 (*(volatile uint32_t *)0x60004068)
#define adr_gpio_ret_pd_p26_config                                                       (0x60004068)
#define mask_gpio_ret_pd_p26_config_p26_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p26_config_p26_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p26_config_p26_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p26_config_p26_pu                           (0x800)                         
#define mask_gpio_ret_pd_p26_config_p26_pd                           (0x400)                         
#define mask_gpio_ret_pd_p26_config_p26_ie                           (0x200)                         
#define mask_gpio_ret_pd_p26_config_p26_oe                           (0x100)                         
#define mask_gpio_ret_pd_p26_config_p26_pid                          (0xff)                          

#define reg_gpio_ret_pd_p27_config                                 (*(volatile uint32_t *)0x6000406c)
#define adr_gpio_ret_pd_p27_config                                                       (0x6000406c)
#define mask_gpio_ret_pd_p27_config_p27_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p27_config_p27_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p27_config_p27_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p27_config_p27_pu                           (0x800)                         
#define mask_gpio_ret_pd_p27_config_p27_pd                           (0x400)                         
#define mask_gpio_ret_pd_p27_config_p27_ie                           (0x200)                         
#define mask_gpio_ret_pd_p27_config_p27_oe                           (0x100)                         
#define mask_gpio_ret_pd_p27_config_p27_pid                          (0xff)                          

#define reg_gpio_ret_pd_p28_config                                 (*(volatile uint32_t *)0x60004070)
#define adr_gpio_ret_pd_p28_config                                                       (0x60004070)
#define mask_gpio_ret_pd_p28_config_p28_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p28_config_p28_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p28_config_p28_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p28_config_p28_pu                           (0x800)                         
#define mask_gpio_ret_pd_p28_config_p28_pd                           (0x400)                         
#define mask_gpio_ret_pd_p28_config_p28_ie                           (0x200)                         
#define mask_gpio_ret_pd_p28_config_p28_oe                           (0x100)                         
#define mask_gpio_ret_pd_p28_config_p28_pid                          (0xff)                          

#define reg_gpio_ret_pd_p29_config                                 (*(volatile uint32_t *)0x60004074)
#define adr_gpio_ret_pd_p29_config                                                       (0x60004074)
#define mask_gpio_ret_pd_p29_config_p29_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p29_config_p29_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p29_config_p29_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p29_config_p29_pu                           (0x800)                         
#define mask_gpio_ret_pd_p29_config_p29_pd                           (0x400)                         
#define mask_gpio_ret_pd_p29_config_p29_ie                           (0x200)                         
#define mask_gpio_ret_pd_p29_config_p29_oe                           (0x100)                         
#define mask_gpio_ret_pd_p29_config_p29_pid                          (0xff)                          

#define reg_gpio_ret_pd_p30_config                                 (*(volatile uint32_t *)0x60004078)
#define adr_gpio_ret_pd_p30_config                                                       (0x60004078)
#define mask_gpio_ret_pd_p30_config_p30_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p30_config_p30_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p30_config_p30_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p30_config_p30_pu                           (0x800)                         
#define mask_gpio_ret_pd_p30_config_p30_pd                           (0x400)                         
#define mask_gpio_ret_pd_p30_config_p30_ie                           (0x200)                         
#define mask_gpio_ret_pd_p30_config_p30_oe                           (0x100)                         
#define mask_gpio_ret_pd_p30_config_p30_pid                          (0xff)                          

#define reg_gpio_ret_pd_p31_config                                 (*(volatile uint32_t *)0x6000407c)
#define adr_gpio_ret_pd_p31_config                                                       (0x6000407c)
#define mask_gpio_ret_pd_p31_config_p31_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p31_config_p31_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p31_config_p31_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p31_config_p31_pu                           (0x800)                         
#define mask_gpio_ret_pd_p31_config_p31_pd                           (0x400)                         
#define mask_gpio_ret_pd_p31_config_p31_ie                           (0x200)                         
#define mask_gpio_ret_pd_p31_config_p31_oe                           (0x100)                         
#define mask_gpio_ret_pd_p31_config_p31_pid                          (0xff)                          

#define reg_gpio_ret_pd_p32_config                                 (*(volatile uint32_t *)0x60004080)
#define adr_gpio_ret_pd_p32_config                                                       (0x60004080)
#define mask_gpio_ret_pd_p32_config_p32_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p32_config_p32_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p32_config_p32_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p32_config_p32_pu                           (0x800)                         
#define mask_gpio_ret_pd_p32_config_p32_pd                           (0x400)                         
#define mask_gpio_ret_pd_p32_config_p32_ie                           (0x200)                         
#define mask_gpio_ret_pd_p32_config_p32_oe                           (0x100)                         
#define mask_gpio_ret_pd_p32_config_p32_pid                          (0xff)                          

#define reg_gpio_ret_pd_p33_config                                 (*(volatile uint32_t *)0x60004084)
#define adr_gpio_ret_pd_p33_config                                                       (0x60004084)
#define mask_gpio_ret_pd_p33_config_p33_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p33_config_p33_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p33_config_p33_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p33_config_p33_pu                           (0x800)                         
#define mask_gpio_ret_pd_p33_config_p33_pd                           (0x400)                         
#define mask_gpio_ret_pd_p33_config_p33_ie                           (0x200)                         
#define mask_gpio_ret_pd_p33_config_p33_oe                           (0x100)                         
#define mask_gpio_ret_pd_p33_config_p33_pid                          (0xff)                          

#define reg_gpio_ret_pd_p34_config                                 (*(volatile uint32_t *)0x60004088)
#define adr_gpio_ret_pd_p34_config                                                       (0x60004088)
#define mask_gpio_ret_pd_p34_config_p34_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p34_config_p34_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p34_config_p34_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p34_config_p34_pu                           (0x800)                         
#define mask_gpio_ret_pd_p34_config_p34_pd                           (0x400)                         
#define mask_gpio_ret_pd_p34_config_p34_ie                           (0x200)                         
#define mask_gpio_ret_pd_p34_config_p34_oe                           (0x100)                         
#define mask_gpio_ret_pd_p34_config_p34_pid                          (0xff)                          

#define reg_gpio_ret_pd_p35_config                                 (*(volatile uint32_t *)0x6000408c)
#define adr_gpio_ret_pd_p35_config                                                       (0x6000408c)
#define mask_gpio_ret_pd_p35_config_p35_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p35_config_p35_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p35_config_p35_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p35_config_p35_pu                           (0x800)                         
#define mask_gpio_ret_pd_p35_config_p35_pd                           (0x400)                         
#define mask_gpio_ret_pd_p35_config_p35_ie                           (0x200)                         
#define mask_gpio_ret_pd_p35_config_p35_oe                           (0x100)                         
#define mask_gpio_ret_pd_p35_config_p35_pid                          (0xff)                          

#define reg_gpio_ret_pd_p36_config                                 (*(volatile uint32_t *)0x60004090)
#define adr_gpio_ret_pd_p36_config                                                       (0x60004090)
#define mask_gpio_ret_pd_p36_config_p36_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p36_config_p36_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p36_config_p36_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p36_config_p36_pu                           (0x800)                         
#define mask_gpio_ret_pd_p36_config_p36_pd                           (0x400)                         
#define mask_gpio_ret_pd_p36_config_p36_ie                           (0x200)                         
#define mask_gpio_ret_pd_p36_config_p36_oe                           (0x100)                         
#define mask_gpio_ret_pd_p36_config_p36_pid                          (0xff)                          

#define reg_gpio_ret_pd_p37_config                                 (*(volatile uint32_t *)0x60004094)
#define adr_gpio_ret_pd_p37_config                                                       (0x60004094)
#define mask_gpio_ret_pd_p37_config_p37_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p37_config_p37_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p37_config_p37_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p37_config_p37_pu                           (0x800)                         
#define mask_gpio_ret_pd_p37_config_p37_pd                           (0x400)                         
#define mask_gpio_ret_pd_p37_config_p37_ie                           (0x200)                         
#define mask_gpio_ret_pd_p37_config_p37_oe                           (0x100)                         
#define mask_gpio_ret_pd_p37_config_p37_pid                          (0xff)                          

#define reg_gpio_ret_pd_p38_config                                 (*(volatile uint32_t *)0x60004098)
#define adr_gpio_ret_pd_p38_config                                                       (0x60004098)
#define mask_gpio_ret_pd_p38_config_p38_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p38_config_p38_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p38_config_p38_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p38_config_p38_pu                           (0x800)                         
#define mask_gpio_ret_pd_p38_config_p38_pd                           (0x400)                         
#define mask_gpio_ret_pd_p38_config_p38_ie                           (0x200)                         
#define mask_gpio_ret_pd_p38_config_p38_oe                           (0x100)                         
#define mask_gpio_ret_pd_p38_config_p38_pid                          (0xff)                          

#define reg_gpio_ret_pd_p39_config                                 (*(volatile uint32_t *)0x6000409c)
#define adr_gpio_ret_pd_p39_config                                                       (0x6000409c)
#define mask_gpio_ret_pd_p39_config_p39_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p39_config_p39_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p39_config_p39_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p39_config_p39_pu                           (0x800)                         
#define mask_gpio_ret_pd_p39_config_p39_pd                           (0x400)                         
#define mask_gpio_ret_pd_p39_config_p39_ie                           (0x200)                         
#define mask_gpio_ret_pd_p39_config_p39_oe                           (0x100)                         
#define mask_gpio_ret_pd_p39_config_p39_pid                          (0xff)                          

#define reg_gpio_ret_pd_p40_config                                 (*(volatile uint32_t *)0x600040a0)
#define adr_gpio_ret_pd_p40_config                                                       (0x600040a0)
#define mask_gpio_ret_pd_p40_config_p40_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p40_config_p40_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p40_config_p40_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p40_config_p40_pu                           (0x800)                         
#define mask_gpio_ret_pd_p40_config_p40_pd                           (0x400)                         
#define mask_gpio_ret_pd_p40_config_p40_ie                           (0x200)                         
#define mask_gpio_ret_pd_p40_config_p40_oe                           (0x100)                         
#define mask_gpio_ret_pd_p40_config_p40_pid                          (0xff)                          

#define reg_gpio_ret_pd_p41_config                                 (*(volatile uint32_t *)0x600040a4)
#define adr_gpio_ret_pd_p41_config                                                       (0x600040a4)
#define mask_gpio_ret_pd_p41_config_p41_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p41_config_p41_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p41_config_p41_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p41_config_p41_pu                           (0x800)                         
#define mask_gpio_ret_pd_p41_config_p41_pd                           (0x400)                         
#define mask_gpio_ret_pd_p41_config_p41_ie                           (0x200)                         
#define mask_gpio_ret_pd_p41_config_p41_oe                           (0x100)                         
#define mask_gpio_ret_pd_p41_config_p41_pid                          (0xff)                          

#define reg_gpio_ret_pd_p42_config                                 (*(volatile uint32_t *)0x600040a8)
#define adr_gpio_ret_pd_p42_config                                                       (0x600040a8)
#define mask_gpio_ret_pd_p42_config_p42_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p42_config_p42_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p42_config_p42_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p42_config_p42_pu                           (0x800)                         
#define mask_gpio_ret_pd_p42_config_p42_pd                           (0x400)                         
#define mask_gpio_ret_pd_p42_config_p42_ie                           (0x200)                         
#define mask_gpio_ret_pd_p42_config_p42_oe                           (0x100)                         
#define mask_gpio_ret_pd_p42_config_p42_pid                          (0xff)                          

#define reg_gpio_ret_pd_p43_config                                 (*(volatile uint32_t *)0x600040ac)
#define adr_gpio_ret_pd_p43_config                                                       (0x600040ac)
#define mask_gpio_ret_pd_p43_config_p43_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p43_config_p43_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p43_config_p43_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p43_config_p43_pu                           (0x800)                         
#define mask_gpio_ret_pd_p43_config_p43_pd                           (0x400)                         
#define mask_gpio_ret_pd_p43_config_p43_ie                           (0x200)                         
#define mask_gpio_ret_pd_p43_config_p43_oe                           (0x100)                         
#define mask_gpio_ret_pd_p43_config_p43_pid                          (0xff)                          

#define reg_gpio_ret_pd_p44_config                                 (*(volatile uint32_t *)0x600040b0)
#define adr_gpio_ret_pd_p44_config                                                       (0x600040b0)
#define mask_gpio_ret_pd_p44_config_p44_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p44_config_p44_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p44_config_p44_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p44_config_p44_pu                           (0x800)                         
#define mask_gpio_ret_pd_p44_config_p44_pd                           (0x400)                         
#define mask_gpio_ret_pd_p44_config_p44_ie                           (0x200)                         
#define mask_gpio_ret_pd_p44_config_p44_oe                           (0x100)                         
#define mask_gpio_ret_pd_p44_config_p44_pid                          (0xff)                          

#define reg_gpio_ret_pd_p45_config                                 (*(volatile uint32_t *)0x600040b4)
#define adr_gpio_ret_pd_p45_config                                                       (0x600040b4)
#define mask_gpio_ret_pd_p45_config_p45_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p45_config_p45_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p45_config_p45_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p45_config_p45_pu                           (0x800)                         
#define mask_gpio_ret_pd_p45_config_p45_pd                           (0x400)                         
#define mask_gpio_ret_pd_p45_config_p45_ie                           (0x200)                         
#define mask_gpio_ret_pd_p45_config_p45_oe                           (0x100)                         
#define mask_gpio_ret_pd_p45_config_p45_pid                          (0xff)                          

#define reg_gpio_ret_pd_p46_config                                 (*(volatile uint32_t *)0x600040b8)
#define adr_gpio_ret_pd_p46_config                                                       (0x600040b8)
#define mask_gpio_ret_pd_p46_config_p46_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p46_config_p46_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p46_config_p46_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p46_config_p46_pu                           (0x800)                         
#define mask_gpio_ret_pd_p46_config_p46_pd                           (0x400)                         
#define mask_gpio_ret_pd_p46_config_p46_ie                           (0x200)                         
#define mask_gpio_ret_pd_p46_config_p46_oe                           (0x100)                         
#define mask_gpio_ret_pd_p46_config_p46_pid                          (0xff)                          

#define reg_gpio_ret_pd_p47_config                                 (*(volatile uint32_t *)0x600040bc)
#define adr_gpio_ret_pd_p47_config                                                       (0x600040bc)
#define mask_gpio_ret_pd_p47_config_p47_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p47_config_p47_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p47_config_p47_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p47_config_p47_pu                           (0x800)                         
#define mask_gpio_ret_pd_p47_config_p47_pd                           (0x400)                         
#define mask_gpio_ret_pd_p47_config_p47_ie                           (0x200)                         
#define mask_gpio_ret_pd_p47_config_p47_oe                           (0x100)                         
#define mask_gpio_ret_pd_p47_config_p47_pid                          (0xff)                          

#define reg_gpio_ret_pd_p48_config                                 (*(volatile uint32_t *)0x600040c0)
#define adr_gpio_ret_pd_p48_config                                                       (0x600040c0)
#define mask_gpio_ret_pd_p48_config_p48_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p48_config_p48_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p48_config_p48_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p48_config_p48_pu                           (0x800)                         
#define mask_gpio_ret_pd_p48_config_p48_pd                           (0x400)                         
#define mask_gpio_ret_pd_p48_config_p48_ie                           (0x200)                         
#define mask_gpio_ret_pd_p48_config_p48_oe                           (0x100)                         
#define mask_gpio_ret_pd_p48_config_p48_pid                          (0xff)                          

#define reg_gpio_ret_pd_p49_config                                 (*(volatile uint32_t *)0x600040c4)
#define adr_gpio_ret_pd_p49_config                                                       (0x600040c4)
#define mask_gpio_ret_pd_p49_config_p49_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p49_config_p49_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p49_config_p49_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p49_config_p49_pu                           (0x800)                         
#define mask_gpio_ret_pd_p49_config_p49_pd                           (0x400)                         
#define mask_gpio_ret_pd_p49_config_p49_ie                           (0x200)                         
#define mask_gpio_ret_pd_p49_config_p49_oe                           (0x100)                         
#define mask_gpio_ret_pd_p49_config_p49_pid                          (0xff)                          

#define reg_gpio_ret_pd_p50_config                                 (*(volatile uint32_t *)0x600040c8)
#define adr_gpio_ret_pd_p50_config                                                       (0x600040c8)
#define mask_gpio_ret_pd_p50_config_p50_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p50_config_p50_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p50_config_p50_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p50_config_p50_pu                           (0x800)                         
#define mask_gpio_ret_pd_p50_config_p50_pd                           (0x400)                         
#define mask_gpio_ret_pd_p50_config_p50_ie                           (0x200)                         
#define mask_gpio_ret_pd_p50_config_p50_oe                           (0x100)                         
#define mask_gpio_ret_pd_p50_config_p50_pid                          (0xff)                          

#define reg_gpio_ret_pd_p51_config                                 (*(volatile uint32_t *)0x600040cc)
#define adr_gpio_ret_pd_p51_config                                                       (0x600040cc)
#define mask_gpio_ret_pd_p51_config_p51_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p51_config_p51_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p51_config_p51_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p51_config_p51_pu                           (0x800)                         
#define mask_gpio_ret_pd_p51_config_p51_pd                           (0x400)                         
#define mask_gpio_ret_pd_p51_config_p51_ie                           (0x200)                         
#define mask_gpio_ret_pd_p51_config_p51_oe                           (0x100)                         
#define mask_gpio_ret_pd_p51_config_p51_pid                          (0xff)                          

#define reg_gpio_ret_pd_p52_config                                 (*(volatile uint32_t *)0x600040d0)
#define adr_gpio_ret_pd_p52_config                                                       (0x600040d0)
#define mask_gpio_ret_pd_p52_config_p52_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p52_config_p52_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p52_config_p52_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p52_config_p52_pu                           (0x800)                         
#define mask_gpio_ret_pd_p52_config_p52_pd                           (0x400)                         
#define mask_gpio_ret_pd_p52_config_p52_ie                           (0x200)                         
#define mask_gpio_ret_pd_p52_config_p52_oe                           (0x100)                         
#define mask_gpio_ret_pd_p52_config_p52_pid                          (0xff)                          

#define reg_gpio_ret_pd_p53_config                                 (*(volatile uint32_t *)0x600040d4)
#define adr_gpio_ret_pd_p53_config                                                       (0x600040d4)
#define mask_gpio_ret_pd_p53_config_p53_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p53_config_p53_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p53_config_p53_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p53_config_p53_pu                           (0x800)                         
#define mask_gpio_ret_pd_p53_config_p53_pd                           (0x400)                         
#define mask_gpio_ret_pd_p53_config_p53_ie                           (0x200)                         
#define mask_gpio_ret_pd_p53_config_p53_oe                           (0x100)                         
#define mask_gpio_ret_pd_p53_config_p53_pid                          (0xff)                          

#define reg_iomux_ret_pd_qspi_ctrl                                 (*(volatile uint32_t *)0x60004190)
#define adr_iomux_ret_pd_qspi_ctrl                                                       (0x60004190)
#define mask_iomux_ret_pd_qspi_ctrl_qspi3_en                         (0x8)                           
#define mask_iomux_ret_pd_qspi_ctrl_qspi2_en                         (0x4)                           
#define mask_iomux_ret_pd_qspi_ctrl_qspi1_en                         (0x2)                           
#define mask_iomux_ret_pd_qspi_ctrl_qspi0_en                         (0x1)                           

#define reg_IR_ir_ctrl                                             (*(volatile uint32_t *)0x60004194)
#define adr_IR_ir_ctrl                                                                   (0x60004194)
#define mask_IR_ir_ctrl_TX_EN_o                                      (0x10)                          
#define mask_IR_ir_ctrl_RX_AMP_EN_o                                  (0x8)                           
#define mask_IR_ir_ctrl_RX_RTUNE_o                                   (0x7)                           

#define reg_iomux_ext_cg_en                                        (*(volatile uint32_t *)0x60004198)
#define adr_iomux_ext_cg_en                                                              (0x60004198)

#define reg_modem_fpga_ctrl                                        (*(volatile uint32_t *)0x6000419c)
#define adr_modem_fpga_ctrl                                                              (0x6000419c)


//---------------------------------------------------
// gpio_ret_pd in  domain address definition
//---------------------------------------------------

#define reg_gpio_ret_pd_p54_config                                 (*(volatile uint32_t *)0x60004400)
#define adr_gpio_ret_pd_p54_config                                                       (0x60004400)
#define mask_gpio_ret_pd_p54_config_p54_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p54_config_p54_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p54_config_p54_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p54_config_p54_pu                           (0x800)                         
#define mask_gpio_ret_pd_p54_config_p54_pd                           (0x400)                         
#define mask_gpio_ret_pd_p54_config_p54_ie                           (0x200)                         
#define mask_gpio_ret_pd_p54_config_p54_oe                           (0x100)                         
#define mask_gpio_ret_pd_p54_config_p54_pid                          (0xff)                          

#define reg_gpio_ret_pd_p55_config                                 (*(volatile uint32_t *)0x60004404)
#define adr_gpio_ret_pd_p55_config                                                       (0x60004404)
#define mask_gpio_ret_pd_p55_config_p55_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p55_config_p55_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p55_config_p55_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p55_config_p55_pu                           (0x800)                         
#define mask_gpio_ret_pd_p55_config_p55_pd                           (0x400)                         
#define mask_gpio_ret_pd_p55_config_p55_ie                           (0x200)                         
#define mask_gpio_ret_pd_p55_config_p55_oe                           (0x100)                         
#define mask_gpio_ret_pd_p55_config_p55_pid                          (0xff)                          

#define reg_gpio_ret_pd_p56_config                                 (*(volatile uint32_t *)0x60004408)
#define adr_gpio_ret_pd_p56_config                                                       (0x60004408)
#define mask_gpio_ret_pd_p56_config_p56_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p56_config_p56_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p56_config_p56_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p56_config_p56_pu                           (0x800)                         
#define mask_gpio_ret_pd_p56_config_p56_pd                           (0x400)                         
#define mask_gpio_ret_pd_p56_config_p56_ie                           (0x200)                         
#define mask_gpio_ret_pd_p56_config_p56_oe                           (0x100)                         
#define mask_gpio_ret_pd_p56_config_p56_pid                          (0xff)                          

#define reg_gpio_ret_pd_p57_config                                 (*(volatile uint32_t *)0x6000440c)
#define adr_gpio_ret_pd_p57_config                                                       (0x6000440c)
#define mask_gpio_ret_pd_p57_config_p57_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p57_config_p57_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p57_config_p57_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p57_config_p57_pu                           (0x800)                         
#define mask_gpio_ret_pd_p57_config_p57_pd                           (0x400)                         
#define mask_gpio_ret_pd_p57_config_p57_ie                           (0x200)                         
#define mask_gpio_ret_pd_p57_config_p57_oe                           (0x100)                         
#define mask_gpio_ret_pd_p57_config_p57_pid                          (0xff)                          

#define reg_gpio_ret_pd_p58_config                                 (*(volatile uint32_t *)0x60004410)
#define adr_gpio_ret_pd_p58_config                                                       (0x60004410)
#define mask_gpio_ret_pd_p58_config_p58_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p58_config_p58_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p58_config_p58_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p58_config_p58_pu                           (0x800)                         
#define mask_gpio_ret_pd_p58_config_p58_pd                           (0x400)                         
#define mask_gpio_ret_pd_p58_config_p58_ie                           (0x200)                         
#define mask_gpio_ret_pd_p58_config_p58_oe                           (0x100)                         
#define mask_gpio_ret_pd_p58_config_p58_pid                          (0xff)                          

#define reg_gpio_ret_pd_p59_config                                 (*(volatile uint32_t *)0x60004414)
#define adr_gpio_ret_pd_p59_config                                                       (0x60004414)
#define mask_gpio_ret_pd_p59_config_p59_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p59_config_p59_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p59_config_p59_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p59_config_p59_pu                           (0x800)                         
#define mask_gpio_ret_pd_p59_config_p59_pd                           (0x400)                         
#define mask_gpio_ret_pd_p59_config_p59_ie                           (0x200)                         
#define mask_gpio_ret_pd_p59_config_p59_oe                           (0x100)                         
#define mask_gpio_ret_pd_p59_config_p59_pid                          (0xff)                          

#define reg_gpio_ret_pd_p60_config                                 (*(volatile uint32_t *)0x60004418)
#define adr_gpio_ret_pd_p60_config                                                       (0x60004418)
#define mask_gpio_ret_pd_p60_config_p60_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p60_config_p60_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p60_config_p60_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p60_config_p60_pu                           (0x800)                         
#define mask_gpio_ret_pd_p60_config_p60_pd                           (0x400)                         
#define mask_gpio_ret_pd_p60_config_p60_ie                           (0x200)                         
#define mask_gpio_ret_pd_p60_config_p60_oe                           (0x100)                         
#define mask_gpio_ret_pd_p60_config_p60_pid                          (0xff)                          

#define reg_gpio_ret_pd_p61_config                                 (*(volatile uint32_t *)0x6000441c)
#define adr_gpio_ret_pd_p61_config                                                       (0x6000441c)
#define mask_gpio_ret_pd_p61_config_p61_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p61_config_p61_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p61_config_p61_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p61_config_p61_pu                           (0x800)                         
#define mask_gpio_ret_pd_p61_config_p61_pd                           (0x400)                         
#define mask_gpio_ret_pd_p61_config_p61_ie                           (0x200)                         
#define mask_gpio_ret_pd_p61_config_p61_oe                           (0x100)                         
#define mask_gpio_ret_pd_p61_config_p61_pid                          (0xff)                          

#define reg_gpio_ret_pd_p62_config                                 (*(volatile uint32_t *)0x60004420)
#define adr_gpio_ret_pd_p62_config                                                       (0x60004420)
#define mask_gpio_ret_pd_p62_config_p62_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p62_config_p62_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p62_config_p62_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p62_config_p62_pu                           (0x800)                         
#define mask_gpio_ret_pd_p62_config_p62_pd                           (0x400)                         
#define mask_gpio_ret_pd_p62_config_p62_ie                           (0x200)                         
#define mask_gpio_ret_pd_p62_config_p62_oe                           (0x100)                         
#define mask_gpio_ret_pd_p62_config_p62_pid                          (0xff)                          

#define reg_gpio_ret_pd_p63_config                                 (*(volatile uint32_t *)0x60004424)
#define adr_gpio_ret_pd_p63_config                                                       (0x60004424)
#define mask_gpio_ret_pd_p63_config_p63_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p63_config_p63_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p63_config_p63_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p63_config_p63_pu                           (0x800)                         
#define mask_gpio_ret_pd_p63_config_p63_pd                           (0x400)                         
#define mask_gpio_ret_pd_p63_config_p63_ie                           (0x200)                         
#define mask_gpio_ret_pd_p63_config_p63_oe                           (0x100)                         
#define mask_gpio_ret_pd_p63_config_p63_pid                          (0xff)                          

#define reg_gpio_ret_pd_p64_config                                 (*(volatile uint32_t *)0x60004428)
#define adr_gpio_ret_pd_p64_config                                                       (0x60004428)
#define mask_gpio_ret_pd_p64_config_p64_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p64_config_p64_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p64_config_p64_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p64_config_p64_pu                           (0x800)                         
#define mask_gpio_ret_pd_p64_config_p64_pd                           (0x400)                         
#define mask_gpio_ret_pd_p64_config_p64_ie                           (0x200)                         
#define mask_gpio_ret_pd_p64_config_p64_oe                           (0x100)                         
#define mask_gpio_ret_pd_p64_config_p64_pid                          (0xff)                          

#define reg_gpio_ret_pd_p65_config                                 (*(volatile uint32_t *)0x6000442c)
#define adr_gpio_ret_pd_p65_config                                                       (0x6000442c)
#define mask_gpio_ret_pd_p65_config_p65_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p65_config_p65_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p65_config_p65_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p65_config_p65_pu                           (0x800)                         
#define mask_gpio_ret_pd_p65_config_p65_pd                           (0x400)                         
#define mask_gpio_ret_pd_p65_config_p65_ie                           (0x200)                         
#define mask_gpio_ret_pd_p65_config_p65_oe                           (0x100)                         
#define mask_gpio_ret_pd_p65_config_p65_pid                          (0xff)                          

#define reg_gpio_ret_pd_p66_config                                 (*(volatile uint32_t *)0x60004430)
#define adr_gpio_ret_pd_p66_config                                                       (0x60004430)
#define mask_gpio_ret_pd_p66_config_p66_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p66_config_p66_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p66_config_p66_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p66_config_p66_pu                           (0x800)                         
#define mask_gpio_ret_pd_p66_config_p66_pd                           (0x400)                         
#define mask_gpio_ret_pd_p66_config_p66_ie                           (0x200)                         
#define mask_gpio_ret_pd_p66_config_p66_oe                           (0x100)                         
#define mask_gpio_ret_pd_p66_config_p66_pid                          (0xff)                          

#define reg_gpio_ret_pd_p67_config                                 (*(volatile uint32_t *)0x60004434)
#define adr_gpio_ret_pd_p67_config                                                       (0x60004434)
#define mask_gpio_ret_pd_p67_config_p67_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p67_config_p67_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p67_config_p67_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p67_config_p67_pu                           (0x800)                         
#define mask_gpio_ret_pd_p67_config_p67_pd                           (0x400)                         
#define mask_gpio_ret_pd_p67_config_p67_ie                           (0x200)                         
#define mask_gpio_ret_pd_p67_config_p67_oe                           (0x100)                         
#define mask_gpio_ret_pd_p67_config_p67_pid                          (0xff)                          

#define reg_gpio_ret_pd_p68_config                                 (*(volatile uint32_t *)0x60004438)
#define adr_gpio_ret_pd_p68_config                                                       (0x60004438)
#define mask_gpio_ret_pd_p68_config_p68_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p68_config_p68_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p68_config_p68_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p68_config_p68_pu                           (0x800)                         
#define mask_gpio_ret_pd_p68_config_p68_pd                           (0x400)                         
#define mask_gpio_ret_pd_p68_config_p68_ie                           (0x200)                         
#define mask_gpio_ret_pd_p68_config_p68_oe                           (0x100)                         
#define mask_gpio_ret_pd_p68_config_p68_pid                          (0xff)                          

#define reg_gpio_ret_pd_p69_config                                 (*(volatile uint32_t *)0x6000443c)
#define adr_gpio_ret_pd_p69_config                                                       (0x6000443c)
#define mask_gpio_ret_pd_p69_config_p69_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p69_config_p69_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p69_config_p69_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p69_config_p69_pu                           (0x800)                         
#define mask_gpio_ret_pd_p69_config_p69_pd                           (0x400)                         
#define mask_gpio_ret_pd_p69_config_p69_ie                           (0x200)                         
#define mask_gpio_ret_pd_p69_config_p69_oe                           (0x100)                         
#define mask_gpio_ret_pd_p69_config_p69_pid                          (0xff)                          

#define reg_gpio_ret_pd_p70_config                                 (*(volatile uint32_t *)0x60004440)
#define adr_gpio_ret_pd_p70_config                                                       (0x60004440)
#define mask_gpio_ret_pd_p70_config_p70_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p70_config_p70_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p70_config_p70_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p70_config_p70_pu                           (0x800)                         
#define mask_gpio_ret_pd_p70_config_p70_pd                           (0x400)                         
#define mask_gpio_ret_pd_p70_config_p70_ie                           (0x200)                         
#define mask_gpio_ret_pd_p70_config_p70_oe                           (0x100)                         
#define mask_gpio_ret_pd_p70_config_p70_pid                          (0xff)                          

#define reg_gpio_ret_pd_p71_config                                 (*(volatile uint32_t *)0x60004444)
#define adr_gpio_ret_pd_p71_config                                                       (0x60004444)
#define mask_gpio_ret_pd_p71_config_p71_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p71_config_p71_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p71_config_p71_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p71_config_p71_pu                           (0x800)                         
#define mask_gpio_ret_pd_p71_config_p71_pd                           (0x400)                         
#define mask_gpio_ret_pd_p71_config_p71_ie                           (0x200)                         
#define mask_gpio_ret_pd_p71_config_p71_oe                           (0x100)                         
#define mask_gpio_ret_pd_p71_config_p71_pid                          (0xff)                          

#define reg_gpio_ret_pd_p72_config                                 (*(volatile uint32_t *)0x60004448)
#define adr_gpio_ret_pd_p72_config                                                       (0x60004448)
#define mask_gpio_ret_pd_p72_config_p72_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p72_config_p72_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p72_config_p72_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p72_config_p72_pu                           (0x800)                         
#define mask_gpio_ret_pd_p72_config_p72_pd                           (0x400)                         
#define mask_gpio_ret_pd_p72_config_p72_ie                           (0x200)                         
#define mask_gpio_ret_pd_p72_config_p72_oe                           (0x100)                         
#define mask_gpio_ret_pd_p72_config_p72_pid                          (0xff)                          

#define reg_gpio_ret_pd_p73_config                                 (*(volatile uint32_t *)0x6000444c)
#define adr_gpio_ret_pd_p73_config                                                       (0x6000444c)
#define mask_gpio_ret_pd_p73_config_p73_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p73_config_p73_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p73_config_p73_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p73_config_p73_pu                           (0x800)                         
#define mask_gpio_ret_pd_p73_config_p73_pd                           (0x400)                         
#define mask_gpio_ret_pd_p73_config_p73_ie                           (0x200)                         
#define mask_gpio_ret_pd_p73_config_p73_oe                           (0x100)                         
#define mask_gpio_ret_pd_p73_config_p73_pid                          (0xff)                          

#define reg_gpio_ret_pd_p74_config                                 (*(volatile uint32_t *)0x60004450)
#define adr_gpio_ret_pd_p74_config                                                       (0x60004450)
#define mask_gpio_ret_pd_p74_config_p74_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p74_config_p74_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p74_config_p74_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p74_config_p74_pu                           (0x800)                         
#define mask_gpio_ret_pd_p74_config_p74_pd                           (0x400)                         
#define mask_gpio_ret_pd_p74_config_p74_ie                           (0x200)                         
#define mask_gpio_ret_pd_p74_config_p74_oe                           (0x100)                         
#define mask_gpio_ret_pd_p74_config_p74_pid                          (0xff)                          

#define reg_gpio_ret_pd_p75_config                                 (*(volatile uint32_t *)0x60004454)
#define adr_gpio_ret_pd_p75_config                                                       (0x60004454)
#define mask_gpio_ret_pd_p75_config_p75_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p75_config_p75_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p75_config_p75_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p75_config_p75_pu                           (0x800)                         
#define mask_gpio_ret_pd_p75_config_p75_pd                           (0x400)                         
#define mask_gpio_ret_pd_p75_config_p75_ie                           (0x200)                         
#define mask_gpio_ret_pd_p75_config_p75_oe                           (0x100)                         
#define mask_gpio_ret_pd_p75_config_p75_pid                          (0xff)                          

#define reg_gpio_ret_pd_p76_config                                 (*(volatile uint32_t *)0x60004458)
#define adr_gpio_ret_pd_p76_config                                                       (0x60004458)
#define mask_gpio_ret_pd_p76_config_p76_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p76_config_p76_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p76_config_p76_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p76_config_p76_pu                           (0x800)                         
#define mask_gpio_ret_pd_p76_config_p76_pd                           (0x400)                         
#define mask_gpio_ret_pd_p76_config_p76_ie                           (0x200)                         
#define mask_gpio_ret_pd_p76_config_p76_oe                           (0x100)                         
#define mask_gpio_ret_pd_p76_config_p76_pid                          (0xff)                          

#define reg_gpio_ret_pd_p77_config                                 (*(volatile uint32_t *)0x6000445c)
#define adr_gpio_ret_pd_p77_config                                                       (0x6000445c)
#define mask_gpio_ret_pd_p77_config_p77_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p77_config_p77_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p77_config_p77_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p77_config_p77_pu                           (0x800)                         
#define mask_gpio_ret_pd_p77_config_p77_pd                           (0x400)                         
#define mask_gpio_ret_pd_p77_config_p77_ie                           (0x200)                         
#define mask_gpio_ret_pd_p77_config_p77_oe                           (0x100)                         
#define mask_gpio_ret_pd_p77_config_p77_pid                          (0xff)                          

#define reg_gpio_ret_pd_p78_config                                 (*(volatile uint32_t *)0x60004460)
#define adr_gpio_ret_pd_p78_config                                                       (0x60004460)
#define mask_gpio_ret_pd_p78_config_p78_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p78_config_p78_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p78_config_p78_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p78_config_p78_pu                           (0x800)                         
#define mask_gpio_ret_pd_p78_config_p78_pd                           (0x400)                         
#define mask_gpio_ret_pd_p78_config_p78_ie                           (0x200)                         
#define mask_gpio_ret_pd_p78_config_p78_oe                           (0x100)                         
#define mask_gpio_ret_pd_p78_config_p78_pid                          (0xff)                          

#define reg_gpio_ret_pd_p79_config                                 (*(volatile uint32_t *)0x60004464)
#define adr_gpio_ret_pd_p79_config                                                       (0x60004464)
#define mask_gpio_ret_pd_p79_config_p79_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p79_config_p79_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p79_config_p79_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p79_config_p79_pu                           (0x800)                         
#define mask_gpio_ret_pd_p79_config_p79_pd                           (0x400)                         
#define mask_gpio_ret_pd_p79_config_p79_ie                           (0x200)                         
#define mask_gpio_ret_pd_p79_config_p79_oe                           (0x100)                         
#define mask_gpio_ret_pd_p79_config_p79_pid                          (0xff)                          

#define reg_gpio_ret_pd_p80_config                                 (*(volatile uint32_t *)0x60004468)
#define adr_gpio_ret_pd_p80_config                                                       (0x60004468)
#define mask_gpio_ret_pd_p80_config_p80_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p80_config_p80_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p80_config_p80_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p80_config_p80_pu                           (0x800)                         
#define mask_gpio_ret_pd_p80_config_p80_pd                           (0x400)                         
#define mask_gpio_ret_pd_p80_config_p80_ie                           (0x200)                         
#define mask_gpio_ret_pd_p80_config_p80_oe                           (0x100)                         
#define mask_gpio_ret_pd_p80_config_p80_pid                          (0xff)                          

#define reg_gpio_ret_pd_p81_config                                 (*(volatile uint32_t *)0x6000446c)
#define adr_gpio_ret_pd_p81_config                                                       (0x6000446c)
#define mask_gpio_ret_pd_p81_config_p81_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p81_config_p81_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p81_config_p81_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p81_config_p81_pu                           (0x800)                         
#define mask_gpio_ret_pd_p81_config_p81_pd                           (0x400)                         
#define mask_gpio_ret_pd_p81_config_p81_ie                           (0x200)                         
#define mask_gpio_ret_pd_p81_config_p81_oe                           (0x100)                         
#define mask_gpio_ret_pd_p81_config_p81_pid                          (0xff)                          

#define reg_gpio_ret_pd_p82_config                                 (*(volatile uint32_t *)0x60004470)
#define adr_gpio_ret_pd_p82_config                                                       (0x60004470)
#define mask_gpio_ret_pd_p82_config_p82_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p82_config_p82_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p82_config_p82_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p82_config_p82_pu                           (0x800)                         
#define mask_gpio_ret_pd_p82_config_p82_pd                           (0x400)                         
#define mask_gpio_ret_pd_p82_config_p82_ie                           (0x200)                         
#define mask_gpio_ret_pd_p82_config_p82_oe                           (0x100)                         
#define mask_gpio_ret_pd_p82_config_p82_pid                          (0xff)                          

#define reg_gpio_ret_pd_p83_config                                 (*(volatile uint32_t *)0x60004474)
#define adr_gpio_ret_pd_p83_config                                                       (0x60004474)
#define mask_gpio_ret_pd_p83_config_p83_cs                           (0x4000)                        
#define mask_gpio_ret_pd_p83_config_p83_dsh                          (0x2000)                        
#define mask_gpio_ret_pd_p83_config_p83_dsl                          (0x1000)                        
#define mask_gpio_ret_pd_p83_config_p83_pu                           (0x800)                         
#define mask_gpio_ret_pd_p83_config_p83_pd                           (0x400)                         
#define mask_gpio_ret_pd_p83_config_p83_ie                           (0x200)                         
#define mask_gpio_ret_pd_p83_config_p83_oe                           (0x100)                         
#define mask_gpio_ret_pd_p83_config_p83_pid                          (0xff)                          


//---------------------------------------------------
// gpadc0 in  domain address definition
//---------------------------------------------------

#define reg_gpadc0_fifo                                            (*(volatile uint32_t *)0x60020000)
#define adr_gpadc0_fifo                                                                  (0x60020000)


//---------------------------------------------------
// gpadc0 in  domain address definition
//---------------------------------------------------

#define reg_gpadc0_downsp                                          (*(volatile uint32_t *)0x60020004)
#define adr_gpadc0_downsp                                                                (0x60020004)

#define reg_gpadc0_coeff_0                                         (*(volatile uint32_t *)0x60020008)
#define adr_gpadc0_coeff_0                                                               (0x60020008)

#define reg_gpadc0_coeff_1                                         (*(volatile uint32_t *)0x6002000c)
#define adr_gpadc0_coeff_1                                                               (0x6002000c)

#define reg_gpadc0_coeff_2                                         (*(volatile uint32_t *)0x60020010)
#define adr_gpadc0_coeff_2                                                               (0x60020010)

#define reg_gpadc0_coeff_3                                         (*(volatile uint32_t *)0x60020014)
#define adr_gpadc0_coeff_3                                                               (0x60020014)

#define reg_gpadc0_set                                             (*(volatile uint32_t *)0x60020018)
#define adr_gpadc0_set                                                                   (0x60020018)
#define mask_gpadc0_set_donsp_out_thd                                (0x1c000)                       
#define mask_gpadc0_set_bp_comp_en                                   (0x2000)                        
#define mask_gpadc0_set_adc_zero_move_en                             (0x1000)                        
#define mask_gpadc0_set_ext_cg_en                                    (0x800)                         
#define mask_gpadc0_set_fifo_thld                                    (0x600)                         
#define mask_gpadc0_set_adc_pos_sel                                  (0x100)                         
#define mask_gpadc0_set_cic_mode_en                                  (0x80)                          
#define mask_gpadc0_set_adc_org_sel                                  (0x40)                          
#define mask_gpadc0_set_reserved                                     (0x20)                          
#define mask_gpadc0_set_a_rshift                                     (0x1f)                          

#define reg_gpadc0_int_sta                                         (*(volatile uint32_t *)0x6002001c)
#define adr_gpadc0_int_sta                                                               (0x6002001c)

#define reg_gpadc0_int_clr                                         (*(volatile uint32_t *)0x60020020)
#define adr_gpadc0_int_clr                                                               (0x60020020)

#define reg_gpadc0_int_mask                                        (*(volatile uint32_t *)0x60020024)
#define adr_gpadc0_int_mask                                                              (0x60020024)

#define reg_gpadc0_ovflow                                          (*(volatile uint32_t *)0x60020028)
#define adr_gpadc0_ovflow                                                                (0x60020028)

#define reg_gpadc0_samp_set_cfg                                    (*(volatile uint32_t *)0x6002002c)
#define adr_gpadc0_samp_set_cfg                                                          (0x6002002c)
#define mask_gpadc0_samp_set_cfg_pwm_sel                             (0x1c0)                         
#define mask_gpadc0_samp_set_cfg_samp_mode_sel                       (0x30)                          
#define mask_gpadc0_samp_set_cfg_type_sel                            (0xf)                           

#define reg_gpadc0_en                                              (*(volatile uint32_t *)0x60020030)
#define adr_gpadc0_en                                                                    (0x60020030)

#define reg_gpadc0_data_test_cfg                                   (*(volatile uint32_t *)0x60020054)
#define adr_gpadc0_data_test_cfg                                                         (0x60020054)
#define mask_gpadc0_data_test_cfg_test_in_en                         (0x400)                         
#define mask_gpadc0_data_test_cfg_test_data                          (0x3ff)                         

#define reg_gpadc0_ch_en                                           (*(volatile uint32_t *)0x60020058)
#define adr_gpadc0_ch_en                                                                 (0x60020058)

#define reg_gpadc0_ch_wait_pcycle                                  (*(volatile uint32_t *)0x6002005c)
#define adr_gpadc0_ch_wait_pcycle                                                        (0x6002005c)

#define reg_gpadc0_samp_num                                        (*(volatile uint32_t *)0x60020060)
#define adr_gpadc0_samp_num                                                              (0x60020060)

#define reg_gpadc0_trig_reg                                        (*(volatile uint32_t *)0x60020064)
#define adr_gpadc0_trig_reg                                                              (0x60020064)
#define mask_gpadc0_trig_reg_clr_sampcnt                             (0x8)                           
#define mask_gpadc0_trig_reg_stop                                    (0x4)                           
#define mask_gpadc0_trig_reg_samp_trig                               (0x2)                           
#define mask_gpadc0_trig_reg_ch_trig                                 (0x1)                           

#define reg_gpadc0_sta_reg0                                        (*(volatile uint32_t *)0x60020068)
#define adr_gpadc0_sta_reg0                                                              (0x60020068)
#define mask_gpadc0_sta_reg0_adc_dat                                 (0xffff0000)                    
#define mask_gpadc0_sta_reg0_samp_cnt                                (0xffff)                        

#define reg_gpadc0_sta_reg1                                        (*(volatile uint32_t *)0x6002006c)
#define adr_gpadc0_sta_reg1                                                              (0x6002006c)
#define mask_gpadc0_sta_reg1_fifo_cnt                                (0x3c0000)                      
#define mask_gpadc0_sta_reg1_fsm                                     (0x38000)                       
#define mask_gpadc0_sta_reg1_aud_sta                                 (0x7fff)                        


//---------------------------------------------------
// gpadc1 in  domain address definition
//---------------------------------------------------

#define reg_gpadc1_fifo                                            (*(volatile uint32_t *)0x60020400)
#define adr_gpadc1_fifo                                                                  (0x60020400)


//---------------------------------------------------
// gpadc1 in  domain address definition
//---------------------------------------------------

#define reg_gpadc1_downsp                                          (*(volatile uint32_t *)0x60020404)
#define adr_gpadc1_downsp                                                                (0x60020404)

#define reg_gpadc1_coeff_0                                         (*(volatile uint32_t *)0x60020408)
#define adr_gpadc1_coeff_0                                                               (0x60020408)

#define reg_gpadc1_coeff_1                                         (*(volatile uint32_t *)0x6002040c)
#define adr_gpadc1_coeff_1                                                               (0x6002040c)

#define reg_gpadc1_coeff_2                                         (*(volatile uint32_t *)0x60020410)
#define adr_gpadc1_coeff_2                                                               (0x60020410)

#define reg_gpadc1_coeff_3                                         (*(volatile uint32_t *)0x60020414)
#define adr_gpadc1_coeff_3                                                               (0x60020414)

#define reg_gpadc1_set                                             (*(volatile uint32_t *)0x60020418)
#define adr_gpadc1_set                                                                   (0x60020418)
#define mask_gpadc1_set_donsp_out_thd                                (0x1c000)                       
#define mask_gpadc1_set_bp_comp_en                                   (0x2000)                        
#define mask_gpadc1_set_adc_zero_move_en                             (0x1000)                        
#define mask_gpadc1_set_ext_cg_en                                    (0x800)                         
#define mask_gpadc1_set_fifo_thld                                    (0x600)                         
#define mask_gpadc1_set_adc_pos_sel                                  (0x100)                         
#define mask_gpadc1_set_cic_mode_en                                  (0x80)                          
#define mask_gpadc1_set_adc_org_sel                                  (0x40)                          
#define mask_gpadc1_set_reserved                                     (0x20)                          
#define mask_gpadc1_set_a_rshift                                     (0x1f)                          

#define reg_gpadc1_int_sta                                         (*(volatile uint32_t *)0x6002041c)
#define adr_gpadc1_int_sta                                                               (0x6002041c)

#define reg_gpadc1_int_clr                                         (*(volatile uint32_t *)0x60020420)
#define adr_gpadc1_int_clr                                                               (0x60020420)

#define reg_gpadc1_int_mask                                        (*(volatile uint32_t *)0x60020424)
#define adr_gpadc1_int_mask                                                              (0x60020424)

#define reg_gpadc1_ovflow                                          (*(volatile uint32_t *)0x60020428)
#define adr_gpadc1_ovflow                                                                (0x60020428)

#define reg_gpadc1_samp_set_cfg                                    (*(volatile uint32_t *)0x6002042c)
#define adr_gpadc1_samp_set_cfg                                                          (0x6002042c)
#define mask_gpadc1_samp_set_cfg_pwm_sel                             (0x1c0)                         
#define mask_gpadc1_samp_set_cfg_samp_mode_sel                       (0x30)                          
#define mask_gpadc1_samp_set_cfg_type_sel                            (0xf)                           

#define reg_gpadc1_en                                              (*(volatile uint32_t *)0x60020430)
#define adr_gpadc1_en                                                                    (0x60020430)

#define reg_gpadc1_data_test_cfg                                   (*(volatile uint32_t *)0x60020454)
#define adr_gpadc1_data_test_cfg                                                         (0x60020454)
#define mask_gpadc1_data_test_cfg_test_in_en                         (0x400)                         
#define mask_gpadc1_data_test_cfg_test_data                          (0x3ff)                         

#define reg_gpadc1_ch_en                                           (*(volatile uint32_t *)0x60020458)
#define adr_gpadc1_ch_en                                                                 (0x60020458)

#define reg_gpadc1_ch_wait_pcycle                                  (*(volatile uint32_t *)0x6002045c)
#define adr_gpadc1_ch_wait_pcycle                                                        (0x6002045c)

#define reg_gpadc1_samp_num                                        (*(volatile uint32_t *)0x60020460)
#define adr_gpadc1_samp_num                                                              (0x60020460)

#define reg_gpadc1_trig_reg                                        (*(volatile uint32_t *)0x60020464)
#define adr_gpadc1_trig_reg                                                              (0x60020464)
#define mask_gpadc1_trig_reg_clr_sampcnt                             (0x8)                           
#define mask_gpadc1_trig_reg_stop                                    (0x4)                           
#define mask_gpadc1_trig_reg_samp_trig                               (0x2)                           
#define mask_gpadc1_trig_reg_ch_trig                                 (0x1)                           

#define reg_gpadc1_sta_reg0                                        (*(volatile uint32_t *)0x60020468)
#define adr_gpadc1_sta_reg0                                                              (0x60020468)
#define mask_gpadc1_sta_reg0_adc_dat                                 (0xffff0000)                    
#define mask_gpadc1_sta_reg0_samp_cnt                                (0xffff)                        

#define reg_gpadc1_sta_reg1                                        (*(volatile uint32_t *)0x6002046c)
#define adr_gpadc1_sta_reg1                                                              (0x6002046c)
#define mask_gpadc1_sta_reg1_fifo_cnt                                (0x3c0000)                      
#define mask_gpadc1_sta_reg1_fsm                                     (0x38000)                       
#define mask_gpadc1_sta_reg1_aud_sta                                 (0x7fff)                        


//---------------------------------------------------
// i2s_seca in  domain address definition
//---------------------------------------------------

#define reg_i2s_seca_rx_fifo                                       (*(volatile uint32_t *)0x6002d000)
#define adr_i2s_seca_rx_fifo                                                             (0x6002d000)

#define reg_i2s_seca_tx_fifo                                       (*(volatile uint32_t *)0x6002d004)
#define adr_i2s_seca_tx_fifo                                                             (0x6002d004)


//---------------------------------------------------
// i2s in  domain address definition
//---------------------------------------------------

#define reg_i2s_intr_state                                         (*(volatile uint32_t *)0x6002d008)
#define adr_i2s_intr_state                                                               (0x6002d008)

#define reg_i2s_intr_clr                                           (*(volatile uint32_t *)0x6002d010)
#define adr_i2s_intr_clr                                                                 (0x6002d010)

#define reg_i2s_intr_mask                                          (*(volatile uint32_t *)0x6002d014)
#define adr_i2s_intr_mask                                                                (0x6002d014)

#define reg_i2s_config                                             (*(volatile uint32_t *)0x6002d018)
#define adr_i2s_config                                                                   (0x6002d018)
#define mask_i2s_config_rx_lr_exg_en                                 (0x40000)                       
#define mask_i2s_config_reserve                                      (0x38000)                       
#define mask_i2s_config_mclk_en                                      (0x4000)                        
#define mask_i2s_config_xo_32m_n16m                                  (0x2000)                        
#define mask_i2s_config_fs_num                                       (0x1800)                        
#define mask_i2s_config_master_slave                                 (0x400)                         
#define mask_i2s_config_mclk_div                                     (0x300)                         
#define mask_i2s_config_ch_mask                                      (0xc0)                          
#define mask_i2s_config_data_length                                  (0x30)                          
#define mask_i2s_config_data_format                                  (0xc)                           
#define mask_i2s_config_wclk_inv                                     (0x2)                           
#define mask_i2s_config_smpl_edge                                    (0x1)                           

#define reg_i2s_config2                                            (*(volatile uint32_t *)0x6002d01c)
#define adr_i2s_config2                                                                  (0x6002d01c)
#define mask_i2s_config2_tx_en                                       (0x200)                         
#define mask_i2s_config2_rx_en                                       (0x100)                         
#define mask_i2s_config2_wclk_width                                  (0xff)                          

#define reg_i2s_ext_cg_en                                          (*(volatile uint32_t *)0x6002d020)
#define adr_i2s_ext_cg_en                                                                (0x6002d020)


//---------------------------------------------------
// cic0 in  domain address definition
//---------------------------------------------------

#define reg_cic0_fifo                                              (*(volatile uint32_t *)0x6002e000)
#define adr_cic0_fifo                                                                    (0x6002e000)


//---------------------------------------------------
// cic0 in  domain address definition
//---------------------------------------------------

#define reg_cic0_downsp                                            (*(volatile uint32_t *)0x6002e004)
#define adr_cic0_downsp                                                                  (0x6002e004)

#define reg_cic0_coeff_0                                           (*(volatile uint32_t *)0x6002e008)
#define adr_cic0_coeff_0                                                                 (0x6002e008)

#define reg_cic0_coeff_1                                           (*(volatile uint32_t *)0x6002e00c)
#define adr_cic0_coeff_1                                                                 (0x6002e00c)

#define reg_cic0_coeff_2                                           (*(volatile uint32_t *)0x6002e010)
#define adr_cic0_coeff_2                                                                 (0x6002e010)

#define reg_cic0_coeff_3                                           (*(volatile uint32_t *)0x6002e014)
#define adr_cic0_coeff_3                                                                 (0x6002e014)

#define reg_cic0_set                                               (*(volatile uint32_t *)0x6002e018)
#define adr_cic0_set                                                                     (0x6002e018)
#define mask_cic0_set_adc_zero_move_en                               (0x8000)                        
#define mask_cic0_set_en                                             (0x4000)                        
#define mask_cic0_set_pdmh_adcl_sel                                  (0x2000)                        
#define mask_cic0_set_adc_pos_sel                                    (0x1000)                        
#define mask_cic0_set_slpf_data_sel                                  (0x800)                         
#define mask_cic0_set_source_bp                                      (0x400)                         
#define mask_cic0_set_comp_bp                                        (0x200)                         
#define mask_cic0_set_slpf_bp                                        (0x100)                         
#define mask_cic0_set_slpf_bgn_flg_en                                (0x80)                          
#define mask_cic0_set_adc_org_sel                                    (0x40)                          
#define mask_cic0_set_adc_dbg_out_en                                 (0x20)                          
#define mask_cic0_set_a_rshift                                       (0x1f)                          

#define reg_cic0_sta_reg                                           (*(volatile uint32_t *)0x6002e01c)
#define adr_cic0_sta_reg                                                                 (0x6002e01c)

#define reg_cic0_int_mask                                          (*(volatile uint32_t *)0x6002e020)
#define adr_cic0_int_mask                                                                (0x6002e020)

#define reg_cic0_int_clr                                           (*(volatile uint32_t *)0x6002e024)
#define adr_cic0_int_clr                                                                 (0x6002e024)

#define reg_cic0_ovflow                                            (*(volatile uint32_t *)0x6002e028)
#define adr_cic0_ovflow                                                                  (0x6002e028)

#define reg_cic0_pdm_config                                        (*(volatile uint32_t *)0x6002e02c)
#define adr_cic0_pdm_config                                                              (0x6002e02c)
#define mask_cic0_pdm_config_pdm_rate                                (0x200)                         
#define mask_cic0_pdm_config_pdm_en                                  (0x100)                         
#define mask_cic0_pdm_config_pdm_falldge                             (0xf0)                          
#define mask_cic0_pdm_config_pdm_risedge                             (0xf)                           

#define reg_cic0_ext_cg_en                                         (*(volatile uint32_t *)0x6002e034)
#define adr_cic0_ext_cg_en                                                               (0x6002e034)


//---------------------------------------------------
// cic1 in  domain address definition
//---------------------------------------------------

#define reg_cic1_fifo                                              (*(volatile uint32_t *)0x6002e400)
#define adr_cic1_fifo                                                                    (0x6002e400)


//---------------------------------------------------
// cic1 in  domain address definition
//---------------------------------------------------

#define reg_cic1_downsp                                            (*(volatile uint32_t *)0x6002e404)
#define adr_cic1_downsp                                                                  (0x6002e404)

#define reg_cic1_coeff_0                                           (*(volatile uint32_t *)0x6002e408)
#define adr_cic1_coeff_0                                                                 (0x6002e408)

#define reg_cic1_coeff_1                                           (*(volatile uint32_t *)0x6002e40c)
#define adr_cic1_coeff_1                                                                 (0x6002e40c)

#define reg_cic1_coeff_2                                           (*(volatile uint32_t *)0x6002e410)
#define adr_cic1_coeff_2                                                                 (0x6002e410)

#define reg_cic1_coeff_3                                           (*(volatile uint32_t *)0x6002e414)
#define adr_cic1_coeff_3                                                                 (0x6002e414)

#define reg_cic1_set                                               (*(volatile uint32_t *)0x6002e418)
#define adr_cic1_set                                                                     (0x6002e418)
#define mask_cic1_set_adc_zero_move_en                               (0x8000)                        
#define mask_cic1_set_en                                             (0x4000)                        
#define mask_cic1_set_pdmh_adcl_sel                                  (0x2000)                        
#define mask_cic1_set_adc_pos_sel                                    (0x1000)                        
#define mask_cic1_set_slpf_data_sel                                  (0x800)                         
#define mask_cic1_set_source_bp                                      (0x400)                         
#define mask_cic1_set_comp_bp                                        (0x200)                         
#define mask_cic1_set_slpf_bp                                        (0x100)                         
#define mask_cic1_set_slpf_bgn_flg_en                                (0x80)                          
#define mask_cic1_set_adc_org_sel                                    (0x40)                          
#define mask_cic1_set_adc_dbg_out_en                                 (0x20)                          
#define mask_cic1_set_a_rshift                                       (0x1f)                          

#define reg_cic1_sta_reg                                           (*(volatile uint32_t *)0x6002e41c)
#define adr_cic1_sta_reg                                                                 (0x6002e41c)

#define reg_cic1_int_mask                                          (*(volatile uint32_t *)0x6002e420)
#define adr_cic1_int_mask                                                                (0x6002e420)

#define reg_cic1_int_clr                                           (*(volatile uint32_t *)0x6002e424)
#define adr_cic1_int_clr                                                                 (0x6002e424)

#define reg_cic1_ovflow                                            (*(volatile uint32_t *)0x6002e428)
#define adr_cic1_ovflow                                                                  (0x6002e428)

#define reg_cic1_pdm_config                                        (*(volatile uint32_t *)0x6002e42c)
#define adr_cic1_pdm_config                                                              (0x6002e42c)
#define mask_cic1_pdm_config_pdm_rate                                (0x200)                         
#define mask_cic1_pdm_config_pdm_en                                  (0x100)                         
#define mask_cic1_pdm_config_pdm_falldge                             (0xf0)                          
#define mask_cic1_pdm_config_pdm_risedge                             (0xf)                           

#define reg_cic1_ext_cg_en                                         (*(volatile uint32_t *)0x6002e434)
#define adr_cic1_ext_cg_en                                                               (0x6002e434)


//---------------------------------------------------
// efuse in  domain address definition
//---------------------------------------------------

#define reg_efuse_soft_cmd                                         (*(volatile uint32_t *)0x6002f400)
#define adr_efuse_soft_cmd                                                               (0x6002f400)
#define mask_efuse_soft_cmd_flg_clr                                  (0x2)                           
#define mask_efuse_soft_cmd_program                                  (0x1)                           

#define reg_efuse_cmd_time                                         (*(volatile uint32_t *)0x6002f404)
#define adr_efuse_cmd_time                                                               (0x6002f404)
#define mask_efuse_cmd_time_tpd_csb_time                             (0xf0000)                       
#define mask_efuse_cmd_time_trpw_time                                (0xc000)                        
#define mask_efuse_cmd_time_tpi_time                                 (0x3f00)                        
#define mask_efuse_cmd_time_tpp_time                                 (0xff)                          

#define reg_efuse_cmd_adrs                                         (*(volatile uint32_t *)0x6002f408)
#define adr_efuse_cmd_adrs                                                               (0x6002f408)
#define mask_efuse_cmd_adrs_adr                                      (0x3f)                          

#define reg_efuse_wdata                                            (*(volatile uint32_t *)0x6002f40c)
#define adr_efuse_wdata                                                                  (0x6002f40c)

#define reg_efuse_2p5v_en                                          (*(volatile uint32_t *)0x6002f410)
#define adr_efuse_2p5v_en                                                                (0x6002f410)

#define reg_efuse_end                                              (*(volatile uint32_t *)0x6002f414)
#define adr_efuse_end                                                                    (0x6002f414)

#define reg_efuse_ext_cg_en                                        (*(volatile uint32_t *)0x6002f418)
#define adr_efuse_ext_cg_en                                                              (0x6002f418)


//---------------------------------------------------
// qdec in  domain address definition
//---------------------------------------------------

#define reg_qdec_int_status                                        (*(volatile uint32_t *)0x60030000)
#define adr_qdec_int_status                                                              (0x60030000)

#define reg_qdec_int_en                                            (*(volatile uint32_t *)0x60030004)
#define adr_qdec_int_en                                                                  (0x60030004)

#define reg_qdec_int_clear                                         (*(volatile uint32_t *)0x60030008)
#define adr_qdec_int_clear                                                               (0x60030008)

#define reg_qdec_qdec_ctrl                                         (*(volatile uint32_t *)0x6003000c)
#define adr_qdec_qdec_ctrl                                                               (0x6003000c)
#define mask_qdec_qdec_ctrl_chx_dir_pol                              (0x4)                           
#define mask_qdec_qdec_ctrl_chx_deb_en                               (0x2)                           
#define mask_qdec_qdec_ctrl_chx_en                                   (0x1)                           

#define reg_qdec_chx_led_pol                                       (*(volatile uint32_t *)0x60030010)
#define adr_qdec_chx_led_pol                                                             (0x60030010)

#define reg_qdec_chx_led_per                                       (*(volatile uint32_t *)0x60030014)
#define adr_qdec_chx_led_per                                                             (0x60030014)

#define reg_qdec_qdec_sample_per                                   (*(volatile uint32_t *)0x60030018)
#define adr_qdec_qdec_sample_per                                                         (0x60030018)
#define mask_qdec_qdec_sample_per_chx_sample_per                     (0x1fffff)                      

#define reg_qdec_chx_sample_acc                                    (*(volatile uint32_t *)0x6003001c)
#define adr_qdec_chx_sample_acc                                                          (0x6003001c)

#define reg_qdec_chx_sample_acc_dbl                                (*(volatile uint32_t *)0x60030020)
#define adr_qdec_chx_sample_acc_dbl                                                      (0x60030020)

#define reg_qdec_chx_sample_acc_no_change                          (*(volatile uint32_t *)0x60030024)
#define adr_qdec_chx_sample_acc_no_change                                                (0x60030024)

#define reg_qdec_chx_sample_rlt                                    (*(volatile uint32_t *)0x60030028)
#define adr_qdec_chx_sample_rlt                                                          (0x60030028)

#define reg_qdec_qdec_clr                                          (*(volatile uint32_t *)0x6003002c)
#define adr_qdec_qdec_clr                                                                (0x6003002c)
#define mask_qdec_qdec_clr_chx_acc_no_change_clr                     (0x4)                           
#define mask_qdec_qdec_clr_chx_acc_dbl_clr                           (0x2)                           
#define mask_qdec_qdec_clr_chx_acc_clr                               (0x1)                           

#define reg_qdec_chx_acc                                           (*(volatile uint32_t *)0x60030030)
#define adr_qdec_chx_acc                                                                 (0x60030030)

#define reg_qdec_chx_acc_dbl                                       (*(volatile uint32_t *)0x60030034)
#define adr_qdec_chx_acc_dbl                                                             (0x60030034)

#define reg_qdec_chx_acc_no_change                                 (*(volatile uint32_t *)0x60030038)
#define adr_qdec_chx_acc_no_change                                                       (0x60030038)

#define reg_qdec_ext_cg_en                                         (*(volatile uint32_t *)0x6003003c)
#define adr_qdec_ext_cg_en                                                               (0x6003003c)


//---------------------------------------------------
// gpt0 in  domain address definition
//---------------------------------------------------

#define reg_gpt0_gpt_tim_cfgrdy_trig                               (*(volatile uint32_t *)0x60032000)
#define adr_gpt0_gpt_tim_cfgrdy_trig                                                     (0x60032000)
#define mask_gpt0_gpt_tim_cfgrdy_trig_tim_cnta_cfgrdy_trig           (0x2)                           
#define mask_gpt0_gpt_tim_cfgrdy_trig_tim_cntb_cfgrdy_trig           (0x1)                           

#define reg_gpt0_gpt_tim_cfgrdy_flag                               (*(volatile uint32_t *)0x60032004)
#define adr_gpt0_gpt_tim_cfgrdy_flag                                                     (0x60032004)
#define mask_gpt0_gpt_tim_cfgrdy_flag_tim_cnta_cfgrdy_flag           (0x2)                           
#define mask_gpt0_gpt_tim_cfgrdy_flag_tim_cntb_cfgrdy_flag           (0x1)                           

#define reg_gpt0_gpt_tim_cfgrdy_clr                                (*(volatile uint32_t *)0x60032008)
#define adr_gpt0_gpt_tim_cfgrdy_clr                                                      (0x60032008)
#define mask_gpt0_gpt_tim_cfgrdy_clr_tim_cnta_cfgrdy_clr             (0x2)                           
#define mask_gpt0_gpt_tim_cfgrdy_clr_tim_cntb_cfgrdy_clr             (0x1)                           

#define reg_gpt0_gpt_tim_mode                                      (*(volatile uint32_t *)0x6003200c)
#define adr_gpt0_gpt_tim_mode                                                            (0x6003200c)
#define mask_gpt0_gpt_tim_mode_ir_out_1_en                           (0x80)                          
#define mask_gpt0_gpt_tim_mode_ir_out_0_en                           (0x40)                          
#define mask_gpt0_gpt_tim_mode_tim_decode_cap_loop                   (0x20)                          
#define mask_gpt0_gpt_tim_mode_ir_enable                             (0x10)                          
#define mask_gpt0_gpt_tim_mode_ir_pol                                (0x8)                           
#define mask_gpt0_gpt_tim_mode_tim_work_mode                         (0x7)                           

#define reg_gpt0_gpt_tim_config                                    (*(volatile uint32_t *)0x60032010)
#define adr_gpt0_gpt_tim_config                                                          (0x60032010)
#define mask_gpt0_gpt_tim_config_tim_cnta_pwm_enable                 (0x80000000)                    
#define mask_gpt0_gpt_tim_config_tim_cnta_pwm_pol                    (0x40000000)                    
#define mask_gpt0_gpt_tim_config_tim_cnta_decode_enable              (0x20000000)                    
#define mask_gpt0_gpt_tim_config_tim_cnta_decode_gpout_pol           (0x10000000)                    
#define mask_gpt0_gpt_tim_config_tim_cnta_decode_mode_sel            (0xc000000)                     
#define mask_gpt0_gpt_tim_config_tim_cnta_cap_enable                 (0x2000000)                     
#define mask_gpt0_gpt_tim_config_tim_cnta_cap_sig_sel                (0x1000000)                     
#define mask_gpt0_gpt_tim_config_tim_cnta_cap_mode_sel               (0xc00000)                      
#define mask_gpt0_gpt_tim_config_tim_cnta_prescale                   (0x3c0000)                      
#define mask_gpt0_gpt_tim_config_tim_cnta_rst_mode                   (0x20000)                       
#define mask_gpt0_gpt_tim_config_tim_cnta_rstval_mode                (0x10000)                       
#define mask_gpt0_gpt_tim_config_tim_cntb_pwm_enable                 (0x8000)                        
#define mask_gpt0_gpt_tim_config_tim_cntb_pwm_pol                    (0x4000)                        
#define mask_gpt0_gpt_tim_config_tim_cntb_decode_enable              (0x2000)                        
#define mask_gpt0_gpt_tim_config_tim_cntb_decode_gpout_pol           (0x1000)                        
#define mask_gpt0_gpt_tim_config_tim_cntb_decode_mode_sel            (0xc00)                         
#define mask_gpt0_gpt_tim_config_tim_cntb_cap_enable                 (0x200)                         
#define mask_gpt0_gpt_tim_config_tim_cntb_cap_sig_sel                (0x100)                         
#define mask_gpt0_gpt_tim_config_tim_cntb_cap_mode_sel               (0xc0)                          
#define mask_gpt0_gpt_tim_config_tim_cntb_prescale                   (0x3c)                          
#define mask_gpt0_gpt_tim_config_tim_cntb_rst_mode                   (0x2)                           
#define mask_gpt0_gpt_tim_config_tim_cntb_rstval_mode                (0x1)                           

#define reg_gpt0_gpt_tim_trig                                      (*(volatile uint32_t *)0x60032014)
#define adr_gpt0_gpt_tim_trig                                                            (0x60032014)
#define mask_gpt0_gpt_tim_trig_tim_cnta_clr                          (0x40)                          
#define mask_gpt0_gpt_tim_trig_tim_cnta_stop                         (0x20)                          
#define mask_gpt0_gpt_tim_trig_tim_cnta_start                        (0x10)                          
#define mask_gpt0_gpt_tim_trig_tim_cntb_clr                          (0x4)                           
#define mask_gpt0_gpt_tim_trig_tim_cntb_stop                         (0x2)                           
#define mask_gpt0_gpt_tim_trig_tim_cntb_start                        (0x1)                           

#define reg_gpt0_gpt_tim_cnt                                       (*(volatile uint32_t *)0x60032018)
#define adr_gpt0_gpt_tim_cnt                                                             (0x60032018)
#define mask_gpt0_gpt_tim_cnt_tim_cnta                               (0xffff0000)                    
#define mask_gpt0_gpt_tim_cnt_tim_cntb                               (0xffff)                        

#define reg_gpt0_gpt_tim_compare                                   (*(volatile uint32_t *)0x6003201c)
#define adr_gpt0_gpt_tim_compare                                                         (0x6003201c)

#define reg_gpt0_gpt_tim_capcnt_32bit                              (*(volatile uint32_t *)0x60032020)
#define adr_gpt0_gpt_tim_capcnt_32bit                                                    (0x60032020)
#define mask_gpt0_gpt_tim_capcnt_32bit_tim_cnt32_capcnt              (0xffffffff)                    

#define reg_gpt0_gpt_tim_capcnt_a                                  (*(volatile uint32_t *)0x60032024)
#define adr_gpt0_gpt_tim_capcnt_a                                                        (0x60032024)
#define mask_gpt0_gpt_tim_capcnt_a_tim_cnta_capcnt                   (0xffff)                        

#define reg_gpt0_gpt_tim_capcnt_b                                  (*(volatile uint32_t *)0x60032028)
#define adr_gpt0_gpt_tim_capcnt_b                                                        (0x60032028)
#define mask_gpt0_gpt_tim_capcnt_b_tim_cntb_capcnt                   (0xffff)                        

#define reg_gpt0_gpt_tim_decinval                                  (*(volatile uint32_t *)0x6003202c)
#define adr_gpt0_gpt_tim_decinval                                                        (0x6003202c)
#define mask_gpt0_gpt_tim_decinval_tim_cnta_decode_intval            (0xff00)                        
#define mask_gpt0_gpt_tim_decinval_tim_cntb_decode_intval            (0xff)                          

#define reg_gpt0_gpt_tim_pwmcnt_low                                (*(volatile uint32_t *)0x60032030)
#define adr_gpt0_gpt_tim_pwmcnt_low                                                      (0x60032030)
#define mask_gpt0_gpt_tim_pwmcnt_low_tim_cnta_pwm_low                (0xffff0000)                    
#define mask_gpt0_gpt_tim_pwmcnt_low_tim_cntb_pwm_low                (0xffff)                        

#define reg_gpt0_gpt_tim_pwmcnt_high                               (*(volatile uint32_t *)0x60032034)
#define adr_gpt0_gpt_tim_pwmcnt_high                                                     (0x60032034)
#define mask_gpt0_gpt_tim_pwmcnt_high_tim_cnta_pwm_high              (0xffff0000)                    
#define mask_gpt0_gpt_tim_pwmcnt_high_tim_cntb_pwm_high              (0xffff)                        

#define reg_gpt0_gpt_tim_cntb_int_status                           (*(volatile uint32_t *)0x60032038)
#define adr_gpt0_gpt_tim_cntb_int_status                                                 (0x60032038)

#define reg_gpt0_gpt_tim_cntb_int_clear                            (*(volatile uint32_t *)0x6003203c)
#define adr_gpt0_gpt_tim_cntb_int_clear                                                  (0x6003203c)

#define reg_gpt0_gpt_tim_cntb_int_mask                             (*(volatile uint32_t *)0x60032040)
#define adr_gpt0_gpt_tim_cntb_int_mask                                                   (0x60032040)
#define mask_gpt0_gpt_tim_cntb_int_mask_tim_cntb_wkup_mask           (0x3e0)                         
#define mask_gpt0_gpt_tim_cntb_int_mask_gpt_cntb_int_mask            (0x1f)                          

#define reg_gpt0_gpt_tim_cnta_int_status                           (*(volatile uint32_t *)0x60032044)
#define adr_gpt0_gpt_tim_cnta_int_status                                                 (0x60032044)

#define reg_gpt0_gpt_tim_cnta_int_clear                            (*(volatile uint32_t *)0x60032048)
#define adr_gpt0_gpt_tim_cnta_int_clear                                                  (0x60032048)

#define reg_gpt0_gpt_tim_cnta_int_mask                             (*(volatile uint32_t *)0x6003204c)
#define adr_gpt0_gpt_tim_cnta_int_mask                                                   (0x6003204c)
#define mask_gpt0_gpt_tim_cnta_int_mask_tim_cnta_wkup_mask           (0x3e0)                         
#define mask_gpt0_gpt_tim_cnta_int_mask_gpt_cnta_int_mask            (0x1f)                          

#define reg_gpt0_gpt_tim_cnta_ctrl                                 (*(volatile uint32_t *)0x60032050)
#define adr_gpt0_gpt_tim_cnta_ctrl                                                       (0x60032050)
#define mask_gpt0_gpt_tim_cnta_ctrl_cnta_cpu_cap_en                  (0x10)                          
#define mask_gpt0_gpt_tim_cnta_ctrl_cnta_sync_start_en               (0x8)                           
#define mask_gpt0_gpt_tim_cnta_ctrl_cnta_sync_stop_en                (0x4)                           
#define mask_gpt0_gpt_tim_cnta_ctrl_cnta_level_instruct_en           (0x2)                           
#define mask_gpt0_gpt_tim_cnta_ctrl_cnta_compare_delay_en            (0x1)                           

#define reg_gpt0_gpt_tim_cntb_ctrl                                 (*(volatile uint32_t *)0x60032054)
#define adr_gpt0_gpt_tim_cntb_ctrl                                                       (0x60032054)
#define mask_gpt0_gpt_tim_cntb_ctrl_cntb_cpu_cap_en                  (0x10)                          
#define mask_gpt0_gpt_tim_cntb_ctrl_cntb_sync_start_en               (0x8)                           
#define mask_gpt0_gpt_tim_cntb_ctrl_cntb_sync_stop_en                (0x4)                           
#define mask_gpt0_gpt_tim_cntb_ctrl_cntb_level_instruct_en           (0x2)                           
#define mask_gpt0_gpt_tim_cntb_ctrl_cntb_compare_delay_en            (0x1)                           

#define reg_gpt0_gpt_tim_cnta_work_flg                             (*(volatile uint32_t *)0x60032058)
#define adr_gpt0_gpt_tim_cnta_work_flg                                                   (0x60032058)
#define mask_gpt0_gpt_tim_cnta_work_flg_cnta_work_flg                (0x2)                           
#define mask_gpt0_gpt_tim_cnta_work_flg_cnta_inc_flg                 (0x1)                           

#define reg_gpt0_gpt_tim_cntb_work_flg                             (*(volatile uint32_t *)0x6003205c)
#define adr_gpt0_gpt_tim_cntb_work_flg                                                   (0x6003205c)
#define mask_gpt0_gpt_tim_cntb_work_flg_cntb_work_flg                (0x2)                           
#define mask_gpt0_gpt_tim_cntb_work_flg_cntb_inc_flg                 (0x1)                           

#define reg_gpt0_wakeup_flg                                        (*(volatile uint32_t *)0x60032060)
#define adr_gpt0_wakeup_flg                                                              (0x60032060)

#define reg_gpt0_ext_cg_en                                         (*(volatile uint32_t *)0x60032084)
#define adr_gpt0_ext_cg_en                                                               (0x60032084)


//---------------------------------------------------
// gpt1 in  domain address definition
//---------------------------------------------------

#define reg_gpt1_gpt_tim_cfgrdy_trig                               (*(volatile uint32_t *)0x60033000)
#define adr_gpt1_gpt_tim_cfgrdy_trig                                                     (0x60033000)
#define mask_gpt1_gpt_tim_cfgrdy_trig_tim_cnta_cfgrdy_trig           (0x2)                           
#define mask_gpt1_gpt_tim_cfgrdy_trig_tim_cntb_cfgrdy_trig           (0x1)                           

#define reg_gpt1_gpt_tim_cfgrdy_flag                               (*(volatile uint32_t *)0x60033004)
#define adr_gpt1_gpt_tim_cfgrdy_flag                                                     (0x60033004)
#define mask_gpt1_gpt_tim_cfgrdy_flag_tim_cnta_cfgrdy_flag           (0x2)                           
#define mask_gpt1_gpt_tim_cfgrdy_flag_tim_cntb_cfgrdy_flag           (0x1)                           

#define reg_gpt1_gpt_tim_cfgrdy_clr                                (*(volatile uint32_t *)0x60033008)
#define adr_gpt1_gpt_tim_cfgrdy_clr                                                      (0x60033008)
#define mask_gpt1_gpt_tim_cfgrdy_clr_tim_cnta_cfgrdy_clr             (0x2)                           
#define mask_gpt1_gpt_tim_cfgrdy_clr_tim_cntb_cfgrdy_clr             (0x1)                           

#define reg_gpt1_gpt_tim_mode                                      (*(volatile uint32_t *)0x6003300c)
#define adr_gpt1_gpt_tim_mode                                                            (0x6003300c)
#define mask_gpt1_gpt_tim_mode_ir_out_1_en                           (0x80)                          
#define mask_gpt1_gpt_tim_mode_ir_out_0_en                           (0x40)                          
#define mask_gpt1_gpt_tim_mode_tim_decode_cap_loop                   (0x20)                          
#define mask_gpt1_gpt_tim_mode_ir_enable                             (0x10)                          
#define mask_gpt1_gpt_tim_mode_ir_pol                                (0x8)                           
#define mask_gpt1_gpt_tim_mode_tim_work_mode                         (0x7)                           

#define reg_gpt1_gpt_tim_config                                    (*(volatile uint32_t *)0x60033010)
#define adr_gpt1_gpt_tim_config                                                          (0x60033010)
#define mask_gpt1_gpt_tim_config_tim_cnta_pwm_enable                 (0x80000000)                    
#define mask_gpt1_gpt_tim_config_tim_cnta_pwm_pol                    (0x40000000)                    
#define mask_gpt1_gpt_tim_config_tim_cnta_decode_enable              (0x20000000)                    
#define mask_gpt1_gpt_tim_config_tim_cnta_decode_gpout_pol           (0x10000000)                    
#define mask_gpt1_gpt_tim_config_tim_cnta_decode_mode_sel            (0xc000000)                     
#define mask_gpt1_gpt_tim_config_tim_cnta_cap_enable                 (0x2000000)                     
#define mask_gpt1_gpt_tim_config_tim_cnta_cap_sig_sel                (0x1000000)                     
#define mask_gpt1_gpt_tim_config_tim_cnta_cap_mode_sel               (0xc00000)                      
#define mask_gpt1_gpt_tim_config_tim_cnta_prescale                   (0x3c0000)                      
#define mask_gpt1_gpt_tim_config_tim_cnta_rst_mode                   (0x20000)                       
#define mask_gpt1_gpt_tim_config_tim_cnta_rstval_mode                (0x10000)                       
#define mask_gpt1_gpt_tim_config_tim_cntb_pwm_enable                 (0x8000)                        
#define mask_gpt1_gpt_tim_config_tim_cntb_pwm_pol                    (0x4000)                        
#define mask_gpt1_gpt_tim_config_tim_cntb_decode_enable              (0x2000)                        
#define mask_gpt1_gpt_tim_config_tim_cntb_decode_gpout_pol           (0x1000)                        
#define mask_gpt1_gpt_tim_config_tim_cntb_decode_mode_sel            (0xc00)                         
#define mask_gpt1_gpt_tim_config_tim_cntb_cap_enable                 (0x200)                         
#define mask_gpt1_gpt_tim_config_tim_cntb_cap_sig_sel                (0x100)                         
#define mask_gpt1_gpt_tim_config_tim_cntb_cap_mode_sel               (0xc0)                          
#define mask_gpt1_gpt_tim_config_tim_cntb_prescale                   (0x3c)                          
#define mask_gpt1_gpt_tim_config_tim_cntb_rst_mode                   (0x2)                           
#define mask_gpt1_gpt_tim_config_tim_cntb_rstval_mode                (0x1)                           

#define reg_gpt1_gpt_tim_trig                                      (*(volatile uint32_t *)0x60033014)
#define adr_gpt1_gpt_tim_trig                                                            (0x60033014)
#define mask_gpt1_gpt_tim_trig_tim_cnta_clr                          (0x40)                          
#define mask_gpt1_gpt_tim_trig_tim_cnta_stop                         (0x20)                          
#define mask_gpt1_gpt_tim_trig_tim_cnta_start                        (0x10)                          
#define mask_gpt1_gpt_tim_trig_tim_cntb_clr                          (0x4)                           
#define mask_gpt1_gpt_tim_trig_tim_cntb_stop                         (0x2)                           
#define mask_gpt1_gpt_tim_trig_tim_cntb_start                        (0x1)                           

#define reg_gpt1_gpt_tim_cnt                                       (*(volatile uint32_t *)0x60033018)
#define adr_gpt1_gpt_tim_cnt                                                             (0x60033018)
#define mask_gpt1_gpt_tim_cnt_tim_cnta                               (0xffff0000)                    
#define mask_gpt1_gpt_tim_cnt_tim_cntb                               (0xffff)                        

#define reg_gpt1_gpt_tim_compare                                   (*(volatile uint32_t *)0x6003301c)
#define adr_gpt1_gpt_tim_compare                                                         (0x6003301c)

#define reg_gpt1_gpt_tim_capcnt_32bit                              (*(volatile uint32_t *)0x60033020)
#define adr_gpt1_gpt_tim_capcnt_32bit                                                    (0x60033020)
#define mask_gpt1_gpt_tim_capcnt_32bit_tim_cnt32_capcnt              (0xffffffff)                    

#define reg_gpt1_gpt_tim_capcnt_a                                  (*(volatile uint32_t *)0x60033024)
#define adr_gpt1_gpt_tim_capcnt_a                                                        (0x60033024)
#define mask_gpt1_gpt_tim_capcnt_a_tim_cnta_capcnt                   (0xffff)                        

#define reg_gpt1_gpt_tim_capcnt_b                                  (*(volatile uint32_t *)0x60033028)
#define adr_gpt1_gpt_tim_capcnt_b                                                        (0x60033028)
#define mask_gpt1_gpt_tim_capcnt_b_tim_cntb_capcnt                   (0xffff)                        

#define reg_gpt1_gpt_tim_decinval                                  (*(volatile uint32_t *)0x6003302c)
#define adr_gpt1_gpt_tim_decinval                                                        (0x6003302c)
#define mask_gpt1_gpt_tim_decinval_tim_cnta_decode_intval            (0xff00)                        
#define mask_gpt1_gpt_tim_decinval_tim_cntb_decode_intval            (0xff)                          

#define reg_gpt1_gpt_tim_pwmcnt_low                                (*(volatile uint32_t *)0x60033030)
#define adr_gpt1_gpt_tim_pwmcnt_low                                                      (0x60033030)
#define mask_gpt1_gpt_tim_pwmcnt_low_tim_cnta_pwm_low                (0xffff0000)                    
#define mask_gpt1_gpt_tim_pwmcnt_low_tim_cntb_pwm_low                (0xffff)                        

#define reg_gpt1_gpt_tim_pwmcnt_high                               (*(volatile uint32_t *)0x60033034)
#define adr_gpt1_gpt_tim_pwmcnt_high                                                     (0x60033034)
#define mask_gpt1_gpt_tim_pwmcnt_high_tim_cnta_pwm_high              (0xffff0000)                    
#define mask_gpt1_gpt_tim_pwmcnt_high_tim_cntb_pwm_high              (0xffff)                        

#define reg_gpt1_gpt_tim_cntb_int_status                           (*(volatile uint32_t *)0x60033038)
#define adr_gpt1_gpt_tim_cntb_int_status                                                 (0x60033038)

#define reg_gpt1_gpt_tim_cntb_int_clear                            (*(volatile uint32_t *)0x6003303c)
#define adr_gpt1_gpt_tim_cntb_int_clear                                                  (0x6003303c)

#define reg_gpt1_gpt_tim_cntb_int_mask                             (*(volatile uint32_t *)0x60033040)
#define adr_gpt1_gpt_tim_cntb_int_mask                                                   (0x60033040)
#define mask_gpt1_gpt_tim_cntb_int_mask_tim_cntb_wkup_mask           (0x3e0)                         
#define mask_gpt1_gpt_tim_cntb_int_mask_gpt_cntb_int_mask            (0x1f)                          

#define reg_gpt1_gpt_tim_cnta_int_status                           (*(volatile uint32_t *)0x60033044)
#define adr_gpt1_gpt_tim_cnta_int_status                                                 (0x60033044)

#define reg_gpt1_gpt_tim_cnta_int_clear                            (*(volatile uint32_t *)0x60033048)
#define adr_gpt1_gpt_tim_cnta_int_clear                                                  (0x60033048)

#define reg_gpt1_gpt_tim_cnta_int_mask                             (*(volatile uint32_t *)0x6003304c)
#define adr_gpt1_gpt_tim_cnta_int_mask                                                   (0x6003304c)
#define mask_gpt1_gpt_tim_cnta_int_mask_tim_cnta_wkup_mask           (0x3e0)                         
#define mask_gpt1_gpt_tim_cnta_int_mask_gpt_cnta_int_mask            (0x1f)                          

#define reg_gpt1_gpt_tim_cnta_ctrl                                 (*(volatile uint32_t *)0x60033050)
#define adr_gpt1_gpt_tim_cnta_ctrl                                                       (0x60033050)
#define mask_gpt1_gpt_tim_cnta_ctrl_cnta_cpu_cap_en                  (0x10)                          
#define mask_gpt1_gpt_tim_cnta_ctrl_cnta_sync_start_en               (0x8)                           
#define mask_gpt1_gpt_tim_cnta_ctrl_cnta_sync_stop_en                (0x4)                           
#define mask_gpt1_gpt_tim_cnta_ctrl_cnta_level_instruct_en           (0x2)                           
#define mask_gpt1_gpt_tim_cnta_ctrl_cnta_compare_delay_en            (0x1)                           

#define reg_gpt1_gpt_tim_cntb_ctrl                                 (*(volatile uint32_t *)0x60033054)
#define adr_gpt1_gpt_tim_cntb_ctrl                                                       (0x60033054)
#define mask_gpt1_gpt_tim_cntb_ctrl_cntb_cpu_cap_en                  (0x10)                          
#define mask_gpt1_gpt_tim_cntb_ctrl_cntb_sync_start_en               (0x8)                           
#define mask_gpt1_gpt_tim_cntb_ctrl_cntb_sync_stop_en                (0x4)                           
#define mask_gpt1_gpt_tim_cntb_ctrl_cntb_level_instruct_en           (0x2)                           
#define mask_gpt1_gpt_tim_cntb_ctrl_cntb_compare_delay_en            (0x1)                           

#define reg_gpt1_gpt_tim_cnta_work_flg                             (*(volatile uint32_t *)0x60033058)
#define adr_gpt1_gpt_tim_cnta_work_flg                                                   (0x60033058)
#define mask_gpt1_gpt_tim_cnta_work_flg_cnta_work_flg                (0x2)                           
#define mask_gpt1_gpt_tim_cnta_work_flg_cnta_inc_flg                 (0x1)                           

#define reg_gpt1_gpt_tim_cntb_work_flg                             (*(volatile uint32_t *)0x6003305c)
#define adr_gpt1_gpt_tim_cntb_work_flg                                                   (0x6003305c)
#define mask_gpt1_gpt_tim_cntb_work_flg_cntb_work_flg                (0x2)                           
#define mask_gpt1_gpt_tim_cntb_work_flg_cntb_inc_flg                 (0x1)                           

#define reg_gpt1_wakeup_flg                                        (*(volatile uint32_t *)0x60033060)
#define adr_gpt1_wakeup_flg                                                              (0x60033060)

#define reg_gpt1_ext_cg_en                                         (*(volatile uint32_t *)0x60033084)
#define adr_gpt1_ext_cg_en                                                               (0x60033084)


//---------------------------------------------------
// gpt2 in  domain address definition
//---------------------------------------------------

#define reg_gpt2_gpt_tim_cfgrdy_trig                               (*(volatile uint32_t *)0x6003b000)
#define adr_gpt2_gpt_tim_cfgrdy_trig                                                     (0x6003b000)
#define mask_gpt2_gpt_tim_cfgrdy_trig_tim_cnta_cfgrdy_trig           (0x2)                           
#define mask_gpt2_gpt_tim_cfgrdy_trig_tim_cntb_cfgrdy_trig           (0x1)                           

#define reg_gpt2_gpt_tim_cfgrdy_flag                               (*(volatile uint32_t *)0x6003b004)
#define adr_gpt2_gpt_tim_cfgrdy_flag                                                     (0x6003b004)
#define mask_gpt2_gpt_tim_cfgrdy_flag_tim_cnta_cfgrdy_flag           (0x2)                           
#define mask_gpt2_gpt_tim_cfgrdy_flag_tim_cntb_cfgrdy_flag           (0x1)                           

#define reg_gpt2_gpt_tim_cfgrdy_clr                                (*(volatile uint32_t *)0x6003b008)
#define adr_gpt2_gpt_tim_cfgrdy_clr                                                      (0x6003b008)
#define mask_gpt2_gpt_tim_cfgrdy_clr_tim_cnta_cfgrdy_clr             (0x2)                           
#define mask_gpt2_gpt_tim_cfgrdy_clr_tim_cntb_cfgrdy_clr             (0x1)                           

#define reg_gpt2_gpt_tim_mode                                      (*(volatile uint32_t *)0x6003b00c)
#define adr_gpt2_gpt_tim_mode                                                            (0x6003b00c)
#define mask_gpt2_gpt_tim_mode_ir_out_1_en                           (0x80)                          
#define mask_gpt2_gpt_tim_mode_ir_out_0_en                           (0x40)                          
#define mask_gpt2_gpt_tim_mode_tim_decode_cap_loop                   (0x20)                          
#define mask_gpt2_gpt_tim_mode_ir_enable                             (0x10)                          
#define mask_gpt2_gpt_tim_mode_ir_pol                                (0x8)                           
#define mask_gpt2_gpt_tim_mode_tim_work_mode                         (0x7)                           

#define reg_gpt2_gpt_tim_config                                    (*(volatile uint32_t *)0x6003b010)
#define adr_gpt2_gpt_tim_config                                                          (0x6003b010)
#define mask_gpt2_gpt_tim_config_tim_cnta_pwm_enable                 (0x80000000)                    
#define mask_gpt2_gpt_tim_config_tim_cnta_pwm_pol                    (0x40000000)                    
#define mask_gpt2_gpt_tim_config_tim_cnta_decode_enable              (0x20000000)                    
#define mask_gpt2_gpt_tim_config_tim_cnta_decode_gpout_pol           (0x10000000)                    
#define mask_gpt2_gpt_tim_config_tim_cnta_decode_mode_sel            (0xc000000)                     
#define mask_gpt2_gpt_tim_config_tim_cnta_cap_enable                 (0x2000000)                     
#define mask_gpt2_gpt_tim_config_tim_cnta_cap_sig_sel                (0x1000000)                     
#define mask_gpt2_gpt_tim_config_tim_cnta_cap_mode_sel               (0xc00000)                      
#define mask_gpt2_gpt_tim_config_tim_cnta_prescale                   (0x3c0000)                      
#define mask_gpt2_gpt_tim_config_tim_cnta_rst_mode                   (0x20000)                       
#define mask_gpt2_gpt_tim_config_tim_cnta_rstval_mode                (0x10000)                       
#define mask_gpt2_gpt_tim_config_tim_cntb_pwm_enable                 (0x8000)                        
#define mask_gpt2_gpt_tim_config_tim_cntb_pwm_pol                    (0x4000)                        
#define mask_gpt2_gpt_tim_config_tim_cntb_decode_enable              (0x2000)                        
#define mask_gpt2_gpt_tim_config_tim_cntb_decode_gpout_pol           (0x1000)                        
#define mask_gpt2_gpt_tim_config_tim_cntb_decode_mode_sel            (0xc00)                         
#define mask_gpt2_gpt_tim_config_tim_cntb_cap_enable                 (0x200)                         
#define mask_gpt2_gpt_tim_config_tim_cntb_cap_sig_sel                (0x100)                         
#define mask_gpt2_gpt_tim_config_tim_cntb_cap_mode_sel               (0xc0)                          
#define mask_gpt2_gpt_tim_config_tim_cntb_prescale                   (0x3c)                          
#define mask_gpt2_gpt_tim_config_tim_cntb_rst_mode                   (0x2)                           
#define mask_gpt2_gpt_tim_config_tim_cntb_rstval_mode                (0x1)                           

#define reg_gpt2_gpt_tim_trig                                      (*(volatile uint32_t *)0x6003b014)
#define adr_gpt2_gpt_tim_trig                                                            (0x6003b014)
#define mask_gpt2_gpt_tim_trig_tim_cnta_clr                          (0x40)                          
#define mask_gpt2_gpt_tim_trig_tim_cnta_stop                         (0x20)                          
#define mask_gpt2_gpt_tim_trig_tim_cnta_start                        (0x10)                          
#define mask_gpt2_gpt_tim_trig_tim_cntb_clr                          (0x4)                           
#define mask_gpt2_gpt_tim_trig_tim_cntb_stop                         (0x2)                           
#define mask_gpt2_gpt_tim_trig_tim_cntb_start                        (0x1)                           

#define reg_gpt2_gpt_tim_cnt                                       (*(volatile uint32_t *)0x6003b018)
#define adr_gpt2_gpt_tim_cnt                                                             (0x6003b018)
#define mask_gpt2_gpt_tim_cnt_tim_cnta                               (0xffff0000)                    
#define mask_gpt2_gpt_tim_cnt_tim_cntb                               (0xffff)                        

#define reg_gpt2_gpt_tim_compare                                   (*(volatile uint32_t *)0x6003b01c)
#define adr_gpt2_gpt_tim_compare                                                         (0x6003b01c)

#define reg_gpt2_gpt_tim_capcnt_32bit                              (*(volatile uint32_t *)0x6003b020)
#define adr_gpt2_gpt_tim_capcnt_32bit                                                    (0x6003b020)
#define mask_gpt2_gpt_tim_capcnt_32bit_tim_cnt32_capcnt              (0xffffffff)                    

#define reg_gpt2_gpt_tim_capcnt_a                                  (*(volatile uint32_t *)0x6003b024)
#define adr_gpt2_gpt_tim_capcnt_a                                                        (0x6003b024)
#define mask_gpt2_gpt_tim_capcnt_a_tim_cnta_capcnt                   (0xffff)                        

#define reg_gpt2_gpt_tim_capcnt_b                                  (*(volatile uint32_t *)0x6003b028)
#define adr_gpt2_gpt_tim_capcnt_b                                                        (0x6003b028)
#define mask_gpt2_gpt_tim_capcnt_b_tim_cntb_capcnt                   (0xffff)                        

#define reg_gpt2_gpt_tim_decinval                                  (*(volatile uint32_t *)0x6003b02c)
#define adr_gpt2_gpt_tim_decinval                                                        (0x6003b02c)
#define mask_gpt2_gpt_tim_decinval_tim_cnta_decode_intval            (0xff00)                        
#define mask_gpt2_gpt_tim_decinval_tim_cntb_decode_intval            (0xff)                          

#define reg_gpt2_gpt_tim_pwmcnt_low                                (*(volatile uint32_t *)0x6003b030)
#define adr_gpt2_gpt_tim_pwmcnt_low                                                      (0x6003b030)
#define mask_gpt2_gpt_tim_pwmcnt_low_tim_cnta_pwm_low                (0xffff0000)                    
#define mask_gpt2_gpt_tim_pwmcnt_low_tim_cntb_pwm_low                (0xffff)                        

#define reg_gpt2_gpt_tim_pwmcnt_high                               (*(volatile uint32_t *)0x6003b034)
#define adr_gpt2_gpt_tim_pwmcnt_high                                                     (0x6003b034)
#define mask_gpt2_gpt_tim_pwmcnt_high_tim_cnta_pwm_high              (0xffff0000)                    
#define mask_gpt2_gpt_tim_pwmcnt_high_tim_cntb_pwm_high              (0xffff)                        

#define reg_gpt2_gpt_tim_cntb_int_status                           (*(volatile uint32_t *)0x6003b038)
#define adr_gpt2_gpt_tim_cntb_int_status                                                 (0x6003b038)

#define reg_gpt2_gpt_tim_cntb_int_clear                            (*(volatile uint32_t *)0x6003b03c)
#define adr_gpt2_gpt_tim_cntb_int_clear                                                  (0x6003b03c)

#define reg_gpt2_gpt_tim_cntb_int_mask                             (*(volatile uint32_t *)0x6003b040)
#define adr_gpt2_gpt_tim_cntb_int_mask                                                   (0x6003b040)
#define mask_gpt2_gpt_tim_cntb_int_mask_tim_cntb_wkup_mask           (0x3e0)                         
#define mask_gpt2_gpt_tim_cntb_int_mask_gpt_cntb_int_mask            (0x1f)                          

#define reg_gpt2_gpt_tim_cnta_int_status                           (*(volatile uint32_t *)0x6003b044)
#define adr_gpt2_gpt_tim_cnta_int_status                                                 (0x6003b044)

#define reg_gpt2_gpt_tim_cnta_int_clear                            (*(volatile uint32_t *)0x6003b048)
#define adr_gpt2_gpt_tim_cnta_int_clear                                                  (0x6003b048)

#define reg_gpt2_gpt_tim_cnta_int_mask                             (*(volatile uint32_t *)0x6003b04c)
#define adr_gpt2_gpt_tim_cnta_int_mask                                                   (0x6003b04c)
#define mask_gpt2_gpt_tim_cnta_int_mask_tim_cnta_wkup_mask           (0x3e0)                         
#define mask_gpt2_gpt_tim_cnta_int_mask_gpt_cnta_int_mask            (0x1f)                          

#define reg_gpt2_gpt_tim_cnta_ctrl                                 (*(volatile uint32_t *)0x6003b050)
#define adr_gpt2_gpt_tim_cnta_ctrl                                                       (0x6003b050)
#define mask_gpt2_gpt_tim_cnta_ctrl_cnta_cpu_cap_en                  (0x10)                          
#define mask_gpt2_gpt_tim_cnta_ctrl_cnta_sync_start_en               (0x8)                           
#define mask_gpt2_gpt_tim_cnta_ctrl_cnta_sync_stop_en                (0x4)                           
#define mask_gpt2_gpt_tim_cnta_ctrl_cnta_level_instruct_en           (0x2)                           
#define mask_gpt2_gpt_tim_cnta_ctrl_cnta_compare_delay_en            (0x1)                           

#define reg_gpt2_gpt_tim_cntb_ctrl                                 (*(volatile uint32_t *)0x6003b054)
#define adr_gpt2_gpt_tim_cntb_ctrl                                                       (0x6003b054)
#define mask_gpt2_gpt_tim_cntb_ctrl_cntb_cpu_cap_en                  (0x10)                          
#define mask_gpt2_gpt_tim_cntb_ctrl_cntb_sync_start_en               (0x8)                           
#define mask_gpt2_gpt_tim_cntb_ctrl_cntb_sync_stop_en                (0x4)                           
#define mask_gpt2_gpt_tim_cntb_ctrl_cntb_level_instruct_en           (0x2)                           
#define mask_gpt2_gpt_tim_cntb_ctrl_cntb_compare_delay_en            (0x1)                           

#define reg_gpt2_gpt_tim_cnta_work_flg                             (*(volatile uint32_t *)0x6003b058)
#define adr_gpt2_gpt_tim_cnta_work_flg                                                   (0x6003b058)
#define mask_gpt2_gpt_tim_cnta_work_flg_cnta_work_flg                (0x2)                           
#define mask_gpt2_gpt_tim_cnta_work_flg_cnta_inc_flg                 (0x1)                           

#define reg_gpt2_gpt_tim_cntb_work_flg                             (*(volatile uint32_t *)0x6003b05c)
#define adr_gpt2_gpt_tim_cntb_work_flg                                                   (0x6003b05c)
#define mask_gpt2_gpt_tim_cntb_work_flg_cntb_work_flg                (0x2)                           
#define mask_gpt2_gpt_tim_cntb_work_flg_cntb_inc_flg                 (0x1)                           

#define reg_gpt2_wakeup_flg                                        (*(volatile uint32_t *)0x6003b060)
#define adr_gpt2_wakeup_flg                                                              (0x6003b060)

#define reg_gpt2_ext_cg_en                                         (*(volatile uint32_t *)0x6003b084)
#define adr_gpt2_ext_cg_en                                                               (0x6003b084)


//---------------------------------------------------
// gpt3 in  domain address definition
//---------------------------------------------------

#define reg_gpt3_gpt_tim_cfgrdy_trig                               (*(volatile uint32_t *)0x6003c000)
#define adr_gpt3_gpt_tim_cfgrdy_trig                                                     (0x6003c000)
#define mask_gpt3_gpt_tim_cfgrdy_trig_tim_cnta_cfgrdy_trig           (0x2)                           
#define mask_gpt3_gpt_tim_cfgrdy_trig_tim_cntb_cfgrdy_trig           (0x1)                           

#define reg_gpt3_gpt_tim_cfgrdy_flag                               (*(volatile uint32_t *)0x6003c004)
#define adr_gpt3_gpt_tim_cfgrdy_flag                                                     (0x6003c004)
#define mask_gpt3_gpt_tim_cfgrdy_flag_tim_cnta_cfgrdy_flag           (0x2)                           
#define mask_gpt3_gpt_tim_cfgrdy_flag_tim_cntb_cfgrdy_flag           (0x1)                           

#define reg_gpt3_gpt_tim_cfgrdy_clr                                (*(volatile uint32_t *)0x6003c008)
#define adr_gpt3_gpt_tim_cfgrdy_clr                                                      (0x6003c008)
#define mask_gpt3_gpt_tim_cfgrdy_clr_tim_cnta_cfgrdy_clr             (0x2)                           
#define mask_gpt3_gpt_tim_cfgrdy_clr_tim_cntb_cfgrdy_clr             (0x1)                           

#define reg_gpt3_gpt_tim_mode                                      (*(volatile uint32_t *)0x6003c00c)
#define adr_gpt3_gpt_tim_mode                                                            (0x6003c00c)
#define mask_gpt3_gpt_tim_mode_ir_out_1_en                           (0x80)                          
#define mask_gpt3_gpt_tim_mode_ir_out_0_en                           (0x40)                          
#define mask_gpt3_gpt_tim_mode_tim_decode_cap_loop                   (0x20)                          
#define mask_gpt3_gpt_tim_mode_ir_enable                             (0x10)                          
#define mask_gpt3_gpt_tim_mode_ir_pol                                (0x8)                           
#define mask_gpt3_gpt_tim_mode_tim_work_mode                         (0x7)                           

#define reg_gpt3_gpt_tim_config                                    (*(volatile uint32_t *)0x6003c010)
#define adr_gpt3_gpt_tim_config                                                          (0x6003c010)
#define mask_gpt3_gpt_tim_config_tim_cnta_pwm_enable                 (0x80000000)                    
#define mask_gpt3_gpt_tim_config_tim_cnta_pwm_pol                    (0x40000000)                    
#define mask_gpt3_gpt_tim_config_tim_cnta_decode_enable              (0x20000000)                    
#define mask_gpt3_gpt_tim_config_tim_cnta_decode_gpout_pol           (0x10000000)                    
#define mask_gpt3_gpt_tim_config_tim_cnta_decode_mode_sel            (0xc000000)                     
#define mask_gpt3_gpt_tim_config_tim_cnta_cap_enable                 (0x2000000)                     
#define mask_gpt3_gpt_tim_config_tim_cnta_cap_sig_sel                (0x1000000)                     
#define mask_gpt3_gpt_tim_config_tim_cnta_cap_mode_sel               (0xc00000)                      
#define mask_gpt3_gpt_tim_config_tim_cnta_prescale                   (0x3c0000)                      
#define mask_gpt3_gpt_tim_config_tim_cnta_rst_mode                   (0x20000)                       
#define mask_gpt3_gpt_tim_config_tim_cnta_rstval_mode                (0x10000)                       
#define mask_gpt3_gpt_tim_config_tim_cntb_pwm_enable                 (0x8000)                        
#define mask_gpt3_gpt_tim_config_tim_cntb_pwm_pol                    (0x4000)                        
#define mask_gpt3_gpt_tim_config_tim_cntb_decode_enable              (0x2000)                        
#define mask_gpt3_gpt_tim_config_tim_cntb_decode_gpout_pol           (0x1000)                        
#define mask_gpt3_gpt_tim_config_tim_cntb_decode_mode_sel            (0xc00)                         
#define mask_gpt3_gpt_tim_config_tim_cntb_cap_enable                 (0x200)                         
#define mask_gpt3_gpt_tim_config_tim_cntb_cap_sig_sel                (0x100)                         
#define mask_gpt3_gpt_tim_config_tim_cntb_cap_mode_sel               (0xc0)                          
#define mask_gpt3_gpt_tim_config_tim_cntb_prescale                   (0x3c)                          
#define mask_gpt3_gpt_tim_config_tim_cntb_rst_mode                   (0x2)                           
#define mask_gpt3_gpt_tim_config_tim_cntb_rstval_mode                (0x1)                           

#define reg_gpt3_gpt_tim_trig                                      (*(volatile uint32_t *)0x6003c014)
#define adr_gpt3_gpt_tim_trig                                                            (0x6003c014)
#define mask_gpt3_gpt_tim_trig_tim_cnta_clr                          (0x40)                          
#define mask_gpt3_gpt_tim_trig_tim_cnta_stop                         (0x20)                          
#define mask_gpt3_gpt_tim_trig_tim_cnta_start                        (0x10)                          
#define mask_gpt3_gpt_tim_trig_tim_cntb_clr                          (0x4)                           
#define mask_gpt3_gpt_tim_trig_tim_cntb_stop                         (0x2)                           
#define mask_gpt3_gpt_tim_trig_tim_cntb_start                        (0x1)                           

#define reg_gpt3_gpt_tim_cnt                                       (*(volatile uint32_t *)0x6003c018)
#define adr_gpt3_gpt_tim_cnt                                                             (0x6003c018)
#define mask_gpt3_gpt_tim_cnt_tim_cnta                               (0xffff0000)                    
#define mask_gpt3_gpt_tim_cnt_tim_cntb                               (0xffff)                        

#define reg_gpt3_gpt_tim_compare                                   (*(volatile uint32_t *)0x6003c01c)
#define adr_gpt3_gpt_tim_compare                                                         (0x6003c01c)

#define reg_gpt3_gpt_tim_capcnt_32bit                              (*(volatile uint32_t *)0x6003c020)
#define adr_gpt3_gpt_tim_capcnt_32bit                                                    (0x6003c020)
#define mask_gpt3_gpt_tim_capcnt_32bit_tim_cnt32_capcnt              (0xffffffff)                    

#define reg_gpt3_gpt_tim_capcnt_a                                  (*(volatile uint32_t *)0x6003c024)
#define adr_gpt3_gpt_tim_capcnt_a                                                        (0x6003c024)
#define mask_gpt3_gpt_tim_capcnt_a_tim_cnta_capcnt                   (0xffff)                        

#define reg_gpt3_gpt_tim_capcnt_b                                  (*(volatile uint32_t *)0x6003c028)
#define adr_gpt3_gpt_tim_capcnt_b                                                        (0x6003c028)
#define mask_gpt3_gpt_tim_capcnt_b_tim_cntb_capcnt                   (0xffff)                        

#define reg_gpt3_gpt_tim_decinval                                  (*(volatile uint32_t *)0x6003c02c)
#define adr_gpt3_gpt_tim_decinval                                                        (0x6003c02c)
#define mask_gpt3_gpt_tim_decinval_tim_cnta_decode_intval            (0xff00)                        
#define mask_gpt3_gpt_tim_decinval_tim_cntb_decode_intval            (0xff)                          

#define reg_gpt3_gpt_tim_pwmcnt_low                                (*(volatile uint32_t *)0x6003c030)
#define adr_gpt3_gpt_tim_pwmcnt_low                                                      (0x6003c030)
#define mask_gpt3_gpt_tim_pwmcnt_low_tim_cnta_pwm_low                (0xffff0000)                    
#define mask_gpt3_gpt_tim_pwmcnt_low_tim_cntb_pwm_low                (0xffff)                        

#define reg_gpt3_gpt_tim_pwmcnt_high                               (*(volatile uint32_t *)0x6003c034)
#define adr_gpt3_gpt_tim_pwmcnt_high                                                     (0x6003c034)
#define mask_gpt3_gpt_tim_pwmcnt_high_tim_cnta_pwm_high              (0xffff0000)                    
#define mask_gpt3_gpt_tim_pwmcnt_high_tim_cntb_pwm_high              (0xffff)                        

#define reg_gpt3_gpt_tim_cntb_int_status                           (*(volatile uint32_t *)0x6003c038)
#define adr_gpt3_gpt_tim_cntb_int_status                                                 (0x6003c038)

#define reg_gpt3_gpt_tim_cntb_int_clear                            (*(volatile uint32_t *)0x6003c03c)
#define adr_gpt3_gpt_tim_cntb_int_clear                                                  (0x6003c03c)

#define reg_gpt3_gpt_tim_cntb_int_mask                             (*(volatile uint32_t *)0x6003c040)
#define adr_gpt3_gpt_tim_cntb_int_mask                                                   (0x6003c040)
#define mask_gpt3_gpt_tim_cntb_int_mask_tim_cntb_wkup_mask           (0x3e0)                         
#define mask_gpt3_gpt_tim_cntb_int_mask_gpt_cntb_int_mask            (0x1f)                          

#define reg_gpt3_gpt_tim_cnta_int_status                           (*(volatile uint32_t *)0x6003c044)
#define adr_gpt3_gpt_tim_cnta_int_status                                                 (0x6003c044)

#define reg_gpt3_gpt_tim_cnta_int_clear                            (*(volatile uint32_t *)0x6003c048)
#define adr_gpt3_gpt_tim_cnta_int_clear                                                  (0x6003c048)

#define reg_gpt3_gpt_tim_cnta_int_mask                             (*(volatile uint32_t *)0x6003c04c)
#define adr_gpt3_gpt_tim_cnta_int_mask                                                   (0x6003c04c)
#define mask_gpt3_gpt_tim_cnta_int_mask_tim_cnta_wkup_mask           (0x3e0)                         
#define mask_gpt3_gpt_tim_cnta_int_mask_gpt_cnta_int_mask            (0x1f)                          

#define reg_gpt3_gpt_tim_cnta_ctrl                                 (*(volatile uint32_t *)0x6003c050)
#define adr_gpt3_gpt_tim_cnta_ctrl                                                       (0x6003c050)
#define mask_gpt3_gpt_tim_cnta_ctrl_cnta_cpu_cap_en                  (0x10)                          
#define mask_gpt3_gpt_tim_cnta_ctrl_cnta_sync_start_en               (0x8)                           
#define mask_gpt3_gpt_tim_cnta_ctrl_cnta_sync_stop_en                (0x4)                           
#define mask_gpt3_gpt_tim_cnta_ctrl_cnta_level_instruct_en           (0x2)                           
#define mask_gpt3_gpt_tim_cnta_ctrl_cnta_compare_delay_en            (0x1)                           

#define reg_gpt3_gpt_tim_cntb_ctrl                                 (*(volatile uint32_t *)0x6003c054)
#define adr_gpt3_gpt_tim_cntb_ctrl                                                       (0x6003c054)
#define mask_gpt3_gpt_tim_cntb_ctrl_cntb_cpu_cap_en                  (0x10)                          
#define mask_gpt3_gpt_tim_cntb_ctrl_cntb_sync_start_en               (0x8)                           
#define mask_gpt3_gpt_tim_cntb_ctrl_cntb_sync_stop_en                (0x4)                           
#define mask_gpt3_gpt_tim_cntb_ctrl_cntb_level_instruct_en           (0x2)                           
#define mask_gpt3_gpt_tim_cntb_ctrl_cntb_compare_delay_en            (0x1)                           

#define reg_gpt3_gpt_tim_cnta_work_flg                             (*(volatile uint32_t *)0x6003c058)
#define adr_gpt3_gpt_tim_cnta_work_flg                                                   (0x6003c058)
#define mask_gpt3_gpt_tim_cnta_work_flg_cnta_work_flg                (0x2)                           
#define mask_gpt3_gpt_tim_cnta_work_flg_cnta_inc_flg                 (0x1)                           

#define reg_gpt3_gpt_tim_cntb_work_flg                             (*(volatile uint32_t *)0x6003c05c)
#define adr_gpt3_gpt_tim_cntb_work_flg                                                   (0x6003c05c)
#define mask_gpt3_gpt_tim_cntb_work_flg_cntb_work_flg                (0x2)                           
#define mask_gpt3_gpt_tim_cntb_work_flg_cntb_inc_flg                 (0x1)                           

#define reg_gpt3_wakeup_flg                                        (*(volatile uint32_t *)0x6003c060)
#define adr_gpt3_wakeup_flg                                                              (0x6003c060)

#define reg_gpt3_ext_cg_en                                         (*(volatile uint32_t *)0x6003c084)
#define adr_gpt3_ext_cg_en                                                               (0x6003c084)


//---------------------------------------------------
// gpioir in  domain address definition
//---------------------------------------------------

#define reg_gpioir_gpio_int_status                                 (*(volatile uint32_t *)0x6004b000)
#define adr_gpioir_gpio_int_status                                                       (0x6004b000)

#define reg_gpioir_gpio_int_mask                                   (*(volatile uint32_t *)0x6004b004)
#define adr_gpioir_gpio_int_mask                                                         (0x6004b004)

#define reg_gpioir_gpio_int_clear                                  (*(volatile uint32_t *)0x6004b008)
#define adr_gpioir_gpio_int_clear                                                        (0x6004b008)

#define reg_gpio_out_status                                        (*(volatile uint32_t *)0x6004b00c)
#define adr_gpio_out_status                                                              (0x6004b00c)

#define reg_gpio_out_set                                           (*(volatile uint32_t *)0x6004b010)
#define adr_gpio_out_set                                                                 (0x6004b010)

#define reg_gpio_out_clear                                         (*(volatile uint32_t *)0x6004b014)
#define adr_gpio_out_clear                                                               (0x6004b014)

#define reg_gpio_int_pol                                           (*(volatile uint32_t *)0x6004b018)
#define adr_gpio_int_pol                                                                 (0x6004b018)

#define reg_gpio_int_edge_nlevel                                   (*(volatile uint32_t *)0x6004b01c)
#define adr_gpio_int_edge_nlevel                                                         (0x6004b01c)

#define reg_gpio_int_both_edge                                     (*(volatile uint32_t *)0x6004b020)
#define adr_gpio_int_both_edge                                                           (0x6004b020)

#define reg_gpio_int0_en                                           (*(volatile uint32_t *)0x6004b024)
#define adr_gpio_int0_en                                                                 (0x6004b024)

#define reg_gpio_int1_en                                           (*(volatile uint32_t *)0x6004b028)
#define adr_gpio_int1_en                                                                 (0x6004b028)

#define reg_gpio_int2_en                                           (*(volatile uint32_t *)0x6004b02c)
#define adr_gpio_int2_en                                                                 (0x6004b02c)

#define reg_gpio_in                                                (*(volatile uint32_t *)0x6004b030)
#define adr_gpio_in                                                                      (0x6004b030)

#define reg_gpio_pwt_pol                                           (*(volatile uint32_t *)0x6004b034)
#define adr_gpio_pwt_pol                                                                 (0x6004b034)

#define reg_gpio_pwt_en                                            (*(volatile uint32_t *)0x6004b038)
#define adr_gpio_pwt_en                                                                  (0x6004b038)

#define reg_gpioir_gpio1_int_status                                (*(volatile uint32_t *)0x6004b080)
#define adr_gpioir_gpio1_int_status                                                      (0x6004b080)

#define reg_gpioir_gpio1_int_mask                                  (*(volatile uint32_t *)0x6004b084)
#define adr_gpioir_gpio1_int_mask                                                        (0x6004b084)

#define reg_gpioir_gpio1_int_clear                                 (*(volatile uint32_t *)0x6004b088)
#define adr_gpioir_gpio1_int_clear                                                       (0x6004b088)

#define reg_gpio1_out_status                                       (*(volatile uint32_t *)0x6004b08c)
#define adr_gpio1_out_status                                                             (0x6004b08c)

#define reg_gpio1_out_set                                          (*(volatile uint32_t *)0x6004b090)
#define adr_gpio1_out_set                                                                (0x6004b090)

#define reg_gpio1_out_clear                                        (*(volatile uint32_t *)0x6004b094)
#define adr_gpio1_out_clear                                                              (0x6004b094)

#define reg_gpio1_int_pol                                          (*(volatile uint32_t *)0x6004b098)
#define adr_gpio1_int_pol                                                                (0x6004b098)

#define reg_gpio1_int_edge_nlevel                                  (*(volatile uint32_t *)0x6004b09c)
#define adr_gpio1_int_edge_nlevel                                                        (0x6004b09c)

#define reg_gpio1_int_both_edge                                    (*(volatile uint32_t *)0x6004b0a0)
#define adr_gpio1_int_both_edge                                                          (0x6004b0a0)

#define reg_gpio1_int0_en                                          (*(volatile uint32_t *)0x6004b0a4)
#define adr_gpio1_int0_en                                                                (0x6004b0a4)

#define reg_gpio1_int1_en                                          (*(volatile uint32_t *)0x6004b0a8)
#define adr_gpio1_int1_en                                                                (0x6004b0a8)

#define reg_gpio1_int2_en                                          (*(volatile uint32_t *)0x6004b0ac)
#define adr_gpio1_int2_en                                                                (0x6004b0ac)

#define reg_gpio1_in                                               (*(volatile uint32_t *)0x6004b0b0)
#define adr_gpio1_in                                                                     (0x6004b0b0)

#define reg_gpio1_pwt_pol                                          (*(volatile uint32_t *)0x6004b0b4)
#define adr_gpio1_pwt_pol                                                                (0x6004b0b4)

#define reg_gpio1_pwt_en                                           (*(volatile uint32_t *)0x6004b0b8)
#define adr_gpio1_pwt_en                                                                 (0x6004b0b8)

#define reg_gpioir_gpio2_int_status                                (*(volatile uint32_t *)0x6004b0bc)
#define adr_gpioir_gpio2_int_status                                                      (0x6004b0bc)

#define reg_gpioir_gpio2_int_mask                                  (*(volatile uint32_t *)0x6004b0c0)
#define adr_gpioir_gpio2_int_mask                                                        (0x6004b0c0)

#define reg_gpioir_gpio2_int_clear                                 (*(volatile uint32_t *)0x6004b0c4)
#define adr_gpioir_gpio2_int_clear                                                       (0x6004b0c4)

#define reg_gpio2_out_status                                       (*(volatile uint32_t *)0x6004b0c8)
#define adr_gpio2_out_status                                                             (0x6004b0c8)

#define reg_gpio2_out_set                                          (*(volatile uint32_t *)0x6004b0cc)
#define adr_gpio2_out_set                                                                (0x6004b0cc)

#define reg_gpio2_out_clear                                        (*(volatile uint32_t *)0x6004b0d0)
#define adr_gpio2_out_clear                                                              (0x6004b0d0)

#define reg_gpio2_int_pol                                          (*(volatile uint32_t *)0x6004b0d4)
#define adr_gpio2_int_pol                                                                (0x6004b0d4)

#define reg_gpio2_int_edge_nlevel                                  (*(volatile uint32_t *)0x6004b0d8)
#define adr_gpio2_int_edge_nlevel                                                        (0x6004b0d8)

#define reg_gpio2_int_both_edge                                    (*(volatile uint32_t *)0x6004b0dc)
#define adr_gpio2_int_both_edge                                                          (0x6004b0dc)

#define reg_gpio2_int0_en                                          (*(volatile uint32_t *)0x6004b0e0)
#define adr_gpio2_int0_en                                                                (0x6004b0e0)

#define reg_gpio2_int1_en                                          (*(volatile uint32_t *)0x6004b0e4)
#define adr_gpio2_int1_en                                                                (0x6004b0e4)

#define reg_gpio2_int2_en                                          (*(volatile uint32_t *)0x6004b0e8)
#define adr_gpio2_int2_en                                                                (0x6004b0e8)

#define reg_gpio2_in                                               (*(volatile uint32_t *)0x6004b0ec)
#define adr_gpio2_in                                                                     (0x6004b0ec)

#define reg_gpio2_pwt_pol                                          (*(volatile uint32_t *)0x6004b0f0)
#define adr_gpio2_pwt_pol                                                                (0x6004b0f0)

#define reg_gpio2_pwt_en                                           (*(volatile uint32_t *)0x6004b0f4)
#define adr_gpio2_pwt_en                                                                 (0x6004b0f4)

#define reg_gpio_pwt_32k_load                                      (*(volatile uint32_t *)0x6004b100)
#define adr_gpio_pwt_32k_load                                                            (0x6004b100)

#define reg_gpio_pwt_deb_config                                    (*(volatile uint32_t *)0x6004b104)
#define adr_gpio_pwt_deb_config                                                          (0x6004b104)
#define mask_gpio_pwt_deb_config_pwt_ms_n32k                         (0x40)                          
#define mask_gpio_pwt_deb_config_pwt_deb                             (0x3f)                          

#define reg_gpio_pwt_wakeup_clr                                    (*(volatile uint32_t *)0x6004b108)
#define adr_gpio_pwt_wakeup_clr                                                          (0x6004b108)

#define reg_gpio_sw_set                                            (*(volatile uint32_t *)0x6004b140)
#define adr_gpio_sw_set                                                                  (0x6004b140)
#define mask_gpio_sw_set_swdio_set                                   (0x2)                           
#define mask_gpio_sw_set_swclk_set                                   (0x1)                           

#define reg_gpio_sw_clr                                            (*(volatile uint32_t *)0x6004b144)
#define adr_gpio_sw_clr                                                                  (0x6004b144)
#define mask_gpio_sw_clr_swdio_clr                                   (0x2)                           
#define mask_gpio_sw_clr_swclk_clr                                   (0x1)                           

#define reg_gpio_swclk_config                                      (*(volatile uint32_t *)0x6004b148)
#define adr_gpio_swclk_config                                                            (0x6004b148)
#define mask_gpio_swclk_config_swclk_cs                              (0x40)                          
#define mask_gpio_swclk_config_swclk_dsh                             (0x20)                          
#define mask_gpio_swclk_config_swclk_dsl                             (0x10)                          
#define mask_gpio_swclk_config_swclk_pu                              (0x8)                           
#define mask_gpio_swclk_config_swclk_pd                              (0x4)                           
#define mask_gpio_swclk_config_swclk_ie                              (0x2)                           
#define mask_gpio_swclk_config_swclk_oe                              (0x1)                           

#define reg_gpio_swdio_config                                      (*(volatile uint32_t *)0x6004b14c)
#define adr_gpio_swdio_config                                                            (0x6004b14c)
#define mask_gpio_swdio_config_swdio_cs                              (0x40)                          
#define mask_gpio_swdio_config_swdio_dsh                             (0x20)                          
#define mask_gpio_swdio_config_swdio_dsl                             (0x10)                          
#define mask_gpio_swdio_config_swdio_pu                              (0x8)                           
#define mask_gpio_swdio_config_swdio_pd                              (0x4)                           
#define mask_gpio_swdio_config_swdio_ie                              (0x2)                           
#define mask_gpio_swdio_config_swdio_oe                              (0x1)                           

#define reg_gpio_sw_in                                             (*(volatile uint32_t *)0x6004b150)
#define adr_gpio_sw_in                                                                   (0x6004b150)
#define mask_gpio_sw_in_swdio_in                                     (0x2)                           
#define mask_gpio_sw_in_swclk_in                                     (0x1)                           

#define reg_gpio_sw_dis                                            (*(volatile uint32_t *)0x6004b154)
#define adr_gpio_sw_dis                                                                  (0x6004b154)

#define reg_gpio_m33_sw_set                                        (*(volatile uint32_t *)0x6004b158)
#define adr_gpio_m33_sw_set                                                              (0x6004b158)
#define mask_gpio_m33_sw_set_m33_swdio_set                           (0x2)                           
#define mask_gpio_m33_sw_set_m33_swclk_set                           (0x1)                           

#define reg_gpio_m33_sw_clr                                        (*(volatile uint32_t *)0x6004b15c)
#define adr_gpio_m33_sw_clr                                                              (0x6004b15c)
#define mask_gpio_m33_sw_clr_m33_swdio_clr                           (0x2)                           
#define mask_gpio_m33_sw_clr_m33_swclk_clr                           (0x1)                           

#define reg_gpio_m33_swclk_config                                  (*(volatile uint32_t *)0x6004b160)
#define adr_gpio_m33_swclk_config                                                        (0x6004b160)
#define mask_gpio_m33_swclk_config_m33_swclk_cs                      (0x40)                          
#define mask_gpio_m33_swclk_config_m33_swclk_dsh                     (0x20)                          
#define mask_gpio_m33_swclk_config_m33_swclk_dsl                     (0x10)                          
#define mask_gpio_m33_swclk_config_m33_swclk_pu                      (0x8)                           
#define mask_gpio_m33_swclk_config_m33_swclk_pd                      (0x4)                           
#define mask_gpio_m33_swclk_config_m33_swclk_ie                      (0x2)                           
#define mask_gpio_m33_swclk_config_m33_swclk_oe                      (0x1)                           

#define reg_gpio_m33_swdio_config                                  (*(volatile uint32_t *)0x6004b164)
#define adr_gpio_m33_swdio_config                                                        (0x6004b164)
#define mask_gpio_m33_swdio_config_m33_swdio_cs                      (0x40)                          
#define mask_gpio_m33_swdio_config_m33_swdio_dsh                     (0x20)                          
#define mask_gpio_m33_swdio_config_m33_swdio_dsl                     (0x10)                          
#define mask_gpio_m33_swdio_config_m33_swdio_pu                      (0x8)                           
#define mask_gpio_m33_swdio_config_m33_swdio_pd                      (0x4)                           
#define mask_gpio_m33_swdio_config_m33_swdio_ie                      (0x2)                           
#define mask_gpio_m33_swdio_config_m33_swdio_oe                      (0x1)                           

#define reg_gpio_m33_sw_in                                         (*(volatile uint32_t *)0x6004b168)
#define adr_gpio_m33_sw_in                                                               (0x6004b168)
#define mask_gpio_m33_sw_in_m33_swdio_in                             (0x2)                           
#define mask_gpio_m33_sw_in_m33_swclk_in                             (0x1)                           

#define reg_gpio_m33_sw_dis                                        (*(volatile uint32_t *)0x6004b16c)
#define adr_gpio_m33_sw_dis                                                              (0x6004b16c)

#define reg_gpio_ext_cg_en                                         (*(volatile uint32_t *)0x6004b170)
#define adr_gpio_ext_cg_en                                                               (0x6004b170)

#define reg_gpio_32k_out_cfg                                       (*(volatile uint32_t *)0x6004b174)
#define adr_gpio_32k_out_cfg                                                             (0x6004b174)
#define mask_gpio_32k_out_cfg_32k_out1_oe                            (0x2)                           
#define mask_gpio_32k_out_cfg_32k_out0_oe                            (0x1)                           

#define reg_gpio_wakeup_source                                     (*(volatile uint32_t *)0x6004b178)
#define adr_gpio_wakeup_source                                                           (0x6004b178)


//---------------------------------------------------
// rtcir in  domain address definition
//---------------------------------------------------

#define reg_rtcir_rtc_int_status                                   (*(volatile uint32_t *)0x6004d000)
#define adr_rtcir_rtc_int_status                                                         (0x6004d000)

#define reg_rtcir_rtc_int_mask                                     (*(volatile uint32_t *)0x6004d004)
#define adr_rtcir_rtc_int_mask                                                           (0x6004d004)

#define reg_rtcir_rtc_int_clr                                      (*(volatile uint32_t *)0x6004d008)
#define adr_rtcir_rtc_int_clr                                                            (0x6004d008)

#define reg_rtc_int_to_cpu_ch_en                                   (*(volatile uint32_t *)0x6004d00c)
#define adr_rtc_int_to_cpu_ch_en                                                         (0x6004d00c)

#define reg_rtc_rd_frz                                             (*(volatile uint32_t *)0x6004d010)
#define adr_rtc_rd_frz                                                                   (0x6004d010)

#define reg_rtc_comp0_hi                                           (*(volatile uint32_t *)0x6004d018)
#define adr_rtc_comp0_hi                                                                 (0x6004d018)

#define reg_rtc_comp0_low                                          (*(volatile uint32_t *)0x6004d01c)
#define adr_rtc_comp0_low                                                                (0x6004d01c)

#define reg_rtc_comp1_hi                                           (*(volatile uint32_t *)0x6004d020)
#define adr_rtc_comp1_hi                                                                 (0x6004d020)

#define reg_rtc_comp1_low                                          (*(volatile uint32_t *)0x6004d024)
#define adr_rtc_comp1_low                                                                (0x6004d024)

#define reg_rtc_comp2_hi                                           (*(volatile uint32_t *)0x6004d028)
#define adr_rtc_comp2_hi                                                                 (0x6004d028)

#define reg_rtc_comp2_low                                          (*(volatile uint32_t *)0x6004d02c)
#define adr_rtc_comp2_low                                                                (0x6004d02c)

#define reg_rtc_comp3_hi                                           (*(volatile uint32_t *)0x6004d030)
#define adr_rtc_comp3_hi                                                                 (0x6004d030)

#define reg_rtc_comp3_low                                          (*(volatile uint32_t *)0x6004d034)
#define adr_rtc_comp3_low                                                                (0x6004d034)

#define reg_rtc_set_load_trig                                      (*(volatile uint32_t *)0x6004d038)
#define adr_rtc_set_load_trig                                                            (0x6004d038)
#define mask_rtc_set_load_trig_wakeup_mask_trig                      (0x10)                          
#define mask_rtc_set_load_trig_comp3_trig                            (0x8)                           
#define mask_rtc_set_load_trig_comp2_trig                            (0x4)                           
#define mask_rtc_set_load_trig_comp1_trig                            (0x2)                           
#define mask_rtc_set_load_trig_comp0_trig                            (0x1)                           

#define reg_rtc_set_flg                                            (*(volatile uint32_t *)0x6004d03c)
#define adr_rtc_set_flg                                                                  (0x6004d03c)

#define reg_rtc_set_flg_clr                                        (*(volatile uint32_t *)0x6004d040)
#define adr_rtc_set_flg_clr                                                              (0x6004d040)
#define mask_rtc_set_flg_clr_prescale_set_clr                        (0x200)                         
#define mask_rtc_set_flg_clr_trigovrflw_trig_cfg_set_clr             (0x100)                         
#define mask_rtc_set_flg_clr_cnt_clr_trig_cfg_set_clr                (0x80)                          
#define mask_rtc_set_flg_clr_stp_trig_cfg_set_clr                    (0x40)                          
#define mask_rtc_set_flg_clr_sta_trig_cfg_set_clr                    (0x20)                          
#define mask_rtc_set_flg_clr_wakeup_mask_set_clr                     (0x10)                          
#define mask_rtc_set_flg_clr_comp3_set_clr                           (0x8)                           
#define mask_rtc_set_flg_clr_comp2_set_clr                           (0x4)                           
#define mask_rtc_set_flg_clr_comp1_set_clr                           (0x2)                           
#define mask_rtc_set_flg_clr_comp0_set_clr                           (0x1)                           

#define reg_rtc_cnt_hi                                             (*(volatile uint32_t *)0x6004d044)
#define adr_rtc_cnt_hi                                                                   (0x6004d044)

#define reg_rtc_cnt_low                                            (*(volatile uint32_t *)0x6004d048)
#define adr_rtc_cnt_low                                                                  (0x6004d048)

#define reg_rtc_cnt_work_flg                                       (*(volatile uint32_t *)0x6004d04c)
#define adr_rtc_cnt_work_flg                                                             (0x6004d04c)

#define reg_rtc_wakeup_flg                                         (*(volatile uint32_t *)0x6004d050)
#define adr_rtc_wakeup_flg                                                               (0x6004d050)
#define mask_rtc_wakeup_flg_chn3_pmu_wakeup_flag                     (0x8)                           
#define mask_rtc_wakeup_flg_chn2_pmu_wakeup_flag                     (0x4)                           
#define mask_rtc_wakeup_flg_chn1_pmu_wakeup_flag                     (0x2)                           
#define mask_rtc_wakeup_flg_chn0_pmu_wakeup_flag                     (0x1)                           

#define reg_rtc_ext_cg_en                                          (*(volatile uint32_t *)0x6004d074)
#define adr_rtc_ext_cg_en                                                                (0x6004d074)


//---------------------------------------------------
// rtc_pdw in  domain address definition
//---------------------------------------------------

#define reg_rtc_pdw_prescale                                       (*(volatile uint32_t *)0x6004d400)
#define adr_rtc_pdw_prescale                                                             (0x6004d400)

#define reg_rtc_pdw_cnt_trig                                       (*(volatile uint32_t *)0x6004d404)
#define adr_rtc_pdw_cnt_trig                                                             (0x6004d404)
#define mask_rtc_pdw_cnt_trig_prescale_trig                          (0x10)                          
#define mask_rtc_pdw_cnt_trig_cnt_trigovrflw                         (0x8)                           
#define mask_rtc_pdw_cnt_trig_cnt_clr                                (0x4)                           
#define mask_rtc_pdw_cnt_trig_cnt_stp                                (0x2)                           
#define mask_rtc_pdw_cnt_trig_cnt_sta                                (0x1)                           

#define reg_rtc_pdw_srst                                           (*(volatile uint32_t *)0x6004d408)
#define adr_rtc_pdw_srst                                                                 (0x6004d408)

#define reg_rtc_pdw_32k_src_sel                                    (*(volatile uint32_t *)0x6004d440)
#define adr_rtc_pdw_32k_src_sel                                                          (0x6004d440)

#define reg_rtc_pdw_dcxolf_en_cfg                                  (*(volatile uint32_t *)0x6004d444)
#define adr_rtc_pdw_dcxolf_en_cfg                                                        (0x6004d444)
#define mask_rtc_pdw_dcxolf_en_cfg_dcxolf_clk_en                     (0x2)                           
#define mask_rtc_pdw_dcxolf_en_cfg_dcxolf_en                         (0x1)                           

#define reg_rtc_pdw_dcxolf_ana_intf                                (*(volatile uint32_t *)0x6004d448)
#define adr_rtc_pdw_dcxolf_ana_intf                                                      (0x6004d448)

#define reg_rtc_pdw_dcxolf_buf_ana_intf                            (*(volatile uint32_t *)0x6004d44c)
#define adr_rtc_pdw_dcxolf_buf_ana_intf                                                  (0x6004d44c)

#define reg_rtc_pdw_32k_src_sel_state                              (*(volatile uint32_t *)0x6004d450)
#define adr_rtc_pdw_32k_src_sel_state                                                    (0x6004d450)

#define reg_rtc_pdw_dcxolf_state                                   (*(volatile uint32_t *)0x6004d454)
#define adr_rtc_pdw_dcxolf_state                                                         (0x6004d454)
#define mask_rtc_pdw_dcxolf_state_dcxolf_clk_en                      (0x2)                           
#define mask_rtc_pdw_dcxolf_state_dcxolf_en                          (0x1)                           

#define reg_rtc_pdw_dcxolf_ana_intf_state                          (*(volatile uint32_t *)0x6004d458)
#define adr_rtc_pdw_dcxolf_ana_intf_state                                                (0x6004d458)
#define mask_rtc_pdw_dcxolf_ana_intf_state_dcxolf_ana_intf           (0x3fffffff)                    

#define reg_rtc_pdw_dcxolf_buf_ana_intf_state                      (*(volatile uint32_t *)0x6004d45c)
#define adr_rtc_pdw_dcxolf_buf_ana_intf_state                                            (0x6004d45c)
#define mask_rtc_pdw_dcxolf_buf_ana_intf_state_dcxolf_buf_ana_intf   (0x3f)                          

#define reg_rtc_pdw_dcxolf_cfg_valid_trig                          (*(volatile uint32_t *)0x6004d460)
#define adr_rtc_pdw_dcxolf_cfg_valid_trig                                                (0x6004d460)
#define mask_rtc_pdw_dcxolf_cfg_valid_trig_dcxolf_clk_en_trig        (0x8)                           
#define mask_rtc_pdw_dcxolf_cfg_valid_trig_dcxolf_en_trig            (0x4)                           
#define mask_rtc_pdw_dcxolf_cfg_valid_trig_dcxolf_ana_intf_trig      (0x2)                           
#define mask_rtc_pdw_dcxolf_cfg_valid_trig_32k_src_sel_trig          (0x1)                           

#define reg_rtc_pdw_ldo_ret_ana_intf                               (*(volatile uint32_t *)0x6004d488)
#define adr_rtc_pdw_ldo_ret_ana_intf                                                     (0x6004d488)
#define mask_rtc_pdw_ldo_ret_ana_intf_ldo_ret                        (0x7)                           

#define reg_rtc_pdw_ldo_ret                                        (*(volatile uint32_t *)0x6004d48c)
#define adr_rtc_pdw_ldo_ret                                                              (0x6004d48c)

#define reg_rtc_pdw_ldo_ret_trig                                   (*(volatile uint32_t *)0x6004d490)
#define adr_rtc_pdw_ldo_ret_trig                                                         (0x6004d490)

#define reg_rtc_pdw_backup_tag                                     (*(volatile uint32_t *)0x6004d4c8)
#define adr_rtc_pdw_backup_tag                                                           (0x6004d4c8)

#define reg_rtc_pdw_backup_tag_state                               (*(volatile uint32_t *)0x6004d4cc)
#define adr_rtc_pdw_backup_tag_state                                                     (0x6004d4cc)
#define mask_rtc_pdw_backup_tag_state_backup_tag                     (0xffffffff)                    

#define reg_rtc_pdw_backup_tag_trig                                (*(volatile uint32_t *)0x6004d4d0)
#define adr_rtc_pdw_backup_tag_trig                                                      (0x6004d4d0)


//---------------------------------------------------
// wdt0 in  domain address definition
//---------------------------------------------------

#define reg_wdt0_wdt_int_status                                    (*(volatile uint32_t *)0x6004e000)
#define adr_wdt0_wdt_int_status                                                          (0x6004e000)

#define reg_wdt0_wdt_int_mask                                      (*(volatile uint32_t *)0x6004e004)
#define adr_wdt0_wdt_int_mask                                                            (0x6004e004)

#define reg_wdt0_wdt_int_clear                                     (*(volatile uint32_t *)0x6004e008)
#define adr_wdt0_wdt_int_clear                                                           (0x6004e008)

#define reg_wdt0_trig_cfg                                          (*(volatile uint32_t *)0x6004e00c)
#define adr_wdt0_trig_cfg                                                                (0x6004e00c)
#define mask_wdt0_trig_cfg_rst_time_trig                             (0x10)                          
#define mask_wdt0_trig_cfg_wen_trig                                  (0x8)                           
#define mask_wdt0_trig_cfg_trigovrflw                                (0x4)                           
#define mask_wdt0_trig_cfg_comp_trig                                 (0x2)                           
#define mask_wdt0_trig_cfg_cnt_clr                                   (0x1)                           

#define reg_wdt0_ctrl                                              (*(volatile uint32_t *)0x6004e010)
#define adr_wdt0_ctrl                                                                    (0x6004e010)
#define mask_wdt0_ctrl_wen                                           (0x7f)                          

#define reg_wdt0_compare                                           (*(volatile uint32_t *)0x6004e014)
#define adr_wdt0_compare                                                                 (0x6004e014)

#define reg_wdt0_cnt_value                                         (*(volatile uint32_t *)0x6004e018)
#define adr_wdt0_cnt_value                                                               (0x6004e018)

#define reg_wdt0_rst_en_ctrl                                       (*(volatile uint32_t *)0x6004e01c)
#define adr_wdt0_rst_en_ctrl                                                             (0x6004e01c)

#define reg_wdt0_rst_gen_time                                      (*(volatile uint32_t *)0x6004e020)
#define adr_wdt0_rst_gen_time                                                            (0x6004e020)

#define reg_wdt0_trig_cfg_vld                                      (*(volatile uint32_t *)0x6004e024)
#define adr_wdt0_trig_cfg_vld                                                            (0x6004e024)

#define reg_wdt0_trig_cfg_vld_clr                                  (*(volatile uint32_t *)0x6004e028)
#define adr_wdt0_trig_cfg_vld_clr                                                        (0x6004e028)

#define reg_wdt0_ext_cg_en                                         (*(volatile uint32_t *)0x6004e02c)
#define adr_wdt0_ext_cg_en                                                               (0x6004e02c)


//---------------------------------------------------
// wdt1 in  domain address definition
//---------------------------------------------------

#define reg_wdt1_wdt_int_status                                    (*(volatile uint32_t *)0x6004e800)
#define adr_wdt1_wdt_int_status                                                          (0x6004e800)

#define reg_wdt1_wdt_int_mask                                      (*(volatile uint32_t *)0x6004e804)
#define adr_wdt1_wdt_int_mask                                                            (0x6004e804)

#define reg_wdt1_wdt_int_clear                                     (*(volatile uint32_t *)0x6004e808)
#define adr_wdt1_wdt_int_clear                                                           (0x6004e808)

#define reg_wdt1_trig_cfg                                          (*(volatile uint32_t *)0x6004e80c)
#define adr_wdt1_trig_cfg                                                                (0x6004e80c)
#define mask_wdt1_trig_cfg_rst_time_trig                             (0x10)                          
#define mask_wdt1_trig_cfg_wen_trig                                  (0x8)                           
#define mask_wdt1_trig_cfg_trigovrflw                                (0x4)                           
#define mask_wdt1_trig_cfg_comp_trig                                 (0x2)                           
#define mask_wdt1_trig_cfg_cnt_clr                                   (0x1)                           

#define reg_wdt1_ctrl                                              (*(volatile uint32_t *)0x6004e810)
#define adr_wdt1_ctrl                                                                    (0x6004e810)
#define mask_wdt1_ctrl_wen                                           (0x7f)                          

#define reg_wdt1_compare                                           (*(volatile uint32_t *)0x6004e814)
#define adr_wdt1_compare                                                                 (0x6004e814)

#define reg_wdt1_cnt_value                                         (*(volatile uint32_t *)0x6004e818)
#define adr_wdt1_cnt_value                                                               (0x6004e818)

#define reg_wdt1_rst_en_ctrl                                       (*(volatile uint32_t *)0x6004e81c)
#define adr_wdt1_rst_en_ctrl                                                             (0x6004e81c)

#define reg_wdt1_rst_gen_time                                      (*(volatile uint32_t *)0x6004e820)
#define adr_wdt1_rst_gen_time                                                            (0x6004e820)

#define reg_wdt1_trig_cfg_vld                                      (*(volatile uint32_t *)0x6004e824)
#define adr_wdt1_trig_cfg_vld                                                            (0x6004e824)

#define reg_wdt1_trig_cfg_vld_clr                                  (*(volatile uint32_t *)0x6004e828)
#define adr_wdt1_trig_cfg_vld_clr                                                        (0x6004e828)

#define reg_wdt1_ext_cg_en                                         (*(volatile uint32_t *)0x6004e82c)
#define adr_wdt1_ext_cg_en                                                               (0x6004e82c)


//---------------------------------------------------
// crg in  domain address definition
//---------------------------------------------------

#define reg_crg_clk_src_ctrl                                         (*(volatile uint32_t *)0x6004f000)
#define adr_crg_clk_src_ctrl                                                               (0x6004f000)
#define mask_crg_clk_src_ctrl_pll_128m_div_val                         (0x30)                          
#define mask_crg_clk_src_ctrl_lp_clk_src_sel                           (0xc)                           
#define mask_crg_clk_src_ctrl_16m_for_32k_en                           (0x2)                           
#define mask_crg_clk_src_ctrl_dcxo_32m_16m_sel                         (0x1)                           

#define reg_crg_sys_clk_src_sel                                      (*(volatile uint32_t *)0x6004f004)
#define adr_crg_sys_clk_src_sel                                                            (0x6004f004)

#define reg_crg_sys_sel                                              (*(volatile uint32_t *)0x6004f008)
#define adr_crg_sys_sel                                                                    (0x6004f008)
#define mask_crg_sys_sel_clk_sys_pll_sel                               (0x8)                           
#define mask_crg_sys_sel_clk_sys_dcxo_div2_sel                         (0x4)                           
#define mask_crg_sys_sel_clk_sys_dcxo_sel                              (0x2)                           
#define mask_crg_sys_sel_clk_sys_rc16m_sel                             (0x1)                           

#define reg_crg_clk_src_div_val_real_sta                             (*(volatile uint32_t *)0x6004f00c)
#define adr_crg_clk_src_div_val_real_sta                                                   (0x6004f00c)
#define mask_crg_clk_src_div_val_real_sta_cpto1_ahb_core_div_val_real  (0x1c000)                       
#define mask_crg_clk_src_div_val_real_sta_cpto0_ahb_core_div_val_real  (0x3800)                        
#define mask_crg_clk_src_div_val_real_sta_ahb_llc_16m_div_val_real     (0x700)                         
#define mask_crg_clk_src_div_val_real_sta_m0_ahb_core_div_val_real     (0xe0)                          
#define mask_crg_clk_src_div_val_real_sta_ahb_apb_div_val_real         (0x1c)                          
#define mask_crg_clk_src_div_val_real_sta_sys_ahb_div_val_real         (0x3)                           

#define reg_crg_clk_div_ctrl0                                        (*(volatile uint32_t *)0x6004f010)
#define adr_crg_clk_div_ctrl0                                                              (0x6004f010)
#define mask_crg_clk_div_ctrl0_cpto1_ahb_core_div_val                  (0xe000000)                     
#define mask_crg_clk_div_ctrl0_sys_div_16m_val                         (0x1c00000)                     
#define mask_crg_clk_div_ctrl0_rc16m_sys_pmu_div_val                   (0x380000)                      
#define mask_crg_clk_div_ctrl0_lp_div_val                              (0x60000)                       
#define mask_crg_clk_div_ctrl0_pwt_lp_div_val                          (0x1c000)                       
#define mask_crg_clk_div_ctrl0_cpto0_ahb_core_div_val                  (0x3800)                        
#define mask_crg_clk_div_ctrl0_ahb_llc_16m_div_val                     (0x700)                         
#define mask_crg_clk_div_ctrl0_m0_ahb_core_div_val                     (0xe0)                          
#define mask_crg_clk_div_ctrl0_ahb_apb_div_val                         (0x1c)                          
#define mask_crg_clk_div_ctrl0_sys_ahb_div_val                         (0x3)                           

#define reg_crg_clk_div_ctrl1                                        (*(volatile uint32_t *)0x6004f014)
#define adr_crg_clk_div_ctrl1                                                              (0x6004f014)
#define mask_crg_clk_div_ctrl1_dcxo_fix_16m_div_val                    (0x3e000000)                    
#define mask_crg_clk_div_ctrl1_ana_test_clk_sel                        (0x1e00000)                     
#define mask_crg_clk_div_ctrl1_sys_div_out_div_val                     (0x1e0000)                      
#define mask_crg_clk_div_ctrl1_gtim3_clk_src_sel                       (0x18000)                       
#define mask_crg_clk_div_ctrl1_gtim2_clk_src_sel                       (0x6000)                        
#define mask_crg_clk_div_ctrl1_gtim1_clk_src_sel                       (0x1800)                        
#define mask_crg_clk_div_ctrl1_gtim0_clk_src_sel                       (0x600)                         
#define mask_crg_clk_div_ctrl1_aud0_clk_src_sel                        (0x100)                         
#define mask_crg_clk_div_ctrl1_sys_div_aud0_val                        (0xff)                          

#define reg_crg_clk_div_ctrl2                                        (*(volatile uint32_t *)0x6004f018)
#define adr_crg_clk_div_ctrl2                                                              (0x6004f018)
#define mask_crg_clk_div_ctrl2_rc48m_div3_en                           (0x20000000)                    
#define mask_crg_clk_div_ctrl2_aud1_clk_src_sel                        (0x10000000)                    
#define mask_crg_clk_div_ctrl2_sys_div_aud1_val                        (0xff00000)                     
#define mask_crg_clk_div_ctrl2_qspi3_sys_clk_src_sel                   (0xc0000)                       
#define mask_crg_clk_div_ctrl2_qspi3_sys_div_val                       (0x38000)                       
#define mask_crg_clk_div_ctrl2_qspi2_sys_clk_src_sel                   (0x6000)                        
#define mask_crg_clk_div_ctrl2_qspi2_sys_div_val                       (0x1c00)                        
#define mask_crg_clk_div_ctrl2_qspi1_sys_clk_src_sel                   (0x300)                         
#define mask_crg_clk_div_ctrl2_qspi1_sys_div_val                       (0xe0)                          
#define mask_crg_clk_div_ctrl2_qspi0_sys_clk_src_sel                   (0x18)                          
#define mask_crg_clk_div_ctrl2_rc16m_qspi0_sys_div_val                 (0x7)                           

#define reg_crg_ext_clk_gate_ctrl0                                   (*(volatile uint32_t *)0x6004f01c)
#define adr_crg_ext_clk_gate_ctrl0                                                         (0x6004f01c)
#define mask_crg_ext_clk_gate_ctrl0_dcxo_32k_out_ext_cg_en             (0x80000000)                    
#define mask_crg_ext_clk_gate_ctrl0_cali_ext_cg_en                     (0x40000000)                    
#define mask_crg_ext_clk_gate_ctrl0_ahb5_ext_cg_en                     (0x20000000)                    
#define mask_crg_ext_clk_gate_ctrl0_ahb4_ext_cg_en                     (0x10000000)                    
#define mask_crg_ext_clk_gate_ctrl0_efuse_ext_cg_en                    (0x8000000)                     
#define mask_crg_ext_clk_gate_ctrl0_rtc_ext_cg_en                      (0x4000000)                     
#define mask_crg_ext_clk_gate_ctrl0_llc_lp_ext_cg_en                   (0x2000000)                     
#define mask_crg_ext_clk_gate_ctrl0_pwt_ext_cg_en                      (0x1000000)                     
#define mask_crg_ext_clk_gate_ctrl0_wdt0_ext_cg_en                     (0x800000)                      
#define mask_crg_ext_clk_gate_ctrl0_qspi3_ext_cg_en                    (0x400000)                      
#define mask_crg_ext_clk_gate_ctrl0_qspi2_ext_cg_en                    (0x200000)                      
#define mask_crg_ext_clk_gate_ctrl0_qspi1_ext_cg_en                    (0x100000)                      
#define mask_crg_ext_clk_gate_ctrl0_qspi0_ext_cg_en                    (0x80000)                       
#define mask_crg_ext_clk_gate_ctrl0_m0_h2h_ahb_ext_cg_en               (0x40000)                       
#define mask_crg_ext_clk_gate_ctrl0_trng_ext_cg_en                     (0x20000)                       
#define mask_crg_ext_clk_gate_ctrl0_cpto0_ext_cg_en                    (0x10000)                       
#define mask_crg_ext_clk_gate_ctrl0_llc_ext_cg_en                      (0x8000)                        
#define mask_crg_ext_clk_gate_ctrl0_aud_adc0_ext_cg_en                 (0x4000)                        
#define mask_crg_ext_clk_gate_ctrl0_gtim3_ext_cg_en                    (0x2000)                        
#define mask_crg_ext_clk_gate_ctrl0_gtim2_ext_cg_en                    (0x1000)                        
#define mask_crg_ext_clk_gate_ctrl0_gtim1_ext_cg_en                    (0x800)                         
#define mask_crg_ext_clk_gate_ctrl0_gtim0_ext_cg_en                    (0x400)                         
#define mask_crg_ext_clk_gate_ctrl0_usb_ext_cg_en                      (0x200)                         
#define mask_crg_ext_clk_gate_ctrl0_qdec_ext_cg_en                     (0x100)                         
#define mask_crg_ext_clk_gate_ctrl0_spi1_ext_cg_en                     (0x80)                          
#define mask_crg_ext_clk_gate_ctrl0_spi0_ext_cg_en                     (0x40)                          
#define mask_crg_ext_clk_gate_ctrl0_i2c2_ext_cg_en                     (0x20)                          
#define mask_crg_ext_clk_gate_ctrl0_i2c1_ext_cg_en                     (0x10)                          
#define mask_crg_ext_clk_gate_ctrl0_i2c0_ext_cg_en                     (0x8)                           
#define mask_crg_ext_clk_gate_ctrl0_uart2_ext_cg_en                    (0x4)                           
#define mask_crg_ext_clk_gate_ctrl0_uart1_ext_cg_en                    (0x2)                           
#define mask_crg_ext_clk_gate_ctrl0_uart0_ext_cg_en                    (0x1)                           

#define reg_crg_ext_clk_gate_ctrl1                                   (*(volatile uint32_t *)0x6004f020)
#define adr_crg_ext_clk_gate_ctrl1                                                         (0x6004f020)
#define mask_crg_ext_clk_gate_ctrl1_cpto1_h2h_ext_cg_en                (0x20000000)                    
#define mask_crg_ext_clk_gate_ctrl1_cpto1_ext_cg_en                    (0x10000000)                    
#define mask_crg_ext_clk_gate_ctrl1_pd_snc_ahb_ext_cg_en               (0x8000000)                     
#define mask_crg_ext_clk_gate_ctrl1_stim1_ext_cg_en                    (0x4000000)                     
#define mask_crg_ext_clk_gate_ctrl1_stim0_ext_cg_en                    (0x2000000)                     
#define mask_crg_ext_clk_gate_ctrl1_wdt1_ext_cg_en                     (0x1000000)                     
#define mask_crg_ext_clk_gate_ctrl1_aud_adc1_ext_cg_en                 (0x800000)                      
#define mask_crg_ext_clk_gate_ctrl1_cpto0_h2h_ext_cg_en                (0x400000)                      
#define mask_crg_ext_clk_gate_ctrl1_i2c3_ext_cg_en                     (0x200000)                      
#define mask_crg_ext_clk_gate_ctrl1_dma_ext_cg_en                      (0x100000)                      
#define mask_crg_ext_clk_gate_ctrl1_rom_ext_cg_en                      (0x80000)                       
#define mask_crg_ext_clk_gate_ctrl1_sram_ext_cg_en                     (0x40000)                       
#define mask_crg_ext_clk_gate_ctrl1_pd_snc_apb_ext_cg_en               (0x20000)                       
#define mask_crg_ext_clk_gate_ctrl1_cic_ext_cg_en                      (0x10000)                       
#define mask_crg_ext_clk_gate_ctrl1_h2p1_ahb_ext_cg_en                 (0x8000)                        
#define mask_crg_ext_clk_gate_ctrl1_pd_mem_ext_cg_en                   (0x4000)                        
#define mask_crg_ext_clk_gate_ctrl1_sys_ctrl_ext_cg_en                 (0x2000)                        
#define mask_crg_ext_clk_gate_ctrl1_pmu_ext_cg_en                      (0x1000)                        
#define mask_crg_ext_clk_gate_ctrl1_gpio_ext_cg_en                     (0x800)                         
#define mask_crg_ext_clk_gate_ctrl1_crg_ext_cg_en                      (0x400)                         
#define mask_crg_ext_clk_gate_ctrl1_m0_ahb_ext_cg_en                   (0x200)                         
#define mask_crg_ext_clk_gate_ctrl1_m0_sys_ext_cg_en                   (0x100)                         
#define mask_crg_ext_clk_gate_ctrl1_sys_div_out_ext_cg_en              (0x80)                          
#define mask_crg_ext_clk_gate_ctrl1_mdm_ext_cg_en                      (0x40)                          
#define mask_crg_ext_clk_gate_ctrl1_sdm_ext_cg_en                      (0x20)                          
#define mask_crg_ext_clk_gate_ctrl1_lo_ext_cg_en                       (0x10)                          
#define mask_crg_ext_clk_gate_ctrl1_fd_ext_cg_en                       (0x8)                           
#define mask_crg_ext_clk_gate_ctrl1_i2s_ext_cg_en                      (0x4)                           
#define mask_crg_ext_clk_gate_ctrl1_m0_dap_ext_cg_en                   (0x2)                           
#define mask_crg_ext_clk_gate_ctrl1_m33_ext_cg_en                      (0x1)                           

#define reg_crg_clk_gate_ctrl0                                       (*(volatile uint32_t *)0x6004f024)
#define adr_crg_clk_gate_ctrl0                                                             (0x6004f024)
#define mask_crg_clk_gate_ctrl0_i2c3_cg_en                             (0x80000000)                    
#define mask_crg_clk_gate_ctrl0_i2c2_cg_en                             (0x40000000)                    
#define mask_crg_clk_gate_ctrl0_i2c1_cg_en                             (0x20000000)                    
#define mask_crg_clk_gate_ctrl0_i2c0_cg_en                             (0x10000000)                    
#define mask_crg_clk_gate_ctrl0_usb_cg_en                              (0x8000000)                     
#define mask_crg_clk_gate_ctrl0_qspi3_cg_en                            (0x4000000)                     
#define mask_crg_clk_gate_ctrl0_qspi2_cg_en                            (0x2000000)                     
#define mask_crg_clk_gate_ctrl0_qspi1_cg_en                            (0x1000000)                     
#define mask_crg_clk_gate_ctrl0_dma_ahb_cg_en                          (0x800000)                      
#define mask_crg_clk_gate_ctrl0_i2s_cg_en                              (0x400000)                      
#define mask_crg_clk_gate_ctrl0_aud_adc1_cg_en                         (0x200000)                      
#define mask_crg_clk_gate_ctrl0_aud_adc0_cg_en                         (0x100000)                      
#define mask_crg_clk_gate_ctrl0_cic_cg_en                              (0x80000)                       
#define mask_crg_clk_gate_ctrl0_trng_cg_en                             (0x40000)                       
#define mask_crg_clk_gate_ctrl0_cali_cg_en                             (0x20000)                       
#define mask_crg_clk_gate_ctrl0_cpto0_cg_en                            (0x10000)                       
#define mask_crg_clk_gate_ctrl0_llc_lp_cg_en                           (0x8000)                        
#define mask_crg_clk_gate_ctrl0_llc_cg_en                              (0x4000)                        
#define mask_crg_clk_gate_ctrl0_mdm_cg_en                              (0x2000)                        
#define mask_crg_clk_gate_ctrl0_sdm_cg_en                              (0x1000)                        
#define mask_crg_clk_gate_ctrl0_lo_cg_en                               (0x800)                         
#define mask_crg_clk_gate_ctrl0_fd_cg_en                               (0x400)                         
#define mask_crg_clk_gate_ctrl0_wdt1_lp_cg_en                          (0x200)                         
#define mask_crg_clk_gate_ctrl0_wdt0_lp_cg_en                          (0x100)                         
#define mask_crg_clk_gate_ctrl0_rtc_rc_32k_cg_en                       (0x80)                          
#define mask_crg_clk_gate_ctrl0_rtc_apb_cg_en                          (0x40)                          
#define mask_crg_clk_gate_ctrl0_stim1_cg_en                            (0x20)                          
#define mask_crg_clk_gate_ctrl0_stim0_cg_en                            (0x10)                          
#define mask_crg_clk_gate_ctrl0_gtim3_cg_en                            (0x8)                           
#define mask_crg_clk_gate_ctrl0_gtim2_cg_en                            (0x4)                           
#define mask_crg_clk_gate_ctrl0_gtim1_cg_en                            (0x2)                           
#define mask_crg_clk_gate_ctrl0_gtim0_cg_en                            (0x1)                           

#define reg_crg_clk_gate_ctrl1                                       (*(volatile uint32_t *)0x6004f028)
#define adr_crg_clk_gate_ctrl1                                                             (0x6004f028)
#define mask_crg_clk_gate_ctrl1_cpto1_cg_en                            (0x200000)                      
#define mask_crg_clk_gate_ctrl1_dcxo_32k_out1_cg_en                    (0x100000)                      
#define mask_crg_clk_gate_ctrl1_dcxo_32k_out0_cg_en                    (0x80000)                       
#define mask_crg_clk_gate_ctrl1_atest_clk_cg_en                        (0x40000)                       
#define mask_crg_clk_gate_ctrl1_sys_div_out_cg_en                      (0x20000)                       
#define mask_crg_clk_gate_ctrl1_qdec_cg_en                             (0x10000)                       
#define mask_crg_clk_gate_ctrl1_spi1_cg_en                             (0x8000)                        
#define mask_crg_clk_gate_ctrl1_spi0_cg_en                             (0x4000)                        
#define mask_crg_clk_gate_ctrl1_uart2_cg_en                            (0x2000)                        
#define mask_crg_clk_gate_ctrl1_uart1_cg_en                            (0x1000)                        
#define mask_crg_clk_gate_ctrl1_uart0_cg_en                            (0x800)                         
#define mask_crg_clk_gate_ctrl1_m0_dap_cg_en                           (0x400)                         
#define mask_crg_clk_gate_ctrl1_m0_cg_en                               (0x200)                         
#define mask_crg_clk_gate_ctrl1_ahb4_cg_en                             (0x100)                         
#define mask_crg_clk_gate_ctrl1_qspi0_cg_en                            (0x80)                          
#define mask_crg_clk_gate_ctrl1_pwt_lp_cg_en                           (0x40)                          
#define mask_crg_clk_gate_ctrl1_gpio_cg_en                             (0x20)                          
#define mask_crg_clk_gate_ctrl1_efuse_cg_en                            (0x10)                          
#define mask_crg_clk_gate_ctrl1_sys_ctrl_cg_en                         (0x8)                           
#define mask_crg_clk_gate_ctrl1_h2p1_ahb_cg_en                         (0x4)                           
#define mask_crg_clk_gate_ctrl1_ahb5_cg_en                             (0x2)                           
#define mask_crg_clk_gate_ctrl1_m33_cg_en                              (0x1)                           

#define reg_crg_soft_reset_ctrl0                                     (*(volatile uint32_t *)0x6004f080)
#define adr_crg_soft_reset_ctrl0                                                           (0x6004f080)
#define mask_crg_soft_reset_ctrl0_i2c3_srst_n                          (0x80000000)                    
#define mask_crg_soft_reset_ctrl0_ahb5_srst_n                          (0x40000000)                    
#define mask_crg_soft_reset_ctrl0_cali_srst_n                          (0x20000000)                    
#define mask_crg_soft_reset_ctrl0_sys_ctrl_srst_n                      (0x10000000)                    
#define mask_crg_soft_reset_ctrl0_rtc_srst_n                           (0x8000000)                     
#define mask_crg_soft_reset_ctrl0_pwt_srst_n                           (0x4000000)                     
#define mask_crg_soft_reset_ctrl0_wdt0_srst_n                          (0x2000000)                     
#define mask_crg_soft_reset_ctrl0_ahb4_srst_n                          (0x1000000)                     
#define mask_crg_soft_reset_ctrl0_dma_srst_n                           (0x800000)                      
#define mask_crg_soft_reset_ctrl0_qspi3_srst_n                         (0x400000)                      
#define mask_crg_soft_reset_ctrl0_qspi2_srst_n                         (0x200000)                      
#define mask_crg_soft_reset_ctrl0_qspi1_srst_n                         (0x100000)                      
#define mask_crg_soft_reset_ctrl0_qspi0_srst_n                         (0x80000)                       
#define mask_crg_soft_reset_ctrl0_gpadc0_srst_n                        (0x40000)                       
#define mask_crg_soft_reset_ctrl0_cic_srst_n                           (0x20000)                       
#define mask_crg_soft_reset_ctrl0_efuse_srst_n                         (0x10000)                       
#define mask_crg_soft_reset_ctrl0_i2s_srst_n                           (0x8000)                        
#define mask_crg_soft_reset_ctrl0_gpio_srst_n                          (0x4000)                        
#define mask_crg_soft_reset_ctrl0_gtim3_srst_n                         (0x2000)                        
#define mask_crg_soft_reset_ctrl0_gtim2_srst_n                         (0x1000)                        
#define mask_crg_soft_reset_ctrl0_gtim1_srst_n                         (0x800)                         
#define mask_crg_soft_reset_ctrl0_gtim0_srst_n                         (0x400)                         
#define mask_crg_soft_reset_ctrl0_usb_srst_n                           (0x200)                         
#define mask_crg_soft_reset_ctrl0_qdec_srst_n                          (0x100)                         
#define mask_crg_soft_reset_ctrl0_spi0_srst_n                          (0x80)                          
#define mask_crg_soft_reset_ctrl0_spi1_srst_n                          (0x40)                          
#define mask_crg_soft_reset_ctrl0_i2c2_srst_n                          (0x20)                          
#define mask_crg_soft_reset_ctrl0_i2c1_srst_n                          (0x10)                          
#define mask_crg_soft_reset_ctrl0_i2c0_srst_n                          (0x8)                           
#define mask_crg_soft_reset_ctrl0_uart2_srst_n                         (0x4)                           
#define mask_crg_soft_reset_ctrl0_uart1_srst_n                         (0x2)                           
#define mask_crg_soft_reset_ctrl0_uart0_srst_n                         (0x1)                           

#define reg_crg_soft_reset_ctrl1                                     (*(volatile uint32_t *)0x6004f084)
#define adr_crg_soft_reset_ctrl1                                                           (0x6004f084)
#define mask_crg_soft_reset_ctrl1_cpto1_srst_n                         (0x200)                         
#define mask_crg_soft_reset_ctrl1_stim1_srst_n                         (0x100)                         
#define mask_crg_soft_reset_ctrl1_stim0_srst_n                         (0x80)                          
#define mask_crg_soft_reset_ctrl1_wdt1_srst_n                          (0x40)                          
#define mask_crg_soft_reset_ctrl1_gpadc1_srst_n                        (0x20)                          
#define mask_crg_soft_reset_ctrl1_trng_srst_n                          (0x10)                          
#define mask_crg_soft_reset_ctrl1_cpto0_srst_n                         (0x8)                           
#define mask_crg_soft_reset_ctrl1_mdm_srst_n                           (0x4)                           
#define mask_crg_soft_reset_ctrl1_llc_srst_n                           (0x2)                           
#define mask_crg_soft_reset_ctrl1_m0_srst_n                            (0x1)                           

#define reg_crg_m33_vect_srst                                        (*(volatile uint32_t *)0x6004f088)
#define adr_crg_m33_vect_srst                                                              (0x6004f088)

#define reg_crg_m0_vect_srst                                         (*(volatile uint32_t *)0x6004f08c)
#define adr_crg_m0_vect_srst                                                               (0x6004f08c)

#define reg_crg_soc_srst_vect                                        (*(volatile uint32_t *)0x6004f090)
#define adr_crg_soc_srst_vect                                                              (0x6004f090)

#define reg_crg_rst_flag                                             (*(volatile uint32_t *)0x6004f094)
#define adr_crg_rst_flag                                                                   (0x6004f094)
#define mask_crg_rst_flag_wdt1_rst_flag                                (0x100)                         
#define mask_crg_rst_flag_pwrup_rst_flag                               (0x80)                          
#define mask_crg_rst_flag_hw_rst_flag                                  (0x40)                          
#define mask_crg_rst_flag_soc_srst_flag                                (0x20)                          
#define mask_crg_rst_flag_wdt0_rst_flag                                (0x10)                          
#define mask_crg_rst_flag_m33_vect_srst_flag                           (0x8)                           
#define mask_crg_rst_flag_m33_sysresetreq_flag                         (0x4)                           
#define mask_crg_rst_flag_m0_vect_srst_flag                            (0x2)                           
#define mask_crg_rst_flag_m0_sysresetreq_flag                          (0x1)                           

#define reg_crg_rst_flag_clr1                                        (*(volatile uint32_t *)0x6004f098)
#define adr_crg_rst_flag_clr1                                                              (0x6004f098)
#define mask_crg_rst_flag_clr1_wdt1_rst_flag_clr                       (0x100)                         
#define mask_crg_rst_flag_clr1_pwrup_rst_flag_clr                      (0x80)                          
#define mask_crg_rst_flag_clr1_hw_rst_flag_clr                         (0x40)                          
#define mask_crg_rst_flag_clr1_soc_srst_flag_clr                       (0x20)                          
#define mask_crg_rst_flag_clr1_wdt0_rst_flag_clr                       (0x10)                          
#define mask_crg_rst_flag_clr1_m33_vect_srst_flag_clr                  (0x8)                           
#define mask_crg_rst_flag_clr1_m33_sysresetreq_flag_clr                (0x4)                           
#define mask_crg_rst_flag_clr1_m0_vect_srst_flag_clr                   (0x2)                           
#define mask_crg_rst_flag_clr1_m0_sysresetreq_flag_clr                 (0x1)                           

#define reg_crg_wdt1_rst_sys_mask                                    (*(volatile uint32_t *)0x6004f09c)
#define adr_crg_wdt1_rst_sys_mask                                                          (0x6004f09c)

#define reg_crg_cali_ctrl                                            (*(volatile uint32_t *)0x6004f100)
#define adr_crg_cali_ctrl                                                                  (0x6004f100)
#define mask_crg_cali_ctrl_xo16m_clk_en_force                          (0x80)                          
#define mask_crg_cali_ctrl_cali_speed                                  (0x78)                          
#define mask_crg_cali_ctrl_cali_src_sel                                (0x4)                           
#define mask_crg_cali_ctrl_pmu_cali_en                                 (0x2)                           
#define mask_crg_cali_ctrl_cali_en                                     (0x1)                           

#define reg_crg_cali_32k_prd                                         (*(volatile uint32_t *)0x6004f104)
#define adr_crg_cali_32k_prd                                                               (0x6004f104)

#define reg_crg_test_clk_reuse_en                                    (*(volatile uint32_t *)0x6004f180)
#define adr_crg_test_clk_reuse_en                                                          (0x6004f180)


//---------------------------------------------------
// pmu in  domain address definition
//---------------------------------------------------

#define reg_pmu_lut_rowxx_irq_state                                (*(volatile uint32_t *)0x60050000)
#define adr_pmu_lut_rowxx_irq_state                                                      (0x60050000)

#define reg_pmu_lut_rowxx_irq_clr                                  (*(volatile uint32_t *)0x60050004)
#define adr_pmu_lut_rowxx_irq_clr                                                        (0x60050004)

#define reg_pmu_lut_row00                                          (*(volatile uint32_t *)0x60050008)
#define adr_pmu_lut_row00                                                                (0x60050008)
#define mask_pmu_lut_row00_lut_row00_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row00_lut_row00_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row00_lut_row00_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row00_lut_row00_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row00_lut_row00_trig_id                         (0x7c)                          
#define mask_pmu_lut_row00_lut_row00_trig_sel                        (0x3)                           

#define reg_pmu_lut_row01                                          (*(volatile uint32_t *)0x6005000c)
#define adr_pmu_lut_row01                                                                (0x6005000c)
#define mask_pmu_lut_row01_lut_row01_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row01_lut_row01_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row01_lut_row01_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row01_lut_row01_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row01_lut_row01_trig_id                         (0x7c)                          
#define mask_pmu_lut_row01_lut_row01_trig_sel                        (0x3)                           

#define reg_pmu_lut_row02                                          (*(volatile uint32_t *)0x60050010)
#define adr_pmu_lut_row02                                                                (0x60050010)
#define mask_pmu_lut_row02_lut_row02_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row02_lut_row02_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row02_lut_row02_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row02_lut_row02_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row02_lut_row02_trig_id                         (0x7c)                          
#define mask_pmu_lut_row02_lut_row02_trig_sel                        (0x3)                           

#define reg_pmu_lut_row03                                          (*(volatile uint32_t *)0x60050014)
#define adr_pmu_lut_row03                                                                (0x60050014)
#define mask_pmu_lut_row03_lut_row03_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row03_lut_row03_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row03_lut_row03_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row03_lut_row03_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row03_lut_row03_trig_id                         (0x7c)                          
#define mask_pmu_lut_row03_lut_row03_trig_sel                        (0x3)                           

#define reg_pmu_lut_row04                                          (*(volatile uint32_t *)0x60050018)
#define adr_pmu_lut_row04                                                                (0x60050018)
#define mask_pmu_lut_row04_lut_row04_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row04_lut_row04_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row04_lut_row04_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row04_lut_row04_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row04_lut_row04_trig_id                         (0x7c)                          
#define mask_pmu_lut_row04_lut_row04_trig_sel                        (0x3)                           

#define reg_pmu_lut_row05                                          (*(volatile uint32_t *)0x6005001c)
#define adr_pmu_lut_row05                                                                (0x6005001c)
#define mask_pmu_lut_row05_lut_row05_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row05_lut_row05_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row05_lut_row05_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row05_lut_row05_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row05_lut_row05_trig_id                         (0x7c)                          
#define mask_pmu_lut_row05_lut_row05_trig_sel                        (0x3)                           

#define reg_pmu_lut_row06                                          (*(volatile uint32_t *)0x60050020)
#define adr_pmu_lut_row06                                                                (0x60050020)
#define mask_pmu_lut_row06_lut_row06_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row06_lut_row06_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row06_lut_row06_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row06_lut_row06_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row06_lut_row06_trig_id                         (0x7c)                          
#define mask_pmu_lut_row06_lut_row06_trig_sel                        (0x3)                           

#define reg_pmu_lut_row07                                          (*(volatile uint32_t *)0x60050024)
#define adr_pmu_lut_row07                                                                (0x60050024)
#define mask_pmu_lut_row07_lut_row07_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row07_lut_row07_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row07_lut_row07_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row07_lut_row07_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row07_lut_row07_trig_id                         (0x7c)                          
#define mask_pmu_lut_row07_lut_row07_trig_sel                        (0x3)                           

#define reg_pmu_lut_row08                                          (*(volatile uint32_t *)0x60050028)
#define adr_pmu_lut_row08                                                                (0x60050028)
#define mask_pmu_lut_row08_lut_row08_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row08_lut_row08_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row08_lut_row08_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row08_lut_row08_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row08_lut_row08_trig_id                         (0x7c)                          
#define mask_pmu_lut_row08_lut_row08_trig_sel                        (0x3)                           

#define reg_pmu_lut_row09                                          (*(volatile uint32_t *)0x6005002c)
#define adr_pmu_lut_row09                                                                (0x6005002c)
#define mask_pmu_lut_row09_lut_row09_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row09_lut_row09_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row09_lut_row09_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row09_lut_row09_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row09_lut_row09_trig_id                         (0x7c)                          
#define mask_pmu_lut_row09_lut_row09_trig_sel                        (0x3)                           

#define reg_pmu_lut_row10                                          (*(volatile uint32_t *)0x60050030)
#define adr_pmu_lut_row10                                                                (0x60050030)
#define mask_pmu_lut_row10_lut_row10_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row10_lut_row10_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row10_lut_row10_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row10_lut_row10_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row10_lut_row10_trig_id                         (0x7c)                          
#define mask_pmu_lut_row10_lut_row10_trig_sel                        (0x3)                           

#define reg_pmu_lut_row11                                          (*(volatile uint32_t *)0x60050034)
#define adr_pmu_lut_row11                                                                (0x60050034)
#define mask_pmu_lut_row11_lut_row11_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row11_lut_row11_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row11_lut_row11_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row11_lut_row11_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row11_lut_row11_trig_id                         (0x7c)                          
#define mask_pmu_lut_row11_lut_row11_trig_sel                        (0x3)                           

#define reg_pmu_lut_row12                                          (*(volatile uint32_t *)0x60050038)
#define adr_pmu_lut_row12                                                                (0x60050038)
#define mask_pmu_lut_row12_lut_row12_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row12_lut_row12_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row12_lut_row12_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row12_lut_row12_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row12_lut_row12_trig_id                         (0x7c)                          
#define mask_pmu_lut_row12_lut_row12_trig_sel                        (0x3)                           

#define reg_pmu_lut_row13                                          (*(volatile uint32_t *)0x6005003c)
#define adr_pmu_lut_row13                                                                (0x6005003c)
#define mask_pmu_lut_row13_lut_row13_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row13_lut_row13_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row13_lut_row13_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row13_lut_row13_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row13_lut_row13_trig_id                         (0x7c)                          
#define mask_pmu_lut_row13_lut_row13_trig_sel                        (0x3)                           

#define reg_pmu_lut_row14                                          (*(volatile uint32_t *)0x60050040)
#define adr_pmu_lut_row14                                                                (0x60050040)
#define mask_pmu_lut_row14_lut_row14_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row14_lut_row14_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row14_lut_row14_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row14_lut_row14_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row14_lut_row14_trig_id                         (0x7c)                          
#define mask_pmu_lut_row14_lut_row14_trig_sel                        (0x3)                           

#define reg_pmu_lut_row15                                          (*(volatile uint32_t *)0x60050044)
#define adr_pmu_lut_row15                                                                (0x60050044)
#define mask_pmu_lut_row15_lut_row15_action_m33_irq_en               (0x400)                         
#define mask_pmu_lut_row15_lut_row15_action_m0p_irq_en               (0x200)                         
#define mask_pmu_lut_row15_lut_row15_action_en_xtal                  (0x100)                         
#define mask_pmu_lut_row15_lut_row15_action_en_pd_sys                (0x80)                          
#define mask_pmu_lut_row15_lut_row15_trig_id                         (0x7c)                          
#define mask_pmu_lut_row15_lut_row15_trig_sel                        (0x3)                           

#define reg_pmu_power_mode_on_th                                   (*(volatile uint32_t *)0x60050048)
#define adr_pmu_power_mode_on_th                                                         (0x60050048)
#define mask_pmu_power_mode_on_th_ldo_dcdc_on_th                     (0xff00)                        
#define mask_pmu_power_mode_on_th_ldo_dig_on_th                      (0xff)                          

#define reg_pmu_clk_en_together                                    (*(volatile uint32_t *)0x6005004c)
#define adr_pmu_clk_en_together                                                          (0x6005004c)

#define reg_pmu_power_mode_off_th                                  (*(volatile uint32_t *)0x60050050)
#define adr_pmu_power_mode_off_th                                                        (0x60050050)
#define mask_pmu_power_mode_off_th_ldo_dcdc_off_th                   (0xff)                          

#define reg_pmu_buck_act_lp                                        (*(volatile uint32_t *)0x60050054)
#define adr_pmu_buck_act_lp                                                              (0x60050054)
#define mask_pmu_buck_act_lp_buck_act2lp_tim                         (0x2)                           
#define mask_pmu_buck_act_lp_buck_lp2act_tim                         (0x1)                           

#define reg_pmu_power_psw_th                                       (*(volatile uint32_t *)0x60050058)
#define adr_pmu_power_psw_th                                                             (0x60050058)
#define mask_pmu_power_psw_th_retpsw_digoff_th                       (0xf0)                          
#define mask_pmu_power_psw_th_digon_retpswn_th                       (0xf)                           

#define reg_pmu_hs_dcxo_stable_th                                  (*(volatile uint32_t *)0x6005005c)
#define adr_pmu_hs_dcxo_stable_th                                                        (0x6005005c)

#define reg_pmu_sram_ret_en                                        (*(volatile uint32_t *)0x60050060)
#define adr_pmu_sram_ret_en                                                              (0x60050060)

#define reg_pmu_power_mode                                         (*(volatile uint32_t *)0x60050064)
#define adr_pmu_power_mode                                                               (0x60050064)
#define mask_pmu_power_mode_sleep_mode                               (0x3)                           

#define reg_pmu_pd_sys_ret_psw                                     (*(volatile uint32_t *)0x60050068)
#define adr_pmu_pd_sys_ret_psw                                                           (0x60050068)

#define reg_pmu_force_sleep                                        (*(volatile uint32_t *)0x6005006c)
#define adr_pmu_force_sleep                                                              (0x6005006c)

#define reg_pmu_buck_act_en                                        (*(volatile uint32_t *)0x60050070)
#define adr_pmu_buck_act_en                                                              (0x60050070)

#define reg_pmu_buck_act_cfg                                       (*(volatile uint32_t *)0x60050074)
#define adr_pmu_buck_act_cfg                                                             (0x60050074)
#define mask_pmu_buck_act_cfg_buck_ocp                               (0x78000000)                    
#define mask_pmu_buck_act_cfg_buck_zcd                               (0x7800000)                     
#define mask_pmu_buck_act_cfg_buck_ton                               (0x700000)                      
#define mask_pmu_buck_act_cfg_buck_pulse                             (0xe0000)                       
#define mask_pmu_buck_act_cfg_buck_bbm                               (0x1c000)                       
#define mask_pmu_buck_act_cfg_buck_hysb                              (0x3000)                        
#define mask_pmu_buck_act_cfg_buck_toff                              (0xe00)                         
#define mask_pmu_buck_act_cfg_buck_ocp_cmp_hys                       (0x1c0)                         
#define mask_pmu_buck_act_cfg_buck_zcd_cmp_hys                       (0x38)                          
#define mask_pmu_buck_act_cfg_buck_do_bbm                            (0x7)                           

#define reg_pmu_buck_act_cfg1                                      (*(volatile uint32_t *)0x60050078)
#define adr_pmu_buck_act_cfg1                                                            (0x60050078)
#define mask_pmu_buck_act_cfg1_buck_fb_l                             (0x3f80)                        
#define mask_pmu_buck_act_cfg1_buck_fb_h                             (0x7f)                          

#define reg_pmu_buck_lp_en                                         (*(volatile uint32_t *)0x6005007c)
#define adr_pmu_buck_lp_en                                                               (0x6005007c)

#define reg_pmu_buck_lp_cfg                                        (*(volatile uint32_t *)0x60050080)
#define adr_pmu_buck_lp_cfg                                                              (0x60050080)
#define mask_pmu_buck_lp_cfg_buck_lp_zcd_h_en                        (0x8)                           
#define mask_pmu_buck_lp_cfg_buck_lp_zcd_l_en                        (0x4)                           
#define mask_pmu_buck_lp_cfg_buck_lp_zcd_h_sel                       (0x2)                           
#define mask_pmu_buck_lp_cfg_buck_lp_zcd_l_sel                       (0x1)                           

#define reg_pmu_buck_lp_cfg1                                       (*(volatile uint32_t *)0x60050084)
#define adr_pmu_buck_lp_cfg1                                                             (0x60050084)
#define mask_pmu_buck_lp_cfg1_buck_lp_n_h                            (0xffff0000)                    
#define mask_pmu_buck_lp_cfg1_buck_lp_n_l                            (0xffff)                        

#define reg_pmu_buck_lp_cfg2                                       (*(volatile uint32_t *)0x60050088)
#define adr_pmu_buck_lp_cfg2                                                             (0x60050088)
#define mask_pmu_buck_lp_cfg2_buck_lp_bbm                            (0x7000000)                     
#define mask_pmu_buck_lp_cfg2_buck_lp_fb_h                           (0xf00000)                      
#define mask_pmu_buck_lp_cfg2_buck_lp_fb_l                           (0xf0000)                       
#define mask_pmu_buck_lp_cfg2_buck_lp_p_h                            (0xff00)                        
#define mask_pmu_buck_lp_cfg2_buck_lp_p_l                            (0xff)                          

#define reg_pmu_buck_lpck_div_val                                  (*(volatile uint32_t *)0x6005008c)
#define adr_pmu_buck_lpck_div_val                                                        (0x6005008c)

#define reg_pmu_ldo_act_en                                         (*(volatile uint32_t *)0x60050090)
#define adr_pmu_ldo_act_en                                                               (0x60050090)

#define reg_pmu_ldo_act                                            (*(volatile uint32_t *)0x60050094)
#define adr_pmu_ldo_act                                                                  (0x60050094)
#define mask_pmu_ldo_act_ldo_act_cfg                                 (0xe)                           
#define mask_pmu_ldo_act_ldo_act_byp                                 (0x1)                           

#define reg_pmu_ldo_1v8_en                                         (*(volatile uint32_t *)0x60050098)
#define adr_pmu_ldo_1v8_en                                                               (0x60050098)

#define reg_pmu_ldo_dig_en                                         (*(volatile uint32_t *)0x6005009c)
#define adr_pmu_ldo_dig_en                                                               (0x6005009c)

#define reg_pmu_ldo_dig                                            (*(volatile uint32_t *)0x600500a0)
#define adr_pmu_ldo_dig                                                                  (0x600500a0)
#define mask_pmu_ldo_dig_ldo_dig_cfg                                 (0xe)                           
#define mask_pmu_ldo_dig_ldo_dig_byp                                 (0x1)                           

#define reg_pmu_ldo_retpsw_n                                       (*(volatile uint32_t *)0x600500a4)
#define adr_pmu_ldo_retpsw_n                                                             (0x600500a4)
#define mask_pmu_ldo_retpsw_n_force_retpsw                           (0x2)                           
#define mask_pmu_ldo_retpsw_n_retpsw_ctrl                            (0x1)                           

#define reg_pmu_ldo_ret                                            (*(volatile uint32_t *)0x600500a8)
#define adr_pmu_ldo_ret                                                                  (0x600500a8)
#define mask_pmu_ldo_ret_ldo_ret_slp_cfg                             (0x38)                          
#define mask_pmu_ldo_ret_ldo_ret_act_cfg                             (0x7)                           

#define reg_pmu_ana_clock                                          (*(volatile uint32_t *)0x600500ac)
#define adr_pmu_ana_clock                                                                (0x600500ac)
#define mask_pmu_ana_clock_pll_on                                    (0x2000)                        
#define mask_pmu_ana_clock_pll_off                                   (0x1000)                        
#define mask_pmu_ana_clock_pll_128m_clk_en                           (0x800)                         
#define mask_pmu_ana_clock_pll_96m_clk_en                            (0x400)                         
#define mask_pmu_ana_clock_pll_128m_clk_dis                          (0x200)                         
#define mask_pmu_ana_clock_pll_96m_clk_dis                           (0x100)                         
#define mask_pmu_ana_clock_dcxo_pwr_on                               (0x80)                          
#define mask_pmu_ana_clock_dcxo_pwr_off                              (0x40)                          
#define mask_pmu_ana_clock_dcxo_clk_en                               (0x20)                          
#define mask_pmu_ana_clock_dcxo_clk_dis                              (0x10)                          
#define mask_pmu_ana_clock_hs_rc_en                                  (0x8)                           
#define mask_pmu_ana_clock_hs_rc_dis                                 (0x4)                           
#define mask_pmu_ana_clock_ls_rc_en                                  (0x2)                           
#define mask_pmu_ana_clock_ls_rc_dis                                 (0x1)                           

#define reg_pmu_clock_state                                        (*(volatile uint32_t *)0x600500b0)
#define adr_pmu_clock_state                                                              (0x600500b0)
#define mask_pmu_clock_state_pll_en                                  (0x80)                          
#define mask_pmu_clock_state_pll_128m_cken                           (0x40)                          
#define mask_pmu_clock_state_pll_96m_cken                            (0x20)                          
#define mask_pmu_clock_state_dcxo_clk_en                             (0x10)                          
#define mask_pmu_clock_state_dcxo_en                                 (0x8)                           
#define mask_pmu_clock_state_hs_rc_cken_st                           (0x4)                           
#define mask_pmu_clock_state_hs_rc_en_st                             (0x2)                           
#define mask_pmu_clock_state_ls_rc_en_st                             (0x1)                           

#define reg_pmu_hs_dcxo_pwr_sel                                    (*(volatile uint32_t *)0x600500b4)
#define adr_pmu_hs_dcxo_pwr_sel                                                          (0x600500b4)

#define reg_pmu_hs_dcxo_ana_intf                                   (*(volatile uint32_t *)0x600500b8)
#define adr_pmu_hs_dcxo_ana_intf                                                         (0x600500b8)
#define mask_pmu_hs_dcxo_ana_intf_dcxo_backup                        (0x3fc00000)                    
#define mask_pmu_hs_dcxo_ana_intf_dcxo_ib                            (0x380000)                      
#define mask_pmu_hs_dcxo_ana_intf_dcxo_ngm                           (0x70000)                       
#define mask_pmu_hs_dcxo_ana_intf_dcxo_capl                          (0xff00)                        
#define mask_pmu_hs_dcxo_ana_intf_dcxo_capr                          (0xff)                          

#define reg_pmu_hs_rc_tune                                         (*(volatile uint32_t *)0x600500bc)
#define adr_pmu_hs_rc_tune                                                               (0x600500bc)

#define reg_pmu_ls_rc_tune                                         (*(volatile uint32_t *)0x600500c0)
#define adr_pmu_ls_rc_tune                                                               (0x600500c0)

#define reg_pmu_pll_cfg                                            (*(volatile uint32_t *)0x600500c4)
#define adr_pmu_pll_cfg                                                                  (0x600500c4)

#define reg_pmu_power_domain_on                                    (*(volatile uint32_t *)0x600500c8)
#define adr_pmu_power_domain_on                                                          (0x600500c8)
#define mask_pmu_power_domain_on_pd_tim_force_on_p                   (0x4)                           
#define mask_pmu_power_domain_on_pd_com_force_on_p                   (0x2)                           
#define mask_pmu_power_domain_on_pd_sys_on_p                         (0x1)                           

#define reg_pmu_power_domain_off                                   (*(volatile uint32_t *)0x600500cc)
#define adr_pmu_power_domain_off                                                         (0x600500cc)
#define mask_pmu_power_domain_off_pd_tim_force_off_p                 (0x4)                           
#define mask_pmu_power_domain_off_pd_com_force_off_p                 (0x2)                           
#define mask_pmu_power_domain_off_pd_sys_off_p                       (0x1)                           

#define reg_pmu_dpsw_ack                                           (*(volatile uint32_t *)0x600500d0)
#define adr_pmu_dpsw_ack                                                                 (0x600500d0)
#define mask_pmu_dpsw_ack_cache_psw_ack                              (0x1000000)                     
#define mask_pmu_dpsw_ack_pd_ret_psw_ack                             (0x800000)                      
#define mask_pmu_dpsw_ack_pd_tim_psw_ack                             (0x400000)                      
#define mask_pmu_dpsw_ack_pd_com_psw_ack                             (0x200000)                      
#define mask_pmu_dpsw_ack_pd_sys_psw_ack                             (0x100000)                      
#define mask_pmu_dpsw_ack_sram_psw_ack                               (0xfffff)                       

#define reg_pmu_code                                               (*(volatile uint32_t *)0x600500d4)
#define adr_pmu_code                                                                     (0x600500d4)
#define mask_pmu_code_c_done                                         (0x2)                           
#define mask_pmu_code_c_flag                                         (0x1)                           

#define reg_pmu_ret_reset_sel                                      (*(volatile uint32_t *)0x600500d8)
#define adr_pmu_ret_reset_sel                                                            (0x600500d8)

#define reg_pmu_phy_iso_sel                                        (*(volatile uint32_t *)0x600500dc)
#define adr_pmu_phy_iso_sel                                                              (0x600500dc)

#define reg_pmu_bg_cfg                                             (*(volatile uint32_t *)0x600500e0)
#define adr_pmu_bg_cfg                                                                   (0x600500e0)

#define reg_pmu_ana_backup                                         (*(volatile uint32_t *)0x600500e4)
#define adr_pmu_ana_backup                                                               (0x600500e4)

#define reg_pmu_test_ctrl                                          (*(volatile uint32_t *)0x600500e8)
#define adr_pmu_test_ctrl                                                                (0x600500e8)

#define reg_pmu_test_en                                            (*(volatile uint32_t *)0x600500ec)
#define adr_pmu_test_en                                                                  (0x600500ec)
#define mask_pmu_test_en_pdon_timeout_en                             (0x4)                           
#define mask_pmu_test_en_wakeup_deb_en                               (0x2)                           
#define mask_pmu_test_en_test_force_en                               (0x1)                           

#define reg_pmu_ana_backup2                                        (*(volatile uint32_t *)0x600500f0)
#define adr_pmu_ana_backup2                                                              (0x600500f0)

#define reg_pmu_ana_sta_backup                                     (*(volatile uint32_t *)0x600500f4)
#define adr_pmu_ana_sta_backup                                                           (0x600500f4)

#define reg_pmu_cdc_cnt                                            (*(volatile uint32_t *)0x600500f8)
#define adr_pmu_cdc_cnt                                                                  (0x600500f8)


//---------------------------------------------------
// sys_ctrl_ret_pd in  domain address definition
//---------------------------------------------------

#define reg_sys_ctrl_ret_pd_m0_addr_remap_ctrl                             (*(volatile uint32_t *)0x60051000)
#define adr_sys_ctrl_ret_pd_m0_addr_remap_ctrl                                                   (0x60051000)
#define mask_sys_ctrl_ret_pd_m0_addr_remap_ctrl_m0_addr_remap_val            (0xfffffc00)                    
#define mask_sys_ctrl_ret_pd_m0_addr_remap_ctrl_m0_addr_remap_end_addr       (0x3fc)                         
#define mask_sys_ctrl_ret_pd_m0_addr_remap_ctrl_m0_addr_remap_ctrl_reserved  (0x2)                           
#define mask_sys_ctrl_ret_pd_m0_addr_remap_ctrl_m0_addr_remap_en             (0x1)                           

#define reg_sys_ctrl_ret_pd_h2h_1d_en                                      (*(volatile uint32_t *)0x60051004)
#define adr_sys_ctrl_ret_pd_h2h_1d_en                                                            (0x60051004)

#define reg_sys_ctrl_ret_pd_sram_timing_cfg0                               (*(volatile uint32_t *)0x60051008)
#define adr_sys_ctrl_ret_pd_sram_timing_cfg0                                                     (0x60051008)
#define mask_sys_ctrl_ret_pd_sram_timing_cfg0_sram_test                      (0x2000)                        
#define mask_sys_ctrl_ret_pd_sram_timing_cfg0_sram_rme                       (0x1000)                        
#define mask_sys_ctrl_ret_pd_sram_timing_cfg0_sram_rm                        (0xf00)                         
#define mask_sys_ctrl_ret_pd_sram_timing_cfg0_sram_ra                        (0xc0)                          
#define mask_sys_ctrl_ret_pd_sram_timing_cfg0_sram_wa                        (0x38)                          
#define mask_sys_ctrl_ret_pd_sram_timing_cfg0_sram_wpulse                    (0x7)                           

#define reg_sys_ctrl_ret_pd_sram_timing_cfg1                               (*(volatile uint32_t *)0x6005100c)
#define adr_sys_ctrl_ret_pd_sram_timing_cfg1                                                     (0x6005100c)
#define mask_sys_ctrl_ret_pd_sram_timing_cfg1_usb_mem_cfg                    (0x7fff)                        

#define reg_sys_ctrl_ret_pd_cache_timing_cfg0                              (*(volatile uint32_t *)0x60051010)
#define adr_sys_ctrl_ret_pd_cache_timing_cfg0                                                    (0x60051010)
#define mask_sys_ctrl_ret_pd_cache_timing_cfg0_cache_test                    (0x2000)                        
#define mask_sys_ctrl_ret_pd_cache_timing_cfg0_cache_rme                     (0x1000)                        
#define mask_sys_ctrl_ret_pd_cache_timing_cfg0_cache_rm                      (0xf00)                         
#define mask_sys_ctrl_ret_pd_cache_timing_cfg0_cache_ra                      (0xc0)                          
#define mask_sys_ctrl_ret_pd_cache_timing_cfg0_cache_wa                      (0x38)                          
#define mask_sys_ctrl_ret_pd_cache_timing_cfg0_cache_wpulse                  (0x7)                           

#define reg_sys_ctrl_device_busy_sta0                                      (*(volatile uint32_t *)0x60051040)
#define adr_sys_ctrl_device_busy_sta0                                                            (0x60051040)

#define reg_sys_ctrl_device_busy_set0                                      (*(volatile uint32_t *)0x60051044)
#define adr_sys_ctrl_device_busy_set0                                                            (0x60051044)

#define reg_sys_ctrl_device_busy_clr0                                      (*(volatile uint32_t *)0x60051048)
#define adr_sys_ctrl_device_busy_clr0                                                            (0x60051048)

#define reg_sys_ctrl_device_busy_sta1                                      (*(volatile uint32_t *)0x6005104c)
#define adr_sys_ctrl_device_busy_sta1                                                            (0x6005104c)

#define reg_sys_ctrl_device_busy_set1                                      (*(volatile uint32_t *)0x60051050)
#define adr_sys_ctrl_device_busy_set1                                                            (0x60051050)

#define reg_sys_ctrl_device_busy_clr1                                      (*(volatile uint32_t *)0x60051054)
#define adr_sys_ctrl_device_busy_clr1                                                            (0x60051054)

#define reg_sys_ctrl_device_busy_sta2                                      (*(volatile uint32_t *)0x60051058)
#define adr_sys_ctrl_device_busy_sta2                                                            (0x60051058)

#define reg_sys_ctrl_device_busy_set2                                      (*(volatile uint32_t *)0x6005105c)
#define adr_sys_ctrl_device_busy_set2                                                            (0x6005105c)

#define reg_sys_ctrl_device_busy_clr2                                      (*(volatile uint32_t *)0x60051060)
#define adr_sys_ctrl_device_busy_clr2                                                            (0x60051060)

#define reg_sys_ctrl_ret_pd_m33_initnsvtor                                 (*(volatile uint32_t *)0x60051064)
#define adr_sys_ctrl_ret_pd_m33_initnsvtor                                                       (0x60051064)

#define reg_sys_ctrl_m0_sw_intr_sta                                        (*(volatile uint32_t *)0x60051080)
#define adr_sys_ctrl_m0_sw_intr_sta                                                              (0x60051080)

#define reg_sys_ctrl_m0_sw_intr_set                                        (*(volatile uint32_t *)0x60051084)
#define adr_sys_ctrl_m0_sw_intr_set                                                              (0x60051084)

#define reg_sys_ctrl_m0_sw_intr_clr                                        (*(volatile uint32_t *)0x60051088)
#define adr_sys_ctrl_m0_sw_intr_clr                                                              (0x60051088)

#define reg_sys_ctrl_m33_sw_intr_sta                                       (*(volatile uint32_t *)0x6005108c)
#define adr_sys_ctrl_m33_sw_intr_sta                                                             (0x6005108c)

#define reg_sys_ctrl_m33_sw_intr_set                                       (*(volatile uint32_t *)0x60051090)
#define adr_sys_ctrl_m33_sw_intr_set                                                             (0x60051090)

#define reg_sys_ctrl_m33_sw_intr_clr                                       (*(volatile uint32_t *)0x60051094)
#define adr_sys_ctrl_m33_sw_intr_clr                                                             (0x60051094)

#define reg_sys_ctrl_ret_pd_perp_int_rut_m0_grp0                           (*(volatile uint32_t *)0x600510c0)
#define adr_sys_ctrl_ret_pd_perp_int_rut_m0_grp0                                                 (0x600510c0)

#define reg_sys_ctrl_ret_pd_perp_int_rut_m33_grp0                          (*(volatile uint32_t *)0x600510c4)
#define adr_sys_ctrl_ret_pd_perp_int_rut_m33_grp0                                                (0x600510c4)

#define reg_sys_ctrl_ret_pd_perp_int_rut_m33_grp1                          (*(volatile uint32_t *)0x600510c8)
#define adr_sys_ctrl_ret_pd_perp_int_rut_m33_grp1                                                (0x600510c8)

#define reg_sys_ctrl_ret_pd_pmu_int_ctrl_mask                              (*(volatile uint32_t *)0x600510cc)
#define adr_sys_ctrl_ret_pd_pmu_int_ctrl_mask                                                    (0x600510cc)
#define mask_sys_ctrl_ret_pd_pmu_int_ctrl_mask_m33_pmu_int_ctrl_mask         (0x2)                           
#define mask_sys_ctrl_ret_pd_pmu_int_ctrl_mask_m0p_pmu_int_ctrl_mask         (0x1)                           

#define reg_sys_ctrl_ret_pd_m33_common0                                    (*(volatile uint32_t *)0x60051100)
#define adr_sys_ctrl_ret_pd_m33_common0                                                          (0x60051100)

#define reg_sys_ctrl_ret_pd_m33_common1                                    (*(volatile uint32_t *)0x60051104)
#define adr_sys_ctrl_ret_pd_m33_common1                                                          (0x60051104)

#define reg_sys_ctrl_ret_pd_m33_common2                                    (*(volatile uint32_t *)0x60051108)
#define adr_sys_ctrl_ret_pd_m33_common2                                                          (0x60051108)

#define reg_sys_ctrl_ret_pd_m33_common3                                    (*(volatile uint32_t *)0x6005110c)
#define adr_sys_ctrl_ret_pd_m33_common3                                                          (0x6005110c)

#define reg_sys_ctrl_ret_pd_m33_common4                                    (*(volatile uint32_t *)0x60051110)
#define adr_sys_ctrl_ret_pd_m33_common4                                                          (0x60051110)

#define reg_sys_ctrl_ret_pd_m33_common5                                    (*(volatile uint32_t *)0x60051114)
#define adr_sys_ctrl_ret_pd_m33_common5                                                          (0x60051114)

#define reg_sys_ctrl_ret_pd_m33_common6                                    (*(volatile uint32_t *)0x60051118)
#define adr_sys_ctrl_ret_pd_m33_common6                                                          (0x60051118)

#define reg_sys_ctrl_gpt_sync_trigger                                      (*(volatile uint32_t *)0x60051140)
#define adr_sys_ctrl_gpt_sync_trigger                                                            (0x60051140)
#define mask_sys_ctrl_gpt_sync_trigger_gpt3_cntb_sync_stop                   (0x8000)                        
#define mask_sys_ctrl_gpt_sync_trigger_gpt3_cntb_sync_start                  (0x4000)                        
#define mask_sys_ctrl_gpt_sync_trigger_gpt3_cnta_sync_stop                   (0x2000)                        
#define mask_sys_ctrl_gpt_sync_trigger_gpt3_cnta_sync_start                  (0x1000)                        
#define mask_sys_ctrl_gpt_sync_trigger_gpt2_cntb_sync_stop                   (0x800)                         
#define mask_sys_ctrl_gpt_sync_trigger_gpt2_cntb_sync_start                  (0x400)                         
#define mask_sys_ctrl_gpt_sync_trigger_gpt2_cnta_sync_stop                   (0x200)                         
#define mask_sys_ctrl_gpt_sync_trigger_gpt2_cnta_sync_start                  (0x100)                         
#define mask_sys_ctrl_gpt_sync_trigger_gpt1_cntb_sync_stop                   (0x80)                          
#define mask_sys_ctrl_gpt_sync_trigger_gpt1_cntb_sync_start                  (0x40)                          
#define mask_sys_ctrl_gpt_sync_trigger_gpt1_cnta_sync_stop                   (0x20)                          
#define mask_sys_ctrl_gpt_sync_trigger_gpt1_cnta_sync_start                  (0x10)                          
#define mask_sys_ctrl_gpt_sync_trigger_gpt0_cntb_sync_stop                   (0x8)                           
#define mask_sys_ctrl_gpt_sync_trigger_gpt0_cntb_sync_start                  (0x4)                           
#define mask_sys_ctrl_gpt_sync_trigger_gpt0_cnta_sync_stop                   (0x2)                           
#define mask_sys_ctrl_gpt_sync_trigger_gpt0_cnta_sync_start                  (0x1)                           

#define reg_sys_ctrl_usb_phy_int_sta                                       (*(volatile uint32_t *)0x60051180)
#define adr_sys_ctrl_usb_phy_int_sta                                                             (0x60051180)

#define reg_sys_ctrl_ret_pd_usb_phy_int_mask                               (*(volatile uint32_t *)0x60051184)
#define adr_sys_ctrl_ret_pd_usb_phy_int_mask                                                     (0x60051184)

#define reg_sys_ctrl_usb_phy_int_clr                                       (*(volatile uint32_t *)0x60051188)
#define adr_sys_ctrl_usb_phy_int_clr                                                             (0x60051188)

#define reg_sys_ctrl_usb_phy_int_event_sta                                 (*(volatile uint32_t *)0x6005118c)
#define adr_sys_ctrl_usb_phy_int_event_sta                                                       (0x6005118c)

#define reg_sys_ctrl_wdt_wakeup_int_sta                                    (*(volatile uint32_t *)0x600511c0)
#define adr_sys_ctrl_wdt_wakeup_int_sta                                                          (0x600511c0)

#define reg_sys_ctrl_ret_pd_wdt_wakeup_int_mask                            (*(volatile uint32_t *)0x600511c4)
#define adr_sys_ctrl_ret_pd_wdt_wakeup_int_mask                                                  (0x600511c4)

#define reg_sys_ctrl_wdt_wakeup_int_clr                                    (*(volatile uint32_t *)0x600511c8)
#define adr_sys_ctrl_wdt_wakeup_int_clr                                                          (0x600511c8)

#define reg_sys_ctrl_ret_pd_m0_stcalib                                     (*(volatile uint32_t *)0x60051200)
#define adr_sys_ctrl_ret_pd_m0_stcalib                                                           (0x60051200)

#define reg_sys_ctrl_ret_pd_m33_nsstcalib                                  (*(volatile uint32_t *)0x60051204)
#define adr_sys_ctrl_ret_pd_m33_nsstcalib                                                        (0x60051204)


//---------------------------------------------------
// stim0 in  domain address definition
//---------------------------------------------------

#define reg_stim0_stim_int_status                                  (*(volatile uint32_t *)0x60052000)
#define adr_stim0_stim_int_status                                                        (0x60052000)

#define reg_stim0_stim_int_mask                                    (*(volatile uint32_t *)0x60052004)
#define adr_stim0_stim_int_mask                                                          (0x60052004)

#define reg_stim0_stim_int_clr                                     (*(volatile uint32_t *)0x60052008)
#define adr_stim0_stim_int_clr                                                           (0x60052008)

#define reg_stim0_int_to_cpu_ch_en                                 (*(volatile uint32_t *)0x6005200c)
#define adr_stim0_int_to_cpu_ch_en                                                       (0x6005200c)

#define reg_stim0_trig_cfg                                         (*(volatile uint32_t *)0x60052010)
#define adr_stim0_trig_cfg                                                               (0x60052010)
#define mask_stim0_trig_cfg_rd_frz                                   (0x10)                          
#define mask_stim0_trig_cfg_trigovrflw                               (0x8)                           
#define mask_stim0_trig_cfg_cnt_clr                                  (0x4)                           
#define mask_stim0_trig_cfg_stp                                      (0x2)                           
#define mask_stim0_trig_cfg_sta                                      (0x1)                           

#define reg_stim0_prescale                                         (*(volatile uint32_t *)0x60052014)
#define adr_stim0_prescale                                                               (0x60052014)

#define reg_stim0_comp0                                            (*(volatile uint32_t *)0x60052018)
#define adr_stim0_comp0                                                                  (0x60052018)

#define reg_stim0_comp1                                            (*(volatile uint32_t *)0x6005201c)
#define adr_stim0_comp1                                                                  (0x6005201c)

#define reg_stim0_comp2                                            (*(volatile uint32_t *)0x60052020)
#define adr_stim0_comp2                                                                  (0x60052020)

#define reg_stim0_comp3                                            (*(volatile uint32_t *)0x60052024)
#define adr_stim0_comp3                                                                  (0x60052024)

#define reg_stim0_set_load_trig                                    (*(volatile uint32_t *)0x60052028)
#define adr_stim0_set_load_trig                                                          (0x60052028)
#define mask_stim0_set_load_trig_wakeup_mask_trig                    (0x20)                          
#define mask_stim0_set_load_trig_prescale_trig                       (0x10)                          
#define mask_stim0_set_load_trig_comp3_trig                          (0x8)                           
#define mask_stim0_set_load_trig_comp2_trig                          (0x4)                           
#define mask_stim0_set_load_trig_comp1_trig                          (0x2)                           
#define mask_stim0_set_load_trig_comp0_trig                          (0x1)                           

#define reg_stim0_set_flg                                          (*(volatile uint32_t *)0x6005202c)
#define adr_stim0_set_flg                                                                (0x6005202c)

#define reg_stim0_set_flg_clr                                      (*(volatile uint32_t *)0x60052030)
#define adr_stim0_set_flg_clr                                                            (0x60052030)
#define mask_stim0_set_flg_clr_trigovrflw_trig_cfg_set_clr           (0x200)                         
#define mask_stim0_set_flg_clr_cnt_clr_trig_cfg_set_clr              (0x100)                         
#define mask_stim0_set_flg_clr_stp_trig_cfg_set_clr                  (0x80)                          
#define mask_stim0_set_flg_clr_sta_trig_cfg_set_clr                  (0x40)                          
#define mask_stim0_set_flg_clr_wakeup_mask_set_clr                   (0x20)                          
#define mask_stim0_set_flg_clr_prescale_set_clr                      (0x10)                          
#define mask_stim0_set_flg_clr_comp3_set_clr                         (0x8)                           
#define mask_stim0_set_flg_clr_comp2_set_clr                         (0x4)                           
#define mask_stim0_set_flg_clr_comp1_set_clr                         (0x2)                           
#define mask_stim0_set_flg_clr_comp0_set_clr                         (0x1)                           

#define reg_stim0_cnt                                              (*(volatile uint32_t *)0x60052034)
#define adr_stim0_cnt                                                                    (0x60052034)

#define reg_stim0_cnt_work_flg                                     (*(volatile uint32_t *)0x60052038)
#define adr_stim0_cnt_work_flg                                                           (0x60052038)

#define reg_stim0_wakeup_flg                                       (*(volatile uint32_t *)0x6005203c)
#define adr_stim0_wakeup_flg                                                             (0x6005203c)
#define mask_stim0_wakeup_flg_chn3_pmu_wakeup_flag                   (0x8)                           
#define mask_stim0_wakeup_flg_chn2_pmu_wakeup_flag                   (0x4)                           
#define mask_stim0_wakeup_flg_chn1_pmu_wakeup_flag                   (0x2)                           
#define mask_stim0_wakeup_flg_chn0_pmu_wakeup_flag                   (0x1)                           

#define reg_stim0_ext_cg_en                                        (*(volatile uint32_t *)0x60052060)
#define adr_stim0_ext_cg_en                                                              (0x60052060)


//---------------------------------------------------
// stim1 in  domain address definition
//---------------------------------------------------

#define reg_stim1_stim_int_status                                  (*(volatile uint32_t *)0x60053000)
#define adr_stim1_stim_int_status                                                        (0x60053000)

#define reg_stim1_stim_int_mask                                    (*(volatile uint32_t *)0x60053004)
#define adr_stim1_stim_int_mask                                                          (0x60053004)

#define reg_stim1_stim_int_clr                                     (*(volatile uint32_t *)0x60053008)
#define adr_stim1_stim_int_clr                                                           (0x60053008)

#define reg_stim1_int_to_cpu_ch_en                                 (*(volatile uint32_t *)0x6005300c)
#define adr_stim1_int_to_cpu_ch_en                                                       (0x6005300c)

#define reg_stim1_trig_cfg                                         (*(volatile uint32_t *)0x60053010)
#define adr_stim1_trig_cfg                                                               (0x60053010)
#define mask_stim1_trig_cfg_rd_frz                                   (0x10)                          
#define mask_stim1_trig_cfg_trigovrflw                               (0x8)                           
#define mask_stim1_trig_cfg_cnt_clr                                  (0x4)                           
#define mask_stim1_trig_cfg_stp                                      (0x2)                           
#define mask_stim1_trig_cfg_sta                                      (0x1)                           

#define reg_stim1_prescale                                         (*(volatile uint32_t *)0x60053014)
#define adr_stim1_prescale                                                               (0x60053014)

#define reg_stim1_comp0                                            (*(volatile uint32_t *)0x60053018)
#define adr_stim1_comp0                                                                  (0x60053018)

#define reg_stim1_comp1                                            (*(volatile uint32_t *)0x6005301c)
#define adr_stim1_comp1                                                                  (0x6005301c)

#define reg_stim1_comp2                                            (*(volatile uint32_t *)0x60053020)
#define adr_stim1_comp2                                                                  (0x60053020)

#define reg_stim1_comp3                                            (*(volatile uint32_t *)0x60053024)
#define adr_stim1_comp3                                                                  (0x60053024)

#define reg_stim1_set_load_trig                                    (*(volatile uint32_t *)0x60053028)
#define adr_stim1_set_load_trig                                                          (0x60053028)
#define mask_stim1_set_load_trig_wakeup_mask_trig                    (0x20)                          
#define mask_stim1_set_load_trig_prescale_trig                       (0x10)                          
#define mask_stim1_set_load_trig_comp3_trig                          (0x8)                           
#define mask_stim1_set_load_trig_comp2_trig                          (0x4)                           
#define mask_stim1_set_load_trig_comp1_trig                          (0x2)                           
#define mask_stim1_set_load_trig_comp0_trig                          (0x1)                           

#define reg_stim1_set_flg                                          (*(volatile uint32_t *)0x6005302c)
#define adr_stim1_set_flg                                                                (0x6005302c)

#define reg_stim1_set_flg_clr                                      (*(volatile uint32_t *)0x60053030)
#define adr_stim1_set_flg_clr                                                            (0x60053030)
#define mask_stim1_set_flg_clr_trigovrflw_trig_cfg_set_clr           (0x200)                         
#define mask_stim1_set_flg_clr_cnt_clr_trig_cfg_set_clr              (0x100)                         
#define mask_stim1_set_flg_clr_stp_trig_cfg_set_clr                  (0x80)                          
#define mask_stim1_set_flg_clr_sta_trig_cfg_set_clr                  (0x40)                          
#define mask_stim1_set_flg_clr_wakeup_mask_set_clr                   (0x20)                          
#define mask_stim1_set_flg_clr_prescale_set_clr                      (0x10)                          
#define mask_stim1_set_flg_clr_comp3_set_clr                         (0x8)                           
#define mask_stim1_set_flg_clr_comp2_set_clr                         (0x4)                           
#define mask_stim1_set_flg_clr_comp1_set_clr                         (0x2)                           
#define mask_stim1_set_flg_clr_comp0_set_clr                         (0x1)                           

#define reg_stim1_cnt                                              (*(volatile uint32_t *)0x60053034)
#define adr_stim1_cnt                                                                    (0x60053034)

#define reg_stim1_cnt_work_flg                                     (*(volatile uint32_t *)0x60053038)
#define adr_stim1_cnt_work_flg                                                           (0x60053038)

#define reg_stim1_wakeup_flg                                       (*(volatile uint32_t *)0x6005303c)
#define adr_stim1_wakeup_flg                                                             (0x6005303c)
#define mask_stim1_wakeup_flg_chn3_pmu_wakeup_flag                   (0x8)                           
#define mask_stim1_wakeup_flg_chn2_pmu_wakeup_flag                   (0x4)                           
#define mask_stim1_wakeup_flg_chn1_pmu_wakeup_flag                   (0x2)                           
#define mask_stim1_wakeup_flg_chn0_pmu_wakeup_flag                   (0x1)                           

#define reg_stim1_ext_cg_en                                        (*(volatile uint32_t *)0x60053060)
#define adr_stim1_ext_cg_en                                                              (0x60053060)

#endif /* __HT32F675X5_REG_H__ */
