/**
 * *************************************************************************************************************
 * @file Afe.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Afe firmware library
 * MCU / CFG Ver. :BH66F2475/1.7
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "Afe.h"
#include "..\board\BoardCfg.h"

void VirefCfg(AfePower_t afePower)
{
    _irefc &= 0xFC;
    _irefc |= afePower.dacRefVol;
    _dacvrefs = afePower.dacVrefSelect;
    _pvref    = afePower.vrefData;
    _irefen   = afePower.irefEn;
}

void Dac1Cfg(DAC_t dac)
{
    _afeda1l = (dac.data << 4) & 0xFF;
    _afeda1h = dac.data >> 4;
    _afeda1c = dac.modeControl;
}

void Dac2Cfg(DAC_t dac)
{
    _afeda2l = (dac.data << 4) & 0xFF;
    _afeda2h = dac.data >> 4;
    _afeda2c = dac.modeControl;
}

void Dac3Cfg(DAC_t dac)
{
    _afeda3l = (dac.data << 4) & 0xFF;
    _afeda3h = dac.data >> 4;
    _afeda3c = dac.modeControl;
}

void Opa1Cfg(OPA_t opa)
{
    // OPA
    _opa1en = opa.enable;
    _gsop1p = opa.enable;
    if(opa.feedbackRes == FB_RES_NOT_CONNECTED)
    {
    	_fbr1c = 0;
    }
    else
    {
	    _fbr1c  = 1;
	    // clang-format off
	    switch (opa.feedbackRes)
	    {
	        case FB_RES_0_5M:  // 0.5MΩ
	            _fbr1s2 = 0; _fbr1s1 = 0; _fbr1s0 = 0; break;
	        case FB_RES_1M:    // 1MΩ
	            _fbr1s2 = 0; _fbr1s1 = 0; _fbr1s0 = 1; break;
	        case FB_RES_2M:    // 2MΩ
	            _fbr1s2 = 0; _fbr1s1 = 1; _fbr1s0 = 0; break;
	        case FB_RES_4M:    // 4MΩ
	            _fbr1s2 = 0; _fbr1s1 = 1; _fbr1s0 = 1; break;
	        case FB_RES_8M:    // 8MΩ
	            _fbr1s2 = 1; _fbr1s1 = 0; _fbr1s0 = 0; break;
	        default:
	            break;
	    }
	    // clang-format on
    }
}

void Opa2Cfg(OPA_t opa)
{
    // OPA
    _opa2en = opa.enable;
    _gsop2p = opa.enable;
    if(opa.feedbackRes == FB_RES_NOT_CONNECTED)
    {
    	_fbr2c = 0;
    }
    else
    {
	    _fbr2c  = 1;
	    // clang-format off
	    switch (opa.feedbackRes)
	    {
	        case FB_RES_0_5M:  // 0.5MΩ
	            _fbr2s2 = 0; _fbr2s1 = 0; _fbr2s0 = 0; break;
	        case FB_RES_1M:    // 1MΩ
	            _fbr2s2 = 0; _fbr2s1 = 0; _fbr2s0 = 1; break;
	        case FB_RES_2M:    // 2MΩ
	            _fbr2s2 = 0; _fbr2s1 = 1; _fbr2s0 = 0; break;
	        case FB_RES_4M:    // 4MΩ
	            _fbr2s2 = 0; _fbr2s1 = 1; _fbr2s0 = 1; break;
	        case FB_RES_8M:    // 8MΩ
	            _fbr2s2 = 1; _fbr2s1 = 0; _fbr2s0 = 0; break;
	        default:
	            break;
	    }
	    // clang-format on
    }
}

void Opa3Cfg(OpaCfg_t opa)
{
    // OPA
    _opa3en = opa.opa3Enable;
    _gsop3p = opa.opa3Enable;
}

void TwoElAfeCfg(AfePower_t afePower, OpaCfg_t opa)
{
    // Viref
    VirefCfg(afePower);

    // DAC1
    Dac1Cfg(afePower.dac1);
    
    // OPA1
    Opa1Cfg(opa.opa1);
}

void ThirdElAfeCfg(AfePower_t afePower, OpaCfg_t opa)
{
//	//test
//	VirefCfg(afePower);
//	Dac1Cfg(afePower.dac1);
//	Dac2Cfg(afePower.dac2);
//	Dac3Cfg(afePower.dac3);
//	Opa1Cfg(opa.opa1);
//	Opa2Cfg(opa.opa2);
//	Opa3Cfg(opa);
//	return;
	
    // Viref
    VirefCfg(afePower);

    // DAC1
    Dac1Cfg(afePower.dac1);
    // DAC3
    Dac3Cfg(afePower.dac3);

    // OPA1
    Opa1Cfg(opa.opa1);
    // OPA3
    Opa3Cfg(opa);
}

void FourElAfeCfg(AfePower_t afePower, OpaCfg_t opa)
{
    // Viref
    VirefCfg(afePower);

    // DAC1
    Dac1Cfg(afePower.dac1);
    // DAC3
    Dac3Cfg(afePower.dac3);
    // DAC2
    Dac2Cfg(afePower.dac2);

    // OPA1
    Opa1Cfg(opa.opa1);
    // OPA3
    Opa3Cfg(opa);
    // OPA2
    Opa2Cfg(opa.opa2);
}

void Disable_AFE()
{
    AfePower_t afePower;
    OpaCfg_t opa;
    afePower.irefEn           = IREF_DISABLE;
    afePower.dac1.modeControl = DAC_MODE_DISABLE_HIGH_Z;
    afePower.dac2.modeControl = DAC_MODE_DISABLE_HIGH_Z;
    afePower.dac3.modeControl = DAC_MODE_DISABLE_HIGH_Z;
    opa.opa1.enable           = OPA_DISABLE;
    opa.opa2.enable           = OPA_DISABLE;
    opa.opa3Enable            = OPA_DISABLE;
    FourElAfeCfg(afePower, opa);
}

// Function to configure Viref
void ConfigureViref(uint8_t data)
{
    AfePower_t afePower;
    afePower.dacRefVol        = DAC_REF_VIREF;
    afePower.dacVrefSelect    = DAC_VREF_1_25V;    // 1.25V or 1.83V
    afePower.vrefData    	  = data;
    afePower.irefEn           = IREF_ENABLE;
    
    VirefCfg(afePower);
}

// Function to configure DAC1
void ConfigureDAC1(uint16_t data)
{
    DAC_t dac = {0};
    dac.modeControl = DAC_MODE_ENABLE;
    dac.data = data;
    Dac1Cfg(dac);
}

// Function to configure DAC1
void ConfigureDAC2(uint16_t data)
{
    DAC_t dac = {0};
    dac.modeControl = DAC_MODE_ENABLE;
    dac.data = data;
    Dac2Cfg(dac);
}

// Function to configure DAC1
void ConfigureDAC3(uint16_t data)
{
    DAC_t dac = {0};
    dac.modeControl = DAC_MODE_ENABLE;
    dac.data = data;
    Dac3Cfg(dac);
}

/*
// ThirdElAfeCfg Demo
void main()
{
    // Determine whether it is a power-on reset or a reset under abnormal conditions,
    // If it is a power-on reset, perform power-on reset initialization, otherwise perform WDT overflow initialization
    if (_to == 0 || _pdf == 0)
    {
        // system init
        ...

        // ThirdElAfeCfg afePower
        AfePower_t afePower;
        afePower.dacRefVol        = DAC_REF_VIREF;
        afePower.dacVrefSelect    = DAC_VREF_1_25V;    // 1.25V or 1.83V
        afePower.dacVrefSelect    = 0x80;
        afePower.irefEn           = IREF_ENABLE;
        afePower.dac1.modeControl = DAC_MODE_ENABLE;
        afePower.dac1.data        = 1638;    // 500mV Vref=1.25V 500/1250*4095 = 1638; Vref=1.83V 500/1830*4095 = 1118
        afePower.dac3.modeControl = DAC_MODE_ENABLE;
        afePower.dac3.data        = 1474;    // 450mV Vref=1.25V 450/1250*4095 = 1474; Vref=1.83V 450/1830*4095 = 1007

        // ThirdElAfeCfg opa
        OpaCfg_t opa;
        opa.opa1.enable       = OPA_ENABLE;
        opa.opa1.feedbackConn = FB_CONNECTED;
        opa.opa1.feedbackRes  = FB_RES_8M;
        opa.opa3Enable        = OPA_ENABLE;

        ThirdElAfeCfg(afePower, opa);
    }
    else
    {
        // WDT Overflow Return First Start
        GCC_CLRWDT();
    }
    while (1)
    {
        GCC_CLRWDT();
    }
}
*/
