/**
 * *************************************************************************************************************
 * @file Afe.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2024-12-17
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Afe firmware library
 * MCU / CFG Ver. :BH66F2455/1.1
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _AFE_H_
#define _AFE_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "stdbool.h"
#include "BH66F2455.h"
#include "AfePower.h"

/*! Enumeration for OPA enable/disable control */
typedef enum {
    OPA_DISABLE = 0x00,    // OPA Disable
    OPA_ENABLE  = 0x01     // OPA Enable
} OpaEnable_e;

/*! Enumeration for OPA feedback resistor values */
typedef enum {
    FB_RES_NOT_CONNECTED = 0xFF,
    FB_RES_0_5M          = 0x00,    // 0.5MΩ
    FB_RES_1M            = 0x01,    // 1MΩ
    FB_RES_2M            = 0x02,    // 2MΩ
    FB_RES_4M            = 0x03,    // 4MΩ
    FB_RES_8M            = 0x04,    // 8MΩ
} OpaFeedbackResistor_e;

/*! Structure for Operational Amplifier (OPA) settings */
typedef struct {
    uint8_t enable;         //!< OPA enable/disable control @see OpaEnable_e
    uint8_t feedbackRes;    //!< OPAn feedback resistor value setting @see OpaFeedbackResistor_e
} OPA_t;

/*! Structure for AFE settings */
typedef struct {
    OPA_t opa1;            //!< Control structure for Operational Amplifier 1
    OPA_t opa2;            //!< Control structure for Operational Amplifier 2
    uint8_t opa3Enable;    //!< OPA3 enable/disable control @see OpaEnable_e
} OpaCfg_t;

/* Exported functions --------------------------------------------------------------------------------------*/
void ConfigureViref(uint8_t data);
void ConfigureDAC1(uint16_t data);
void ConfigureDAC2(uint16_t data);
void ConfigureDAC3(uint16_t data);
void VirefCfg(AfePower_t afePower);
void TwoElAfeCfg(AfePower_t afePower, OpaCfg_t opa);
void ThirdElAfeCfg(AfePower_t afePower, OpaCfg_t opa);
void FourElAfeCfg(AfePower_t afePower, OpaCfg_t opa);
void Disable_AFE();

#endif
