/**
 * *************************************************************************************************************
 * @file Oscillators.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2024-12-11
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Oscillators firmware library
 * MCU / CFG Ver. :BH66F2455/1.1
 * Version = 1.0.0
 * # 主要功能
 *  * 系统频率使用fH
 *  * 若有LXT功能，Cpu关闭时默认开启，方便作为RTC计时
 *  * 对于有HXT、LXT的MCU，若使能了HXT、LXT，但硬件异常可能造成MCU WDT溢出
 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "..\board\BoardCfg.h"
#include "Oscillators.h"
#include "BH66F2455.h"

/* *
 * @ Brief Configure system frequency
 * @ 
 * @ 
 */
void Oscillators_Cfg(Oscillators_Cfg_t *cfg)
{
    _scc  = cfg->haltMode;
    _ircc = cfg->irc2;
    while (!_ircf);    // Wait HIRC or MIRC Oscillator Stable
}

void SetHaltMode(uint8_t haltMode)
{
	_scc  = haltMode;
}
