/**
 * *************************************************************************************************************
 * @file Uart.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Uart firmware library
 * MCU / CFG Ver. :BH66F2475/1.7
 * Version = 1.0.1
 * * Uart 初始化配置函數
 * * Uart 使能和除能
 * * Uart 發送16進制buf (使用中断的方式)
 * * Uart 發送char 字符串 (使用中断的方式)
 * * Uart 接收 (使用中断的方式)
 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _UART_H_
#define _UART_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "stdbool.h"
#include "BH66F2455.h"

/* Exported types ----------------------------------------------------------------------------------------*/
/**
 * @brief Uart cfg structure definition
 *
 */
typedef struct {
    union {
        struct
        {
            uint8_t addr   : 1;
            uint8_t wakeUp : 1;
        } b;

        uint8_t byte;
    } flag;
} Uart_Cfg_t;

/**
 * @brief Uart cfg structure definition
 *
 */
typedef struct {
    volatile uint8_t *txOffset;
    volatile uint8_t txLen;

    union {
        struct {
            uint8_t isBusy      : 1;
            uint8_t queueIsFull : 1;
        } b;

        uint8_t byte;
    } flag;

    volatile uint8_t rxBufLen;
    volatile uint8_t *rxBuf;
} Uart_Status_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
void Uart_Cfg(const Uart_Cfg_t *cfg_t);
#define Uart_Enable()      { _uarten = 1; _txen = 1; _rxen = 1;}
#define Uart_Disable()     { _uarten = 0;}
#define Uart_Isr_Enable()  { _ure = 1;}
#define Uart_Isr_Disable() { _ure = 0;}

extern volatile Uart_Status_t uartStatus;
bool Uart_TxByte_Interrupt(volatile uint8_t *buf, uint8_t len);
void Uart_TxByte_Polling(uint8_t *byte, uint8_t len);
bool Uart_IsAvailable_ReadByte(uint8_t * byte);

void IntegerToString(int32_t value, uint8_t *str, uint8_t size);
// clang-format on

#endif