/**
 * *************************************************************************************************************
 * @file CTM.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for CTM firmware library
 * MCU / CFG Ver. :BH66F2475/1.7
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _CTM_H_
#define _CTM_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "stdbool.h"
#include "BH66F2475.h"

/* Exported types ------------------------------------------------------------------------------------------*/
/*! timer Counter Clock selection enum */
typedef enum {
    CTM_CLOCK_FSYS_4   = (0x00 << 4),
    CTM_CLOCK_FSYS     = (0x01 << 4),
    CTM_CLOCK_FH_16    = (0x02 << 4),
    CTM_CLOCK_FH_64    = (0x03 << 4),
    CTM_CLOCK_FSUB     = (0x04 << 4),
    CTM_CLOCK_PIN_RISE = (0x06 << 4),
    CTM_CLOCK_PIN_FALL = (0x07 << 4),
} CTM_Clock_e;

/*! CTM count clear mode enum */
typedef enum {
    CTM_COUNT_CLEAR_P_MATCH,
    CTM_COUNT_CLEAR_A_MATCH,
} CTM_CountClear_e;

/*! Compare a match.
typedef enum {
    CTM_COMPAREMATCH_KEEP_L               = (0x00 << 3),
    CTM_COMPAREMATCH_KEEP_H               = (0x01 << 3),
    CTM_COMPAREMATCH_INIT_H_OUTPUT_L      = (0x03 << 3),
    CTM_COMPAREMATCH_INIT_L_OUTPUT_H      = (0x04 << 3),
    CTM_COMPAREMATCH_INIT_L_OUTPUT_TOGGLE = (0x06 << 3),
    CTM_COMPAREMATCH_INIT_H_OUTPUT_TOGGLE = (0x07 << 3),
} CTM_CompareMatch_Output_e;

/*! compare match output configuration */
typedef struct {
    uint8_t clockSource;    //!< RW @see CTM_Clock_e
    uint8_t outputMode;     //!< RW @see CTM_CompareMatch_Output_e
    uint8_t countClear;     //!< RW @see CTM_CountClear_e
    bool pinInvert;
    uint16_t count;
} CTM_Cfg_CompareMatchOutputMode_t;

/*! 'Cause I'm out.
typedef enum {
    CTM_PWM_OUTPUT_KEEP_H       = (0x00 << 3),
    CTM_PWM_OUTPUT_KEEP_L       = (0x01 << 3),
    CTM_PWM_OUTPUT_PWM_ACTIVE_L = (0x04 << 3),
    CTM_PWM_OUTPUT_PWM_ACTIVE_H = (0x05 << 3),
} CTM_PWM_Output_e;

/*! Outgoing PWM
typedef enum {
    CTM_PWM_DUTY_CCRA_PERIOD_CCRP,
    CTM_PWM_DUTY_CCRP_PERIOD_CCRA,
} CTM_PWM_DutyPeriod_e;

/*! PWM output configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see CTM_Clock_e
    uint8_t outputMode;     //!< R/W @see CTM_PWM_Output_e
    uint8_t dutyPeriod;     //!< R/W @see CTM_PWM_DutyPeriod_e
    bool pinInvert;
    uint16_t ccraData;
    uint8_t ccrpData;
} CTM_Cfg_PWM_t;

/*! TimerCount configuration */
typedef struct {
    uint8_t clockSource;    //!< R/W @see CTM_Clock_e
    uint8_t countClear;     //!< R/W @see CTM_CountClear_e
    uint16_t count;
} CTM_Cfg_TimerCounter_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
void CTM0_Cfg_CompareMatchOutput(CTM_Cfg_CompareMatchOutputMode_t *cfg);
void CTM0_Cfg_TimerCounter(CTM_Cfg_TimerCounter_t *cfg);
void CTM0_Cfg_PWM(CTM_Cfg_PWM_t *cfg);
#define CTM0_Enable()           { _ct0pau = 0;  _ct0on = 1;}
#define CTM0_Disable()          { _ct0on = 0;}
#define CTM0A_Isr_Enable()      { _ctm0af = 0; _ctm0ae =1; _mf0e = 1;}
#define CTM0A_Isr_Disable()     { _ctm0ae = 0;}
#define CTM0P_Isr_Enable()      { _ctm0pf = 0; _ctm0pe =1; _mf0e = 1;}
#define CTM0P_Isr_Disable()     { _ctm0pe = 0;}

void CTM1_Cfg_CompareMatchOutput(CTM_Cfg_CompareMatchOutputMode_t *cfg);
void CTM1_Cfg_TimerCounter(CTM_Cfg_TimerCounter_t *cfg);
void CTM1_Cfg_PWM(CTM_Cfg_PWM_t *cfg);
#define CTM1_Enable()           { _ct1pau = 0;  _ct1on = 1;}
#define CTM1_Disable()          { _ct1on = 0;}
#define CTM1A_Isr_Enable()      { _ctm1af = 0; _ctm1ae =1; _mf0e = 1;}
#define CTM1A_Isr_Disable()     { _ctm1ae = 0;}
#define CTM1P_Isr_Enable()      { _ctm1pf = 0; _ctm1pe =1; _mf0e = 1;}
#define CTM1P_Isr_Disable()     { _ctm1pe = 0;}

// clang-format on
#endif