/**
 * *************************************************************************************************************
 * @file I2c.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for I2c firmware library
 * MCU / CFG Ver. :BH66F2475/1.7
 * Version = 1.0.1

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _I2C_H_
#define _I2C_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include <stdint.h>
#include "stdbool.h"
#include "BH66F2455.h"

/** @defgroup I2c
 * @{
 */

/* Exported types ----------------------------------------------------------------------------------------*/
/**
 * @brief I2c Debounce Time Selection enum
 *
 */
typedef enum {
    I2C_DEBOUNCE_NONE   = (0x00 << 2), /*!<  Standard Mode: Fsys > 2MHz     Fast Mode:Fsys > 5MHz   */
    I2C_DEBOUNCE_CLOCK2 = (0x01 << 2), /*!<  Standard Mode: Fsys > 4MHz     Fast Mode:Fsys > 10MHz  */
    I2C_DEBOUNCE_CLOCK4 = (0x02 << 2), /*!<  Standard Mode: Fsys > 8MHz     Fast Mode:Fsys > 20MHz  */
} I2c_Debounce_e;

/**
 * @brief I2c cfg structure definition
 *
 */
typedef struct {
    uint8_t addr;
    uint8_t debounce;    //!< default:NONE @ref I2c_Debounce_e

    union {
        struct {
            uint8_t wakeUp  : 1;    //!< default false Address Match Wake-up control
            uint8_t timeOut : 1;    //!< default false
        } b;

        uint8_t byte;
    } flag;

    uint8_t timeOutMs;    //!< default:0 timeOutPeriod<=63 (timeOutPeriod+1)×(32/Fsub)≈(timeOutPeriod+1)*1ms
} I2c_Cfg_t;

// clang-format off
/* Exported functions --------------------------------------------------------------------------------------*/
void I2c_Cfg(const I2c_Cfg_t *Cfg);
#define I2c_Enable()      { _simen = 0x01;}
#define I2c_Disable()     { _simen = 0x00;}
#define I2c_Isr_Enable()  { _sime = 1;}
#define I2c_Isr_Disable() { _sime = 0;}

// clang-format on
/**
 * @}
 */

#endif