/*************************************************************************************************************
 * @file    app_cfg.h
 * @version V1.0
 * @date    2021-02-06
 * @brief   ble_peripheral app configuration.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/


#ifndef __APP_CFG_H__
#define __APP_CFG_H__


// HT32F675x5 Memory Map
#include "..\..\..\..\..\sources\mem_cfg\ht32f675x5_mem_cfg_r2.h"


//=====================================================================================================================
// MEMOARY MAP DEFINE
//=====================================================================================================================
//=============================================================================
// RAM(0x2000_2000 ~ 0x2003_FFFF)
//=============================================================================
// CP RAM Code & Data In SDK
#define RAM_CP_ADDR                         (RAM_2ND_BOOT_ADDR) // 0x2000_3000
#define RAM_CP_SIZE_MAX                     (120 * KBYTE)

// CP STACK and HEAP in SDK
#define RAM_CP_STACK_SIZE_MAX               (4 * KBYTE) // @ref startup_ARMCM0Plus.s
#define RAM_CP_HEAP_SIZE_MAX                (4 * KBYTE) // @ref startup_ARMCM0Plus.s
#define RAM_CP_STACK_HEAP_SIZE_MAX          (RAM_CP_STACK_SIZE_MAX + RAM_CP_HEAP_SIZE_MAX)
#define RAM_CP_STACK_HEAP_ADDR              (RAM_CP_ADDR + RAM_CP_SIZE_MAX - RAM_CP_STACK_HEAP_SIZE_MAX)

// MP NEW_VECTOR In SDK
#define RAM_MP_VECTOR_ADDR                  (RAM_CP_ADDR + RAM_CP_SIZE_MAX)
#define RAM_MP_VECTOR_SIZE_MAX              (512)

// MP RAM Code In SDK
#define RAM_MP_CODE_ADDR                    (RAM_MP_VECTOR_ADDR + RAM_MP_VECTOR_SIZE_MAX)
#define RAM_MP_CODE_SIZE_MAX                (32 * KBYTE - RAM_MP_VECTOR_SIZE_MAX)

// MP RAM Data In SDK
#define RAM_MP_DATA_ADDR                    (RAM_MP_CODE_ADDR + RAM_MP_CODE_SIZE_MAX)
#define RAM_MP_DATA_SIZE_MAX                (32 * KBYTE)

// MP STACK and HEAP in SDK
#define RAM_MP_STACK_SIZE_MAX               (4 * KBYTE) // @ref startup_ARMCM33.s
#define RAM_MP_HEAP_SIZE_MAX                (0 * KBYTE) // @ref startup_ARMCM33.s
#define RAM_MP_STACK_HEAP_SIZE_MAX          (RAM_MP_STACK_SIZE_MAX + RAM_MP_HEAP_SIZE_MAX)
#define RAM_MP_STACK_HEAP_ADDR              (RAM_MP_DATA_ADDR + RAM_MP_DATA_SIZE_MAX - RAM_MP_STACK_HEAP_SIZE_MAX)

#define RAM_APP_SIZE_KBYTE_MAX              (((RAM_MP_DATA_ADDR + RAM_MP_DATA_SIZE_MAX) - RAM_BASE_ADDR) / KBYTE)

//=============================================================================
// Flash(0x1000_0000 ~ 0x1007_FFFF)
//=============================================================================
// APP Code
#define FLASH_MP_APP_CODE_ADDR              (FLASH_BASE_ADDR + FLASH_BOOT_RESERVED_SIZE_MAX)
#define FLASH_MP_APP_CODE_ADDR_OFFSET       (FLASH_MP_APP_CODE_ADDR - FLASH_BASE_ADDR)
#define FLASH_MP_APP_CODE_SIZE_MAX          (80 * KBYTE) //(Align to 4 KBytes)

// MMU Addr (Align to 4 KBytes)
#define FLASH_MMU_SIZE_MAX                  (4 * KBYTE)
#define FLASH_MMU_BASE_ADDR                 (FLASH_BASE_ADDR + FLASH_SIZE_MAX - FLASH_MMU_SIZE_MAX)
#define FLASH_MMU_BASE_ADDR_OFFSET          (FLASH_MMU_BASE_ADDR - FLASH_BASE_ADDR)

// History Data
#define FLASH_HISTORY_DATA_SIZE_MAX         (700 * KBYTE) //(Align to 4 KBytes)
#define FLASH_HISTORY_DATA_BASE_ADDR        (FLASH_MMU_BASE_ADDR - FLASH_HISTORY_DATA_SIZE_MAX)
#define FLASH_HISTORY_DATA_BASE_ADDR_OFFSET (FLASH_HISTORY_DATA_BASE_ADDR - FLASH_BASE_ADDR)

// OTA Addr
#define FLASH_FW_UPGRADE_CODE_ADDR          (FLASH_MP_APP_CODE_ADDR + FLASH_MP_APP_CODE_SIZE_MAX)
#define FLASH_FW_UPGRADE_CODE_SIZE_MAX      (FLASH_SIZE_MAX - FLASH_MP_APP_CODE_SIZE_MAX - FLASH_MMU_SIZE_MAX - FLASH_HISTORY_DATA_SIZE_MAX - FLASH_BOOT_RESERVED_SIZE_MAX)

#if (FLASH_FW_UPGRADE_CODE_SIZE_MAX < FLASH_MP_APP_CODE_SIZE_MAX)
    #error "Firmware Upgrade Space not enough !"
#endif
#if (FLASH_FW_UPGRADE_CODE_ADDR + FLASH_FW_UPGRADE_CODE_SIZE_MAX) > FLASH_MMU_BASE_ADDR
    #error "Beyond FLASH_MMU_BASE_ADDR !"
#endif



//=====================================================================================================================
// PERIPHERAL DEFINE
//=====================================================================================================================
//=============================================================================
// GPIO
//=============================================================================
// mp app_debug
#define GPIO_PORT_MP_APP_DEBUG_TX (GPIO_PORT_UART0_TX)
#define GPIO_PIN_MP_APP_DEBUG_TX  (GPIO_PIN_UART0_TX)

// cp app_debug
#define GPIO_PORT_CP_APP_DEBUG_TX (GPIO_PORT_UART2_TX)
#define GPIO_PIN_CP_APP_DEBUG_TX  (GPIO_PIN_UART2_TX)

// cp mlog
#define GPIO_PORT_CP_MLOG_TX (GPIO_PORT_UART0_TX)
#define GPIO_PIN_CP_MLOG_TX  (GPIO_PIN_UART0_TX)

//=============================================================================
// UART
//=============================================================================
// mp app_debug
#define UART_HANDLE_MP_APP_DEBUG (UART0)
#define UART_BPS_MP_APP_DEBUG    (921600)

// cp app_debug
#define UART_HANDLE_CP_APP_DEBUG (UART2)
#define UART_BPS_CP_APP_DEBUG    (921600)

// cp mlog
#define UART_HANDLE_CP_MLOG (UART0)
#define UART_BPS_CP_MLOG    (921600)

//=============================================================================
// BLE
//=============================================================================
#define BLE_ADV_INTERVAL_MS                 MSEC_TO_UNITS(1000, UNIT_0_625_MS)
#define BLE_ADV_NAME_STRING                 ("BH CGM HT32")
#define BLE_DEVICE_MAC                      {0x11, 0x11, 0x11, 0x44, 0xAC, 0x04}


//=====================================================================================================================
// APP Version
//=====================================================================================================================
#define APP_VERSION                         (0x0011) // V0.11


//=====================================================================================================================
// APP Configuration
//=====================================================================================================================
//=============================================================================
// DEFAULT CFG
//=============================================================================
#define RC_HCLK_TUNE_DEFAUT_VAL             (0x56)
#define RC_LCLK_TUNE_DEFAUT_VAL             (0xA9)

//=============================================================================
// SYSTEM/LPWR CLOCK
//=============================================================================
#define DCXO_LCLK_BUF_3                     (3)     /* [0~7]*/
#define DCXO_LCLK_IB_3                      (3)     /* [0~7]*/
#define DCXO_LCLK_NGM_3                     (3)     /* [0~7]*/
#define DCXO_LCLK_CAP_3PF                   (30)    /* [30~285] 3pF~28.5pF */
#define DCXO_LCLK_CAP_7PF4                  (74)    /* [30~285] 3pF~28.5pF */
#define DCXO_LCLK_CAP_10PF                  (100)   /* [30~285] 3pF~28.5pF */
#define DCXO_LCLK_CAP_15PF                  (150)   /* [30~285] 3pF~28.5pF */
#define DCXO_LCLK_STABLE_TIME_300MS         (300)
#define DCXO_LCLK_STABLE_TIME_500MS         (500)
#define DCXO_HCLK_IB_5					     (5)
#define DCXO_HCLK_CAP_18PF					(180)
#define DCXO_HCLK_STABLE_TIME_2500US        (2500)
#define DCXO_HCLK_STABLE_TIME_2000US        (2000)
#define DCXO_HCLK_STABLE_TIME               (DCXO_HCLK_STABLE_TIME_2000US)
#define SYSTEM_CLOCK_PLL64M_ENABLED         (0)
#define DCXO_LCLK_STABLE_TIME               (DCXO_LCLK_STABLE_TIME_500MS)

//=============================================================================
// LOG CFG
//=============================================================================
#if defined(__MAIN_PROCESSOR)
    #define APP_DEBUG_ENABLED               (1)
    #define MLOG_DEBUG_ENABLED              (0)
#else
    #define APP_DEBUG_ENABLED               (1)
    #define MLOG_DEBUG_ENABLED              (0)
#endif

#if APP_DEBUG_ENABLED
    #define PRINTF(fmt, args...)            printf(fmt, ##args)
    #define INFO(fmt,args...)               printf("[%s][%d] : "fmt,__func__,__LINE__,##args)
#else
    #define PRINTF(fmt, args...)
    #define INFO(fmt,args...)
#endif


//=====================================================================================================================
// SYSTEM CONTROL COMMON REGISTER DEFINE
//=====================================================================================================================
#define SYS_CTRL_COM_REG_MP_CTRL_CP         (3)

// System power manage
#define	SYSTEM_POWER_VOLTAGE				(110)			//110=1100mv,115=1150mv,120 or other=1200mv

// BLE Advertising Channel Number
#define BLE_ADV_CHANNEL_NUM					(2)			//1=1ch,2=2ch,3 or other=3ch


//=====================================================================================================================
//Wakeup LUT Index
//=====================================================================================================================
#define LUT_INDEX_CP_LLC                    (15)
#define LUT_INDEX_KEY                       (14)
#define LUT_INDEX_STIM_WAKEUP               (13)

//=====================================================================================================================
// CGM Device
//=====================================================================================================================
// UART
#define CGM_UART_HANDLE                     (UART1)
#define CGM_UART_PORT_TX                    (GPIO_PORT_UART1_TX)
#define CGM_UART_PIN_TX                     (GPIO_PIN_UART1_TX)
#define CGM_UART_PORT_RX                    (GPIO_PORT_UART1_RX)
#define CGM_UART_PIN_RX                     (GPIO_PIN_UART1_RX)
#define CGM_UART_BPS                        (38400)
#define CGM_UART_BUF_SIZE                   (512)

// SPI
#define SPI_CMD_SUPPORT                     (0)
#if SPI_CMD_SUPPORT
#define CGM_SPI_MASTER_HANDLE               (SPI0)
#define CGM_SPI_MASTER_CLK_GPIO_PORT        (GPIOA)
#define CGM_SPI_MASTER_CLK_GPIO_PIN         (GPIO_PIN_0)
#define CGM_SPI_MASTER_MOSI_GPIO_PORT       (GPIOA)
#define CGM_SPI_MASTER_MOSI_GPIO_PIN        (GPIO_PIN_1)
#define CGM_SPI_MASTER_MISO_GPIO_PORT       (GPIOA)
#define CGM_SPI_MASTER_MISO_GPIO_PIN        (GPIO_PIN_2)
#define CGM_SPI_MASTER_CS_GPIO_PORT         (GPIOA)
#define CGM_SPI_MASTER_CS_GPIO_PIN          (GPIO_PIN_18)
#endif

//=====================================================================================================================
// TT CMD
//=====================================================================================================================
#define TT_CMD_WRITE_DEV_NAME               (0x01)
#define TT_CMD_READ_DEV_NAME                (0x02)
#define TT_CMD_WRITE_ADV_INTERVAL           (0x03)
#define TT_CMD_READ_ADV_INTERVAL            (0x04)
#define TT_CMD_WRITE_CONN_INTERVAL          (0x05)
#define TT_CMD_WRITE_DEV_NAME_PARAM_MAX_LEN (23)
#define TT_CMD_WRITE_ADV_INTERVAL_PARAM_LEN (2)

// OTA
#define OTA_UPGRADE_INFO_ADDR_OFFSET        (FLASH_FW_UPGRADE_CODE_INFO_ADDR_OFFSET)
#define OTA_CODE_ADDR_OFFSET                (FLASH_FW_UPGRADE_CODE_ADDR - FLASH_BASE_ADDR)

#define CGMS_DB_RECORDS_MAX_NUM             (100)

#define BLE_SEND_AFE_DATA_INTERVAL (60)    // BLE interval for sending AFE data (in seconds)
#define AFE_COLLECTION_INTERVAL    (10)    // AFE data collection interval (in seconds)

#define NTC_MEASURE_BY_BLE (1)

#endif /* __APP_CFG_H__ */


