/**
 * *************************************************************************************************************
 * @file Adc24.c
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2022-04-01
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for Adc24 firmware library
 * MCU / CFG Ver. :BH66F2475/1.7
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
#include "stdbool.h"
#include "Adc24.h"
#include "AfePower.h"
#include "..\application\Iap_Isp.h"

static volatile int8_t adcAutoModeBuf[64] __attribute__((at(0x300)));
volatile int8_t *adcAutoModeBufP;

// clang-format off
#define SET_ADC_ENABLE_AUTO_START_CONVERT() { _adf = 1; _bufrst = 1; _pgaen = 0; _aden = 0; _adcdl = 0; _autoadcen = 1; _eoca = 0;}
#define SET_ADC_ENABLE()			        { _aden = 1;}
#define SET_ADC_DISABLE()			        { _pgaen = 0; _aden = 0;}
#define SET_ADC_START_CONVERT()		        { _adrst = 0; _adrst = 1; _adrst = 0; _adcdl = 0; _autoadcen = 0; _eoc = 0; }
#define SET_ADC_INPUT_SHORT(x)    	        { _inis = x;}
#define SET_ERRCHKRST_ENABLE                true
#define SET_ERRCHKRST_DISABLE               false

//!< fADCK = fMCLK
//!< SINC2 DataRate = fADCK/(OSR*2)
#define SET_ADC_DATA_400KHZ_RATE2_6HZ()      { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x00<<1); _adcr1=(0x01<<4);}  // 6.10Hz：(OSR=32768)
#define SET_ADC_DATA_400KHZ_RATE2_12HZ()     { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x01<<1); _adcr1=(0x01<<4);}  // 12.21Hz：(OSR=16384)
#define SET_ADC_DATA_400KHZ_RATE2_24HZ()     { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x02<<1); _adcr1=(0x01<<4);}  // 24.41Hz：(OSR=8192)
#define SET_ADC_DATA_400KHZ_RATE2_49HZ()     { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x03<<1); _adcr1=(0x01<<4);}  // 48.83Hz：(OSR=4096)
#define SET_ADC_DATA_400KHZ_RATE2_98HZ()     { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x04<<1); _adcr1=(0x01<<4);}  // 97.66Hz：(OSR=2048)
#define SET_ADC_DATA_400KHZ_RATE2_195HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x05<<1); _adcr1=(0x01<<4);}  // 195.31Hz：(OSR=1024)
#define SET_ADC_DATA_400KHZ_RATE2_391HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x06<<1); _adcr1=(0x01<<4);}  // 390.63Hz：(OSR=512)
#define SET_ADC_DATA_400KHZ_RATE2_781HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x07<<1); _adcr1=(0x01<<4);}  // 781.25Hz：(OSR=256)
#define SET_ADC_DATA_400KHZ_RATE2_1563HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x08<<1); _adcr1=(0x01<<4);}  // 1562.50Hz：(OSR=128)

//!< SINC3 DataRate = fADCK/(OSR)
#define SET_ADC_DATA_400KHZ_RATE3_12HZ()     { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x00<<1); _adcr1=(0x01<<4);}  // 12.21Hz：(OSR=32768)
#define SET_ADC_DATA_400KHZ_RATE3_24HZ()     { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x01<<1); _adcr1=(0x01<<4);}  // 24.41Hz：(OSR=16384)
#define SET_ADC_DATA_400KHZ_RATE3_49HZ()     { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x02<<1); _adcr1=(0x01<<4);}  // 48.83Hz：(OSR=8192)
#define SET_ADC_DATA_400KHZ_RATE3_98HZ()     { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x03<<1); _adcr1=(0x01<<4);}  // 97.66Hz：(OSR=4096)
#define SET_ADC_DATA_400KHZ_RATE3_195HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x04<<1); _adcr1=(0x01<<4);}  // 195.31Hz：(OSR=2048)
#define SET_ADC_DATA_400KHZ_RATE3_391HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x05<<1); _adcr1=(0x01<<4);}  // 390.63Hz：(OSR=1024)
#define SET_ADC_DATA_400KHZ_RATE3_781HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x06<<1); _adcr1=(0x01<<4);}  // 781.25Hz：(OSR=512)
#define SET_ADC_DATA_400KHZ_RATE3_1563HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x07<<1); _adcr1=(0x01<<4);}  // 1562.50Hz：(OSR=256)
#define SET_ADC_DATA_400KHZ_RATE3_3125HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x08<<1); _adcr1=(0x01<<4);}  // 3125.00Hz：(OSR=128)

//!< fmclk = 4000000
//!< SINC2 DataRate = FMCLK/(OSR*N*2)
#define SET_ADC_DATA_4MHZ_RATE2_5HZ()     { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x00<<1); _adcr1=(0x02<<5);}  // 5.09Hz：(N=12, OSR=32768)
#define SET_ADC_DATA_4MHZ_RATE2_10HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x01<<1); _adcr1=(0x02<<5);}  // 10.17Hz：(N=12, OSR=16384)
#define SET_ADC_DATA_4MHZ_RATE2_20HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x02<<1); _adcr1=(0x02<<5);}  // 20.35Hz：(N=12, OSR=8192)
#define SET_ADC_DATA_4MHZ_RATE2_41HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x03<<1); _adcr1=(0x02<<5);}  // 40.69Hz：(N=12, OSR=4096)
#define SET_ADC_DATA_4MHZ_RATE2_81HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x04<<1); _adcr1=(0x02<<5);}  // 81.38Hz：(N=12, OSR=2048)
#define SET_ADC_DATA_4MHZ_RATE2_163HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x05<<1); _adcr1=(0x02<<5);}  // 162.76Hz：(N=12, OSR=1024)
#define SET_ADC_DATA_4MHZ_RATE2_326HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x06<<1); _adcr1=(0x02<<5);}  // 325.52Hz：(N=12, OSR=512)
#define SET_ADC_DATA_4MHZ_RATE2_651HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x07<<1); _adcr1=(0x02<<5);}  // 651.04Hz：(N=12, OSR=256)
#define SET_ADC_DATA_4MHZ_RATE2_1302HZ()  { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x08<<1); _adcr1=(0x02<<5);}  // 1302.08Hz：(N=12, OSR=128)

#define SET_ADC_DATA_4MHZ_RATE2_2HZ()     { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x00<<1); _adcr1=(0x00<<5);}  // 2.03Hz：(N=30, OSR=32768)
#define SET_ADC_DATA_4MHZ_RATE2_4HZ()     { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x01<<1); _adcr1=(0x00<<5);}  // 4.07Hz：(N=30, OSR=16384)
#define SET_ADC_DATA_4MHZ_RATE2_8HZ()     { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x02<<1); _adcr1=(0x00<<5);}  // 8.14Hz：(N=30, OSR=8192)
#define SET_ADC_DATA_4MHZ_RATE2_16HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x03<<1); _adcr1=(0x00<<5);}  // 16.28Hz：(N=30, OSR=4096)
#define SET_ADC_DATA_4MHZ_RATE2_33HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x04<<1); _adcr1=(0x00<<5);}  // 32.55Hz：(N=30, OSR=2048)
#define SET_ADC_DATA_4MHZ_RATE2_65HZ()    { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x05<<1); _adcr1=(0x00<<5);}  // 65.1Hz：(N=30, OSR=1024)
#define SET_ADC_DATA_4MHZ_RATE2_130HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x06<<1); _adcr1=(0x00<<5);}  // 130.21Hz：(N=30, OSR=512)
#define SET_ADC_DATA_4MHZ_RATE2_260HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x07<<1); _adcr1=(0x00<<5);}  // 260.42Hz：(N=30, OSR=256)
#define SET_ADC_DATA_4MHZ_RATE2_521HZ()   { _adcs=0x1F; _sinc3=0x90; _adcr0=(0x08<<1); _adcr1=(0x00<<5);}  // 520.83Hz：(N=30, OSR=128)

//!< SINC3 DataRate = FMCLK/(OSR*N)
#define SET_ADC_DATA_4MHZ_RATE3_10HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x00<<1); _adcr1=(0x02<<5);}  // 10.17Hz：(N=12, OSR=32768)
#define SET_ADC_DATA_4MHZ_RATE3_20HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x01<<1); _adcr1=(0x02<<5);}  // 20.35Hz：(N=12, OSR=16384)
#define SET_ADC_DATA_4MHZ_RATE3_41HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x02<<1); _adcr1=(0x02<<5);}  // 40.69Hz：(N=12, OSR=8192)
#define SET_ADC_DATA_4MHZ_RATE3_81HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x03<<1); _adcr1=(0x02<<5);}  // 81.38Hz：(N=12, OSR=4096)
#define SET_ADC_DATA_4MHZ_RATE3_163HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x04<<1); _adcr1=(0x02<<5);}  // 162.76Hz：(N=12, OSR=2048)
#define SET_ADC_DATA_4MHZ_RATE3_326HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x05<<1); _adcr1=(0x02<<5);}  // 325.52Hz：(N=12, OSR=1024)
#define SET_ADC_DATA_4MHZ_RATE3_651HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x06<<1); _adcr1=(0x02<<5);}  // 651.04Hz：(N=12, OSR=512)
#define SET_ADC_DATA_4MHZ_RATE3_1302HZ()  { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x07<<1); _adcr1=(0x02<<5);}  // 1302.08Hz：(N=12, OSR=256)
#define SET_ADC_DATA_4MHZ_RATE3_2604HZ()  { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x08<<1); _adcr1=(0x02<<5);}  // 2604.17Hz：(N=12, OSR=128)

#define SET_ADC_DATA_4MHZ_RATE3_4HZ()     { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x00<<1); _adcr1=(0x00<<5);}  // 4.07Hz：(N=30, OSR=32768)
#define SET_ADC_DATA_4MHZ_RATE3_8HZ()     { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x01<<1); _adcr1=(0x00<<5);}  // 8.14Hz：(N=30, OSR=16384)
#define SET_ADC_DATA_4MHZ_RATE3_16HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x02<<1); _adcr1=(0x00<<5);}  // 16.28Hz：(N=30, OSR=8192)
#define SET_ADC_DATA_4MHZ_RATE3_33HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x03<<1); _adcr1=(0x00<<5);}  // 32.55Hz：(N=30, OSR=4096)
#define SET_ADC_DATA_4MHZ_RATE3_65HZ()    { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x04<<1); _adcr1=(0x00<<5);}  // 65.1Hz：(N=30, OSR=2048)
#define SET_ADC_DATA_4MHZ_RATE3_130HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x05<<1); _adcr1=(0x00<<5);}  // 130.21Hz：(N=30, OSR=1024)
#define SET_ADC_DATA_4MHZ_RATE3_260HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x06<<1); _adcr1=(0x00<<5);}  // 260.42Hz：(N=30, OSR=512)
#define SET_ADC_DATA_4MHZ_RATE3_521HZ()   { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x07<<1); _adcr1=(0x00<<5);}  // 520.83Hz：(N=30, OSR=256)
#define SET_ADC_DATA_4MHZ_RATE3_1042HZ()  { _adcs=0x1F; _sinc3=0x93; _adcr0=(0x08<<1); _adcr1=(0x00<<5);}  // 1041.67Hz：(N=30, OSR=128)

// clang-format on
volatile Adc24_Source_t adc24SourceData;

/*
 * @Brief config
 **
 * @Param adcCfg @see AdcCfg_t
 */
void Adc24_Cfg(Adc24_Cfg_t cfg)
{
    // adc sampleRate
    switch (cfg.sampleRate)
    {
#if ADC_USE_RATE3
            // clang-format off
        case ADC24_RATE_400KHZ_12HZ: SET_ADC_DATA_400KHZ_RATE3_12HZ(); break;
        case ADC24_RATE_400KHZ_24HZ: SET_ADC_DATA_400KHZ_RATE3_24HZ(); break;
        case ADC24_RATE_400KHZ_49HZ: SET_ADC_DATA_400KHZ_RATE3_49HZ(); break;
        case ADC24_RATE_400KHZ_98HZ: SET_ADC_DATA_400KHZ_RATE3_98HZ(); break;
        case ADC24_RATE_400KHZ_195HZ: SET_ADC_DATA_400KHZ_RATE3_195HZ(); break;
        case ADC24_RATE_400KHZ_391HZ: SET_ADC_DATA_400KHZ_RATE3_391HZ(); break;
        case ADC24_RATE_400KHZ_781HZ: SET_ADC_DATA_400KHZ_RATE3_781HZ(); break;
        case ADC24_RATE_400KHZ_1563HZ: SET_ADC_DATA_400KHZ_RATE3_1563HZ(); break;
        case ADC24_RATE_400KHZ_3125HZ: SET_ADC_DATA_400KHZ_RATE3_3125HZ(); break;

        case ADC24_RATE_4MHZ_4HZ: SET_ADC_DATA_4MHZ_RATE3_4HZ(); break;
        case ADC24_RATE_4MHZ_8HZ: SET_ADC_DATA_4MHZ_RATE3_8HZ(); break;
        case ADC24_RATE_4MHZ_10HZ: SET_ADC_DATA_4MHZ_RATE3_10HZ(); break;
        case ADC24_RATE_4MHZ_16HZ: SET_ADC_DATA_4MHZ_RATE3_16HZ(); break;
        case ADC24_RATE_4MHZ_20HZ: SET_ADC_DATA_4MHZ_RATE3_20HZ(); break;
        case ADC24_RATE_4MHZ_33HZ: SET_ADC_DATA_4MHZ_RATE3_33HZ(); break;
        case ADC24_RATE_4MHZ_41HZ: SET_ADC_DATA_4MHZ_RATE3_41HZ(); break;
        case ADC24_RATE_4MHZ_65HZ: SET_ADC_DATA_4MHZ_RATE3_65HZ(); break;
        case ADC24_RATE_4MHZ_81HZ: SET_ADC_DATA_4MHZ_RATE3_81HZ(); break;
        case ADC24_RATE_4MHZ_130HZ: SET_ADC_DATA_4MHZ_RATE3_130HZ(); break;
        case ADC24_RATE_4MHZ_163HZ: SET_ADC_DATA_4MHZ_RATE3_163HZ(); break;
        case ADC24_RATE_4MHZ_260HZ: SET_ADC_DATA_4MHZ_RATE3_260HZ(); break;
        case ADC24_RATE_4MHZ_326HZ: SET_ADC_DATA_4MHZ_RATE3_326HZ(); break;
        case ADC24_RATE_4MHZ_521HZ: SET_ADC_DATA_4MHZ_RATE3_521HZ(); break;
        case ADC24_RATE_4MHZ_651HZ: SET_ADC_DATA_4MHZ_RATE3_651HZ(); break;
        case ADC24_RATE_4MHZ_1302HZ: SET_ADC_DATA_4MHZ_RATE3_1302HZ(); break;

// clang-format on
#endif
#if ADC_USE_RATE2
            // clang-format off
        case ADC24_RATE_400KHZ_6HZ: SET_ADC_DATA_400KHZ_RATE2_6HZ(); break;
        case ADC24_RATE_400KHZ_12HZ: SET_ADC_DATA_400KHZ_RATE2_12HZ(); break;
        case ADC24_RATE_400KHZ_24HZ: SET_ADC_DATA_400KHZ_RATE2_24HZ(); break;
        case ADC24_RATE_400KHZ_49HZ: SET_ADC_DATA_400KHZ_RATE2_49HZ(); break;
        case ADC24_RATE_400KHZ_98HZ: SET_ADC_DATA_400KHZ_RATE2_98HZ(); break;
        case ADC24_RATE_400KHZ_195HZ: SET_ADC_DATA_400KHZ_RATE2_195HZ(); break;
        case ADC24_RATE_400KHZ_391HZ: SET_ADC_DATA_400KHZ_RATE2_391HZ(); break;
        case ADC24_RATE_400KHZ_781HZ: SET_ADC_DATA_400KHZ_RATE2_781HZ(); break;
        case ADC24_RATE_400KHZ_1563HZ: SET_ADC_DATA_400KHZ_RATE2_1563HZ(); break;

        case ADC24_RATE_4MHZ_2HZ: SET_ADC_DATA_4MHZ_RATE2_2HZ(); break;
        case ADC24_RATE_4MHZ_4HZ: SET_ADC_DATA_4MHZ_RATE2_4HZ(); break;
        case ADC24_RATE_4MHZ_5HZ: SET_ADC_DATA_4MHZ_RATE2_5HZ(); break;
        case ADC24_RATE_4MHZ_8HZ: SET_ADC_DATA_4MHZ_RATE2_8HZ(); break;
        case ADC24_RATE_4MHZ_10HZ: SET_ADC_DATA_4MHZ_RATE2_10HZ(); break;
        case ADC24_RATE_4MHZ_16HZ: SET_ADC_DATA_4MHZ_RATE2_16HZ(); break;
        case ADC24_RATE_4MHZ_20HZ: SET_ADC_DATA_4MHZ_RATE2_20HZ(); break;
        case ADC24_RATE_4MHZ_33HZ: SET_ADC_DATA_4MHZ_RATE2_33HZ(); break;
        case ADC24_RATE_4MHZ_41HZ: SET_ADC_DATA_4MHZ_RATE2_41HZ(); break;
        case ADC24_RATE_4MHZ_65HZ: SET_ADC_DATA_4MHZ_RATE2_65HZ(); break;
        case ADC24_RATE_4MHZ_81HZ: SET_ADC_DATA_4MHZ_RATE2_81HZ(); break;
        case ADC24_RATE_4MHZ_130HZ: SET_ADC_DATA_4MHZ_RATE2_130HZ(); break;
        case ADC24_RATE_4MHZ_163HZ: SET_ADC_DATA_4MHZ_RATE2_163HZ(); break;
        case ADC24_RATE_4MHZ_260HZ: SET_ADC_DATA_4MHZ_RATE2_260HZ(); break;
        case ADC24_RATE_4MHZ_326HZ: SET_ADC_DATA_4MHZ_RATE2_326HZ(); break;
        case ADC24_RATE_4MHZ_521HZ: SET_ADC_DATA_4MHZ_RATE2_521HZ(); break;
        case ADC24_RATE_4MHZ_651HZ: SET_ADC_DATA_4MHZ_RATE2_651HZ(); break;
        case ADC24_RATE_4MHZ_1302HZ: SET_ADC_DATA_4MHZ_RATE2_1302HZ(); break;
// clang-format on
#endif
		case ADC24_SINC2_RATE_400KHZ_391HZ: SET_ADC_DATA_400KHZ_RATE2_391HZ(); break;
        default:
            break;
    }

    // adc gain configuration
    _pgac = cfg.gain;
    if (cfg.gain == ADC24_REFx1_GAINx1BYPASS)
    {
        _pgabps = 1;
        _pgaen  = 0;
    }
    else
    {
        _pgabps = 0;
        _pgaen  = 1;
    }

    // adc channel
    _pgacs = cfg.channel;
    if ((cfg.channel & 0xF0) == 0xD0)
    {
        PIN_PA1_AIN1();
    }
    if ((cfg.channel & 0x0F) == 0x0D)
    {
        PIN_PA3_AIN0();
    }
    
    _vdetecten = 0;
    if (_pgacs == ADC24_CHP_AVDD5_N_AVDD6)
    {
        _vdetecten = 1;
    }

    // adc data skip
    _ctrl = cfg.dataSkip;

    // adc data avg
    _adacctrl = cfg.dataAvgCnt;

    // adc auto write num
    if (cfg.autoWriteNum != ADC24_WRNUM_DISABLE)
    {
        _autoadcc = (cfg.autoWriteNum - 1) << 1;
    }

    // adc err check
    _errchkc = cfg.errCheck;

    adcAutoModeBufP = adcAutoModeBuf;
}

/**
 * @brief adc convert start
 */
void Adc24_Enable(Adc24_Cfg_t cfg)
{
//    adc24SourceData.flag.b.isAutoModeReady = 0;
//    adc24SourceData.flag.b.isReady = 0;
//    adc24SourceData.samplingCnt    = 0;
//    if (_ctrlen)
//    {
//        adc24SourceData.samplingCnt = ((_addsk1 << 1) + _addsk0) + 1;
//    }
//    // SET_ADC_INPUT_SHORT(true);
//    if (cfg.autoWriteNum != ADC24_WRNUM_DISABLE)
//    {
//        SET_ADC_ENABLE_AUTO_START_CONVERT();
//    }
//    else
//    {
//        SET_ADC_ENABLE();
//        SET_ADC_START_CONVERT();
//    }
	SET_ADC_ENABLE_AUTO_START_CONVERT();
}

/**
 * @brief adc convert stop
 */
void Adc24_Disable()
{
    adc24SourceData.flag.b.isReady = 0;
    adc24SourceData.samplingCnt    = 0;
    SET_ADC_DISABLE();
}

void Adc24_Poling()
{
    // if (_eoca == 1)
    // {
    //     adc24SourceData.samplingCnt++;
    //     // 前三筆數據丟掉，第四筆才開始處理
    //     if (adc24SourceData.samplingCnt > 3)
    //     {
    //         // Read current ADC
    //         _adcdl                             = 1;
    //         adc24SourceData.data.byte.byteLow  = 0x00;
    //         adc24SourceData.data.byte.byteMid  = _adrl_avg;
    //         adc24SourceData.data.byte.byteHigh = _adrm_avg;
    //         adc24SourceData.data.byte.byteRes  = _adrh_avg;
    //         _adcdl                             = 0;    // 數據讀取完成，取消鎖存
    //         adc24SourceData.data.adcData       = adc24SourceData.data.adcData >> 8;
    //         adc24SourceData.flag.b.isReady     = 1;
    //     }
    //     _eoca = 0;
    // }
    if (_eoc == 1)
    {
        // ADC 轉換完成
        adc24SourceData.samplingCnt++;
        // 前三筆數據丟掉，第四筆才開始處理
        if (adc24SourceData.samplingCnt > 4)
        {
            // Read current ADC
            _adcdl                             = 1;
            adc24SourceData.data.byte.byteLow  = 0x00;
            adc24SourceData.data.byte.byteMid  = _adrl;
            adc24SourceData.data.byte.byteHigh = _adrm;
            adc24SourceData.data.byte.byteRes  = _adrh;
            _adcdl                             = 0;    // 數據讀取完成，取消鎖存
            adc24SourceData.data.adcData       = adc24SourceData.data.adcData >> 8;
            adc24SourceData.flag.b.isReady     = 1;
        }
        _eoc = 0;
    }
}

//@------------ADC Auto Mode中斷入口函數---------------@
#ifdef SUPPORT_ISP
__attribute__((interrupt(0x0C), reg_acc(0x82), isr_at(PROM_AP_ADDRESS_START + 0x0C))) void ADC_Auto_Mode_ISR_Routine()
#else
DEFINE_ISR(ADC_Auto_Mode_ISR, 0x0C)
#endif
{
    adc24SourceData.flag.b.isAutoModeReady = 1;
}

//@------------ADC Average 中斷入口函數---------------@
#ifdef SUPPORT_ISP
__attribute__((interrupt(0x34), reg_acc(/*0x82待確認*/), isr_at(PROM_AP_ADDRESS_START + 0x10))) void ADC_Average_ISR_Routine()
#else
DEFINE_ISR(ADC_Average_ISR, 0x34)
#endif
{
     if (_eoca == 1)
     {
     	_pa4 =1;
     	_pa4 =0;
         adc24SourceData.samplingCnt++;
         // 前三筆數據丟掉，第四筆才開始處理
         if (adc24SourceData.samplingCnt > 3)
         {
             // Read current ADC
             _adcdl                             = 1;
             adc24SourceData.data.byte.byteLow  = 0x00;
             adc24SourceData.data.byte.byteMid  = _adrl_avg;
             adc24SourceData.data.byte.byteHigh = _adrm_avg;
             adc24SourceData.data.byte.byteRes  = _adrh_avg;
             _adcdl                             = 0;    // 數據讀取完成，取消鎖存
             adc24SourceData.data.adcData       = adc24SourceData.data.adcData >> 8;
             adc24SourceData.flag.b.isReady     = 1;
         }
         _eoca = 0;
     }
}

//@------------ADC 中斷入口函數---------------@
#ifdef SUPPORT_ISP
__attribute__((interrupt(0x10), reg_acc(/*0x82待確認*/), isr_at(PROM_AP_ADDRESS_START + 0x10))) void ADC_ISR_Routine()
#else
DEFINE_ISR(ADC_ISR, 0x10)
#endif
{
    if (_eoc == 1)
    {
        // ADC 轉換完成
        adc24SourceData.samplingCnt++;
        // 前三筆數據丟掉，第四筆才開始處理
        if (adc24SourceData.samplingCnt > 3)
        {
            // Read current ADC
            _adcdl                             = 1;
            adc24SourceData.data.byte.byteLow  = 0x00;
            adc24SourceData.data.byte.byteMid  = _adrl;
            adc24SourceData.data.byte.byteHigh = _adrm;
            adc24SourceData.data.byte.byteRes  = _adrh;
            _adcdl                             = 0;    // 數據讀取完成，取消鎖存
            adc24SourceData.data.adcData       = adc24SourceData.data.adcData >> 8;
            adc24SourceData.flag.b.isReady     = 1;
        }
        _eoc = 0;
    }
}
/*
// ADC 转换器自动模式 Demo
void main()
{
    // Determine whether it is a power-on reset or a reset under abnormal conditions,
    // If it is a power-on reset, perform power-on reset initialization, otherwise perform WDT overflow initialization
    if (_to == 0 || _pdf == 0)
    {
        // system init
        //...

        // ADC 转换器自动模式
        Adc24_Cfg_t adc24Cfg;
        adc24Cfg.sampleRate   = ADC24_RATE_391HZ;
        adc24Cfg.gain         = ADC24_REFx1_GAINx1;
        adc24Cfg.channel      = ADC24_CHP_OP1O_N_DAC1O;
        adc24Cfg.dataSkip     = ADC24_DATA_SKIP_3;
        adc24Cfg.dataAvgCnt   = ADC24_ADACC_DISABLE;
        adc24Cfg.autoWriteNum = ADC24_WRNUM_8;
        Adc24_adc24Cfg(adc24Cfg);
        Adc24_Enable(adc24Cfg);
        adc24SourceData.samplingCnt = 3;

        Oscillators_Cfg_t oscCfg;
        oscCfg.haltMode = HALT_MODE_IDLE_2;
        oscCfg.irc2     = IRC2_MIRC_400KHZ;
        Oscillators_Cfg(&oscCfg);

        // ADC普通模式
        Adc24_Cfg_t adc24Cfg;
        adc24Cfg.sampleRate   = ADC24_RATE_391HZ;
        adc24Cfg.gain         = ADC24_REFx1_GAINx1;
        adc24Cfg.channel      = ADC24_CHP_OP1O_N_DAC1O;
        adc24Cfg.dataSkip     = ADC24_DATA_SKIP_3;
        adc24Cfg.dataAvgCnt   = ADC24_ADACC_DISABLE;
        adc24Cfg.autoWriteNum = ADC24_WRNUM_DISABLE;
        Adc24_adc24Cfg(adc24Cfg);
        Adc24_Enable(adc24Cfg);
    }
    else
    {
        // WDT Overflow Return First Start
        GCC_CLRWDT();
    }
    while (1)
    {
        GCC_CLRWDT();
    }
}
*/
