/**
 * *************************************************************************************************************
 * @file AfePower.h
 * @author BH_CodeGenerator
 * @version 0.1
 * @date 2024-12-17
 * @warning <!--auto generated by Tools, do not modify or add anything, otherwise, your change will be lost!!! -->
 * @brief all the functions prototypes for AfePower firmware library
 * MCU / CFG Ver. :BH66F2455/1.1
 * Version = 1.0.0

 * *************************************************************************************************************
 *  @attention
 *
 *  Firmware Disclaimer Information
 *
 *  1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, which is supplied by BEST HEALTH ELECTRONIC Inc., (hereinafter referred to as BestHealth) is the
 *     proprietary and confidential intellectual property of BestHealth, and is protected by copyright law and
 *     other intellectual property laws.
 *
 *  2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *     code, is confidential information belonging to BestHealth, and must not be disclosed to any third parties
 *     other than BestHealth and the customer.
 *
 *  3. The program technical documentation, including the code, is provided and for customer reference
 *     only. After delivery by BestHealth, the customer shall use the program technical documentation, including
 *     the code, at their own risk. BestHealth disclaims any expressed, implied or statutory warranties, including
 *     the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 *  <h2><center>Copyright (C) BEST HEALTH ELECTRONIC Inc. All rights reserved</center></h2>
 */
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef _AFEPOWER_H_
#define _AFEPOWER_H_

/* Includes ------------------------------------------------------------------------------------------------*/
#include "BH66F2455.h"
#include "stdint.h"

/* Exported types ------------------------------------------------------------------------------------------*/

/*! Dac reference voltage enum */
typedef enum {
    DAC_REF_VIREF = 0x01,
    DAC_REF_AVDD  = 0x02,
    DAC_REF_HZ    = 0x03
} Dac_RefVoltage_e;

/*! Dac reference voltage selection enum */
typedef enum {
    DAC_VREF_1_25V = 0x00,    // 1.25V reference voltage
    DAC_VREF_1_83V = 0x01     // 1.83V reference voltage
} Dac_Vref_Select_e;

/*! Dac mode control bits */
typedef enum {
    DAC_MODE_DISABLE_HIGH_Z = 0x00,    // Disable, output in high impedance state
    DAC_MODE_ENABLE         = 0x01,    // Enable mode
    DAC_MODE_DISABLE_GND    = 0x10     // Disable, output grounded
} Dac_Mode_Control_e;

/*! Enumeration for internal reference voltage generator control */
typedef enum {
    IREF_DISABLE = 0x00,    // Disable the internal reference voltage generator
    IREF_ENABLE  = 0x01     // Enable the internal reference voltage generator
} Iref_Control_e;

/*! Structure for 12-bit D/A Converter control */
typedef struct {
    uint8_t modeControl;    //!< Mode control bits for the 12-bit D/A converter n @see Dac_Mode_Control_e
    uint16_t data;          //!< Output control bits for the 12-bit D/A converter n
} DAC_t;

/*! Structure for AFE Power settings */
typedef struct {
    uint8_t dacRefVol;        //!< Reference voltage setting (R/W) @see Dac_RefVoltage_e
    uint8_t dacVrefSelect;    //!< Reference voltage selection (R/W) @see Dac_Vref_Select_e
    uint8_t vrefData;         //!< Internal reference voltage generator fine-tuning control
    uint8_t irefEn;           //!< Control for the internal reference voltage generator @see Iref_Control_e
    DAC_t dac1;               //!< Control structure for DAC 1
    DAC_t dac2;               //!< Control structure for DAC 2
    DAC_t dac3;               //!< Control structure for DAC 3
} AfePower_t;

/* Exported functions --------------------------------------------------------------------------------------*/
// clang-format off
#define Dac_vref_Cfg(type)      { _irefc &= 0xFC; _irefc |= type;}; //!< Dac_RefVoltage_e
#define Dac_vref_Slect(vrefs)   { _dacvrefs = vrefs;}; //!< Dac_Vref_Slect_e
#define Viref_Cfg(x)            { _pvref = x;} //!< x 0~255
#define Viref_Enable()          { _irefen = 1;}
#define Viref_Disable()         { _irefen = 0;}

#define Dac0_Cfg(x)     { _afeda0l = (x << 4) & 0xFF; _afeda0h = x >> 4;}
#define Dac0_Enable()   { _afeda0c = 0x01;}
#define Dac0_Disable()  { _afeda0c = 0x00;}
#define Dac0_GND()      { _afeda0c = 0x10;}

#define Dac1_Cfg(x)     { _afeda1l = (x << 4) & 0xFF; _afeda1h = x >> 4;}
#define Dac1_Enable()   { _afeda1c = 0x01;}
#define Dac1_Disable()  { _afeda1c = 0x00;}
#define Dac1_GND()      { _afeda1c = 0x10;}

#define Dac2_Cfg(x)     { _afeda2l = (x << 4) & 0xFF; _afeda2h = x >> 4;}
#define Dac2_Enable()   { _afeda2c = 0x01;}
#define Dac2_Disable()  { _afeda2c = 0x00;}
#define Dac2_GND()      { _afeda2c = 0x10;}

#define Dac3_Cfg(x)     { _afeda3l = (x << 4) & 0xFF; _afeda3h = x >> 4;}
#define Dac3_Enable()   { _afeda3c = 0x01;}
#define Dac3_Disable()  { _afeda3c = 0x00;}
#define Dac3_GND()      { _afeda3c = 0x10;}

// clang-format on
#endif
