/*************************************************
File:               BM22O2121_A.h
Description:        Define the class and function of the BestModulesCorp Servo module BM22O2121-A application library
History:            V1.00   -- initial version；2021/08/22；Arduino IDE :  ≥v1.8.13
Author:             Best Modules Corp
**************************************************/

#ifndef BM22O2121_A_h
#define BM22O2121_A_h

#include "SoftwareSerial_9N1_OneWire.h"
#include "Arduino.h"

/*****************  Servo Responses     ******************/ 

#define ACK_SUCCESSFULLY                 0x00   // Transmitted successfully
#define NACK_LOW_VOLTAGE                 0x02   // System voltage is lower than 3.5V
#define NACK_STALL_PROTECTION            0x04   // stall protection
#define NACK_ANGLE_ERROR                 0x08   // Angle is incorrect
#define NACK_CHECKSUM_ERROR              0x40   // CheckSum error
#define NACK_UNSUPPORTED_COMMAND         0x80   // Unsupported command
#define FAIL                             0xAA   // Error, undefined response  

/*****************   Servo Commands     *******************/ 

#define RESET                            0x00   // Reset the servo
#define STANDBY                          0x01   // Standby the servo
#define SYNCACTION                       0x02   // Each module sets the "DelayRotate..." command and execute synchronously through the SyncAction command
#define GETVERSION                       0x03   // Get the firmware version
#define SETEID                           0x80   // Set Eid of the servo (1-15) 
#define ANGLE                            0x09   // Set the servo to rotate to an angle
#define DELAYANGLE                       0x29   // Set the delayAngle of the servo 
#define MID                              0x26   // Fixed value, 0x1E for BM22O2121
#define TLEN6                            0x60   // Packet length of (Command/Status+Param0~ParamN+CheckSum)

class BM22O2121_A
{
  public: 
        BM22O2121_A(uint8_t TxRxPin);           // Creates a new object to interface(TRX) with the Servo
        ~BM22O2121_A();
        
/***************     Command Function     ****************/  

        uint8_t Reset(uint8_t Eid);                                         // Reset the servo
        void Standby();                                                     // Let the servo standby
        void SyncAction();                                                  // Synchronous execution of "DelayRotate..."
        uint32_t GetFWVer(uint8_t Eid);                                     // Get the firmware version 
        uint8_t SetEid(uint8_t Eid);                                        // Set Eid of servo
        uint8_t Angle(uint8_t Eid,uint8_t Angle,uint16_t Time);             // Controlling servo angle and turning time
        uint8_t DelayAngle(uint8_t Eid,uint8_t Angle,uint16_t Time);        // Controlling servo angle and turning time (must be used with SyncAction function)
               
  private: 
/***************    Response Function     ****************/   
    
        uint8_t Response();                     // Help functions to response status  
        
/***************    Command Packet     *****************/   

        uint8_t GetCommandPacket6(uint8_t Eid,uint8_t Command,uint16_t Mode,uint16_t Time);
        // GetCommandPacket6 represents the 8 byte command that we send to the servo
        
        SoftwareSerial_9N1_OneWire _Serial9N1;                                                   // Define _Serial9N1 to use the SoftwareSerial_9N1_OneWire function
};

#endif
