/*************************************************
This sketch reads the smoke sensor module BM22S2021-1 information and
monitor the smoke density of the air.

Wire Connection between BM22S2021-1 and Arduino Uno:
BM22S2021-1 pin 1 (VDD) connect to Arduino Uno pin 5V
BM22S2021-1 pin 2 (VSS) connect to Arduino Uno pin GND
BM22S2021-1 pin 3 (RX) connect to Arduino Uno pin 7  
BM22S2021-1 pin 4 (TX) connect to Arduino Uno pin 6
BM22S2021-1 pin 5 (STATUS) connect to Arduino Uno pin 5

If you use a 16x2 character LCD with I2C interface,
connect SCL to Arduino Uno pin SCL
connect SDA to Arduino Uno pin SDA
connect VCC to Arduino Uno pin 5V
connect GDN to Arduino Uno pin GND

Download the LiquidCrystal_I2C library:
In Arduino IDE >> Tools >> Manage Libraries...,
search LiquidCrystal I2C, and install
**************************************************/
#include "BM22S2021-1.h"
//#include <LiquidCrystal_I2C.h>
//LiquidCrystal_I2C lcd(0x27, 16, 2);

#define rxPin 6     // Software UART RX pin
#define txPin 7     // Software UART TX pin
#define statusPin 5 // STATUS Pin：D5

uint8_t T0Astatus,T0Bstatus,rtn;
uint8_t moduleInfo[41] = {0}; // buffer to store module information

BM22S2021_1 my2021(statusPin,rxPin,txPin); //Softeware serial

void setup()
{
  my2021.begin(); // Initialize Softeware serial, baud rate 9600, Set pin5 as input 
  Serial.begin(9600);
  
  //disable UART auto output if you read/write the module using commands
  rtn = my2021.writeRegister(0x2E,0);
  //enable UART auto output if you read the module with auto receive function
  //rtn = my2021.writeRegister(0x2E,0x80);
  //Serial.println(rtn);
  
  // initialize the 16x2 LCD module
  //lcd.init();
  //lcd.backlight();
}

void loop()
{
  rtn = my2021.readRunningVariables(0x90);        // read device status
  T0Astatus = my2021.readRunningVariables(0x95);  // read channel A status
  T0Bstatus = my2021.readRunningVariables(0x96);  // read channel B status
  Serial.print("device status: 0x"); Serial.println(rtn, HEX); 
  Serial.print("Channel A status: 0x"); Serial.println(T0Astatus, HEX); 
  Serial.print("Channel B status: 0x"); Serial.println(T0Bstatus, HEX);

  //lcd.clear();
  //lcd.setCursor(0,0);
  if ((T0Astatus & 0x04)== 0x04) {
    Serial.println(" Channel A: alarm");
    //lcd.print("Ch. A: alarm");
  }
  else if ((T0Astatus & 0x02)== 0x02) {
    Serial.println(" Channel A: pre-alarm");    
    //lcd.print("Ch. A: pre-alarm");
  }
  else if ((T0Astatus & 0x08)== 0x08) {
    Serial.println(" Channel A: fault");    
    //lcd.print("Ch. A: fault");
  }
  else {
    Serial.println(" Channel A: normal");        
    //lcd.print("Ch. A: normal");
  }
  //lcd.setCursor(0,1); 
  if ((T0Bstatus & 0x04)== 0x04) {
    Serial.println(" Channel B: alarm");
    //lcd.print("Ch. B: alarm");
  }
  else if ((T0Bstatus & 0x02)== 0x02) {
    Serial.println(" Channel B: pre-alarm");
    //lcd.print("Ch. B: pre-alarm");
  }
  else if ((T0Bstatus & 0x08)== 0x08) {
    Serial.println(" Channel B: fault");
    //lcd.print("Ch. B: fault");
  }
  else {
    Serial.println(" Channel B: normal");
    //lcd.print("Ch. B: normal");
  }  
  Serial.println();
  delay(3000);
}
