/*****************************************************************
File:             BM22S2021-1.h
Author:           BEST MODULES
Description:      Define classes and required variables
History：         
V1.0.1-- initial version；2022-09-20；Arduino IDE : v1.8.19
******************************************************************/

#ifndef  _BM22S2021_h_
#define  _BM22S2021_h_

#include <Arduino.h>
#include <SoftwareSerial.h>

#define UART_BAUD 9600
#define debug 0

class BM22S2021_1
 {
    public:
    BM22S2021_1(uint8_t statusPin,HardwareSerial*theSerial);
    BM22S2021_1(uint8_t statusPin,uint8_t rxPin, uint8_t txPin);
    void  begin();

    uint8_t resetModule();                                // command U0
    uint8_t getVerDate(uint8_t buff[]);                   // command U1
    uint8_t calibrateModule();                            // command U2
    uint8_t getInfoPackage(uint8_t buff[]);               // command U3
    uint8_t writeRegister(uint8_t addr,uint8_t data);     // command U4  
    uint8_t readRegister(uint8_t addr);                   // command U5
    uint8_t readRunningVariables(uint8_t addr);           // command U6
    uint8_t restoreDefault();                             // command U7

    uint8_t autoRx(uint8_t buff[]);
    
    private:
    void readData(uint8_t buff[]);
    void writeData(uint8_t buff[],uint8_t datalength);
    void clear_UART_FIFO();
    uint8_t _rxPin;
    uint8_t _txPin;
    uint8_t _statusPin;
    HardwareSerial*_serial =NULL;
    SoftwareSerial*_softSerial =NULL;
 };

#endif
