#include <BMD26M088.h>
#include "FONT_5X7.h"
BMD26M088 Rgb(&Wire2);
#include <MsTimer.h>
volatile unsigned char cascade4_Buff[4][8]={{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0},{0,0,0,0,0,0,0,0}};
volatile uint8_t color_r = 255,color_g = 0,color_b = 0;
int stringCount=0;
int stringLen=0;
volatile uint8_t color_Count = 0;

/*     User can change     */
#define STARTPOINT 31 //Starting position of string，range 0~31
#define REFRESH_TIME 100 //Moving interval time，10~MAX,uint:ms
#define COLOR_CHANGE_TIME 2000 //Color change time,uint:ms
char displayChar[23]={'B','e','s','t',' ','M','o','d','u','l','e','s',' ','1','2','3','4','5','6','7','8','9','0'};

void setup() 
{
  cascade4_begin();  //Module initialization
  cascade4_clearAll();  //Clear screen
  
  stringCount=STARTPOINT;
  MsTimer::set(COLOR_CHANGE_TIME, colorChange);
  MsTimer::start();
  colorChange(); //Call function once，for initial color


}

void loop() 
{
  drawStringRun(displayChar,23,1);
  delay(REFRESH_TIME); //Moving refresh interval

}
/**********************************************************
Description: String refresh move to the left
Parameters :
            charBuff[]:The string to be displayed
            charLen：The length of the string to be displayed（Number of characters）
            charInterval：The interval between each character，range 0~MAX
Return: void      
Others:  
**********************************************************/
void drawStringRun(char charBuff[],uint8_t charLen,uint8_t charInterval)
{
  clear_cascade4_Buff();
  stringLen=charLen*(5+charInterval);
  stringCount--;
  clear_cascade4_Buff();
  drawString(charBuff,charLen,charInterval,stringCount);
  if(stringCount == (-stringLen))
  {
    stringCount=STARTPOINT;//After completing one round of display, restart
  }
  refresh();
}

/**********************************************************
Description: Colorful changes in color, customizable
Parameters : none
Return: void      
Others:  
**********************************************************/
void colorChange()
{
  color_Count++;
  if(color_Count == 7)
  {
    color_Count = 1;
  }
  switch(color_Count)
  {
    case 1:
       setColor(255,0,0);
       break;
    case 2:
       setColor(0,255,0);
       break;
    case 3:
       setColor(0,0,255);
       break;
    case 4:
       setColor(125,125,0);
       break;
    case 5:
       setColor(0,125,125);
       break;
    case 6:
       setColor(125,0,125);
       break;
    default:
       break;
  }
}


/**********************************************************
Description: Initialize 4 modules
Parameters : none
Return: void      
Others:  
**********************************************************/
void cascade4_begin()
{
  Rgb.begin(BMD26M088_I2C_ADDRESS_VDD);
  Rgb.begin(BMD26M088_I2C_ADDRESS_SDA);
  Rgb.begin(BMD26M088_I2C_ADDRESS_SCL);
  Rgb.begin(BMD26M088_I2C_ADDRESS_GND);
}

/**********************************************************
Description: Clear screen
Parameters : none
Return: void      
Others:  
**********************************************************/
void cascade4_clearAll()
{
  Rgb.clearAll(BMD26M088_I2C_ADDRESS_VDD);
  Rgb.clearAll(BMD26M088_I2C_ADDRESS_SDA);
  Rgb.clearAll(BMD26M088_I2C_ADDRESS_SCL);
  Rgb.clearAll(BMD26M088_I2C_ADDRESS_GND);
}

/**********************************************************
Description: Clear cascade4_Buff[]
Parameters : none
Return: void      
Others:  
**********************************************************/
void clear_cascade4_Buff()
{
  for(uint8_t i=0;i<4;i++)
  {
    for(uint8_t j=0;j<8;j++)
    {
      cascade4_Buff[i][j]=0;
    }
  }
}

/**********************************************************
Description: Display a string at a certain location
Parameters :
            charBuff[]:The string to be displayed
            charLen：The length of the string to be displayed（Number of characters）
            charInterval：The interval between each character，range 0~MAX
            position：Position of string display，range-(charLen*(5+charInterval)) ~ 31.Exceeding the limit will not be displayed on the screen
Return: void      
Others:  
**********************************************************/
void drawString(char charBuff[],uint8_t charLen,uint8_t charInterval,int position)
{
  uint8_t i = 0;
  for(i = 0;i < charLen;i++)
  {
    drawCharPosition(charBuff[i],(5+charInterval)*i+position);
  }
}


/**********************************************************
Description: set color
Parameters :
            R :color_r
            G :color_g
            B :color_b
Return: void      
Others:  
**********************************************************/
void setColor(uint8_t R, uint8_t G, uint8_t B)
{
  color_r = R;
  color_g = G;
  color_b = B;
}

/**********************************************************
Description: Display a character at a certain location
Parameters :
            Ch :Characters to be displayed
            position：The position of the character display，range -4 ~ 31.Exceeding the limit will not be displayed on the screen
Return: void      
Others:  
**********************************************************/
void drawCharPosition(char Ch,int position)
{
  uint8_t Index;
  int8_t i, j;
  Index = Ch - 32;
  if(position< (-4) || position> (31))
  {
    //Out of range
  }
  else if(position>= (-4) && position<= (-1))
  {
    for(i = 0;i<7;i++)
    {
      cascade4_Buff[0][i]|=ASCII_5X7[Index][i]>>abs(position);
    }
  }
  else if(position>= (0) && position<= (3))
  {
    for(i = 0;i<7;i++)
    {
      cascade4_Buff[0][i]|=ASCII_5X7[Index][i]<<position;
    }
  }
  else if(position>= (4) && position<= (7))
  {
    for(i = 0;i<7;i++)
    {
      cascade4_Buff[0][i]|=ASCII_5X7[Index][i]<<position;
    }
    for(i = 0;i<7;i++)
    {
      cascade4_Buff[1][i]|=ASCII_5X7[Index][i]>>(8-position);
    }
  }
  else if(position>= (8) && position<= (11))
  {
    for(i = 0;i<7;i++)
    {
      cascade4_Buff[1][i]|=ASCII_5X7[Index][i]<<(position-8);
    }
  }
  else if(position>= (12) && position<= (15))
  {
    for(i = 0;i<7;i++)
    {
      cascade4_Buff[1][i]|=ASCII_5X7[Index][i]<<(position-8);
    }
    for(i = 0;i<7;i++)
    {
      cascade4_Buff[2][i]|=ASCII_5X7[Index][i]>>(16-position);
    }
  }
  else if(position>= (16) && position<= (19))
  {
    for(i = 0;i<7;i++)
    {
      cascade4_Buff[2][i]|=ASCII_5X7[Index][i]<<(position-16);
    }
  }
  else if(position>= (20) && position<= (23))
  {
    for(i = 0;i<7;i++)
    {
      cascade4_Buff[2][i]|=ASCII_5X7[Index][i]<<(position-16);
    }
    for(i = 0;i<7;i++)
    {
      cascade4_Buff[3][i]|=ASCII_5X7[Index][i]>>(24-position);
    }
  }
  else if(position>= (24) && position<= (27))
  {
    for(i = 0;i<7;i++)
    {
      cascade4_Buff[3][i]|=ASCII_5X7[Index][i]<<(position-24);
    }
  }
  else if(position>= (28) && position<= (31))
  {
    for(i = 0;i<7;i++)
    {
      cascade4_Buff[3][i]|=ASCII_5X7[Index][i]<<(position-24);
    }
  }
  else
  {
    
  }

}


/**********************************************************
Description: refresh RGB
Parameters : None
Return: void      
Others:  
**********************************************************/
void refresh()
{
  uint8_t i = 0,j = 0;
  uint8_t Temp =0;

  for(i = 0; i < 8; i++)
  {
    Temp = cascade4_Buff[0][i];
    for(j = 0; j < 8; j++)
    {
      if(((Temp >> j)  & 0x01))
      {
        Rgb.writeRGB(BMD26M088_I2C_ADDRESS_VDD, i * 8 + j, color_r,color_g,color_b);
      }
      else
      {
        Rgb.writeRGB(BMD26M088_I2C_ADDRESS_VDD, i * 8 + j, 0,0,0);
      }
    }
  }
  for(i = 0; i < 8; i++)
  {
    Temp = cascade4_Buff[1][i];
    for(j = 0; j < 8; j++)
    {
      if(((Temp >> j)  & 0x01))
      {
        Rgb.writeRGB(BMD26M088_I2C_ADDRESS_SDA, i * 8 + j, color_r,color_g,color_b);
      }
      else
      {
        Rgb.writeRGB(BMD26M088_I2C_ADDRESS_SDA, i * 8 + j, 0,0,0);
      }
    }
  }
  for(i = 0; i < 8; i++)
  {
    Temp = cascade4_Buff[2][i];
    for(j = 0; j < 8; j++)
    {
      if(((Temp >> j)  & 0x01))
      {
        Rgb.writeRGB(BMD26M088_I2C_ADDRESS_SCL, i * 8 + j, color_r,color_g,color_b);
      }
      else
      {
        Rgb.writeRGB(BMD26M088_I2C_ADDRESS_SCL, i * 8 + j, 0,0,0);
      }
    }
  }
  for(i = 0; i < 8; i++)
  {
    Temp = cascade4_Buff[3][i];
    for(j = 0; j < 8; j++)
    {
      if(((Temp >> j)  & 0x01))
      {
        Rgb.writeRGB(BMD26M088_I2C_ADDRESS_GND, i * 8 + j, color_r,color_g,color_b);
      }
      else
      {
        Rgb.writeRGB(BMD26M088_I2C_ADDRESS_GND, i * 8 + j, 0,0,0);
      }
    }
  }


}

