/*********************************************************************************************************//**
 * @file    BMH06203_HT32/src/BMH06203.h
 * @version V1.0.1
 * @date    2024-08-01
 * @brief   The header file of BMH06203 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BMH06203_H
#define __BMH06203_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "i2c_master_config.h"
#include "ht32_board_config.h"
#include "bmduino_check.h"

#include "middleware/i2c_master.h"
#include "middleware/uart_module.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Exported typedef ----------------------------------------------------------------------------------------*/
typedef enum {
  BMH06203_SUCCESS,
  BMH06203_FAILURE
} BMH06203_selStatus;
/* Exported constants --------------------------------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------------------------------------*/
#define BMH06203_MASTERADDR     		0x28
#define BMH06203_CLKFREQ        		100000

#define BMH06203_READ_OK          	0
#define BMH06203_READ_ERROR       	1
#define BMH06203_NO_ACK           	2
#define BMH06203_TIMEOUT_ERROR    	3

#define BMH06203_DISABLE         	0
#define BMH06203_ENABLE          	1	 

#define BMH06203_IIC_MODE  0x00
#define BMH06203_PWM_MODE  0x01
#define BMH06203_IO_MODE1  0x02// temperature threshold IO_C output low leveltemperature threshold IO_C output high level
#define BMH06203_IO_MODE2 	0x06//temperature threshold IO_C output high leveltemperature threshold IO_C output low level

#define BMH06203_AMB_TEMP  0x08  // Environment temperature(unit )
#define BMH06203_OBJ_TEMP 	0x09  // Surface temperature(unit )
#define BMH06203_BODY_TEMP 0x0A // Body temperature(unit )
/* Exported variables --------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/
BMH06203_selStatus BMH63K203_selWire(uint32_t wire_number);
void BMH06203_Init(void);

float BMH06203_readTemperature(uint8_t TYPE);
void BMH06203_sleep(void);
void BMH06203_writeEEPROM(uint8_t addr, uint16_t data);
uint16_t BMH06203_readEEPROM(uint8_t addr);
void BMH06203_setMode(uint8_t Mode);
void BMH06203_setPWMParam(uint16_t min,uint16_t max);
void BMH06203_setIOParam(uint16_t threshold);
		
void BMH06203_writeBytes(uint8_t wbuf[], uint8_t wlen);
uint8_t BMH06203_readBytes(uint8_t rbuf[], uint8_t rlen);
void _BMH06203_delay(vu32 count);
void _BMH06203_SCL_Init(void);
void _BMH06203_SCL_HIGH(void);
void _BMH06203_SCL_LOW(void);

#ifdef __cplusplus
}
#endif

#endif
