/*********************************************************************************************************//**
 * @file    BMV23M001_HT32/src/BMV23M001.h
 * @version V1.0.1
 * @date    2024-08-01
 * @brief   The header file of BMV23M001 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BMV23M001_H
#define __BMV23M001_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "i2c_master_config.h"
#include "ht32_board_config.h"
#include "bmduino_check.h"

#include "middleware/i2c_master.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Exported typedef ----------------------------------------------------------------------------------------*/
typedef enum {
  BMV23M001_SUCCESS,
  BMV23M001_FAILURE
} BMV23M001_selStatus;
/* Exported constants --------------------------------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------------------------------------*/
#define BMV23M001_MASTERADDR     		0x4B
#define BMV23M001_CLKFREQ        		100000

#define BMV23M001_READ_OK          	0
#define BMV23M001_READ_ERROR       	1
#define BMV23M001_NO_ACK           	2
#define BMV23M001_TIMEOUT_ERROR    	3

#define BMV23M001_DISABLE         	0
#define BMV23M001_ENABLE          	1	 

#define StatusFAIL      (3)
/* Exported variables --------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/
BMV23M001_selStatus BMV23M001_selWire(uint32_t wire_number);
void BMV23M001_Init(void);

uint16_t BMV23M001_ADC_GetA0(void);
uint16_t BMV23M001_ADC_GetA1(void);
uint8_t BMV23M001_getStatus(void);
uint8_t BMV23M001_getGateStatus(void);
uint8_t BMV23M001_readSoundStatus(void);
uint16_t BMV23M001_readSoundEnvelopeADC(void);
uint16_t BMV23M001_getFWVer(void);
void BMV23M001_writeBytes(uint8_t wbuf[], uint8_t wlen);
uint8_t BMV23M001_readBytes(uint8_t rbuf[], uint8_t rlen);
void _BMV23M001_delay(vu32 count);

#ifdef __cplusplus
}
#endif

#endif
