/*****************************************************************
  File:        BM42S3021-1_demo
  Description: 
******************************************************************/
#include "BM42S3021-1.h"
#include <BMD58T280.h>

#if !defined(ARDUINO_AVR_UNO) // For BMduino
BMD58T280 TFTscreen;          // Create LCD objects. Please comment out this line of code if you don't use EBI mode
//BMD58T280 TFTscreen(&SPI);    // Create LCD objects. Please comment out this line of code if you don't use SPI mode
#else // For UNO
BMD58T280 TFTscreen(&SPI);    // Create LCD objects
#endif

BM42S3021_1 mymod(&Wire1);//Please uncomment out this line of code if you use HW Serial on BMduino

String tmp_data;
char char_temp[20];
uint8_t type;
float tempC, tempF;
void setup()
{
  mymod.begin();
  TFTscreen.begin();
  Serial.begin(9600);
  mymod.setThermocoupleType(Type_K);
  TFTscreen.setRotation(1);
  TFTscreen.background(0, 0, 0);
  TFTscreen.stroke(255, 255, 255);
  TFTscreen.setTextSize(3);
  TFTscreen.text("BM42S3021-1", 70, 0, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
  TFTscreen.setTextSize(6);
  TFTscreen.text("C:", 10, 70, BM_ILI9341::YELLOW, BM_ILI9341::BLACK);
  TFTscreen.text("F:", 10, 140, BM_ILI9341::YELLOW, BM_ILI9341::BLACK);
}

void loop()
{
  tempC = mymod.readTemperature();
  tempF = (tempC * 1.8) + 32;
  Serial.print("C:");
  Serial.print(tempC);
  Serial.print("    F:");
  Serial.println(tempF);
  TFTdisplay();
}

void TFTdisplay()
{
  tmp_data = String(tempC, 1);
  tmp_data = tmp_data + "  ";
  tmp_data.toCharArray(char_temp, 20);
  TFTscreen.text(char_temp, 82, 70, BM_ILI9341 ::YELLOW, BM_ILI9341::BLACK);
  tmp_data = String(tempF, 1);
  tmp_data = tmp_data + "  ";
  tmp_data.toCharArray(char_temp, 20);
  TFTscreen.text(char_temp, 82, 140, BM_ILI9341 ::YELLOW, BM_ILI9341::BLACK);
}
