/*********************************************************************************************************//**
 * @file    BME82M131_HT32/src/BME82M131.h
 * @version V1.0.1
 * @date    2024-09-06
 * @brief   The header file of BM62S2201_1 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BME82M131_H
#define __BME82M131_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "i2c_master_config.h"
#include "ht32_board_config.h"
#include "bmduino_check.h"

#include "middleware/i2c_master.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Exported typedef ----------------------------------------------------------------------------------------*/
typedef enum {
  BME82M131_SUCCESS,
  BME82M131_FAILURE
} BME82M131_selStatus;
/** GAIN selection */
typedef enum
{
  BME82M131_GAIN_1,         // ALS gain 1x
  BME82M131_GAIN_2,				  // ALS gain 2x
  BME82M131_GAIN_1_8,       // ALS gain 1/8x
  BME82M131_GAIN_1_4,       // ALS gain 1/4x
  BME82M131_GAIN_INVALID
} BME82M131_GAIN_t;
/** ALS integration time setting */
typedef enum
{
	BME82M131_IT_25ms,        // ALS intetgration time 25ms
	BME82M131_IT_50ms,        // ALS intetgration time 50ms
	BME82M131_IT_100ms,				// ALS intetgration time 100ms
	BME82M131_IT_200ms,				// ALS intetgration time 200ms
	BME82M131_IT_400ms,				// ALS intetgration time 400ms
	BME82M131_IT_800ms,				// ALS intetgration time 800ms
	BME82M131_IT_INVALID
} BME82M131_IT_TIME_t;
		
typedef enum
{
	BME82M131_CONF_IT_25ms = 0x0c,      // 0b1100-ALS intetgration time 25ms
	BME82M131_CONF_IT_50ms = 0x08,      // 0b1000-ALS intetgration time 50ms
	BME82M131_CONF_IT_100ms = 0x00,		  // 0b0000-ALS intetgration time 100ms
  BME82M131_CONF_IT_200ms = 0x01,			// 0b0001-ALS intetgration time 200ms
	BME82M131_CONF_IT_400ms = 0x02,			// 0b0010-ALS intetgration time 400ms
  BME82M131_CONF_IT_800ms = 0x03,			// 0b0011-ALS intetgration time 800ms
  BME82M131_CONF_IT_INVALID
} BME82M131_CONF_IT_TIME_t;	
/** ALS persistence protect number setting */
typedef enum
{
  BME82M131_PERS_1,							// ALS irq persisance 1 sample
  BME82M131_PERS_2,             // ALS irq persisance 2 sample
  BME82M131_PERS_4,							// ALS irq persisance 4 sample
  BME82M131_PERS_8,							// ALS irq persisance 8 sample
  BME82M131_PERS_INVALID
} BME82M131_PERS_t;

/** ALS interrupt enable setting */
typedef enum
{
  BME82M131_INT_DISABLE,
  BME82M131_INT_ENABLE,
  BME82M131_INT_INVALID
} BME82M131_INTEN_t;
/** ALS shut down setting */
typedef enum
{
  BME82M131_POWER_ON,
  BME82M131_SHUT_DOWN,
  BME82M131_SD_INVALID
} BME82M131_SD_t;
typedef enum
{
	BME82M131_POWER_SAVING_MODE1,              //Power saving mode 1
	BME82M131_POWER_SAVING_MODE2, 						 //Power saving mode 2
	BME82M131_POWER_SAVING_MODE3,						   //Power saving mode 3
	BME82M131_POWER_SAVING_MODE4, 						 //Power saving mode 4
	BME82M131_POWER_SAVING_INVALID
} BME82M131_PSM_MODE_t;
typedef enum
{
	BME82M131_POWER_SAVING_MODE_DISABLE,                             
	BME82M131_POWER_SAVING_MODE_ENABLE,
	BME82M131_PSMEN_INVALID
} BME82M131_PSMEN_t;
/** ALS interrupt status, logical OR of the crossing low and high thrteshold INT triggers */
typedef enum
{
  BME82M131_INT_STATUS_NONE,
  BME82M131_INT_STATUS_HIGH,
  BME82M131_INT_STATUS_LOW,
  BME82M131_INT_STATUS_BOTH,
  BME82M131_INT_STATUS_INVALID
} BME82M131_INT_STATUS_t;
/* Exported constants --------------------------------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------------------------------------*/
#define BME82M131_MODULE_MID     0x48
#define BME82M131_MASTERADDR     0x48
#define BME82M131_CLKFREQ        100000

/* Exported variables --------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/
BME82M131_selStatus BME82M131_selWire(uint32_t wire_number);
void BME82M131_Init(void);

uint8_t BME82M131_getINT(void);
uint8_t BME82M131_getNumber(void);
uint16_t BME82M131_readALS(uint8_t sensornumber);
uint16_t BME82M131_readWhite(uint8_t sensornumber);
float BME82M131_readLux(uint8_t sensorNmuber);
uint8_t BME82M131_getInterruptFalg(uint8_t sensorNmuber);

uint8_t BME82M131_getPowerSavingMode(uint8_t sensorNmuber); 
uint8_t BME82M131_getPowerSavingModeStatus(uint8_t sensorNmuber); 
uint8_t BME82M131_getMoudleStatus(uint8_t sensorNmuber);      
uint8_t BME82M131_isInterruptEnabled(uint8_t sensorNmuber); 
uint8_t BME82M131_getPersistence(uint8_t sensorNmuber);
uint8_t BME82M131_getIntegrationTime(uint8_t sensorNmuber);
uint8_t BME82M131_getGain(uint8_t sensorNmuber); 
uint16_t BME82M131_getHighThreshold(uint8_t sensorNmuber);
uint16_t BME82M131_getLowThreshold(uint8_t sensorNmuber);
    
bool BME82M131_setPowerSavingMode(uint8_t sensorNmuber, BME82M131_PSM_MODE_t mode);  
bool BME82M131_setPowerSavingModeStatus(uint8_t sensorNmuber, BME82M131_PSMEN_t psmen);   
bool BME82M131_ALSOn( uint8_t sensorNmuber);
bool BME82M131_ALSDown( uint8_t sensorNmuber); 
bool BME82M131_setInterruptStatus(uint8_t sensorNmuber, BME82M131_INTEN_t ie);   
bool BME82M131_setPersistence(uint8_t sensorNmuber, BME82M131_PERS_t pers);  
bool BME82M131_setIntegrationTime(uint8_t sensorNmuber, BME82M131_IT_TIME_t it);
bool BME82M131_setGain(uint8_t sensorNmuber, BME82M131_GAIN_t gain); 
bool BME82M131_setHighThreshold(uint8_t sensorNmuber, uint16_t threshold);
bool BME82M131_setLowThreshold(uint8_t sensorNmuber, uint16_t threshold); 
		
/* private  */
bool BME82M131_initialize(void);
bool BME82M131_isConnected(void);
bool BME82M131_setStatus(uint8_t sensornumber, BME82M131_SD_t sd);     
void BME82M131_sendData(uint8_t id, uint8_t len, uint8_t par[]); 
void BME82M131_writeBytes(uint8_t wbuf[], uint8_t wlen);       
bool BME82M131_readBytes(uint8_t rbuf[], uint8_t rlen);
bool BME82M131_getAlsConfig(uint8_t sensornumber,uint16_t *als_conf);
bool BME82M131_getPsmReg(uint8_t sensorNmuber, uint16_t *psm);
BME82M131_IT_TIME_t ITTimeFromCONf(BME82M131_CONF_IT_TIME_t it);
BME82M131_CONF_IT_TIME_t configITTime(BME82M131_IT_TIME_t it);
void _BME82M131_delay(vu32 count);



#ifdef __cplusplus
}
#endif

#endif

