/*************************************************************************************************************
 * @file    BM25S3221_1_HT32/example_readDustConcentration/main.c
 * @version V1.0.1
 * @date    2025-06-21
 * @brief   Main program.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/

/* Includes ------------------------------------------------------------------------------------------------*/
#include "ht32.h"
#include "ht32_board.h"
#include "ht32_board_config.h"
#include "BM25S3221_1.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Private types -------------------------------------------------------------------------------------------*/
/* Private constants ---------------------------------------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------------------------------------*/
/* Global variables ----------------------------------------------------------------------------------------*/
#define PM1_0 dustValue[0]
#define PM2_5 dustValue[1]
#define PM10 dustValue[2]
uint8_t dataBuf[32] = {0}, command = 0;
uint16_t dustValue[3] = {0};

/* Private variables ---------------------------------------------------------------------------------------*/
/* Global functions ----------------------------------------------------------------------------------------*/
void delay(vu32 count);
void displayMenu(void);
void selectMode(void);
void SerialMonitor_Init(void);
uint8_t SerialMonitor_Read(uint8_t rbuf[], uint8_t rlen);
/***********************************************************************************************************
 * @brief  Main program.
 * @retval None
 ***********************************************************************************************************/
int main(void)
{
  SerialMonitor_Init(); // Initialise the serial monitor with a baud rate of 115200
  BM25S3221_1_Init();   // Module initialization using UART communication.
  delay(200);
  displayMenu();
  while (1)
  {
    selectMode();
    if (command == 1)
    {
      if (BM25S3221_1_readDustValue(dustValue) == BM25S3221_1_CHECK_OK)
      {
        // PM2_5 = BM25S3221_1_readPM25Value();
        // printf("PM2.5:%d\n", PM2_5);
        printf("PM1.0:%d  PM2.5:%d  PM10:%d\n", PM1_0, PM2_5, PM10); // Unit: ug/m^3
        delay(1000);
      }
      else
      {
        printf("read failed!\n");
      }
    }
    if (command == 2)
    {
      if (BM25S3221_1_isInfoAvailable() == true)
      {
        BM25S3221_1_readInfoPacket(dataBuf);
        PM1_0 = ((uint16_t)dataBuf[10] << 8) + dataBuf[11];
        PM2_5 = ((uint16_t)dataBuf[12] << 8) + dataBuf[13];
        PM10 = ((uint16_t)dataBuf[14] << 8) + dataBuf[15];
        printf("PM1.0:%d  PM2.5:%d  PM10:%d\n", PM1_0, PM2_5, PM10); // Unit: ug/m^3
      }
    }
  }
}

/* Private functions ---------------------------------------------------------------------------------------*/
/***********************************************************************************************************
 * @brief  delay ms.
 * @param  count
 * @retval void
 ************************************************************************************************************/
void delay(vu32 count)
{
  count = SystemCoreClock / 8000 * count;
  while (count--)
    ;
}
/***********************************************************************************************************
 * @brief  Display select menu.
 * @param  void
 * @retval void
 ************************************************************************************************************/
void displayMenu(void)
{
  printf("==== Enter the serial number to run the corresponding command ====\n");
  printf("1. Setup the module to command query mode.\n");
  printf("2. Setup the module to active upload mode.\n");
  printf("==================================================================\n");
  printf("Please input key for printf....\n");
}
/***********************************************************************************************************
 * @brief  Select mode.
 * @param  void
 * @retval void
 ************************************************************************************************************/
void selectMode(void)
{
  uint8_t tmp[2] = {0};
  if (USART_GetFIFOStatus(RETARGET_USART_PORT, USART_FIFO_RX) > 0)
  {
    SerialMonitor_Read(tmp, 2);
    if (tmp[1] == 13) // Carriage return: 13(ASCII code)
    {
      command = tmp[0] - 48;
    }
    else
    {
      command = 0;
    }
    switch (command)
    {
    case 0:
      printf("Please set carriage return as the ending character.\n");
      break;
    case 1:
      printf("1. Setup the module to command query mode.\n");
      BM25S3221_1_setUploadMode(BM25S3221_1_CMD);
      delay(100);
      break;
    case 2:
      printf("2. Setup the module to active upload mode.\n");
      BM25S3221_1_setUploadMode(BM25S3221_1_AUTO);
      break;
    default:
      printf("Please enter the correct serial number.\n");
    }
    printf("\n");
  }
}
/***********************************************************************************************************
 * @brief  Serial monitor init.
 * @param  void
 * @retval void
 ***********************************************************************************************************/
void SerialMonitor_Init(void)
{
  RETARGET_Configuration();
  { /* Enable peripheral clock of Rx GPIO                                                                 */
    CKCU_PeripClockConfig_TypeDef CKCUClock = {{0}};
    CKCUClock.Bit.HTCFG_UART_RX_GPIO_CLK = 1;
    CKCU_PeripClockConfig(CKCUClock, ENABLE);
  }
  /* Turn on UxART Rx internal pull up resistor to prevent unknow state                                    */
  GPIO_PullResistorConfig(HTCFG_UART_RX_GPIO_PORT, HTCFG_UART_RX_GPIO_PIN, GPIO_PR_UP); // PA5 pull up
}
/***********************************************************************************************************
 * @brief  Read data to serial monitor
 * @param  rbuf:Variables for storing Data to be obtained
 * @param  rlen:Length of data to be obtained
 * @retval result
 *    @arg 0: Read successed
 *    @arg 1: Read fail, Timeout
 ************************************************************************************************************/
uint8_t SerialMonitor_Read(uint8_t rbuf[], uint8_t rlen)
{
  uint8_t i = 0, delayCount = 0;
  for (i = 0; i < rlen; i++)
  {
    delayCount = 0;
    while (USART_GetFIFOStatus(RETARGET_USART_PORT, USART_FIFO_RX) == 0)
    {
      if (delayCount > 50)
      {
        return 1;
      }
      delay(1);
      delayCount++;
    }
    rbuf[i] = USART_ReceiveData(RETARGET_USART_PORT);
  }
  return 0;
}
