/*************************************************************************************************************
 * @file    BM25S3221_1_HT32/src/BM25S3221_1.h
 * @version V1.0.1
 * @date    2025-06-21
 * @brief   The header file of BM25S3221_1 driver.
 *************************************************************************************************************
 * @attention
 *
 * Firmware Disclaimer Information
 *
 * 1. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, which is supplied by Holtek Semiconductor Inc., (hereinafter referred to as "HOLTEK") is the
 *    proprietary and confidential intellectual property of HOLTEK, and is protected by copyright law and
 *    other intellectual property laws.
 *
 * 2. The customer hereby acknowledges and agrees that the program technical documentation, including the
 *    code, is confidential information belonging to HOLTEK, and must not be disclosed to any third parties
 *    other than HOLTEK and the customer.
 *
 * 3. The program technical documentation, including the code, is provided "as is" and for customer reference
 *    only. After delivery by HOLTEK, the customer shall use the program technical documentation, including
 *    the code, at their own risk. HOLTEK disclaims any expressed, implied or statutory warranties, including
 *    the warranties of merchantability, satisfactory quality and fitness for a particular purpose.
 *
 * <h2><center>Copyright (C) Holtek Semiconductor Inc. All rights reserved</center></h2>
 ************************************************************************************************************/
/* Define to prevent recursive inclusion -------------------------------------------------------------------*/
#ifndef __BM25S3221_1_H
#define __BM25S3221_1_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------------------------------------*/
/*
  !!! PORTING !!!
  Include related header files.
*/
#include "ht32.h"
#include "i2c_master_config.h"
#include "ht32_board_config.h"
#include "bmduino_check.h"

#include "middleware/uart_module.h"

/* Settings ------------------------------------------------------------------------------------------------*/
/* Exported typedef ----------------------------------------------------------------------------------------*/
typedef enum {
  BM25S3221_1_SUCCESS,
  BM25S3221_1_FAILURE
} BM25S3221_1_selStatus;
/* Exported constants --------------------------------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------------------------------------*/
#define BM25S3221_1_CHECK_OK                 (0)
#define BM25S3221_1_CHECK_ERROR              (1)
#define BM25S3221_1_TIMEOUT_ERROR            (2)

#define BM25S3221_1_UART_TXTIMEOUT           (1000) // uint:baud clock
#define BM25S3221_1_UART_RXTIMEOUT_BYTE      (50) // uint:ms

#define BM25S3221_1_AUTO	(0x40)
#define BM25S3221_1_CMD		(0x41)
/* Exported variables --------------------------------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------------------------------------*/
BM25S3221_1_selStatus BM25S3221_1_selSerial(uint32_t serial_number);
void BM25S3221_1_Init(void);
uint16_t BM25S3221_1_readPM25Value(void);
uint8_t BM25S3221_1_readDustValue(uint16_t array[]);
bool BM25S3221_1_isInfoAvailable(void);
void BM25S3221_1_readInfoPacket(uint8_t array[]);
void BM25S3221_1_setUploadMode(uint8_t modeCode);
uint8_t BM25S3221_1_sleep(void);
uint8_t BM25S3221_1_wakeUp(void);

void BM25S3221_1_writeBytes(uint8_t wbuf[], uint8_t wlen);
uint8_t BM25S3221_1_readBytes(uint8_t rbuf[], uint8_t rlen);
void _BM25S3221_1_delayMs(uint32_t count);
#ifdef __cplusplus
}
#endif

#endif

