/************************************************************
* BM22O2421-A Servo Module example code
* Arduino IDE version: 1.8.13
* Arduino Board: UNO R3
* Wire Connection:
*   BM22O2421-A Servo Module (VDD) connects to power 12V
*   BM22O2421-A Servo Module (TRX) connects to UNO pin 8
*   BM22O2421-A Servo Module (GND) connects to UNO pin GND
*   
* Created on 2021/08/22 by Best Modules Corp.
*************************************************************/
// This example code assumes there are 2 servos on the same link,
// their EID (Eid1, Eid2) has been set to 1 and 2 respectively.

#include "BM22O2421_A.h"
#define trxPin 8 
uint8_t Eid1=1, Eid2=2;        //Eid value can be from 1 to 15
BM22O2421_A _Servo(trxPin);
void setup() 
{
  Serial.begin(9600);
}

void loop() 
{ 
  Serial.println("Servo1:DelayAngle = 0");
  _Servo.DelayAngle(Eid1,0,1000);
  Serial.println("Servo2:DelayAngle = 0");
  _Servo.DelayAngle(Eid2,0,1000);
  Serial.println("SyncAction");
  _Servo.SyncAction();
  delay(3000);

  Serial.println("Servo1:DelayAngle = 60");
  _Servo.DelayAngle(Eid1,60,1000);
  Serial.println("Servo2:DelayAngle = 60");
  _Servo.DelayAngle(Eid2,60,1000);
  Serial.println("SyncAction");
  _Servo.SyncAction();
  delay(3000);

  Serial.println("Servo1:Rotate, clockwise, 3 seconds");
  _Servo.DelayRotate(Eid1,1000,3000);
  Serial.println("Servo2:Rotate, clockwise, 3 seconds");
  _Servo.DelayRotate(Eid2,1000,3000);
  Serial.println("SyncAction");
  _Servo.SyncAction();
  delay(5000);

  Serial.println("Servo1:Rotate, counterclockwise, 3 seconds");
  _Servo.DelayRotate(Eid1,-1000,3000);
  Serial.println("Servo2:Rotate, counterclockwise, 3 seconds");
  _Servo.DelayRotate(Eid2,-1000,3000);
  Serial.println("SyncAction");
  _Servo.SyncAction();
  delay(5000); 
}
