/*************************************************
File:         BM22S402x-1_demo.ino
Description:  
Note:         
**************************************************/
#include "BM22S402x-1.h" //PIR library
#include "BM22O2x21-A.h" //Digital servo library
#include <BMD58T280.h> //TFT LCD library
#include <MsTimer.h> // Timer library
#define SERVO_EID 1
BM22S402x_1 pir(&Serial2);
BMD58T280 tft;
BM22O2221_A servo(&Serial1);

bool ispreheat = true, isTrigger = false;
volatile int8_t delayTime = 3;
volatile uint32_t previousTime = 0, currentTime = 0;
uint8_t error = 0, sta_PIR = 0, sta_PIR_old = 0;
String tmp_data;
char char_data[3] = {0};

void setupPIR();
void setupServo();
void preheatPIR();
void initDisplay();

void setup()
{
  /*Initialize module*/   
  pir.begin();
  servo.begin();
  tft.begin();
  Serial.begin(115200); // Initialize Serial, baud rate 115200bps
  delay(100);
  /*Initialize I/O*/
  pinMode(STATUS2,OUTPUT);
  digitalWrite(STATUS2, LOW);

  setupPIR();
  setupServo();
  initDisplay();
  delay(100);

  /*Initialize Timer*/
  MsTimer::set(1000, timeISR); // Count period:1 sec.
  MsTimer::start();
}

void loop()
{
  if (ispreheat == true)
  {
    preheatPIR();
  }
  sta_PIR = pir.isTrigger();
  // Serial.print("sta_PIR:");
  // Serial.println(sta_PIR);
  if (sta_PIR != sta_PIR_old)
  {
    sta_PIR_old = sta_PIR;
    if (sta_PIR == 1)
    {
      digitalWrite(STATUS2, HIGH);
      servo.setPosTime(SERVO_EID, 90, 500); // The servo rotates 90 degrees
      tft.setTextSize(4);
      tft.text("   Alarm   ", 30, 5, BM_ILI9341::YELLOW, BM_ILI9341::BLACK); // Display "Alarm"
      isTrigger = true;
      delayTime = 3;
      MsTimer::start(); // Start timer
    }
  }
  if (isTrigger == true) 
  {
    // Display countdown
    tmp_data = String(delayTime);
    tmp_data.toCharArray(char_data, 3);
    tft.setTextSize(20);
    tft.text(char_data, 110, 65, BM_ILI9341::YELLOW, BM_ILI9341::BLACK);
    // Serial.print("delayTime:");
    // Serial.println(delayTime);
    if (delayTime <= 0)
    {
      digitalWrite(STATUS2, LOW);
      servo.setPosTime(SERVO_EID, 0, 500); // The servo returns to 0 degrees
      tft.setTextSize(4);
      tft.text("           ", 30, 5, BM_ILI9341::YELLOW, BM_ILI9341::BLACK); // Clear "Alarm"
      isTrigger = false;
      MsTimer::stop();
    }
  }
}

void setupPIR()
{
  /* Setup PIR module */
  error += pir.writeCommand(0x07, L1); // Sensitivity level: 1(Most sensitive)
  /* Single trigger mode */
  // error += pir.writeCommand(0x09, 10);   // Delay time: 10*0.1 = 1 sec
  // error += pir.writeCommand(0x0b, 5);    // Block time:  5*0.2 = 1 sec
  // error += pir.writeCommand(0x05, 0x69); // LVD disable, enable PIR, single trigger, AUTO mode
  /* Continue trigger mode */
  error += pir.writeCommand(0x05, 0x6B); // LVD disable, enable PIR, continue trigger, AUTO mode
  if (error == 0)
  {
    Serial.println("PIR setup succeeded!");
  }
  else
  {
    Serial.println("PIR setup failed.");
  }
  delay(100);
}

void setupServo()
{
  uint16_t FWVer;
  /* Setup servo module.
  If the EID of the servo is not equal to 1, uncomment the following program*/
  // if (servo.setEID(1) == SUCCESS)
  // {
  //   Serial.println("Servo EID setup succeeded!");
  // }
  // else
  // {
  //   Serial.println("Servo EID setup failed");
  // }
  // delay(100);
  Serial.print("Servo FWVer:");
  FWVer = servo.getFWVer(SERVO_EID);
  Serial.println(FWVer, HEX);
  servo.setPosTime(SERVO_EID, 0, 0);
  delay(100);
}

void initDisplay()
{
  tft.setRotation(1);
  tft.background(BM_ILI9341::BLACK);
  tft.stroke(BM_ILI9341::WHITE);
  tft.setTextSize(4);
  tft.text("Preheating", 42, 5, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
}

void preheatPIR()
{
  if (error == 0)
  {
    if (pir.isStable() == false)
    {
      if (currentTime > previousTime)
      {
        previousTime = currentTime;
        String tmp_data = String(currentTime);
        Serial.println(tmp_data);
        tmp_data.toCharArray(char_data, 3);
        tft.setTextSize(20);
        if (currentTime < 10)
        {
          tft.text(char_data, 110, 65, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
        }
        else
        {
          tft.text(char_data, 50, 65, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
        }
      }
    }
    else
    {
      tft.setTextSize(4);
      tft.text(" Operating ", 30, 5, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
      tft.setTextSize(20);
      tft.text("  ", 50, 65, BM_ILI9341::WHITE, BM_ILI9341::BLACK);
      Serial.println("PIR stabilized.");
      ispreheat = false;
      MsTimer::stop();
      currentTime = 0;
      previousTime = 0;
      delay(500);
    }
  }
}

void timeISR()
{
  currentTime++;
  delayTime--;
  if (delayTime <= 0 && sta_PIR == true)
  {
    delayTime = 3;
  }
}