/*************************************************
This sketch reads the PIR detector module BM22S4221-1 information and
displays on the serial monitor.

Wire COnnection between BM22S3221-1 and Arduino Uno:
BM22S4221-1 pin 1 (VDD) connect to Arduino Uno pin 5V
BM22S4221-1 pin 2 (VSS) connect to Arduino Uno pin GND
BM22S4221-1 pin 3 (RX) connect to Arduino Uno pin 3
BM22S4221-1 pin 4 (TX) connect to Arduino Uno pin 2
BM22S4221-1 pin 5 (STATUS) connect to Arduino Uno pin 8

If you use a 16x2 character LCD with I2C interface,
connect SCL to Arduino Uno pin SCL
connect SDA to Arduino Uno pin SDA
connect VCC to Arduino Uno pin 5V
connect GDN to Arduino Uno pin GND
**************************************************/
#include "BM22S4221-1.h"
//#include <LiquidCrystal_I2C.h>
//LiquidCrystal_I2C lcd(0x27, 16, 2);

#define rxPin 2       // Software UART RX pin
#define txPin 3       // Software UART TX pin
#define statusPin 8   // STATUS Pin：D8

uint8_t rtn=1, tmp=0;
uint8_t moduleInfo[25] = {1}; // buffer to store module information

BM22S4221_1 pir(statusPin, rxPin, txPin); //Softeware serial

void setup()
{
  pir.begin(); // Initialize Softeware serial, baud rate 9600, Set pin8 as input 
  Serial.begin(9600);
  pinMode(statusPin, INPUT_PULLUP);

  pir.setAutoTx(8);  // enable auto Tx
  // initialize the 16x2 LCD module
  //lcd.init();
  //lcd.backlight();
  //lcd.clear();
}

void loop()
{
  rtn = pir.autoRx(moduleInfo);
  if (rtn == 0){
    Serial.print("PIR status: 0x");
    Serial.print(moduleInfo[10], HEX);
    if ((moduleInfo[10]&0x04) == 0){
      Serial.println(" preheating");
      //lcd.clear(); lcd.setCursor(1,0); lcd.print("preheating");
      //lcd.setCursor(1,1); lcd.print(moduleInfo[18]/2);
    }
    else if((moduleInfo[10]&0x80) != 0){
      Serial.println(" alarm with output signal active");
      //lcd.clear(); lcd.setCursor(1,0); lcd.print("alarm");      
    }
    else if((moduleInfo[10]&0x08) != 0){
      Serial.println(" alarm");
      //lcd.clear(); lcd.setCursor(1,0); lcd.print("alarm");      
    }  
    else{
      Serial.println(" nothing detected");
      //lcd.clear(); lcd.setCursor(0,0); lcd.print("nothing detected");              
    }    
  } 
}
