/*****************************************************************
File:             BM22S4221-1.h
Author:           BEST MODULES CORP.
Description:      Define classes and required variables
History：         
V1.0.1-- initial version；2022-09-06；Arduino IDE : v1.8.13
******************************************************************/

#ifndef  _BM22S4221_h_
#define  _BM22S4221_h_
#include <Arduino.h>
#include <SoftwareSerial.h>
#define  UART_BAUD 9600
#define  debug 0

class BM22S4221_1
{
    public:
    BM22S4221_1(uint8_t statusPin,HardwareSerial*theSerial);
    BM22S4221_1(uint8_t statusPin,uint8_t rxPin, uint8_t txPin);
    void begin();
    
    uint8_t resetModule();                  //command U00
    uint8_t getVerDate(uint8_t buff[]);     //command U01
    uint8_t getInfoPackage(uint8_t buff[]); //command U02    
    uint8_t restoreDefault();               //command U03

    uint8_t isAutoTx();                     //command R00
    uint8_t getStatusPinActiveMode();       //command R01
    uint8_t getVBG();                       //command R02

    uint8_t setAutoTx(uint8_t state);               //command W00
    uint8_t setStatusPinActiveMode(uint8_t state);  //command W01
    uint8_t setOpaGain(uint8_t value);              //command W02
    uint8_t setAlarmThreshold(uint8_t Threshold);   //command W03
    uint8_t setAlarmDetectDelay(uint8_t time=3);    //command W04
    uint8_t setAlarmOutputTime(uint8_t time=3);     //command W05
    uint8_t setPreheaTime(uint8_t time);            //command W06

    uint8_t autoRx(uint8_t buff[]);
    
    private:
    void readData(uint8_t buff[]);
    void wirteData(uint8_t buff[], uint8_t datalength);
    void clear_UART_FIFO();
    uint8_t _rxPin;
    uint8_t _txPin;
    uint8_t _statusPin;
    HardwareSerial*_serial =NULL;
    SoftwareSerial *_softSerial =NULL;
};

#endif
